/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.client.AbstractVoucherDetailMessageListUI;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherDetailMessageListUI
extends AbstractVoucherDetailMessageListUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherDetailMessageListUI.class);
    public static final String MASTERVOUCHER = "MASTERVOUCHER";
    private CompanyOrgUnitInfo transferOrg;
    private CompanyOrgUnitInfo masterCompany;
    private Date dateFrom;
    private Date dateTo;
    private String voucherType;
    int masterCurrencyPrecision = 2;
    int transferCurrencyPrecision = 2;

    public void onLoad() throws Exception {
        this.initParam();
        super.onLoad();
        this.initMyButton();
    }

    private void initParam() {
        Map ctx = this.getUIContext();
        this.transferOrg = this.getCompany();
        this.masterCompany = BooksUtil.getCurrentMasterCompany(null, this.transferOrg);
        this.dateFrom = (Date)ctx.get("dateFrom");
        this.dateTo = (Date)ctx.get("dateTo");
        this.voucherType = (String)ctx.get("voucherType");
    }

    private void initMyButton() throws EASBizException, BOSException {
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionQuery.setVisible(false);
        this.btnTraceUp.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.btnTraceDown.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        if (this.masterCompany.getBaseCurrency() != null) {
            this.masterCurrencyPrecision = this.masterCompany.getBaseCurrency().getPrecision();
        }
        if (this.transferOrg.getBaseCurrency() != null) {
            CurrencyInfo baseCur = this.transferOrg.getBaseCurrency();
            baseCur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCur.getId()));
            this.transferCurrencyPrecision = baseCur.getPrecision();
        }
        this.tblMain.getHead().setRowHeight(0, 22);
        this.tblMain.getHead().setRowHeight(1, 22);
        this.tblMain.getColumn("localDebitAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.masterCurrencyPrecision));
        this.tblMain.getColumn("localCreditAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.masterCurrencyPrecision));
        this.tblMain.getColumn("tagVoucher.localDebitAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.transferCurrencyPrecision));
        this.tblMain.getColumn("tagVoucher.localCreditAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.transferCurrencyPrecision));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherMessageFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo v) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)this.masterCompany.getId().toString()));
        fic.add(new FilterItemInfo("voucherType.id", (Object)this.voucherType));
        fic.add(new FilterItemInfo("bizStatus", (Object)this.getBizStatus(), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)this.dateFrom), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)this.dateTo), CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("sourceType", (Object)1, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("message.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("tagVoucher.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("tagVoucher.voucherType.id", (Object)this.voucherType));
        fic.add(new FilterItemInfo("tagVoucher.bookedDate", (Object)DateTimeUtils.format((Date)this.dateFrom), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("tagVoucher.bookedDate", (Object)DateTimeUtils.format((Date)this.dateTo), CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("tagVoucher.id", null, CompareType.EQUALS));
        fic.add(new FilterItemInfo("message.id", null, CompareType.EQUALS));
        fic.add(new FilterItemInfo("difLocalDebitAmount", (Object)0, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("difLocalCreditAmount", (Object)0, CompareType.NOTEQUALS));
        String maskString = "#0 and #1 and #2 and #3 and #4 and #5 and ((#6 and ((#7 and #8 and #9 and #10) or #11) or #12)) and #13 and #14";
        filter.setMaskString(maskString);
        ev.setFilter(filter);
        try {
            exec.setEntityView("Voucher", ev);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        EntityViewInfo mesEv = new EntityViewInfo();
        FilterInfo mesFilter = new FilterInfo();
        FilterItemCollection mesFic = mesFilter.getFilterItems();
        mesFic.add(new FilterItemInfo("company.id", (Object)this.transferOrg.getId().toString()));
        SelectorItemCollection sic = mesEv.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("srcVoucher.id"));
        sic.add(new SelectorItemInfo("tagVoucher.id"));
        sic.add(new SelectorItemInfo("message"));
        sic.add(new SelectorItemInfo("isSuc"));
        sic.add(new SelectorItemInfo("company.id"));
        mesEv.setFilter(mesFilter);
        try {
            exec.setEntityView("message", mesEv);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return exec;
    }

    private CompanyOrgUnitInfo getCompany() {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (this.getUIContext().get("COMPANY") != null && this.getUIContext().get("COMPANY") instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY");
        }
        return company;
    }

    @Override
    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String key = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        if (key != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)key);
            uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
            uiContext.put((Object)MASTERVOUCHER, (Object)MASTERVOUCHER);
            this.trace(uiContext);
        }
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String key = (String)this.tblMain.getRow(rowIndex).getCell("tagVoucher.id").getValue();
        if (key != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)key);
            uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
            this.trace(uiContext);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"6_VoucherMessegeListUI"));
        }
    }

    public static String getEditUIMode(CoreUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected void trace(UIContext uiContext) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherDetailMessageListUI.getEditUIMode((CoreUIObject)this)).create("com.kingdee.eas.fi.gl.client.VoucherEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private int getBizStatus() {
        int bizStatus = 3;
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany(null, this.transferOrg);
        String bookId = BooksUtil.getCurrentBook(null, this.transferOrg.getId().toString()).getId().toString();
        try {
            BooksRuleInfo ruleInfo = AccountRuleFactory.getRemoteInstance().getRuleS(bookId, masterCompany);
            if (ruleInfo.getProperties().get("B001") != null && "1".equals(ruleInfo.getVoucherStatus())) {
                bizStatus = 5;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return bizStatus;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        super.appendFootRow();
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            return null;
        }
        IRow footRow = footRowManager.getFootRow(0);
        footRow.getCell("localDebitAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.masterCurrencyPrecision));
        footRow.getCell("localCreditAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.masterCurrencyPrecision));
        footRow.getCell("tagVoucher.localDebitAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.transferCurrencyPrecision));
        footRow.getCell("tagVoucher.localCreditAmount").getStyleAttributes().setNumberFormat(BooksUtil.getDecimalFormat(this.transferCurrencyPrecision));
        return footRow;
    }
}

