/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.RunningBusinessMethod;
import com.kingdee.eas.fi.gl.VoucherExpImpException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractFMDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.AbstractFMDataImport");
    private Map infoMap = new HashMap(100);
    protected Map DataBaseMap = null;
    protected Map BosObjectMap = null;
    private CompanyOrgUnitInfo currentCompany;
    protected String projectIsolate = null;
    private Map accountBankCache = new HashMap();

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws EASBizException, BOSException {
        if (this.currentCompany == null && ctx != null) {
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            this.currentCompany = contextHelper.getCurrentCompany();
            if (this.currentCompany == null) {
                String companyId = contextHelper.getCurrentUser().getDefOrgUnit().getId().toString();
                this.currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)this.currentCompany);
            }
        }
        return this.currentCompany;
    }

    public Map getInfoMap() {
        return this.infoMap;
    }

    public void setInfoMap(Map infoMap) {
        this.infoMap = infoMap;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return this._getController(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            this.getCurrentCompany(ctx);
            return this._transmit(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            return this._exportTransmit(rs, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString(IRowSet rs, String columnName) {
        try {
            String value = rs.getString(columnName);
            if (value == null) {
                value = "";
            }
            return value;
        }
        catch (SQLException e) {
            return "";
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this._submit(coreBaseInfo, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract ICoreBase _getController(Context var1) throws EASBizException, BOSException;

    protected abstract CoreBaseInfo _transmit(Hashtable var1, Context var2) throws EASBizException, BOSException;

    protected abstract void _submit(CoreBaseInfo var1, Context var2) throws BOSException, EASBizException;

    protected Hashtable _exportTransmit(IRowSet rs, Context ctx) throws EASBizException, BOSException {
        return null;
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData) throws BOSException {
        this.prepareImport(ctx, info, hsData, null);
    }

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData, String prefix) throws BOSException {
        this.verifyEmpty(ctx, hsData);
        BOSObjectType type = info.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo prop = properties.get(i);
            String name = prop.getName();
            if (name == null) continue;
            String importKey = null;
            importKey = FMHelper.isEmpty((String)prefix) ? name : prefix + "." + name;
            Object data = this.getData(hsData, importKey);
            if (data == null) continue;
            if (prop instanceof LinkPropertyInfo) {
                IObjectValue value = null;
                LinkPropertyInfo new_name = (LinkPropertyInfo)prop;
                EntityObjectInfo sobj = new_name.getRelationship().getSupplierObject();
                BOSObjectType sobjtype = sobj.getType();
                IObjectCollection obj = this.getCollectionByNumber(ctx, data, sobjtype);
                if (obj != null && obj.size() >= 1) {
                    value = obj.getObject(0);
                    info.put(name, (Object)value);
                    continue;
                }
                if (obj == null || obj.size() == 0) {
                    // empty if block
                }
            }
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo new_name = (OwnPropertyInfo)prop;
            DataType datatype = new_name.getDataType();
            if (datatype == DataType.STRING) {
                info.setString(name, this.getString(ctx, data));
                continue;
            }
            if (datatype == DataType.DATE) {
                info.setDate(name, this.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.TIMESTAMP) {
                info.setDate(name, this.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.DECIMAL) {
                info.setBigDecimal(name, this.getAmount(ctx, data));
                continue;
            }
            if (datatype != DataType.INTEGER) continue;
            info.setInt(name, this.getInt(ctx, data));
        }
    }

    private IObjectCollection getCollectionByNumber(Context ctx, Object data, BOSObjectType sobjtype) throws BOSException {
        IObjectCollection obj = null;
        try {
            obj = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(sobjtype, "select * where number ='" + data + "' or name=''");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return obj;
    }

    private void verifyEmpty(Context ctx, Hashtable hsData) throws BOSException {
        String templateNum = this.getTemplateNumber();
        if (FMHelper.isEmpty((String)templateNum)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)templateNum));
        view.setFilter(filter);
        DIETemplateCollection tepleteColl = DIETemplateFactory.getLocalInstance((Context)ctx).getDIETemplateCollection(view);
        if (tepleteColl.size() == 0) {
            return;
        }
        DIETemplateInfo teplateInfo = tepleteColl.get(0);
        DIETemplateFieldEntryCollection entryColl = teplateInfo.getFieldEntries();
        for (DIETemplateFieldEntryInfo entry : entryColl) {
            String fieldNum = entry.getNumber();
            boolean isRequired = entry.isIsNeed();
            Object data = ((DataToken)hsData.get((Object)fieldNum)).data;
            if (!isRequired || !FMHelper.isEmpty((Object)data)) continue;
            String fieldName = entry.getName();
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"ziduan_cannot_be_null", (Locale)ctx.getLocale()), fieldName);
            throw new BOSException(msgStr);
        }
    }

    protected String getTemplateNumber() {
        return "";
    }

    protected AccountBankInfo getAccountBank(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString().trim();
        Object accbObj = this.accountBankCache.get(number);
        if (accbObj != null) {
            return (AccountBankInfo)accbObj;
        }
        IAccountBank acb = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = acb.getAccountBankCollection("select * where number ='" + number + "'");
        if (coll == null || coll.size() == 0) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"accountBankIsNot", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        this.accountBankCache.put(number, coll.get(0));
        return coll.get(0);
    }

    protected BigDecimal getAmount(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return FMConstants.ZERO;
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"dataTransferError", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return value;
    }

    protected int getInt(Context ctx, Object data) throws BOSException {
        int value;
        if (data == null || data.toString().trim().length() == 0) {
            return 0;
        }
        try {
            value = TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"dataTransferError", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return value;
    }

    protected String getString(Context ctx, Object data) {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        return data.toString().trim();
    }

    protected Date getDate(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = TypeConversionUtils.objToUtilDate((Object)data);
        }
        catch (Exception e) {
            try {
                date = new SimpleDateFormat().parse(data.toString());
            }
            catch (ParseException e1) {
                String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"dateTransferError", (Locale)ctx.getLocale()), data);
                throw new BOSException(msgStr);
            }
        }
        return date;
    }

    protected CurrencyInfo getCurrency(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        ICurrency cur = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection coll = cur.getCurrencyCollection("select * where number ='" + data + "'");
        if (coll == null || coll.size() == 0) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"currencyIsNot", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return coll.get(0);
    }

    protected SettlementTypeInfo getSettlementType(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        ISettlementType st = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("*"));
        SettlementTypeCollection coll = st.getSettlementTypeCollection(ev);
        if (coll == null || coll.size() == 0) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"settleTypeIsNot", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return coll.get(0);
    }

    protected AsstActTypeInfo getAsstActType(Context ctx, Object data) throws EASBizException, BOSException {
        String boskey;
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
        String bosType = asstActTypeInfo.getBOSType().toString();
        if (this.getBosObjectMapValue(bosType, boskey = data.toString().trim()) != null) {
            asstActTypeInfo = (AsstActTypeInfo)this.getBosObjectMapValue(bosType, boskey);
        } else {
            asstActTypeInfo = this.getAssTypeByNumber(ctx, boskey);
            this.setBosObjectMapValue(bosType, boskey, asstActTypeInfo);
        }
        return asstActTypeInfo;
    }

    public AsstActTypeInfo getAssTypeByNumber(Context ctx, String number) throws BOSException, VoucherExpImpException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("isForCompany"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("asstHGAttribute"));
        sic.add(new SelectorItemInfo("mappingFieldName"));
        sic.add(new SelectorItemInfo("realtionDataObject"));
        sic.add(new SelectorItemInfo("isMultilevel"));
        sic.add(new SelectorItemInfo("groupTableName"));
        sic.add(new SelectorItemInfo("glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("glAsstActTypeGrp.shareTactic"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)number.trim()));
        AsstActTypeInfo asstActTypeInfo = null;
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
        if (asstActTypeCollection != null && asstActTypeCollection.size() != 0) {
            if (asstActTypeCollection.size() > 1) {
                throw new VoucherExpImpException(VoucherExpImpException.ASSTNAME_NOT_SAME, (Object[])new String[]{number});
            }
            asstActTypeInfo = asstActTypeCollection.get(0);
        }
        return asstActTypeInfo;
    }

    protected DataBaseInfo getAsstActObject(Context ctx, AsstActTypeInfo asstActTypeInfo, String strAsstActID) throws BOSException {
        String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
        DataBaseInfo data = null;
        if (this.getDataBaseMapValue(asstHGAttribute, strAsstActID) != null) {
            data = (DataBaseInfo)this.getDataBaseMapValue(asstHGAttribute, strAsstActID);
        }
        if (data != null) {
            return data;
        }
        IAssistantHG iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        BOSObjectType type = iAssistantHG.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(type);
        PropertyCollection props = eo.getInheritedNoDuplicatedProperties();
        Iterator itr = props.iterator();
        LinkPropertyInfo pi = null;
        try {
            while (itr.hasNext()) {
                PropertyInfo p = (PropertyInfo)itr.next();
                if (!asstHGAttribute.equalsIgnoreCase(p.getName()) || !(p instanceof LinkPropertyInfo)) continue;
                pi = (LinkPropertyInfo)p;
                break;
            }
            if (pi != null) {
                DataBaseCollection collection;
                Object[] args;
                IRowSet rowSet;
                String customerSql;
                FilterInfo Dfilter;
                String groupID;
                EntityObjectInfo eobj = pi.getRelationship().getSupplierObject();
                String strFacotry = eobj.getBusinessImplFactory();
                String strImpl = eobj.getBusinessImplName();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("*"));
                view.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                String cuid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
                if (!asstActTypeInfo.isIsForCompany() || asstHGAttribute.equals("person") || !"CurProject".equalsIgnoreCase(asstHGAttribute)) {
                    // empty if block
                }
                if (asstActTypeInfo.getGlAsstActTypeGrp() != null && strAsstActID != null) {
                    fic.add(new FilterItemInfo("longNumber", (Object)strAsstActID.replace('.', '!')));
                } else if ("CurProject".equalsIgnoreCase(asstHGAttribute) && strAsstActID != null) {
                    fic.add(new FilterItemInfo("longNumber", (Object)strAsstActID.replace('.', '!')));
                } else {
                    fic.add(new FilterItemInfo("number", (Object)strAsstActID));
                }
                if (asstActTypeInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_Project")) {
                    fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("isListItem", (Object)new Integer(1)));
                    if (this.projectIsolate == null) {
                        this.projectIsolate = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "ProjectIsolate");
                    }
                    if ("true".equalsIgnoreCase(this.projectIsolate)) {
                        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                    }
                } else if (asstActTypeInfo.getRealtionDataObject().equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                    GeneralAsstActTypeGroupInfo info = asstActTypeInfo.getGlAsstActTypeGrp();
                    groupID = info.getId().toString();
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID));
                    filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)strAsstActID.replace('.', '!')));
                    evi.setFilter(filterInfo);
                    GeneralAsstActTypeCollection colls = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeCollection(evi);
                    if (colls.size() > 0) {
                        return colls.get(0);
                    }
                }
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getLocalInstance((Context)ctx), (String)cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                    Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getLocalInstance((Context)ctx), (String)cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                } else if ("material".equalsIgnoreCase(asstHGAttribute)) {
                    fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
                } else if (!"person".equalsIgnoreCase(asstHGAttribute)) {
                    if ("innerAccount".equalsIgnoreCase(asstHGAttribute)) {
                        fic.add(new FilterItemInfo("closed", (Object)"0"));
                        fic.add(new FilterItemInfo("isUsed", (Object)"1"));
                    } else if ("bankAccount".equalsIgnoreCase(asstHGAttribute)) {
                        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                        fic.add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                    } else if (asstActTypeInfo.isIsMultilevel()) {
                        FilterInfo filter1 = new FilterInfo();
                        if (!(asstHGAttribute.equals("saleOrg") || asstHGAttribute.equals("profitOrg") || asstHGAttribute.equals("purchaseOrg") || asstHGAttribute.equals("storeageOrg") || asstHGAttribute.equals("companyOrg") || asstHGAttribute.equals("costOrg"))) {
                            if (asstActTypeInfo.getGroupTableName() == null && (asstActTypeInfo.getGlAsstActTypeGrp() == null || !asstActTypeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.S2) && !asstActTypeInfo.getGlAsstActTypeGrp().getShareTactic().equals((Object)ShareTacticEnum.B1))) {
                                fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                            } else if (asstActTypeInfo.getGlAsstActTypeGrp() != null) {
                                filter1.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                                groupID = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
                                String idCol = GlUtils.getGeneralCollection((Context)ctx, (String)groupID);
                                if (idCol.length() != 0) {
                                    filter1.getFilterItems().add(new FilterItemInfo("id", (Object)idCol, CompareType.NOTINCLUDE));
                                    filter1.setMaskString("#0 or #1");
                                }
                            }
                        }
                        if (asstActTypeInfo.getGlAsstActTypeGrp() != null) {
                            groupID = asstActTypeInfo.getGlAsstActTypeGrp().getId().toString();
                            fic.add(new FilterItemInfo("group.id", (Object)groupID));
                            filter.mergeFilter(GlUtils.getFilterForGeneral((Context)ctx, (String)groupID), "and");
                        }
                        if (filter1.getFilterItems().size() > 0) {
                            filter.mergeFilter(filter1, "and");
                        }
                    }
                }
                if ("customer".equalsIgnoreCase(asstHGAttribute)) {
                    customerSql = "select customer.fid as customerFid from t_bd_customer as customer INNER JOIN T_BD_CustomerCompanyInfo AS customerCompany on customer.fid=customerCompany.FCustomerID LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON customerCompany.FComOrgID = COMPANYORGUNIT.FID  where customer.fnumber='" + strAsstActID + "' and customer.fusedStatus = 1 and COMPANYORGUNIT.fid='" + company.getId().toString() + "'";
                    rowSet = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)customerSql).executeSQL();
                    if (rowSet.next()) {
                        String customerFid = rowSet.getString("customerFid");
                        CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(customerFid));
                        this.setDataBaseMapValue(asstHGAttribute, strAsstActID, customer);
                        return customer;
                    }
                    return null;
                }
                if ("provider".equalsIgnoreCase(asstHGAttribute)) {
                    customerSql = "select supplier.fid as supplierFid from T_BD_Supplier as supplier INNER JOIN T_BD_SupplierCompanyInfo AS supplierCompany on supplier.fid=supplierCompany.FSupplierID LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ON supplierCompany.FComOrgID = COMPANYORGUNIT.FID  where supplier.fnumber='" + strAsstActID + "' and supplier.fusedStatus = 1 and COMPANYORGUNIT.fid='" + company.getId().toString() + "'";
                    rowSet = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)customerSql).executeSQL();
                    if (rowSet.next()) {
                        String supplierFid = rowSet.getString("supplierFid");
                        SupplierInfo supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierFid));
                        this.setDataBaseMapValue(asstHGAttribute, strAsstActID, supplier);
                        return supplier;
                    }
                    return null;
                }
                String strMethod = "getDataBaseCollection";
                Class[] argTypes = new Class[]{view.getClass()};
                Object result = RunningBusinessMethod.runLocalMethod((Context)ctx, (String)strFacotry, (String)strImpl, (String)strMethod, (Class[])argTypes, (Object[])(args = new Object[]{view}));
                if (result != null && (collection = (DataBaseCollection)result).size() != 0) {
                    data = collection.get(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDataBaseMapValue(asstHGAttribute, strAsstActID, data);
        return data;
    }

    public Map getBosObjectMap() {
        if (this.BosObjectMap == null) {
            this.BosObjectMap = new HashMap();
        }
        return this.BosObjectMap;
    }

    public Map getDataBaseMap() {
        if (this.DataBaseMap == null) {
            this.DataBaseMap = new HashMap();
        }
        return this.DataBaseMap;
    }

    public Object getBosObjectMapValue(String bosType, String key) {
        if (key == null || key.trim().equals("")) {
            return null;
        }
        Map bosTypeMap = null;
        if (this.getBosObjectMap().containsKey(bosType)) {
            bosTypeMap = (Map)this.getBosObjectMap().get(bosType);
        } else {
            bosTypeMap = new HashMap();
            this.getBosObjectMap().put(bosType, bosTypeMap);
        }
        return bosTypeMap.get(key);
    }

    public void setBosObjectMapValue(String bosType, String key, Object value) {
        if (value == null) {
            return;
        }
        Map<String, Object> bosTypeMap = null;
        if (this.getBosObjectMap().containsKey(bosType)) {
            bosTypeMap = (Map)this.getBosObjectMap().get(bosType);
        } else {
            bosTypeMap = new HashMap();
            this.getBosObjectMap().put(bosType, bosTypeMap);
        }
        bosTypeMap.put(key, value);
    }

    public Object getDataBaseMapValue(String asstHGAttribute, String key) {
        if (key == null || key.trim().equals("")) {
            return null;
        }
        Map asstHGAttributeMap = null;
        if (this.getDataBaseMap().containsKey(asstHGAttribute)) {
            asstHGAttributeMap = (Map)this.getDataBaseMap().get(asstHGAttribute);
        } else {
            asstHGAttributeMap = new HashMap();
            this.getDataBaseMap().put(asstHGAttribute, asstHGAttributeMap);
        }
        return asstHGAttributeMap.get(key);
    }

    public void setDataBaseMapValue(String asstHGAttribute, String key, Object value) {
        if (value == null) {
            return;
        }
        Map<String, Object> asstHGAttributeMap = null;
        if (this.getDataBaseMap().containsKey(asstHGAttribute)) {
            asstHGAttributeMap = (Map)this.getDataBaseMap().get(asstHGAttribute);
        } else {
            asstHGAttributeMap = new HashMap();
            this.getDataBaseMap().put(asstHGAttribute, asstHGAttributeMap);
        }
        asstHGAttributeMap.put(key, value);
    }

    public ExchangeRateInfo getExRateInfo(Context ctx, String srcCurrId, String destCurrId, CompanyOrgUnitInfo company, Date date) {
        ExchangeTableInfo baseExchangeTable;
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = company.getBaseExchangeTable()) == null) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = null;
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    public boolean isIndirectExRate(ExchangeRateInfo exRateInfo) {
        if (exRateInfo == null) {
            return false;
        }
        return exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
    }
}

