/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBookNotifyBuilder;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractPayPackageJournal {
    protected PeriodInfo currPeriodInfo;
    protected int cs104;
    protected boolean isMinusReverse;
    protected PaymentBillInfo billInfo;
    protected Context ctx;
    protected String billId;
    protected RecPayBookNotifyBuilder builder;

    public abstract void bookPaymentBill(JournalCollection var1) throws BOSException, EASBizException;

    protected void bookOppAccount(Context ctx, String billId, JournalCollection journalCollection, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        AccountViewInfo oppAccount = this.getOppAccountView();
        if (oppAccount != null && (oppAccount.isIsBank() || oppAccount.isIsCash())) {
            JournalInfo journalInfo = this.createBaseJournal(ctx, billInfo);
            this.createJournalFundFlowItem(billInfo, journalInfo, false);
            journalInfo.setIsDebit(true);
            if (oppAccount.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(this.getOppAccount_AccountBank());
                if (billInfo.getPayeeAccountBankO() != null && billInfo.getPayeeAccountBankO().isIsByCurrency()) {
                    journalInfo.setCurrency(billInfo.getPayeeAccountBankO().getCurrency());
                } else {
                    journalInfo.setCurrency(billInfo.getCurrency());
                }
            } else if (oppAccount.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setAccountView(oppAccount);
            journalInfo.setOppAccountView(billInfo.getPayerAccount());
            BigDecimal amount = this.getAmount();
            BigDecimal bigDecimal = amount = amount == null ? Constants.ZERO : amount;
            if (this.isMinusReverse && amount.compareTo(Constants.ZERO) < 0) {
                journalInfo.setCreditAmount(amount.abs());
                journalInfo.setDebitAmount(Constants.ZERO);
            } else {
                journalInfo.setDebitAmount(amount);
                journalInfo.setCreditAmount(Constants.ZERO);
            }
            if (null != billInfo.getVoucher() && billInfo.getVoucher().getBizStatus() != VoucherStatusEnum.TEMP) {
                journalInfo.setVoucherId(billInfo.getVoucher().getId().toString());
                journalInfo.setVoucherNumber(billInfo.getVoucherNumber());
                journalInfo.setVoucherType(billInfo.getVoucherType());
                if (EmptyUtil.isEmpty((CoreBaseInfo)journalInfo.getOppAccountView()) && billInfo.getVoucher().getEntries().size() > 0) {
                    VoucherEntryInfo oppVoucherInfo = null;
                    VoucherEntryCollection col = billInfo.getVoucher().getEntries();
                    for (int i = 0; i < col.size(); ++i) {
                        VoucherEntryInfo EntryInfo = col.get(i);
                        if (EntryDC.DEBIT != EntryInfo.getEntryDC()) continue;
                        oppVoucherInfo = EntryInfo;
                        break;
                    }
                    if (oppVoucherInfo != null && oppVoucherInfo.getAccount() != null) {
                        journalInfo.setOppAccountView(oppVoucherInfo.getAccount());
                    }
                }
            }
            if (!FMHelper.checkIsBooked((Context)ctx, (String)billInfo.getSourceBillId(), (BOSObjectType)new TimeDepositBillInfo().getBOSType(), (AccountBankInfo)journalInfo.getAccountBank())) {
                journalCollection.add(journalInfo);
                this.builder.CtrlOppAcctIDSet.add(billId);
            }
        }
    }

    protected void bookPayerAccount(Context ctx, JournalCollection journalCollection, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getPayerAccount() != null && (billInfo.getPayerAccount().isIsBank() || billInfo.getPayerAccount().isIsCash())) {
            JournalInfo journalInfo = this.createBaseJournal(ctx, billInfo);
            this.createJournalFundFlowItem(billInfo, journalInfo, true);
            journalInfo.setIsDebit(false);
            if (billInfo.getPayerAccount().isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(billInfo.getPayerAccountBank());
            } else if (billInfo.getPayerAccount().isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            BigDecimal amount = null;
            journalInfo.setAccountView(billInfo.getPayerAccount());
            journalInfo.setOppAccountView(this.getOppAccountView());
            amount = this.getAmount();
            BigDecimal bigDecimal = amount = amount == null ? Constants.ZERO : amount;
            if (this.isMinusReverse && amount.compareTo(FMConstants.ZERO) < 0) {
                journalInfo.setDebitAmount(amount.abs());
                journalInfo.setCreditAmount(Constants.ZERO);
            } else {
                journalInfo.setCreditAmount(amount);
                journalInfo.setDebitAmount(Constants.ZERO);
            }
            journalInfo.setOppAcctNumber(billInfo.getPayeeAccountBank());
            journalInfo.setOppBank(billInfo.getPayeeBank());
            if (null != billInfo.getVoucher() && billInfo.getVoucher().getBizStatus() != VoucherStatusEnum.TEMP) {
                journalInfo.setVoucherId(billInfo.getVoucher().getId().toString());
                journalInfo.setVoucherNumber(billInfo.getVoucherNumber());
                journalInfo.setVoucherType(billInfo.getVoucherType());
                if (EmptyUtil.isEmpty((CoreBaseInfo)journalInfo.getOppAccountView()) && billInfo.getVoucher().getEntries().size() > 0) {
                    VoucherEntryInfo oppVoucherInfo = null;
                    VoucherEntryCollection col = billInfo.getVoucher().getEntries();
                    for (int i = 0; i < col.size(); ++i) {
                        VoucherEntryInfo EntryInfo = col.get(i);
                        if (EntryDC.DEBIT != EntryInfo.getEntryDC()) continue;
                        oppVoucherInfo = EntryInfo;
                        break;
                    }
                    if (oppVoucherInfo != null && oppVoucherInfo.getAccount() != null) {
                        journalInfo.setOppAccountView(oppVoucherInfo.getAccount());
                    }
                }
            }
            if (!FMHelper.checkIsBooked((Context)ctx, (String)billInfo.getSourceBillId(), (BOSObjectType)new TimeDepositBillInfo().getBOSType(), (AccountBankInfo)journalInfo.getAccountBank())) {
                journalCollection.add(journalInfo);
            }
        }
    }

    protected abstract String getDescreption();

    protected abstract BigDecimal getAmount();

    protected abstract AccountViewInfo getOppAccountView();

    protected abstract AccountBankInfo getOppAccount_AccountBank() throws EASBizException, BOSException;

    private JournalInfo createBaseJournal(Context ctx, PaymentBillInfo billInfo) throws BOSException, EASBizException {
        PeriodInfo temp;
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        if (billInfo.isIsCBPay()) {
            journalInfo.setBillType(BillTypeEnum.cbpaymentBill);
        } else {
            journalInfo.setBillType(BillTypeEnum.paymentBill);
        }
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = billInfo.getCompany();
        Date bookDate = this.getBookDate_cs104(ctx, billInfo.getBizDate(), billInfo.isIsCommittoBe(), companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = null;
        if (this.builder.billPeriodCache != null && (temp = this.builder.billPeriodCache).getBeginDate().compareTo(bookDate) <= 0 && temp.getEndDate().compareTo(bookDate) >= 0 && companyInfo1.getAccountPeriodType().getId().toString().equals(temp.getPeriodType().getId().toString())) {
            bookPeriodInfo = temp;
        }
        if (bookPeriodInfo == null) {
            this.builder.billPeriodCache = bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        }
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setPlanItem(billInfo.getFpItem());
        journalInfo.setSettlementType(billInfo.getSettlementType());
        journalInfo.setSettlementNumber(billInfo.getSettlementNumber());
        journalInfo.setDescription(this.getDescreption());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setOppUnit(billInfo.getPayeeName());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        if (billInfo.getBankCheckFlag() != null) {
            journalInfo.setBankCheckFlag(billInfo.getBankCheckFlag());
        }
        return journalInfo;
    }

    private void createJournalFundFlowItem(PaymentBillInfo billInfo, JournalInfo journalInfo, boolean isOwn) {
        PaymentBillEntryCollection paymentBillEntryCollection = billInfo.getEntries();
        if ("head".equals(this.getJournlType())) {
            for (int i = 0; i < paymentBillEntryCollection.size(); ++i) {
                PaymentBillEntryInfo entryInfo = paymentBillEntryCollection.get(i);
                JournalFlowItemInfo flowItemInfo = new JournalFlowItemInfo();
                flowItemInfo.setFundFlowItem(entryInfo.getFundFlowItem());
                if (isOwn) {
                    if (entryInfo.getFundFlowItem() != null && entryInfo.getFundFlowItem().getDirection() == FundFlowDirection.IN) {
                        flowItemInfo.setAmount(entryInfo.getActualAmt().negate());
                    } else {
                        flowItemInfo.setAmount(entryInfo.getActualAmt());
                    }
                } else if (entryInfo.getFundFlowItem() != null && entryInfo.getFundFlowItem().getDirection() == FundFlowDirection.OUT) {
                    flowItemInfo.setAmount(entryInfo.getActualAmt().negate());
                } else {
                    flowItemInfo.setAmount(entryInfo.getActualAmt());
                }
                journalInfo.getFlowItemEntries().add(flowItemInfo);
            }
        } else {
            JournalFlowItemInfo flowItemInfo = new JournalFlowItemInfo();
            flowItemInfo.setFundFlowItem(this.getEntryFlowItem());
            if (isOwn) {
                if (this.getEntryFlowItem() != null && this.getEntryFlowItem().getDirection() == FundFlowDirection.IN) {
                    flowItemInfo.setAmount(this.getAmount().negate());
                } else {
                    flowItemInfo.setAmount(this.getAmount());
                }
            } else if (this.getEntryFlowItem() != null && this.getEntryFlowItem().getDirection() == FundFlowDirection.OUT) {
                flowItemInfo.setAmount(this.getAmount().negate());
            } else {
                flowItemInfo.setAmount(this.getAmount());
            }
            journalInfo.getFlowItemEntries().add(flowItemInfo);
        }
    }

    protected abstract String getJournlType();

    protected abstract FundFlowItemInfo getEntryFlowItem();

    protected Date getBookDate_cs104(Context ctx, Date bizDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
        }
        Date bookDate = bizDate;
        if (this.cs104 == 1) {
            bookDate = new Date();
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    protected Date getBookDate_cs104(Context ctx, Date bizDate, boolean iscommitbe, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"casCurrentPeriod", (Locale)ctx.getLocale())});
        }
        Date bookDate = bizDate;
        if (this.cs104 == 1) {
            bookDate = new Date();
        } else if (this.cs104 == 2) {
            if (iscommitbe) {
                bookDate = new Date();
            } else {
                SettBizTypeInfo bizType = this.billInfo.getBizType();
                if (bizType != null && (SettBizTypeEnum.PAYOUTSIDE.equals((Object)bizType.getType()) || SettBizTypeEnum.LINKPAY.equals((Object)bizType.getType())) && (SettlementStatusEnum.SUBMITED.equals((Object)this.billInfo.getSettlementStatus()) || SettlementStatusEnum.ACCEPTED.equals((Object)this.billInfo.getSettlementStatus()) || this.billInfo.getSourceBillId() != null && new SettlementBillInfo().getBOSType().equals((Object)new ObjectUuidPK(this.billInfo.getSourceBillId()).getObjectType()))) {
                    EntityViewInfo settleView = new EntityViewInfo();
                    settleView.getSelector().add(new SelectorItemInfo("id"));
                    settleView.getSelector().add(new SelectorItemInfo("sourceBillId"));
                    settleView.getSelector().add(new SelectorItemInfo("settleType"));
                    settleView.getSelector().add(new SelectorItemInfo("settleType.payThroughBE"));
                    settleView.getSelector().add(new SelectorItemInfo("bizDate"));
                    FilterInfo fi = new FilterInfo();
                    if (this.billInfo.getSourceBillId() != null && new SettlementBillInfo().getBOSType().equals((Object)new ObjectUuidPK(this.billInfo.getSourceBillId()).getObjectType())) {
                        fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.billInfo.getSourceBillId(), CompareType.EQUALS));
                    } else {
                        fi.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)this.billInfo.getId(), CompareType.EQUALS));
                    }
                    settleView.setFilter(fi);
                    SettlementBillCollection settlementBillCollection = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillCollection(settleView);
                    if (!EmptyUtil.isEmpty((AbstractObjectCollection)settlementBillCollection)) {
                        SettlementBillInfo settlementBillInfo = settlementBillCollection.get(0);
                        EntityViewInfo journalView = new EntityViewInfo();
                        journalView.getSelector().add(new SelectorItemInfo("id"));
                        journalView.getSelector().add(new SelectorItemInfo("createDate"));
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)settlementBillInfo.getId(), CompareType.EQUALS));
                        journalView.setFilter(filter);
                        JournalCollection journalCollection = JournalFactory.getLocalInstance(ctx).getJournalCollection(journalView);
                        if (!EmptyUtil.isEmpty((AbstractObjectCollection)journalCollection)) {
                            JournalInfo journalInfo = journalCollection.get(0);
                            if (journalInfo.getCreateDate() != null) {
                                bookDate = journalInfo.getCreateDate();
                            }
                        } else {
                            bookDate = settlementBillInfo.getSettleType() != null && settlementBillInfo.getSettleType().isPayThroughBE() ? new Date() : settlementBillInfo.getBizDate();
                        }
                    }
                }
            }
        }
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }
}

