/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.fi.cas.AgentPayBillCollection;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.FeeTypeCollection;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IFeeType;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.IBEBank;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.EASResource;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class AgentPayBillDataImportUtil {
    private static Logger logger = Logger.getLogger((String)AgentPayBillDataImportUtil.class.getName());

    public static BEBankInfo getRecBankByNumber(String number, Context ctx) throws BOSException {
        BEBankInfo info = null;
        IBEBank iBank = BEBankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        view.setFilter(fi);
        BEBankCollection collection = iBank.getBEBankCollection(view);
        if (collection != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static AgentPayBillInfo getAgentPayBillByNumber(Hashtable hsData, Context ctx) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String company = currCompany.getNumber();
        String number = (String)((DataToken)hsData.get((Object)"FNumber")).data;
        if (company == null || number == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        view.setFilter(fi);
        try {
            AgentPayBillCollection coll = AgentPayBillFactory.getLocalInstance(ctx).getAgentPayBillCollection(view);
            if (coll != null && coll.size() > 0) {
                return coll.get(0);
            }
            return null;
        }
        catch (BOSException e) {
            return null;
        }
    }

    public static FeeTypeInfo getFeeTypeByNumber(String number, Context ctx) throws BOSException {
        FeeTypeInfo info;
        try {
            IFeeType iFeeType = FeeTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(fi);
            FeeTypeCollection collection = iFeeType.getFeeTypeCollection(view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"1_AgentPayBillDataImportUtil"));
            }
            info = collection.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        return info;
    }

    public static CostCenterOrgUnitInfo getCostCenterByNumber(String number, Context ctx) throws BOSException {
        CostCenterOrgUnitInfo info;
        try {
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(fi);
            CostCenterOrgUnitCollection collection = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"2_AgentPayBillDataImportUtil"));
            }
            info = collection.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        return info;
    }

    public static ExpenseTypeInfo getExpenseTypeByNumber(String number, Context ctx) throws BOSException {
        ExpenseTypeInfo info;
        try {
            IExpenseType iExpenseType = ExpenseTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(fi);
            ExpenseTypeCollection collection = iExpenseType.getExpenseTypeCollection(view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"3_AgentPayBillDataImportUtil"));
            }
            info = collection.get(0);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        return info;
    }

    public static AccountViewInfo getAccountByNumber(Context ctx, String fieldName, String companyId, String currencyId, String number) throws BOSException {
        AccountViewInfo accountView = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            view.setFilter(fi);
            AccountViewCollection collection = FMHelper.getAccountViewCollection((Context)ctx, (String)companyId, (String)currencyId, (EntityViewInfo)view);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"4_AgentPayBillDataImportUtil", (Object[])new Object[]{fieldName, fieldName}));
            }
            accountView = collection.get(0);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage());
        }
        return accountView;
    }
}

