/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.IBgCtrlHandler;

public class BgCtrlPaymentBillHandler
implements IBgCtrlHandler {
    public BgCtrlParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        PaymentBillInfo info = this.getBillInfo(ctx, billId);
        return BgCtrlPaymentBillHandler.getParamColl(info);
    }

    public static BgCtrlParamCollection getParamColl(PaymentBillInfo info) {
        BgCtrlParamCollection coll = new BgCtrlParamCollection();
        coll.add(BgCtrlPaymentBillHandler.getParam(info));
        if (info.getOppFpItem() != null) {
            BgCtrlParamInfo oppCtrlInfo = BgCtrlPaymentBillHandler.getParam(info);
            oppCtrlInfo.setItemCombinNumber(info.getOppFpItem().getNumber());
            oppCtrlInfo.setItemCombinName(info.getOppFpItem().getName());
            coll.add(oppCtrlInfo);
        }
        return coll;
    }

    private static BgCtrlParamInfo getParam(PaymentBillInfo info) {
        BgCtrlParamInfo ctrlInfo = new BgCtrlParamInfo();
        if (info.getId() != null) {
            ctrlInfo.setSrcBillId(info.getId().toString());
        }
        ctrlInfo.setSrcBillNumber(info.getNumber());
        ctrlInfo.setOrgUnitId(info.getCompany().getId().toString());
        ctrlInfo.setBizDate(info.getBizDate());
        ctrlInfo.setCurrencyId(info.getCurrency().getId().toString());
        ctrlInfo.setCurrencyNumber(info.getCurrency().getNumber());
        if (info.getFpItem() != null) {
            ctrlInfo.setItemCombinNumber(info.getFpItem().getNumber());
            ctrlInfo.setItemCombinName(info.getFpItem().getName());
        }
        ctrlInfo.setAmount(info.getActPayAmt());
        return ctrlInfo;
    }

    private PaymentBillInfo getBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        IPaymentBill iPaymentBill = null;
        iPaymentBill = ctx == null ? PaymentBillFactory.getRemoteInstance() : PaymentBillFactory.getLocalInstance(ctx);
        return iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        return sic;
    }
}

