/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.IEJBAccess;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotpFormulaUtil {
    private static Logger logger = Logger.getLogger((String)BotpFormulaUtil.class.getName());
    private static Map hm = new HashMap();
    private static final String PaymentBill_BOSTYPE = "40284E81";
    private static final String ReceivingBill_BOSTYPE = "FA44FD5B";
    private static final BOSObjectType PaymentBillBOSTYPE = new BOSObjectType("40284E81");
    private static final BOSObjectType ReceivingBillBOSTYPE = new BOSObjectType("FA44FD5B");

    public static CoreBaseInfo getObjectByBosTypeAndNumber(Context ctx, BOSObjectType bosType, String billNumber) throws EASBizException, BOSException {
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("number", billNumber));
    }

    public static Object getObjectByBosTypeAndLongNumber(Context ctx, BOSObjectType bosType, String billLongNumber, String typeNumber) throws EASBizException, BOSException {
        String billLongNumberReal = billLongNumber.replace('.', '!');
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("longNumber", (Object)billLongNumberReal));
        f.getFilterItems().add(new FilterItemInfo("group.number", (Object)typeNumber));
        evi.setFilter(f);
        CoreBaseCollection cols = BotpFormulaUtil.getBizInterface(ctx, bosType).getCollection(evi);
        if (cols == null || cols.size() == 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"220_BotpFormulaUtil", (Object[])new Object[]{billLongNumber}));
        }
        return cols.get(0);
    }

    public static CoreBaseInfo getObjectByBosTypeAndName(Context ctx, BOSObjectType bosType, String billName) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("name", (Object)billName));
        evi.setFilter(f);
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getCollection(evi).get(0);
    }

    public static String getIDByBosTypeAndName(Context ctx, BOSObjectType bosType, String billName) throws EASBizException, BOSException {
        CoreBaseInfo info = BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("name", billName));
        return info.getId().toString();
    }

    public static CoreBaseInfo getObjectByBosTypeAndID(Context ctx, BOSObjectType bosType, String id) throws EASBizException, BOSException {
        return BotpFormulaUtil.getBizInterface(ctx, bosType).getValue(BotpFormulaUtil.getOQL("id", id));
    }

    public static CoreBaseInfo getAssActInfo(Context ctx, String billID, String number) {
        BOSObjectType bosType = BOSUuid.read((String)billID).getType();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("parent.id", (Object)billID));
        f.getFilterItems().add(new FilterItemInfo("asstActType.number", (Object)number));
        f.getFilterItems().add(new FilterItemInfo("isSelected", (Object)Boolean.TRUE));
        evi.setFilter(f);
        String assTypeID = null;
        try {
            AssItemsForCashCollection assItemsForCash = null;
            if (PaymentBillBOSTYPE.equals((Object)bosType)) {
                assItemsForCash = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashCollection(evi);
            } else if (ReceivingBillBOSTYPE.equals((Object)bosType)) {
                assItemsForCash = AssItemsForCashRecFactory.getLocalInstance(ctx).getAssItemsForCashCollection(evi);
            }
            if (assItemsForCash != null && assItemsForCash.size() > 0) {
                assTypeID = assItemsForCash.get(0).getFromID();
            }
            if (assTypeID != null) {
                BOSObjectType assType = BOSUuid.read(assTypeID).getType();
                return BotpFormulaUtil.getObjectByBosTypeAndID(ctx, assType, assTypeID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return null;
    }

    private static ICoreBase getBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        ICoreBase icb = null;
        icb = BotpFormulaUtil.getStub(ctx).getEntityBizInterface(bosType);
        return icb;
    }

    private static String getOQL(String fieldName, String billNumber) {
        return "select * where " + fieldName + " = '" + billNumber + "'";
    }

    private static IEJBAccess getStub(Context ctx) throws BOSException {
        IEJBAccess stub = null;
        stub = ctx == null ? EJBAccessFactory.createRemoteInstance() : EJBAccessFactory.createLocalInstance((Context)ctx);
        return stub;
    }

    public static Object getAsstActTypeByAsstActName(Context ctx, BOSObjectType bosType, String asstActName) throws BOSException, EASBizException {
        EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosType);
        String tableName = eoi.getTable().getName();
        String oql = "select * where realtionDataObject = '" + tableName + "'";
        return AsstActTypeFactory.getLocalInstance((Context)ctx).getValue(oql);
    }
}

