/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.hraux.init.IHRInterfaceForFiCas;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.IBEBank;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;

public class CasForHRUtils
implements IHRInterfaceForFiCas {
    private Context ctx = null;

    public CasForHRUtils(Context ctx) {
        this.ctx = ctx;
    }

    public String impl(CompanyOrgUnitInfo companyInfo, IRow[] rows, CurrencyInfo currencyInfo, String[] colNames) throws EASBizException, BOSException {
        AgentPayBillInfo agentPay = CasForHRUtils.createPay(companyInfo, rows, currencyInfo, colNames);
        AgentPayBillFactory.getRemoteInstance().addnew((CoreBaseInfo)agentPay);
        return agentPay.getNumber();
    }

    private static AgentPayBillInfo createPay(CompanyOrgUnitInfo companyInfo, IRow[] rows, CurrencyInfo currencyInfo, String[] colNames) throws BOSException, EASBizException {
        String bankAgentIssueResourceURL = colNames[0];
        String personNameColKey = colNames[1];
        String bankColKey = colNames[2];
        String accountColKey = colNames[3];
        String infactPayColKey = colNames[4];
        AgentPayBillInfo agentPay = new AgentPayBillInfo();
        ICodingRuleManager codeRuleMgr = CodingRuleManagerFactory.getRemoteInstance();
        if (!codeRuleMgr.isExist((IObjectValue)agentPay, companyInfo.getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)(bankAgentIssueResourceURL + "NO_RULE")));
            SysUtil.abort();
        } else {
            agentPay.setNumber(codeRuleMgr.getNumber((IObjectValue)agentPay, companyInfo.getId().toString()));
        }
        agentPay.setCompany(companyInfo);
        agentPay.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = CasForHRUtils.getDate();
        agentPay.setCreateTime(new Timestamp(date.getTime()));
        agentPay.setBizDate(new Timestamp(date.getTime()));
        agentPay.setCurrency(currencyInfo);
        agentPay.setExchangeRate(new BigDecimal(1));
        AgentPayBillEntryCollection agentPayEntrys = agentPay.getEntrys();
        IBEBank iBEBank = BEBankFactory.getRemoteInstance();
        BigDecimal totalAmount = new BigDecimal(0.0);
        int totalCount = 0;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            AgentPayBillEntryInfo entry = new AgentPayBillEntryInfo();
            String personName = (String)row.getCell(personNameColKey).getValue();
            entry.setRecName(personName);
            String bankName = (String)row.getCell(bankColKey).getValue();
            BEBankCollection banks = iBEBank.getBEBankCollection(" where name = '" + bankName + "'");
            entry.setRecBank(banks.get(0));
            String account = (String)row.getCell(accountColKey).getValue();
            entry.setRecBankAccount(account);
            BigDecimal amount = (BigDecimal)row.getCell(infactPayColKey).getValue();
            entry.setAmount(amount);
            ++totalCount;
            totalAmount = totalAmount.add(amount);
            agentPayEntrys.add(entry);
        }
        agentPay.setActualAmount(Constants.ZERO);
        agentPay.setAmount(totalAmount);
        agentPay.setLocalAmount(totalAmount);
        agentPay.setBalance(Constants.ZERO);
        agentPay.setCount(totalCount);
        agentPay.setBillStatus(BillStatusEnum.SAVE);
        return agentPay;
    }

    private static Date getDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }
}

