/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountPropertyCollection;
import com.kingdee.eas.basedata.assistant.AccountPropertyFactory;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.util.HashSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CasSubsidiaryLedgerHelper {
    private static Logger logger = Logger.getLogger((String)CasSubsidiaryLedgerHelper.class.getName());
    private static final Color SHUT_INNERACCT_COLOR = new Color(100, 100, 255);
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    public static final String fsResourcePath = "com.kingdee.eas.fm.fs.client.FSDailySettleResource";

    public static void fillInnerAcctByType(KDTree tree, String[] applyUnitIds, boolean isDisUnused) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)resourcePath, (String)"accountProperty"));
        CasSubsidiaryLedgerHelper.makeTreeByAccountProperty(root);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < applyUnitIds.length; ++i) {
            set.add(applyUnitIds[i]);
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        entity.getFilter().getFilterItems().add(new FilterItemInfo("applyUnit.id", set, CompareType.INCLUDE));
        if (!isDisUnused) {
            entity.getFilter().getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        }
        entity.getSelector().add("*");
        entity.getSelector().add("type.property");
        entity.getSorter().add(new SorterItemInfo("number"));
        try {
            InnerAccountCollection accounts = InnerAccountFactory.getRemoteInstance().getInnerAccountCollection(entity);
            block3: for (int i = 0; i < accounts.size(); ++i) {
                InnerAccountInfo acct = accounts.get(i);
                acct.setDisplayFormat("$number$ - $name$");
                DefaultKingdeeTreeNode acctNode = new DefaultKingdeeTreeNode((Object)acct);
                if (acct.isClosed()) {
                    acctNode.setTextColor(SHUT_INNERACCT_COLOR);
                    acctNode.setTextBold(true);
                }
                AccountPropertyInfo accountPropertyName = null;
                for (int j = 0; j < root.getChildCount(); ++j) {
                    Object ob = ((DefaultKingdeeTreeNode)root.getChildAt(j)).getUserObject();
                    if (ob == null || !(ob instanceof AccountPropertyInfo)) continue;
                    accountPropertyName = (AccountPropertyInfo)ob;
                    if (!acct.getType().getId().equals((Object)accountPropertyName.getId())) continue;
                    ((DefaultKingdeeTreeNode)root.getChildAt(j)).add((MutableTreeNode)acctNode);
                    continue block3;
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        tree.setModel((TreeModel)model);
    }

    private static void makeTreeByAccountProperty(DefaultKingdeeTreeNode root) {
        AccountPropertyCollection accountPropertyColl = null;
        try {
            accountPropertyColl = AccountPropertyFactory.getRemoteInstance().getAccountPropertyCollection();
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        if (accountPropertyColl != null) {
            for (int i = 0; i < accountPropertyColl.size(); ++i) {
                DefaultKingdeeTreeNode currentNode = new DefaultKingdeeTreeNode();
                currentNode.setUserObject((Object)accountPropertyColl.get(i));
                root.add((MutableTreeNode)currentNode);
            }
        }
    }
}

