/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgItemReferenceHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashBgHelper {
    private static Logger logger = Logger.getLogger((String)CashBgHelper.class.getName());

    public static void BatchSignBgItemUsed(Context ctx, Map map) throws BOSException, EASBizException {
        if (map != null) {
            Object pk2 = null;
            for (Object pk2 : map.keySet()) {
                IFMBgUsed fmInfo = (IFMBgUsed)map.get(pk2);
                ArrayList<String> bgItemCombinIDS = new ArrayList<String>();
                FMBgItemProp[] bgItemProps = fmInfo.getBgItemProps();
                for (int i = 0; i < bgItemProps.length; ++i) {
                    String bgItemId = ((CoreBaseInfo)fmInfo).getString(bgItemProps[i].getBgItemIDProp());
                    if (FMHelper.isEmpty((String)bgItemId)) continue;
                    bgItemCombinIDS.add(bgItemId);
                }
                Object[] o = bgItemCombinIDS.toArray();
                String[] strArray = new String[o.length];
                for (int i = 0; i < o.length; ++i) {
                    strArray[i] = (String)o[i];
                }
                map.put(pk2, strArray);
            }
        }
        BgItemReferenceHelper.batchBgItemUsed((Context)ctx, (Map)map);
    }

    public static void setOrgView(KDBizPromptBox prmtFpItem, CostCenterOrgUnitInfo ccoInfo, boolean isOrgCtrlFpItem) {
        EntityViewInfo itemevi = prmtFpItem.getEntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (itemevi == null) {
            itemevi = new EntityViewInfo();
        } else {
            filterInfo = itemevi.getFilter();
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
        }
        CashBgHelper.getItemOrgs(ccoInfo, filterInfo, false, isOrgCtrlFpItem);
        itemevi.setFilter(filterInfo);
        prmtFpItem.setEntityViewInfo(itemevi);
    }

    public static void getItemOrgs(CostCenterOrgUnitInfo ccoInfo, FilterInfo filter, boolean isLevel1, boolean isOrgCtrlFpItem) {
        if (!isOrgCtrlFpItem) {
            return;
        }
        if (filter == null) {
            return;
        }
        if (ccoInfo == null) {
            ccoInfo = SysContext.getSysContext().getCurrentCostUnit();
        }
        HashSet<String> numberSet = new HashSet<String>();
        if (ccoInfo != null) {
            String[] numberStr = ccoInfo.getLongNumber().split("\\!");
            if (numberStr != null) {
                int in = numberStr.length;
                for (int i = 0; i < in; ++i) {
                    numberSet.add(numberStr[i]);
                }
            }
            int maskSize = filter.getFilterItems().size();
            filter.getFilterItems().add(new FilterItemInfo("orgNum", numberSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgLongnum", (Object)(ccoInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (isLevel1) {
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
            }
            if (StringUtils.isEmpty((String)filter.getMaskString())) {
                String oldMaskS = "";
                for (int n = 0; n < maskSize; ++n) {
                    oldMaskS = n == 0 ? "#" + String.valueOf(n) : oldMaskS + " and  #" + String.valueOf(n);
                }
                if (oldMaskS.equals("")) {
                    if (isLevel1) {
                        filter.setMaskString("( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
                    } else {
                        filter.setMaskString("(#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
                    }
                } else if (isLevel1) {
                    filter.setMaskString("(" + oldMaskS + ") and ( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
                } else {
                    filter.setMaskString("(" + oldMaskS + ") and (#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
                }
            } else if (isLevel1) {
                filter.setMaskString("(" + filter.getMaskString() + ") and ( #" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ") and #" + String.valueOf(maskSize + 2));
            } else {
                filter.setMaskString("(" + filter.getMaskString() + ") and (#" + String.valueOf(maskSize) + " or #" + String.valueOf(maskSize + 1) + ")");
            }
        } else {
            filter.getFilterItems().clear();
            numberSet.add("_");
            filter.getFilterItems().add(new FilterItemInfo("orgNum", numberSet, CompareType.INCLUDE));
            filter.setMaskString("(#0)");
        }
    }
}

