/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.FundsMoveBillFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import java.util.Date;

public class FundsMoveBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        FundsMoveBillInfo bill = FundsMoveBillFactory.getLocalInstance(ctx).getFundsMoveBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        this.setCompanyId(bill.getCompany().getId().toString());
        JournalCollection journalCollection = super.getJournalColl(ctx, billId);
        JournalInfo moveOutCreditJournal = this.createMoveOutCreditJournal(ctx, bill);
        moveOutCreditJournal.setCurrency(bill.getMoveOutCurrency());
        if (bill.getMoveOutAccountView().isIsCash()) {
            moveOutCreditJournal.setAccountBank(null);
            moveOutCreditJournal.setType(JournalTypeEnum.CASH);
            journalCollection.add(moveOutCreditJournal);
        } else if (bill.getMoveOutAccountView().isIsBank()) {
            moveOutCreditJournal.setType(JournalTypeEnum.BANK);
            journalCollection.add(moveOutCreditJournal);
        }
        JournalInfo feeCreditJournal = this.createFeeCreditJournal(ctx, bill);
        feeCreditJournal.setCurrency(bill.getFeeCurrency());
        if (bill.getPayoutAcctView() != null && bill.getPayoutAcctView().isIsCash()) {
            feeCreditJournal.setAccountBank(null);
            feeCreditJournal.setType(JournalTypeEnum.CASH);
            journalCollection.add(feeCreditJournal);
        } else if (bill.getPayoutAcctView() != null && bill.getPayoutAcctView().isIsBank()) {
            feeCreditJournal.setType(JournalTypeEnum.BANK);
            journalCollection.add(feeCreditJournal);
        }
        JournalInfo debitJournal = this.createDebitJournal(ctx, bill);
        debitJournal.setCurrency(bill.getMoveInCurrency());
        if (bill.getMoveInAccountView().isIsCash()) {
            debitJournal.setAccountBank(null);
            debitJournal.setType(JournalTypeEnum.CASH);
            journalCollection.add(debitJournal);
        } else if (bill.getMoveInAccountView().isIsBank()) {
            debitJournal.setType(JournalTypeEnum.BANK);
            journalCollection.add(debitJournal);
        }
        return journalCollection;
    }

    private JournalInfo createMoveOutCreditJournal(Context ctx, FundsMoveBillInfo bill) throws BOSException, EASBizException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setAccountBank(bill.getMoveOutBankAccount());
        journalInfo.setAccountView(bill.getMoveOutAccountView());
        journalInfo.setCreditAmount(bill.getMoveOutAmount());
        journalInfo.setOppUnit(bill.getCompany().getName());
        journalInfo.setOppAccountView(bill.getMoveInAccountView());
        if (bill.getMoveInBankAccount() != null) {
            journalInfo.setOppAcctNumber(bill.getMoveInBankAccount().getBankAccountNumber());
            journalInfo.setOppBank(bill.getMoveInBankAccount().getBank().getName());
        }
        return journalInfo;
    }

    private JournalInfo createFeeCreditJournal(Context ctx, FundsMoveBillInfo bill) throws BOSException, EASBizException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setAccountBank(bill.getFeeBankAccount());
        journalInfo.setAccountView(bill.getPayoutAcctView());
        journalInfo.setCreditAmount(bill.getFeeAmount());
        journalInfo.setOppUnit(bill.getCompany().getName());
        journalInfo.setOppAccountView(bill.getFeeAcctView());
        return journalInfo;
    }

    private JournalInfo createDebitJournal(Context ctx, FundsMoveBillInfo bill) throws BOSException, EASBizException {
        JournalInfo journalInfo = this.createBaseJouranl(ctx, bill);
        journalInfo.setAccountView(bill.getMoveInAccountView());
        journalInfo.setAccountBank(bill.getMoveInBankAccount());
        journalInfo.setDebitAmount(bill.getMoveInAmount());
        journalInfo.setOppUnit(bill.getCompany().getName());
        journalInfo.setOppAccountView(bill.getMoveOutAccountView());
        if (bill.getMoveOutBankAccount() != null) {
            journalInfo.setOppAcctNumber(bill.getMoveOutBankAccount().getBankAccountNumber());
            journalInfo.setOppBank(bill.getMoveOutBankAccount().getBank().getName());
        }
        return journalInfo;
    }

    private JournalInfo createBaseJouranl(Context ctx, FundsMoveBillInfo bill) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setId(BOSUuid.create((BOSObjectType)journalInfo.getBOSType()));
        journalInfo.setCompany(bill.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(bill.getId().toString());
        journalInfo.setBizDate(bill.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = bill.getCompany();
        Date bookDate = this.getBookDate_cs104(ctx, bill.getBizDate(), companyInfo1);
        journalInfo.setCreateDate(bookDate);
        journalInfo.setBillType(BillTypeEnum.FundsMoveBill);
        journalInfo.setBillNumber(bill.getNumber());
        journalInfo.setSettlementNumber(bill.getNumber());
        journalInfo.setDescription(bill.getDigest());
        journalInfo.setHandler(bill.getHandler());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        if (null != bill.getVoucher()) {
            journalInfo.setVoucherId(bill.getVoucher().getId().toString());
            journalInfo.setVoucherNumber(bill.getVoucher().getNumber());
            journalInfo.setVoucherType(bill.getVoucher().getVoucherType());
        }
        return journalInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("company.*");
        selectors.add("moveOutBankAccount.*");
        selectors.add("moveOutBankAccount.bank.id");
        selectors.add("moveOutBankAccount.bank.name");
        selectors.add("moveInBankAccount.*");
        selectors.add("moveInBankAccount.bank.id");
        selectors.add("moveInBankAccount.bank.name");
        selectors.add("feeBankAccount.*");
        selectors.add("feeBankAccount.bank.id");
        selectors.add("feeBankAccount.bank.name");
        selectors.add("moveOutAccountView.*");
        selectors.add("moveInAccountView.*");
        selectors.add("payoutAcctView.*");
        selectors.add("voucher.*");
        return selectors;
    }

    public static void main(String[] args) {
    }
}

