/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.vc.IBackWriteHandler;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;

public class JournalBackWriteHandler
implements IBackWriteHandler {
    public void prepareData(Context ctx, VcResultCollection resultColl) throws BOSException, EASBizException {
        HashMap<String, Integer> id_groupMap = new HashMap<String, Integer>();
        HashSet<String> bankIdSet = new HashSet<String>();
        HashSet<String> journalIdSet = new HashSet<String>();
        int m = resultColl.size();
        for (int i = 0; i < m; ++i) {
            VcResultInfo tmpResultInfo = resultColl.get(i);
            BOSUuid boId = tmpResultInfo.getBizObjectId();
            id_groupMap.put(boId.toString(), new Integer(tmpResultInfo.getGroup()));
            if (tmpResultInfo.getBizObjectFullName().endsWith("BankStatement")) {
                bankIdSet.add(boId.toString());
                continue;
            }
            journalIdSet.add(boId.toString());
        }
        StringBuffer getDateSql = new StringBuffer(1208);
        if (journalIdSet != null && journalIdSet.size() == 0) {
            journalIdSet.add("");
        }
        if (bankIdSet != null && bankIdSet.size() == 0) {
            bankIdSet.add("");
        }
        getDateSql.append(" select fid ,fCREATEDATE ,fverifystatus from t_cas_journal where ");
        getDateSql.append("fid in (" + this.newBuildIn(journalIdSet.toArray()));
        getDateSql.append(" union all ");
        getDateSql.append(" select fid, fcreatedate, fverifystatus from T_CAS_BankStatement where ");
        getDateSql.append("fid in (" + this.newBuildIn(bankIdSet.toArray()));
        Connection conn = null;
        PreparedStatement state = null;
        ResultSet rs = null;
        HashMap<String, Date> id_dateMap = new HashMap<String, Date>();
        HashMap group_dateMap = new HashMap();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.prepareStatement(getDateSql.toString());
            rs = state.executeQuery();
            while (rs.next()) {
                int s = rs.getInt(3);
                if (s == 2) {
                    throw new CasException(CasException.CANNOTVERIFY);
                }
                id_dateMap.put(rs.getString(1), rs.getDate(2));
                Object group = id_groupMap.get(rs.getString(1));
                Object date = group_dateMap.get(group);
                if (date == null) {
                    group_dateMap.put(group, rs.getDate(2));
                    continue;
                }
                group_dateMap.put(group, DateHelper.max((java.util.Date)((java.util.Date)date), (java.util.Date)rs.getDate(2)));
            }
        }
        catch (SQLException exp) {
            try {
                throw new BOSException((Throwable)exp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)conn);
        for (VcResultInfo vcResultInfo : resultColl) {
            vcResultInfo.setWriteDate((java.util.Date)group_dateMap.get(new Integer(vcResultInfo.getGroup())));
        }
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

