/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalEAIVerify;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import java.util.Date;
import org.apache.log4j.Logger;

public class JournalVerifyFromK3
extends JournalEAIVerify {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.JournalVerifyFromK3");

    @Override
    public void verifyImport(Context ctx, JournalInfo journal) throws EASBizException, BOSException {
        if (journal == null) {
            return;
        }
        AccountBankInfo accountBank = journal.getAccountBank();
        if (accountBank != null) {
            journal.setType(JournalTypeEnum.BANK);
            ObjectUuidPK acctBankPK = new ObjectUuidPK(accountBank.getId());
            AccountBankInfo accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
            journal.setAccountView(accountBankInfo.getAccount());
            journal.setCompany(accountBankInfo.getCompany());
        } else {
            journal.setType(JournalTypeEnum.BANK);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"accountView");
            AccountViewInfo acctviewInfo = journal.getAccountView();
            if (!acctviewInfo.isIsCash()) {
                throw new BOSException("must cash accountview");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journal, (String)"company");
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        boolean isDebit = journal.getDebitAmount().equals(FMConstants.ZERO);
        journal.setIsDebit(isDebit);
        if (journal.getCreateDate() == null) {
            journal.setCreateDate(DateHelper.getDayBegin());
        }
        journal.setPeriod(PeriodUtils.getPeriodInfo((Context)ctx, (Date)journal.getCreateDate(), (CompanyOrgUnitInfo)journal.getCompany()));
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        AccountBankInfo accountK3 = new AccountBankInfo();
        AccountViewInfo account = accountK3.getAccount();
        if (account != null && account.getCAA() != null) {
            long l = System.currentTimeMillis();
        }
    }
}

