/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractPayPackageJournal;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBookNotifyBuilder;
import java.math.BigDecimal;

public class PayEntryPackageJournal
extends AbstractPayPackageJournal {
    private int entryPosition = 0;

    public PayEntryPackageJournal(Context ctx, PaymentBillInfo billInfo, PeriodInfo currPeriodInfo, int cs104, boolean isMinusReverse, RecPayBookNotifyBuilder builder) {
        this.ctx = ctx;
        this.billInfo = billInfo;
        this.currPeriodInfo = currPeriodInfo;
        this.cs104 = cs104;
        this.isMinusReverse = isMinusReverse;
        this.billId = billInfo.getId().toString();
        this.builder = builder;
    }

    @Override
    public void bookPaymentBill(JournalCollection journalCollection) throws BOSException, EASBizException {
        PaymentBillEntryCollection paymentBillEntryCollection = this.billInfo.getEntries();
        int size = paymentBillEntryCollection.size();
        int i = 0;
        while (i < size) {
            this.entryPosition = i++;
            this.bookPayerAccount(this.ctx, journalCollection, this.billInfo);
            this.bookOppAccount(this.ctx, this.billId, journalCollection, this.billInfo);
        }
    }

    @Override
    protected BigDecimal getAmount() {
        return this.billInfo.getEntries().get(this.entryPosition).getActualAmt();
    }

    @Override
    protected AccountViewInfo getOppAccountView() {
        return this.billInfo.getEntries().get(this.entryPosition).getOppAccount();
    }

    @Override
    protected AccountBankInfo getOppAccount_AccountBank() throws EASBizException, BOSException {
        return this.getAccountBank(this.ctx, this.billInfo);
    }

    private AccountBankInfo getAccountBank(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        PaymentBillEntryInfo entryInfo = info.getEntries().get(this.entryPosition);
        int size = entryInfo.getAssItemsEntries().size();
        AssItemsForCashPayInfo assItemsinfo = null;
        String accountBankNumber = "";
        for (int i = 0; i < size; ++i) {
            assItemsinfo = entryInfo.getAssItemsEntries().get(i);
            if (!assItemsinfo.isIsSelected() || !"T_BD_AccountBanks".equals(assItemsinfo.getAsstActType().getRealtionDataObject())) continue;
            accountBankNumber = assItemsinfo.getFromNumber();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountBankNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
        IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection accountBankColl = iaccountBank.getAccountBankCollection(evi);
        return accountBankColl.get(0);
    }

    @Override
    protected String getJournlType() {
        return "entry";
    }

    @Override
    protected FundFlowItemInfo getEntryFlowItem() {
        return this.billInfo.getEntries().get(this.entryPosition).getFundFlowItem();
    }

    @Override
    protected String getDescreption() {
        return this.billInfo.getEntries().get(this.entryPosition).getRemark();
    }
}

