/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.nt.ChequeAppRecInfo;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.ChequeStatusEnum;
import com.kingdee.eas.fm.nt.IChequeAssosicateProvider;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTNumberFormat;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

public class PaymentBillChequeAssociateProvider
implements IChequeAssosicateProvider {
    public void writeAssosicateCheque(ChequeInfo cheque, String[] ids) throws BOSException, EASBizException {
        BigDecimal totalAmount;
        if (ids == null || ids.length < 1) {
            return;
        }
        PaymentBillCollection coll = this.getPayColl(ids);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        PaymentBillInfo info = coll.get(0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateHelper.getDayBegin());
        if (cheque.getIssueDate() == null) {
            cheque.setIssueDate(cal.getTime());
        }
        cal.add(5, 10);
        if (cheque.getExpiredDate() == null) {
            cheque.setExpiredDate(cal.getTime());
        }
        if ((totalAmount = this.getTotalAmt(coll)) == null || totalAmount.compareTo(FMConstants.ZERO) <= 0) {
            throw new NTException(NTException.AMOUT_BIGTHAN_ZERO);
        }
        cheque.setAmount(totalAmount);
        CurrencyInfo currency = cheque.getCurrency() == null ? info.getCurrency() : cheque.getCurrency();
        cheque.setCurrency(currency);
        String iso = currency.getIsoCode();
        NTNumberFormat f = NTNumberFormat.getInstance((String)iso);
        String amountString = f.format(totalAmount);
        cheque.setCapitalization(amountString);
        cheque.setPayeeName(info.getPayeeName());
        cheque.setPayeeAcctNumber(info.getPayeeAccountBank());
        cheque.setPayeeAcctBank(info.getPayeeBank());
        cheque.setOppAccount(info.getOppAccount());
        cheque.setPaymentBillNum(info.getNumber());
        for (int i = 0; i < coll.size(); ++i) {
            PaymentBillInfo paymentBill = coll.get(i);
            paymentBill.setSettlementNumber(cheque.getNumber());
        }
        cheque.setUsage(info.getDescription());
        StringBuffer sb = new StringBuffer();
        sb.append(info.getNumber());
        for (int i = 1; i < coll.size(); ++i) {
            sb.append(",");
            sb.append(info.getNumber());
        }
        cheque.setDescription(sb.toString());
        cheque.setTurnInAcctBank(null);
        PersonInfo creator = info.getCreator().getPerson();
        if (cheque.getState().equals((Object)ChequeStatusEnum.NEW)) {
            ChequeAppRecInfo recInfo = new ChequeAppRecInfo();
            if (creator != null) {
                recInfo.setApplyDate(cheque.getIssueDate());
                recInfo.setRemindDate(cheque.getExpiredDate());
                recInfo.setCeiling(cheque.getAmount());
            }
            cheque.setApplyRec(recInfo);
        }
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        cheque.getApplyRec().setCreator(userInfo);
    }

    private BigDecimal getTotalAmt(PaymentBillCollection coll) {
        BigDecimal totalAmount = FMConstants.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            PaymentBillInfo info = coll.get(i);
            totalAmount = totalAmount.add(info.getActPayAmt());
        }
        return totalAmount;
    }

    public void fillBilllist(KDTable table, String[] ids) throws BOSException, EASBizException, SQLException {
        if (ids == null || ids.length < 1) {
            return;
        }
        PaymentBillCollection coll = this.getPayColl(ids);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        BOSUuid currencyId = coll.get(0).getCurrency().getId();
        table.getColumn("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((BOSUuid)currencyId));
        PaymentBillInfo info = null;
        table.checkParsed();
        table.removeRows();
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            row = table.addRow();
            row.getCell("billNumber").setValue((Object)info.getNumber());
            row.getCell("bankAccount").setValue((Object)info.getPayerAccountBank().getBankAccountNumber());
            row.getCell("bankAccountId").setValue((Object)info.getPayerAccountBank().getId().toString());
            row.getCell("currency").setValue((Object)info.getCurrency().getName());
            row.getCell("currencyId").setValue((Object)info.getCurrency().getId().toString());
            row.getCell("amount").setValue((Object)info.getActPayAmt());
            row.getCell("settleType").setValue((Object)info.getSettlementType().getName());
            if (info.getSettlementType().getNtType() != null) {
                row.getCell("settleTypeId").setValue((Object)info.getSettlementType().getNtType().getId().toString());
            } else {
                row.getCell("settleTypeId").setValue((Object)"");
            }
            row.getCell("settleNumber").setValue((Object)info.getSettlementNumber());
        }
    }

    private PaymentBillCollection getPayColl(String[] ids) throws BOSException {
        EntityViewInfo evi = FMHelper.getIncludeEntityView((String)"id", (String[])ids);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("creator.*"));
        evi.getSelector().add(new SelectorItemInfo("creator.person.*"));
        evi.getSelector().add(new SelectorItemInfo("auditor.*"));
        evi.getSelector().add(new SelectorItemInfo("auditor.person.*"));
        evi.getSelector().add(new SelectorItemInfo("payerAccountBank.*"));
        evi.getSelector().add(new SelectorItemInfo("currency.*"));
        evi.getSelector().add(new SelectorItemInfo("settlementType.*"));
        evi.getSelector().add(new SelectorItemInfo("settlementType.ntType.*"));
        evi.getSelector().add(new SelectorItemInfo("oppAccount.*"));
        PaymentBillCollection coll = PaymentBillFactory.getRemoteInstance().getPaymentBillCollection(evi);
        return coll;
    }

    public void saveAssosicateCheque(ChequeInfo cheque, String[] ids) throws BOSException, EASBizException {
        if (cheque != null) {
            IPaymentBill payment = PaymentBillFactory.getRemoteInstance();
            payment.writeOff(FMHelper.asSet((String[])ids), cheque);
        }
    }
}

