/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.VcStatusEnum;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public class PaymentBillDataProcess {
    static String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";

    public static void setAmountProp(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        PaymentBillEntryCollection coll = info.getEntries();
        if (info.getSourceType() != SourceTypeEnum.AP || coll.size() == 0) {
            return;
        }
        if (info.getCurrency() != null) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()));
            info.setCurrency(currencyInfo);
        }
        if (info.getExchangeRate() == null) {
            PaymentBillDataProcess.throwBlankExcetion(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"399_PaymentBillDataProcess"));
        }
        BigDecimal amountVc = SysConstant.BIGZERO;
        BigDecimal totalAmount = SysConstant.BIGZERO;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            amountVc = coll.get(i).getAmountVc();
            BigDecimal bigDecimal = amountVc = amountVc == null ? SysConstant.BIGZERO : amountVc;
            if (amountVc.compareTo(SysConstant.BIGZERO) == 0) {
                coll.get(i).setVcStatus(VcStatusEnum.NOT_VERIFICATED);
                continue;
            }
            if (amountVc.compareTo(SysConstant.BIGZERO) > 0 && amountVc.compareTo(coll.get(i).getAmount()) < 0) {
                coll.get(i).setVcStatus(VcStatusEnum.PART_VERIFICATED);
                continue;
            }
            if (amountVc.compareTo(coll.get(i).getAmount()) != 0) continue;
            coll.get(i).setVcStatus(VcStatusEnum.FULL_VERIFICATED);
        }
        ExchangeRateInfo rateInfo = CasForArApUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), new Date(), false);
        Object amountLoc = null;
        BigDecimal totalAmountLoc = SysConstant.BIGZERO;
        boolean isDirectExchange = true;
        if (rateInfo != null) {
            isDirectExchange = CasForArApUtil.isDirectExchangeRate(rateInfo);
        }
        int basePrecision = 4;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + info.getCompany().getId().toString() + "'");
        if (companyInfo != null) {
            basePrecision = companyInfo.getBaseCurrency().getPrecision();
        }
        PaymentBillDataProcess.setAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getAmount().compareTo(SysConstant.BIGZERO) == 0) {
                coll.get(i).setAmount(coll.get(i).getActualAmt().add(coll.get(i).getRebate()));
                if (!info.isIsInitializeBill() || info.getEntries().get(i).getUnVcLocAmount() == null || info.getEntries().get(i).getUnVcLocAmount().compareTo(SysConstant.BIGZERO) == 0) {
                    coll.get(i).setLocalAmt(coll.get(i).getActualLocAmt().add(coll.get(i).getRebateLocAmt()));
                }
            }
            if (coll.get(i).getActualAmt().compareTo(SysConstant.BIGZERO) != 0) continue;
            coll.get(i).setActualAmt(coll.get(i).getAmount().subtract(coll.get(i).getRebate()));
            if (info.isIsInitializeBill() && info.getEntries().get(i).getUnVcLocAmount() != null && info.getEntries().get(i).getUnVcLocAmount().compareTo(SysConstant.BIGZERO) != 0) continue;
            coll.get(i).setActualLocAmt(coll.get(i).getLocalAmt().subtract(coll.get(i).getRebateLocAmt()));
        }
        if (info.isIsInitializeBill()) {
            PaymentBillDataProcess.setLockAmt(ctx, info, info.getEntries());
        }
        PaymentBillDataProcess.setUnLockAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        BigDecimal flag = info.getEntries().get(0).getUnVcLocAmount();
        if (!info.isIsInitializeBill() || info.isIsImport() || flag == null || flag.compareTo(SysConstant.BIGZERO) == 0) {
            PaymentBillDataProcess.setUnVcAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        }
        PaymentBillDataProcess.setMatchedAmount(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        PaymentBillDataProcess.setActualAmt(info.getEntries(), info.getExchangeRate(), isDirectExchange, basePrecision);
        if (info.isIsInitializeBill()) {
            PaymentBillDataProcess.setHisUnVcAmt(info.getEntries());
        }
        if (info.getBizType() != null && info.getBizType().getType() != null) {
            SettBizTypeEnum type = info.getBizType().getType();
            info.setSettleBizType(type);
        }
        PaymentBillDataProcess.setHeadAmt(info);
    }

    private static void throwBlankExcetion(String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, new String[]{messageItem});
    }

    private static void setAmt(PaymentBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal Amt = null;
        BigDecimal AmtLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            Amt = coll.get(i).getAmount();
            Amt = Amt == null ? BigDecimal.ZERO : Amt;
            AmtLoc = CasForArApUtil.calculateLocalAmount(Amt, exchangeRate, isDirectExchange, basePrecision);
            coll.get(i).setAmount(Amt);
            coll.get(i).setLocalAmt(AmtLoc);
        }
    }

    private static void setActualAmt(PaymentBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal Amt = null;
        BigDecimal AmtLoc = null;
        BigDecimal actualAmt = null;
        BigDecimal actualAmtLoc = null;
        BigDecimal rebate = null;
        BigDecimal rebateLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            Amt = coll.get(i).getAmount();
            AmtLoc = coll.get(i).getLocalAmt();
            rebate = coll.get(i).getRebate();
            rebate = rebate == null ? BigDecimal.ZERO : rebate;
            rebateLoc = CasForArApUtil.calculateLocalAmount(rebate, exchangeRate, isDirectExchange, basePrecision);
            rebateLoc = rebateLoc == null ? BigDecimal.ZERO : rebateLoc;
            actualAmt = Amt.subtract(rebate);
            actualAmtLoc = AmtLoc.subtract(rebateLoc);
            coll.get(i).setActualAmt(actualAmt);
            coll.get(i).setActualLocAmt(actualAmtLoc);
            coll.get(i).setRebate(rebate);
            coll.get(i).setRebateLocAmt(rebateLoc);
        }
    }

    private static void setHisUnVcAmt(PaymentBillEntryCollection coll) {
        BigDecimal unVcAmt = null;
        BigDecimal unVcLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            unVcAmt = coll.get(i).getUnVcAmount();
            unVcAmt = unVcAmt == null ? SysConstant.BIGZERO : unVcAmt;
            coll.get(i).setHisUnVcAmount(unVcAmt);
            unVcLocAmt = coll.get(i).getUnVcLocAmount();
            unVcLocAmt = unVcLocAmt == null ? SysConstant.BIGZERO : unVcLocAmt;
            coll.get(i).setHisUnVcLocAmount(unVcLocAmt);
        }
    }

    private static void setHeadAmt(PaymentBillInfo info) throws EASBizException, BOSException {
        BigDecimal Amt = null;
        BigDecimal LocAmt = null;
        BigDecimal actualAmt = SysConstant.BIGZERO;
        BigDecimal actualLocAmt = SysConstant.BIGZERO;
        BigDecimal verifiedAmt = SysConstant.BIGZERO;
        BigDecimal verifiedLocAmt = SysConstant.BIGZERO;
        BigDecimal unVerifiedAmt = SysConstant.BIGZERO;
        BigDecimal unVerifiedLocAmt = SysConstant.BIGZERO;
        BigDecimal actualAmtSum = SysConstant.BIGZERO;
        BigDecimal actualLocAmtSum = SysConstant.BIGZERO;
        BigDecimal verifiedAmtSum = SysConstant.BIGZERO;
        BigDecimal verifiedLocAmtSum = SysConstant.BIGZERO;
        BigDecimal unVerifiedAmtSum = SysConstant.BIGZERO;
        BigDecimal unVerifiedLocAmtSum = SysConstant.BIGZERO;
        BigDecimal HAmt = null;
        BigDecimal HLocAmt = null;
        HAmt = SysConstant.BIGZERO;
        HLocAmt = SysConstant.BIGZERO;
        PaymentBillEntryCollection entryColl = info.getEntries();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            Amt = entryColl.get(i).getAmount();
            Amt = Amt == null ? SysConstant.BIGZERO : Amt;
            LocAmt = entryColl.get(i).getLocalAmt();
            LocAmt = LocAmt == null ? SysConstant.BIGZERO : LocAmt;
            HAmt = HAmt.add(Amt);
            HLocAmt = HLocAmt.add(LocAmt);
            actualAmt = entryColl.get(i).getActualAmt();
            actualAmt = actualAmt == null ? SysConstant.BIGZERO : actualAmt;
            actualLocAmt = entryColl.get(i).getActualLocAmt();
            actualLocAmt = actualLocAmt == null ? SysConstant.BIGZERO : actualLocAmt;
            verifiedAmt = entryColl.get(i).getAmountVc();
            verifiedAmt = verifiedAmt == null ? SysConstant.BIGZERO : verifiedAmt;
            verifiedLocAmt = entryColl.get(i).getLocalAmtVc();
            verifiedLocAmt = verifiedLocAmt == null ? SysConstant.BIGZERO : verifiedLocAmt;
            unVerifiedAmt = entryColl.get(i).getUnVcAmount();
            unVerifiedAmt = unVerifiedAmt == null ? SysConstant.BIGZERO : unVerifiedAmt;
            unVerifiedLocAmt = entryColl.get(i).getUnVcLocAmount();
            unVerifiedLocAmt = unVerifiedLocAmt == null ? SysConstant.BIGZERO : unVerifiedLocAmt;
            actualAmtSum = actualAmtSum.add(actualAmt);
            actualLocAmtSum = actualLocAmtSum.add(actualLocAmt);
            verifiedAmtSum = verifiedAmtSum.add(verifiedAmt);
            verifiedLocAmtSum = verifiedLocAmtSum.add(verifiedLocAmt);
            unVerifiedAmtSum = unVerifiedAmtSum.add(unVerifiedAmt);
            unVerifiedLocAmtSum = unVerifiedLocAmtSum.add(unVerifiedLocAmt);
        }
        info.setAmount(HAmt);
        info.setLocalAmt(HLocAmt);
        info.setActPayAmt(actualAmtSum);
        info.setActPayLocAmt(actualLocAmtSum);
        info.setVerifiedAmt(verifiedAmtSum);
        info.setVerifiedAmtLoc(verifiedLocAmtSum);
        info.setUnVerifiedAmt(unVerifiedAmtSum);
        info.setUnVerifiedAmtLoc(unVerifiedLocAmtSum);
    }

    private static void setUnLockAmt(PaymentBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal apAmt = null;
        BigDecimal apLocAmt = null;
        BigDecimal lockAmt = null;
        BigDecimal lockLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            apAmt = coll.get(i).getAmount();
            lockAmt = coll.get(i).getLockAmt();
            lockAmt = lockAmt == null ? SysConstant.BIGZERO : lockAmt;
            coll.get(i).setLockAmt(lockAmt);
            coll.get(i).setUnLockAmt(apAmt.add(lockAmt.negate()));
            apLocAmt = coll.get(i).getLocalAmt();
            lockLocAmt = CasForArApUtil.calculateLocalAmount(lockAmt, exchangeRate, isDirectExchange, basePrecision);
            lockLocAmt = lockLocAmt == null ? SysConstant.BIGZERO : lockLocAmt;
            coll.get(i).setLockLocAmt(lockLocAmt);
            coll.get(i).setUnLockLocAmt(apLocAmt.add(lockLocAmt.negate()));
        }
    }

    private static void setMatchedAmount(PaymentBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) {
        BigDecimal apAmt = null;
        BigDecimal apLocAmt = null;
        BigDecimal matchedAmount = null;
        BigDecimal matchedAmountLoc = null;
        for (int i = 0; i < coll.size(); ++i) {
            apAmt = coll.get(i).getAmount();
            apLocAmt = coll.get(i).getLocalAmt();
            matchedAmount = coll.get(i).getMatchedAmount();
            matchedAmount = matchedAmount == null ? BigDecimal.ZERO : matchedAmount;
            matchedAmountLoc = CasForArApUtil.calculateLocalAmount(matchedAmount, exchangeRate, isDirectExchange, basePrecision);
            coll.get(i).setMatchedAmount(matchedAmount);
            coll.get(i).setMatchedAmountLoc(matchedAmountLoc);
        }
    }

    private static void setLockAmt(Context ctx, PaymentBillInfo info, PaymentBillEntryCollection coll) throws EASBizException, BOSException {
        BigDecimal apAmtVc = null;
        BigDecimal apLocAmtVc = null;
        CurrencyInfo curr = info.getCurrency();
        BigDecimal exchangeRate = info.getExchangeRate();
        boolean isIndirectExRate = PaymentBillDataProcess.getIsIndirectExchangeRate(ctx, curr, null, info.getCompany(), info.getBizDate());
        if (!isIndirectExRate && exchangeRate.compareTo(SysConstant.BIGZERO) != 0) {
            exchangeRate = Constants.ONE.divide(exchangeRate, exchangeRate.scale(), 4);
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            apAmtVc = coll.get(i).getAmountVc();
            apAmtVc = apAmtVc == null ? SysConstant.BIGZERO : apAmtVc;
            coll.get(i).setLockAmt(apAmtVc);
            apLocAmtVc = PaymentBillDataProcess.getLocalAmt(exchangeRate, curr.getPrecision(), apAmtVc);
            apLocAmtVc = apLocAmtVc == null ? SysConstant.BIGZERO : apLocAmtVc;
            coll.get(i).setLockLocAmt(apLocAmtVc);
        }
    }

    private static void setUnVcAmt(PaymentBillEntryCollection coll, BigDecimal exchangeRate, boolean isDirectExchange, int basePrecision) throws EASBizException, BOSException {
        BigDecimal apAmt = null;
        BigDecimal apLocAmt = null;
        BigDecimal vcAmt = null;
        BigDecimal vcLocAmt = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            apAmt = coll.get(i).getAmount();
            vcAmt = coll.get(i).getAmountVc();
            vcAmt = vcAmt == null ? SysConstant.BIGZERO : vcAmt;
            coll.get(i).setUnVcAmount(apAmt.subtract(vcAmt));
            apLocAmt = coll.get(i).getLocalAmt();
            vcLocAmt = CasForArApUtil.calculateLocalAmount(vcAmt, exchangeRate, isDirectExchange, basePrecision);
            vcLocAmt = vcLocAmt == null ? SysConstant.BIGZERO : vcLocAmt;
            coll.get(i).setUnVcLocAmount(apLocAmt.subtract(vcLocAmt));
        }
    }

    private static BigDecimal getLocalAmt(BigDecimal exchangeRate, int precision, BigDecimal amt) {
        if (exchangeRate == null) {
            exchangeRate = new BigDecimal("1");
        }
        return amt.multiply(exchangeRate).setScale(precision, 4);
    }

    private static boolean getIsIndirectExchangeRate(Context ctx, CurrencyInfo srcCurr, CurrencyInfo destCurr, CompanyOrgUnitInfo company, Date date) throws EASBizException, BOSException {
        if (srcCurr == null || date == null) {
            return true;
        }
        if (company == null) {
            company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        }
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (destCurr == null) {
            destCurr = company.getBaseCurrency();
        }
        if (destCurr == null || baseExchangeTable == null) {
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo("baseCurrency.id"));
            selCol.add(new SelectorItemInfo("BaseExchangeTable.id"));
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), selCol);
            baseExchangeTable = companyInfo.getBaseExchangeTable();
            destCurr = companyInfo.getBaseCurrency();
            if (destCurr == null || baseExchangeTable == null) {
                return true;
            }
        }
        date = DateTimeUtils.truncateDate((Date)date);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurr.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurr.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (exRateInfo == null) {
            return true;
        }
        return !exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE);
    }

    public static void setCasAmount(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        boolean isIndirectExRate;
        BigDecimal exchangeRate = info.getExchangeRate();
        if (exchangeRate == null) {
            exchangeRate = Constants.ONE;
        }
        if (!(isIndirectExRate = PaymentBillDataProcess.getIsIndirectExchangeRate(ctx, info.getCurrency(), null, info.getCompany(), info.getBizDate())) && exchangeRate.compareTo(SysConstant.BIGZERO) != 0) {
            exchangeRate = Constants.ONE.divide(exchangeRate, exchangeRate.scale(), 4);
        }
        int baseCurrencyPrecision = 2;
        CurrencyInfo baseCurrency = info.getCompany().getBaseCurrency();
        if (EmptyUtil.isEmpty((CoreBaseInfo)baseCurrency)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            baseCurrency = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), sic).getBaseCurrency();
            baseCurrencyPrecision = baseCurrency.getPrecision();
        } else {
            if (baseCurrency.getPrecision() == 0) {
                baseCurrency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("SELECT id, number, name, precision WHERE id = '" + String.valueOf(baseCurrency.getId()) + "'");
            }
            baseCurrencyPrecision = baseCurrency.getPrecision();
        }
        PaymentBillEntryCollection coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getRebate() == null) {
                coll.get(i).setRebate(SysConstant.BIGZERO);
            }
            if (coll.get(i).getRebateLocAmt() == null) {
                coll.get(i).setRebateLocAmt(PaymentBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getRebate()));
            }
            if (coll.get(i).getAmount() == null) {
                coll.get(i).setAmount(SysConstant.BIGZERO);
            }
            if (coll.get(i).getLocalAmt() == null) {
                coll.get(i).setLocalAmt(PaymentBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getAmount()));
            }
            if (coll.get(i).getActualAmt() != null) {
                coll.get(i).setAmount(coll.get(i).getActualAmt().add(coll.get(i).getRebate()));
                coll.get(i).setLocalAmt(PaymentBillDataProcess.getLocalAmt(exchangeRate, baseCurrencyPrecision, coll.get(i).getAmount()));
            }
            if (coll.get(i).getActualAmt() == null) {
                coll.get(i).setActualAmt(SysConstant.BIGZERO);
            }
            if (coll.get(i).getActualLocAmt() == null) {
                coll.get(i).setActualLocAmt(coll.get(i).getLocalAmt().subtract(coll.get(i).getRebateLocAmt()));
            }
            if (coll.get(i).getActualAmtVc() == null) {
                coll.get(i).setActualAmtVc(SysConstant.BIGZERO);
            }
            if (coll.get(i).getActualLocAmtVc() == null) {
                coll.get(i).setActualLocAmtVc(SysConstant.BIGZERO);
            }
            if (coll.get(i).getMatchedAmount() == null) {
                coll.get(i).setMatchedAmount(SysConstant.BIGZERO);
            }
            if (coll.get(i).getMatchedAmountLoc() != null) continue;
            coll.get(i).setMatchedAmountLoc(SysConstant.BIGZERO);
        }
    }
}

