/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractPaymentBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.DifBankEnum;
import com.kingdee.eas.fi.cas.FundDispatchPlanStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.UrgentDegreeEnum;
import com.kingdee.eas.fi.cas.verifyStatusEnum;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.rpm.BillClaimStatusEnum;
import com.kingdee.eas.fm.ss.SmartType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PaymentBillInfo
extends AbstractPaymentBillInfo
implements Serializable,
IFMBgUsed,
IEASBillHeadInfo {
    public PaymentBillInfo() {
    }

    protected PaymentBillInfo(String pkField) {
        super(pkField);
    }

    public boolean getIsIndirectRate() {
        return this.getBoolean("isIndirectRate");
    }

    public void setIsIndirectRate(boolean item) {
        this.setBoolean("isIndirectRate", item);
    }

    public static SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.number"));
        return sic;
    }

    public boolean isPrePayBill(Context ctx) throws BOSException, EASBizException {
        PaymentBillEntryCollection coll = this.getEntries();
        if (coll == null || coll.size() == 0) {
            return false;
        }
        String srcId = coll.get(0).getSourceBillId();
        if (StringUtils.isEmpty((String)srcId) || !BOSUuid.isValid((String)srcId, (boolean)true)) {
            return false;
        }
        String srcBosType = BOSUuid.read((String)srcId).getType().toString();
        if (this.isPreBillByBosType(srcBosType)) {
            return true;
        }
        if ("D001019A".equalsIgnoreCase(srcBosType)) {
            IBTPManager iBTPManager = null;
            iBTPManager = ctx == null ? BTPManagerFactory.getRemoteInstance() : BTPManagerFactory.getLocalInstance((Context)ctx);
            BOTRelationCollection iObjectColl = iBTPManager.getRelationCollection(srcId, false);
            if (iObjectColl.size() > 0) {
                BOTRelationInfo botRelationInfo = (BOTRelationInfo)iObjectColl.getObject(0);
                return this.isPreBillByBosType(botRelationInfo.getSrcEntityID());
            }
        }
        return false;
    }

    public boolean isPreBillByBosType(String bosType) {
        if (StringUtil.isEmpty((String)bosType)) {
            return false;
        }
        return "3171BFAD".equals(bosType) || "78B50853".equals(bosType) || "F99EE589".equals(bosType);
    }

    public boolean isAssoGen() {
        PaymentBillEntryCollection coll = this.getEntries();
        String sourceBillId = this.getSourceBillId();
        if (sourceBillId == null && (coll == null || coll.get(0) == null)) {
            return false;
        }
        return sourceBillId != null || coll.get(0).getSourceBillId() != null || coll.get(0).getSourceBillEntryId() != null;
    }

    public boolean isAssoGenByEndorsementBill() {
        String sourceBillType = null;
        if (this.getSourceBillId() != null) {
            sourceBillType = BOSUuid.read((String)this.getSourceBillId()).getType().toString();
            return sourceBillType.equals("2584B4A2");
        }
        PaymentBillEntryCollection coll = this.getEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (coll.get(i).getSourceBillId() == null) continue;
            sourceBillType = BOSUuid.read((String)coll.get(i).getSourceBillId()).getType().toString();
            return sourceBillType.equals("2584B4A2");
        }
        return false;
    }

    public boolean isAssoGenByApBill() {
        PaymentBillEntryCollection coll = this.getEntries();
        String sourceBillType = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (coll.get(i).getSourceBillId() != null) {
                sourceBillType = BOSUuid.read((String)coll.get(i).getSourceBillId()).getType().toString();
                return sourceBillType.equals("48DA3A71");
            }
            if (coll.get(i).getSourceBillEntryId() == null) continue;
            sourceBillType = BOSUuid.read((String)coll.get(i).getSourceBillEntryId()).getType().toString();
            return sourceBillType.equals("ED4DBC81");
        }
        return false;
    }

    public boolean isAssoGenByPayPlan() {
        PaymentBillEntryCollection coll = this.getEntries();
        String sourceBillType = null;
        String sourceBillEntryType = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String sourceBillID = coll.get(i).getSourceBillId();
            String sourceBillEntryID = coll.get(i).getSourceBillEntryId();
            if (!StringUtil.isEmpty((String)sourceBillEntryID)) {
                sourceBillEntryType = BOSUuid.read((String)sourceBillEntryID).getType().toString();
            }
            if (StringUtil.isEmpty((String)sourceBillID) || !StringUtil.isEmpty((String)sourceBillEntryID) && !"838B993A".equals(sourceBillEntryType)) continue;
            sourceBillType = BOSUuid.read((String)sourceBillID).getType().toString();
            return sourceBillType.equals("48DA3A71");
        }
        return false;
    }

    public boolean isAssoGenByPayRequestBill() {
        PaymentBillEntryCollection coll = this.getEntries();
        String sourceBillType = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            if (coll.get(i).getSourceBillId() != null) {
                sourceBillType = BOSUuid.read((String)coll.get(i).getSourceBillId()).getType().toString();
                return sourceBillType.equals("D001019A");
            }
            if (coll.get(i).getSourceBillEntryId() == null) continue;
            sourceBillType = BOSUuid.read((String)coll.get(i).getSourceBillEntryId()).getType().toString();
            return sourceBillType.equals("C84206F8");
        }
        return false;
    }

    public PaymentBillInfo copy() {
        PaymentBillInfo newInfo = (PaymentBillInfo)this.clone();
        newInfo.setId(null);
        newInfo.setPayType(null);
        newInfo.setActPayAmtVc(null);
        newInfo.setActPayLocAmtVc(null);
        newInfo.setPayDate(null);
        newInfo.setIsRelateCheque(false);
        newInfo.setCheque(null);
        newInfo.setUseDepartment(null);
        if (this.getUrgentDegree() != null) {
            newInfo.setUrgentDegree(UrgentDegreeEnum.NORMAL);
        }
        newInfo.setCurPlannedPayment(null);
        newInfo.setCurBackPay(null);
        newInfo.setPaymentPlan(null);
        newInfo.setCurReqPercent(null);
        newInfo.setAllReqPercent(null);
        newInfo.setImageSchedule(null);
        newInfo.setBgAmount(null);
        newInfo.setIsRelatePayBook(false);
        newInfo.setEditFlag(null);
        newInfo.setEditFlagNew(null);
        newInfo.setIsCommittoBe(false);
        newInfo.setBankPayState(BankPayingBillStateEnum.DE);
        newInfo.setBankReturnInfo(null);
        newInfo.setSrcAgenPaymentBillID(null);
        newInfo.setAgentPaymentBillID(null);
        newInfo.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
        newInfo.setLastPayeeType(null);
        newInfo.setLastPayeeNumber(null);
        newInfo.setLastPayeeName(null);
        newInfo.setLastPayeeID(null);
        newInfo.setIsNeedPay(true);
        newInfo.setIsReverseLockAmount(true);
        newInfo.setTransUpBillEntryId(null);
        newInfo.setIsDifBank(DifBankEnum.SameBank);
        newInfo.setOppFpItem(null);
        newInfo.setOppBgItemName(null);
        newInfo.setOppBgItemNumber(null);
        newInfo.setOppBgItemId(null);
        newInfo.setCommitBeTime(null);
        newInfo.setSwiftcode(null);
        newInfo.setPrintCount(0);
        newInfo.setBatchNo(null);
        newInfo.setIsRefundmentPay(false);
        newInfo.setIsBackToBE(false);
        newInfo.setIsCBPay(false);
        newInfo.setPayPlanBillID(null);
        newInfo.setFundDispatchPlanStatus(FundDispatchPlanStatusEnum.UNREPORTED);
        newInfo.setIsSmart(SmartType.Open);
        newInfo.setTradedTime(null);
        newInfo.setIsRefund(false);
        newInfo.setBillClaimStatus(BillClaimStatusEnum.UNCLAIM);
        newInfo.setPayBillClaim(null);
        newInfo.setIsRelatePayElecBook(false);
        newInfo.setIsSchCreated(false);
        newInfo.setExpectPayEndDate(null);
        if (newInfo.getPayerAccountBank() != null && newInfo.getPayerAccountBank().isIsClosed()) {
            newInfo.setPayerAccountBank(null);
        }
        if (newInfo.getPayeeAccountBankO() != null && newInfo.getPayeeAccountBankO().isIsClosed()) {
            newInfo.setPayeeAccountBank(null);
            newInfo.setPayeeBank(null);
            newInfo.setPayeeAccountBankO(null);
        }
        newInfo.setIsExchanged(false);
        newInfo.setLastExhangeRate(null);
        newInfo.setIsCommitSettle(false);
        newInfo.setAuditDate(null);
        newInfo.setCashier(null);
        newInfo.setAccountant(null);
        newInfo.setFiVouchered(false);
        newInfo.setBillStatus(BillStatusEnum.SAVE);
        newInfo.setIsImport(false);
        newInfo.setAmount(null);
        newInfo.setLocalAmt(null);
        newInfo.setConceit(null);
        newInfo.setSummary(null);
        newInfo.setContractNo(null);
        newInfo.setDayaccount(null);
        newInfo.setCapitalAmount(null);
        newInfo.setContractBillId(null);
        newInfo.setIsBookRL(false);
        newInfo.setIsRedBill(false);
        newInfo.setIsTransBill(false);
        newInfo.setIsCtrlOppAcct(false);
        newInfo.setIsTransOtherBill(false);
        newInfo.setIsNeedVoucher(true);
        newInfo.setVoucherType(null);
        newInfo.setVoucher(null);
        newInfo.setVoucherNumber(null);
        newInfo.setVerifiedAmt(null);
        newInfo.setUnVerifiedAmt(null);
        newInfo.setVerifiedAmtLoc(null);
        newInfo.setUnVerifiedAmtLoc(null);
        newInfo.setApproveDate(null);
        newInfo.setApprover(null);
        newInfo.setAccepter(null);
        newInfo.setAccepterDate(null);
        newInfo.setIsAppointVoucher(false);
        newInfo.setMixEntryVerify(0);
        newInfo.setIsImpFromGL(false);
        newInfo.setAdminOrgUnitId_SourceBill(null);
        newInfo.setPersonID_SourceBill(null);
        newInfo.setAsstActID_SourceBill(null);
        newInfo.setAsstActTypeID_SourceBill(null);
        newInfo.setBillDate_SourceBill(null);
        newInfo.setIsCoopBuild(false);
        newInfo.setContractNum(null);
        newInfo.setSubSettDate(null);
        newInfo.setPcaVouchered(false);
        newInfo.setBankCheckFlag(null);
        newInfo.setBgCtrlAmt(null);
        newInfo.setIsDiffCurSettlement(false);
        newInfo.setIsPreVerify(false);
        newInfo.setVerifyStatus(verifyStatusEnum.UNVERIFY);
        newInfo.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        newInfo.setIsInitializeBill(false);
        newInfo.setNumber(null);
        newInfo.setBizDate(new Date());
        newInfo.setBillDate(new Date());
        newInfo.setHandler(null);
        newInfo.setHasEffected(false);
        newInfo.setAuditor(null);
        newInfo.setSourceBillId(null);
        newInfo.setSourceFunction(null);
        newInfo.setCreator(null);
        newInfo.setCreateTime(null);
        newInfo.setLastUpdateUser(null);
        newInfo.setLastUpdateTime(null);
        newInfo.setRefundPayBillId(null);
        newInfo.setString("elecBillStatus", null);
        newInfo.setSettleFailMsg(null);
        newInfo.setHasEReceipt(false);
        newInfo.setSettlementNumber(null);
        newInfo.put("receivableBillEntrys", null);
        for (int i = 0; i < newInfo.getAssItems().size(); ++i) {
            newInfo.getAssItems().get(i).setId(null);
        }
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            PaymentBillEntryInfo entry = newInfo.getEntries().get(i);
            for (int j = 0; j < entry.getAssItemsEntries().size(); ++j) {
                entry.getAssItemsEntries().get(j).setId(null);
            }
            entry.setId(null);
            entry.setPaymentBill(null);
            entry.setCostAmt(null);
            entry.setMatchedAmount(null);
            entry.setMatchedAmountLoc(null);
            entry.setPayableDate(null);
            entry.setSrcPlanBillID(null);
            entry.setSrcPlanBillEntryID(null);
            entry.setAmountVc(null);
            entry.setLocalAmtVc(null);
            entry.setUnVcAmount(null);
            entry.setUnVcLocAmount(null);
            entry.setUnVerifyExgRateLoc(null);
            entry.setRebateAmtVc(null);
            entry.setRebateLocAmtVc(null);
            entry.setActualAmtVc(null);
            entry.setActualLocAmtVc(null);
            entry.setLockAmt(null);
            entry.setLockLocAmt(null);
            entry.setUnLockAmt(null);
            entry.setUnLockLocAmt(null);
            entry.setSourceBillId(null);
            entry.setSourceBillEntryId(null);
            entry.setVcStatus(null);
            entry.setHisUnVcAmount(null);
            entry.setHisUnVcLocAmount(null);
            entry.setCoreBillType(null);
            entry.setCoreBillId(null);
            entry.setCoreBillEntryId(null);
            entry.setCoreBillNumber(null);
            entry.setCoreBillEntrySeq(0);
            entry.setTrackNumbet(null);
            entry.setSourceBillAsstActID(null);
            entry.setOtherBillTransAsstTypeId(null);
            entry.setContractNum(null);
            entry.setContractEntrySeq(0);
            entry.setContractBillID(null);
            entry.setContractEntryID(null);
            entry.setTrackNumber(null);
            entry.setBgCtrlAmt(null);
        }
        return newInfo;
    }

    @Override
    public String getLogInfo() {
        if (SourceTypeEnum.FDC.equals((Object)this.getSourceType())) {
            String retValue = "";
            if (this.getNumber() != null) {
                retValue = this.getNumber();
            }
            return retValue;
        }
        return super.getLogInfo();
    }

    public boolean canCommitCH(Boolean needAudited) {
        InnerAccountInfo innerAccount;
        if (this.getSourceBillId() != null) {
            BOSUuid srcBill = BOSUuid.read((String)this.getSourceBillId());
            if (srcBill.getType().equals((Object)new SettlementBillInfo().getBOSType())) {
                return false;
            }
            if (srcBill.getType().equals((Object)new LoanInterestBillInfo().getBOSType())) {
                return false;
            }
        }
        InnerAccountInfo innerAccountInfo = innerAccount = this.getPayerAccountBank() == null ? null : this.getPayerAccountBank().getInnerAcct();
        return needAudited != false ? this.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && this.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT) && innerAccount != null && innerAccount.getClearingHouse().isInGroup() : (this.getBillStatus().equals((Object)BillStatusEnum.AUDITED) || this.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) || this.getBillStatus().equals((Object)BillStatusEnum.APPROVED)) && this.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT) && innerAccount != null && innerAccount.getClearingHouse().isInGroup();
    }

    public boolean canCommitCHForAudit() {
        InnerAccountInfo innerAccount;
        if (this.getSourceBillId() != null) {
            BOSUuid srcBill = BOSUuid.read((String)this.getSourceBillId());
            if (srcBill.getType().equals((Object)new SettlementBillInfo().getBOSType())) {
                return false;
            }
            if (srcBill.getType().equals((Object)new LoanInterestBillInfo().getBOSType())) {
                return false;
            }
        }
        InnerAccountInfo innerAccountInfo = innerAccount = this.getPayerAccountBank() == null ? null : this.getPayerAccountBank().getInnerAcct();
        return this.getBillStatus().equals((Object)BillStatusEnum.AUDITED) && this.getSettlementStatus().equals((Object)SettlementStatusEnum.UNSUBMIT) && innerAccount != null && innerAccount.getClearingHouse().isInGroup() && this.getPayBillType() != null && !this.getPayBillType().isIsFinanceTranUp();
    }

    public boolean needCommitCH() {
        BOSUuid srcBill;
        if (this.getSourceBillId() != null && (srcBill = BOSUuid.read((String)this.getSourceBillId())).getType().equals((Object)new SettlementBillInfo().getBOSType())) {
            return false;
        }
        SettlementStatusEnum settlementStatus = this.getSettlementStatus();
        if (settlementStatus == null) {
            settlementStatus = SettlementStatusEnum.UNSUBMIT;
        }
        if (this.getBizType() == null) {
            return false;
        }
        return settlementStatus.equals((Object)SettlementStatusEnum.UNSUBMIT) && this.getPayerBank() != null && this.getPayerBank().isInGroup();
    }

    public FMBgItemProp[] getBgItemProps() {
        return new FMBgItemProp[]{new FMBgItemProp("outBgItemId", "outBgItemNumber", "outBgItemName"), new FMBgItemProp("oppBgItemId", "oppBgItemNumber", "oppBgItemName")};
    }

    public String getBOTPEditUI() {
        String editUi = null;
        if (SourceTypeEnum.CASH.equals((Object)this.getSourceType())) {
            editUi = "com.kingdee.eas.fi.cas.client.CasPaymentBillUI";
        } else if (SourceTypeEnum.AP.equals((Object)this.getSourceType())) {
            editUi = "com.kingdee.eas.fi.cas.client.PaymentBillUI";
        }
        return editUi;
    }

    public String getBOTPListUI() {
        String listUi = null;
        if (this.isIsCBPay()) {
            listUi = "com.kingdee.eas.fm.cbs.client.CBSPaymentBillListUI";
        } else if (SourceTypeEnum.CASH.equals((Object)this.getSourceType())) {
            listUi = "com.kingdee.eas.fi.cas.client.CasPaymentBillListUI";
        } else if (SourceTypeEnum.AP.equals((Object)this.getSourceType())) {
            listUi = "com.kingdee.eas.fi.cas.client.PaymentBillListUI";
        }
        return listUi;
    }

    public void setExpectDealTime(Date item) {
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp time = Timestamp.valueOf(simpleDate.format(item));
        this.setTimestamp("expectDealTime", time);
    }
}

