/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesCollection;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public class RecPayAcctBankStratageCtrl {
    public static void acctBankBalanceCtrl(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model instanceof PaymentBillInfo) {
            PaymentBillInfo info = (PaymentBillInfo)model;
            if (info.getPayerAccountBank() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("ctrlStrategy.*");
                String bankId = info.getPayerAccountBank().getId().toString();
                AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), sic);
                info.setPayerAccountBank(acctBank);
            }
            RecPayAcctBankStratageCtrl.acctBankBalancePaymentBill(ctx, info);
        } else if (model instanceof ReceivingBillInfo) {
            AccountBankInfo acctBank;
            String bankId;
            SelectorItemCollection sic;
            ReceivingBillInfo info = (ReceivingBillInfo)model;
            if (info.getPayerAccountBankO() != null) {
                sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("ctrlStrategy.*");
                bankId = info.getPayerAccountBankO().getId().toString();
                acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), sic);
                info.setPayerAccountBankO(acctBank);
            }
            if (info.getPayeeAccountBank() != null) {
                sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("ctrlStrategy.*");
                bankId = info.getPayeeAccountBank().getId().toString();
                acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), sic);
                info.setPayeeAccountBank(acctBank);
            }
            RecPayAcctBankStratageCtrl.acctBankBalanceReceivingBill(ctx, info);
        } else if (model instanceof AgentPayBillInfo) {
            AgentPayBillInfo info = (AgentPayBillInfo)model;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("ctrlStrategy.*");
            String bankId = info.getPayBankAccount().getId().toString();
            AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), sic);
            info.setPayBankAccount(acctBank);
            AccountViewInfo acctView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccount().getId().toString()));
            info.setPayerAccount(acctView);
            RecPayAcctBankStratageCtrl.acctBankBalanceAgentPayBill(ctx, info);
        }
    }

    public static void acctBankBalanceCtrl(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        BOSObjectType bosType = BOSUuid.read((String)pk.toString()).getType();
        if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            RecPayAcctBankStratageCtrl.acctBankBalancePaymentBillCtrl(ctx, pk);
        } else if (bosType.equals((Object)new ReceivingBillInfo().getBOSType())) {
            RecPayAcctBankStratageCtrl.acctBankBalanceReceivingBillCtrl(ctx, pk);
        }
    }

    private static void acctBankBalanceAgentPayBill(Context ctx, AgentPayBillInfo info) throws EASBizException, BOSException {
        AccountBankGroupInfo acctBankGroup;
        boolean isCtrlAccountBank = true;
        boolean isCtrlAccountBankGroup = true;
        CurrencyInfo currency = info.getCurrency();
        AccountBankInfo acctBank = info.getPayBankAccount();
        AccountViewInfo acctView = info.getPayerAccount();
        if (acctBank == null) {
            return;
        }
        AccountMgrStrategyInfo strategy = null;
        if (acctBank != null) {
            strategy = acctBank.getCtrlStrategy();
        }
        if (isCtrlAccountBank && strategy == null) {
            isCtrlAccountBank = false;
        }
        if (isCtrlAccountBank && strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            isCtrlAccountBank = false;
        }
        if (info.getAmount().compareTo(Constants.ZERO) <= 0) {
            isCtrlAccountBank = false;
        }
        CompanyOrgUnitInfo company = info.getCompany();
        BigDecimal balance = Constants.ZERO;
        BigDecimal amount = Constants.ZERO;
        if (isCtrlAccountBank) {
            String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (acctBank.isIsSetBankInterface() && !"1".equals(CS132)) {
                String acctBankID = acctBank.getId().toString();
                String currencyID = info.getCurrency().getId().toString();
                balance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankID, currencyID);
            } else {
                balance = RecPayHelper.getTotalBalance(ctx, info.getCompany(), acctView, acctBank, info.getCurrency());
            }
            amount = balance.subtract(info.getAmount());
            RecPayAcctBankStratageCtrl.acctBankStrageCtrl(acctBank, strategy, amount);
        }
        if ((acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBank.getId().toString())) == null || acctBankGroup.getStrategy() == null) {
            isCtrlAccountBankGroup = false;
        } else {
            strategy = acctBankGroup.getStrategy();
        }
        if (isCtrlAccountBankGroup) {
            BigDecimal totalbalance;
            amount = totalbalance = RecPayAcctBankStratageCtrl.getTotalBalance(ctx, company, acctBankGroup, currency, new Date());
            RecPayAcctBankStratageCtrl.acctBankGroupCtrl(acctBankGroup, strategy, amount);
        }
    }

    private static void acctBankBalancePaymentBillCtrl(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payerAccountBank.*");
        sic.add("payerAccountBank.ctrlStrategy.*");
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo(pk, sic);
        RecPayAcctBankStratageCtrl.acctBankBalancePaymentBill(ctx, info);
    }

    private static void acctBankBalancePaymentBill(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        AccountBankGroupInfo acctBankGroup;
        BOSUuid sbid;
        boolean isCtrlAccountBank = true;
        boolean isCtrlAccountBankGroup = true;
        AccountBankInfo acctBank = info.getPayerAccountBank();
        AccountViewInfo acctView = info.getPayerAccount();
        CurrencyInfo currency = info.getCurrency();
        if (acctBank == null) {
            return;
        }
        String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId != null && (sbid = BOSUuid.read((String)sourceBillId)).getType().equals((Object)new TransDetailInfo().getBOSType()) && acctBank.isIsSetBankInterface() && !"1".equals(CS132)) {
            return;
        }
        AccountMgrStrategyInfo strategy = null;
        if (acctBank != null) {
            strategy = acctBank.getCtrlStrategy();
        }
        if (isCtrlAccountBank && strategy == null) {
            isCtrlAccountBank = false;
        }
        if (isCtrlAccountBank && strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            isCtrlAccountBank = false;
        }
        if (info.getActPayAmt().compareTo(Constants.ZERO) <= 0) {
            isCtrlAccountBank = false;
        }
        CompanyOrgUnitInfo company = info.getCompany();
        BigDecimal balance = Constants.ZERO;
        BigDecimal amount = Constants.ZERO;
        if (isCtrlAccountBank) {
            if (acctBank.isIsSetBankInterface() && !"1".equals(CS132)) {
                String acctBankID = acctBank.getId().toString();
                String currencyID = info.getCurrency().getId().toString();
                balance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankID, currencyID);
                amount = balance.subtract(info.getActPayAmt());
            } else {
                amount = balance = RecPayAcctBankStratageCtrl.getBalance(ctx, company, acctBank, acctView, currency, new Date());
            }
            RecPayAcctBankStratageCtrl.acctBankStrageCtrl(acctBank, strategy, amount);
        }
        if ((acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBank.getId().toString())) == null || acctBankGroup.getStrategy() == null) {
            isCtrlAccountBankGroup = false;
        } else {
            strategy = acctBankGroup.getStrategy();
        }
        if (isCtrlAccountBankGroup) {
            BigDecimal totalbalance;
            amount = totalbalance = RecPayAcctBankStratageCtrl.getTotalBalance(ctx, company, acctBankGroup, currency, new Date());
            AccountBankInfo payeeAcct = info.getPayeeAccountBankO();
            if (payeeAcct != null && RecPayAcctBankStratageCtrl.isBelongToAcctBankGroup(payeeAcct, acctBankGroup)) {
                amount = amount.subtract(info.getActPayAmt());
            }
            RecPayAcctBankStratageCtrl.acctBankGroupCtrl(acctBankGroup, strategy, amount);
        }
    }

    private static void acctBankBalanceReceivingBillCtrl(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payeeAccountBank.*");
        sic.add("payeeAccountBank.ctrlStrategy.*");
        sic.add("payeeAccountBank.company.*");
        sic.add("payerAccountBankO.*");
        sic.add("payerAccountBankO.ctrlStrategy.*");
        ReceivingBillInfo info = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillInfo(pk, sic);
        RecPayAcctBankStratageCtrl.acctBankBalanceReceivingBill(ctx, info);
    }

    private static void acctBankBalanceReceivingBill(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        AccountBankGroupInfo acctBankGroup;
        boolean isCtrlAccountBank = true;
        boolean isCtrlAccountBankGroup = true;
        AccountBankInfo acctBank = info.getPayeeAccountBank();
        AccountViewInfo acctView = info.getOppAccount();
        CompanyOrgUnitInfo company = info.getCompany();
        CurrencyInfo currency = info.getCurrency();
        if (acctBank == null || !acctBank.getCompany().getId().equals((Object)company.getId())) {
            return;
        }
        AccountMgrStrategyInfo strategy = null;
        if (isCtrlAccountBank) {
            strategy = acctBank.getCtrlStrategy();
        }
        if (strategy == null) {
            isCtrlAccountBank = false;
        }
        if (isCtrlAccountBank && strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            isCtrlAccountBank = false;
        }
        if (isCtrlAccountBank && info.getActRecAmt().compareTo(Constants.ZERO) >= 0) {
            isCtrlAccountBank = false;
        }
        BigDecimal balance = Constants.ZERO;
        BigDecimal amount = Constants.ZERO;
        if (isCtrlAccountBank) {
            amount = balance = RecPayAcctBankStratageCtrl.getBalance(ctx, company, acctBank, acctView, currency, new Date());
            RecPayAcctBankStratageCtrl.acctBankStrageCtrl(acctBank, strategy, amount);
        }
        if ((acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBank.getId().toString())) == null || acctBankGroup.getStrategy() == null) {
            isCtrlAccountBankGroup = false;
        } else {
            strategy = acctBankGroup.getStrategy();
        }
        if (isCtrlAccountBankGroup) {
            BigDecimal totalbalance;
            amount = totalbalance = RecPayAcctBankStratageCtrl.getTotalBalance(ctx, company, acctBankGroup, currency, new Date());
            AccountBankInfo payeeAcct = info.getPayeeAccountBank();
            if (payeeAcct != null && RecPayAcctBankStratageCtrl.isBelongToAcctBankGroup(payeeAcct, acctBankGroup)) {
                amount = amount.subtract(info.getActRecAmt());
            }
            RecPayAcctBankStratageCtrl.acctBankGroupCtrl(acctBankGroup, strategy, amount);
        }
    }

    private static boolean isBelongToAcctBankGroup(AccountBankInfo acctBank, AccountBankGroupInfo group) {
        boolean isBelongTo = false;
        AcctBankGroupEntriesCollection entries = group.getEntries();
        int j = entries.size();
        for (int i = 0; i < j; ++i) {
            AcctBankGroupEntriesInfo entry = entries.get(i);
            AccountBankInfo entryAcct = entry.getAcctBank();
            if (!acctBank.getId().toString().equals(entryAcct.getId().toString())) continue;
            isBelongTo = true;
            break;
        }
        return isBelongTo;
    }

    public static void acctBankGroupCtrl(AccountBankGroupInfo acctBankGroup, AccountMgrStrategyInfo strategy, BigDecimal amount) throws BOSException, AccountBankException {
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.GROUPOVERDRAFT, new Object[]{acctBankGroup.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(Constants.ZERO) < 0) {
                throw new AccountBankException(AccountBankException.GROUPNOALLOWOVERDRAFT, new Object[]{acctBankGroup.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.GROUPOVERLOWAMOUNT, new Object[]{acctBankGroup.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
    }

    private static void acctBankStrageCtrl(AccountBankInfo acctBank, AccountMgrStrategyInfo strategy, BigDecimal amount) throws BOSException, AccountBankException {
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{acctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(Constants.ZERO) < 0) {
                throw new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{acctBank.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{acctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
    }

    private static BigDecimal getTotalBalance(Context ctx, CompanyOrgUnitInfo company, AccountBankGroupInfo acctBankGroup, CurrencyInfo currency, Date date) throws BOSException, EASBizException {
        BigDecimal totalBal = Constants.ZERO;
        BigDecimal bal = Constants.ZERO;
        AcctBankGroupEntriesCollection entries = acctBankGroup.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankGroupEntriesInfo entry = entries.get(i);
            AccountBankInfo acctBank = entry.getAcctBank();
            bal = RecPayAcctBankStratageCtrl.getBalance(ctx, company, acctBank, null, currency, date);
            totalBal = totalBal.add(bal);
        }
        return totalBal;
    }

    private static BigDecimal getBalance(Context ctx, CompanyOrgUnitInfo company, AccountBankInfo acctBank, AccountViewInfo view, CurrencyInfo currency, Date date) throws BOSException, EASBizException {
        return RecPayHelper.getTotalBalance(ctx, company, view, acctBank, currency);
    }

    public static void verifyOverDraft(CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, CoreBillBaseInfo editData) throws Exception {
        if (editData instanceof PaymentBillInfo) {
            PaymentBillInfo paymentbill = (PaymentBillInfo)editData;
            RecPayAcctBankStratageCtrl.verifyOverDraftForPaymentBill(bean, strategy, balance, paymentbill);
        } else if (editData instanceof ReceivingBillInfo) {
            ReceivingBillInfo receivingBill = (ReceivingBillInfo)editData;
            RecPayAcctBankStratageCtrl.verifyOverDraftForReceivingBill(bean, strategy, balance, receivingBill);
        } else if (editData instanceof FundsMoveBillInfo) {
            FundsMoveBillInfo fmbi = (FundsMoveBillInfo)editData;
            RecPayAcctBankStratageCtrl.verifyOverDraftForFundsMoveBillInfo(bean, strategy, balance, fmbi);
        } else if (editData instanceof AgentPayBillInfo) {
            AgentPayBillInfo apbi = (AgentPayBillInfo)editData;
            RecPayAcctBankStratageCtrl.verifyOverDraftForAgentPayBill(bean, strategy, balance, apbi);
        }
    }

    private static void verifyOverDraftForAgentPayBill(CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, AgentPayBillInfo editData) throws Exception {
        String msg;
        int result;
        boolean isAcctViewNotChanged;
        if (balance == null) {
            return;
        }
        boolean isCtrlAcctBank = true;
        boolean isCtrlAcctBankGroup = true;
        AccountBankInfo payerAcctBank = editData.getPayBankAccount();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        boolean isRemind = false;
        if (strategy != null) {
            if (null == strategy.getOverdraftCtrl()) {
                strategy = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(strategy.getId()));
            }
            isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayBankAccount() != null && bean.getAcctBank().getId().equals((Object)editData.getPayBankAccount().getId());
        boolean bl = isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayBankAccount() == null && bean.getAcctView() != null && editData.getPayerAccount() != null && bean.getAcctView().getId().equals((Object)editData.getPayerAccount().getId());
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(bean.getOrignalAmt());
        }
        BigDecimal amount = balance.subtract(editData.getAmount());
        RecPayAcctBankStratageCtrl.ctrlAcctBank(strategy, isCtrlAcctBank, payerAcctBank, isRemind, amount);
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getRemoteInstance().getAcctBankGroup(editData.getPayBankAccount().getId().toString());
        if (acctBankGroup == null) {
            return;
        }
        strategy = acctBankGroup.getStrategy();
        isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getRemoteInstance().getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            totalbalance = totalbalance.add(bean.getOrignalAmt());
        }
        if ((amount = totalbalance.subtract(editData.getActualAmount())).compareTo(Constants.ZERO) < 0 && isRemind && (result = MsgBox.showConfirm2(null, (String)(msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"GroupBALLESSTHANODAMT")))) == 2) {
            SysUtil.abort();
        }
    }

    private static void verifyOverDraftForFundsMoveBillInfo(CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, FundsMoveBillInfo editData) throws Exception {
        String msg;
        int result;
        boolean isAcctViewNotChanged;
        if (balance == null) {
            return;
        }
        boolean isCtrlAcctBank = true;
        boolean isCtrlAcctBankGroup = true;
        AccountBankInfo moveOutAcctBank = editData.getMoveOutBankAccount();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        boolean isRemind = false;
        if (strategy != null) {
            if (null == strategy.getOverdraftCtrl()) {
                strategy = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(strategy.getId()));
            }
            isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        boolean isAcctBankNotChanged = bean.getAcctBank() != null && moveOutAcctBank != null && bean.getAcctBank().getId().equals((Object)moveOutAcctBank.getId());
        boolean bl = isAcctViewNotChanged = bean.getAcctBank() == null && editData.getMoveOutBankAccount() == null && bean.getAcctView() != null && editData.getMoveOutBankAccount() != null && bean.getAcctView().getId().equals((Object)editData.getMoveOutBankAccount().getId());
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(bean.getOrignalAmt());
        }
        BigDecimal amount = balance.subtract(editData.getMoveOutAmount());
        RecPayAcctBankStratageCtrl.ctrlAcctBank(strategy, isCtrlAcctBank, moveOutAcctBank, isRemind, amount);
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getRemoteInstance().getAcctBankGroup(editData.getMoveOutBankAccount().getId().toString());
        if (acctBankGroup == null) {
            return;
        }
        strategy = acctBankGroup.getStrategy();
        isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getMoveOutCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getRemoteInstance().getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            totalbalance = totalbalance.add(bean.getOrignalAmt());
        }
        if ((amount = totalbalance.subtract(editData.getMoveOutAmount())).compareTo(Constants.ZERO) < 0 && isRemind && (result = MsgBox.showConfirm2(null, (String)(msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"GroupBALLESSTHANODAMT")))) == 2) {
            SysUtil.abort();
        }
    }

    private static void verifyOverDraftForPaymentBill(CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, PaymentBillInfo editData) throws Exception {
        String msg;
        int result;
        boolean isAcctViewNotChanged;
        if (balance == null) {
            return;
        }
        boolean isCtrlAcctBank = true;
        AccountBankInfo payerAcctBank = editData.getPayerAccountBank();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        boolean isRemind = false;
        if (strategy != null) {
            isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayerAccountBank() != null && bean.getAcctBank().getId().equals((Object)editData.getPayerAccountBank().getId());
        boolean bl = isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayerAccountBank() == null && bean.getAcctView() != null && editData.getPayerAccount() != null && bean.getAcctView().getId().equals((Object)editData.getPayerAccount().getId());
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(bean.getOrignalAmt());
        }
        BigDecimal amount = balance.subtract(editData.getActPayAmt());
        RecPayAcctBankStratageCtrl.ctrlAcctBank(strategy, isCtrlAcctBank, payerAcctBank, isRemind, amount);
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getRemoteInstance().getAcctBankGroup(editData.getPayerAccountBank().getId().toString());
        if (acctBankGroup == null) {
            return;
        }
        strategy = acctBankGroup.getStrategy();
        isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getRemoteInstance().getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            totalbalance = totalbalance.add(bean.getOrignalAmt());
        }
        if ((amount = totalbalance.subtract(editData.getActPayAmt())).compareTo(Constants.ZERO) < 0 && isRemind && (result = MsgBox.showConfirm2(null, (String)(msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"GroupBALLESSTHANODAMT")))) == 2) {
            SysUtil.abort();
        }
    }

    public static void ctrlAcctBank(AccountMgrStrategyInfo strategy, boolean isCtrlAcctBank, AccountBankInfo payerAcctBank, boolean isRemind, BigDecimal amount) throws AccountBankException {
        if (isCtrlAcctBank && amount.compareTo(Constants.ZERO) < 0 && isRemind) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"BALLESSTHANODAMTDETAIL");
            int result = MsgBox.showConfirm2(null, (String)(msg = MessageFormat.format(msg, payerAcctBank.getName(), amount.abs())));
            if (result == 2) {
                SysUtil.abort();
            } else {
                return;
            }
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{payerAcctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(Constants.ZERO) < 0) {
                throw new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{payerAcctBank.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{payerAcctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
    }

    public static String ctrlAcctBankForTip(AccountMgrStrategyInfo strategy, boolean isCtrlAcctBank, AccountBankInfo payerAcctBank, boolean isRemind, BigDecimal amount) throws AccountBankException {
        if (isCtrlAcctBank && amount.compareTo(Constants.ZERO) < 0 && isRemind) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"BALLESSTHANODAMTDETAIL");
            msg = MessageFormat.format(msg, payerAcctBank.getName(), amount.abs());
            return msg;
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{payerAcctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(Constants.ZERO) < 0) {
                throw new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{payerAcctBank.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{payerAcctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
        return "";
    }

    public static void verifyOverDraftForReceivingBill(CasRecPayHandler.RecPayInstanceAmountBean bean, AccountMgrStrategyInfo strategy, BigDecimal balance, ReceivingBillInfo editData) throws Exception {
        String msg;
        int result;
        if (balance == null) {
            return;
        }
        boolean isCtrlAcctBank = true;
        boolean isRemind = false;
        AccountBankInfo payerAcctBank = editData.getPayerAccountBankO();
        if (payerAcctBank == null || !payerAcctBank.getCompany().getId().equals((Object)editData.getCompany().getId())) {
            return;
        }
        boolean isAcctBankNotChanged = bean.getAcctBank() != null && editData.getPayerAccountBankO() != null && bean.getAcctBank().getId().equals((Object)editData.getPayerAccountBankO().getId());
        boolean isAcctViewNotChanged = bean.getAcctBank() == null && editData.getPayerAccountBank() == null && bean.getAcctView() != null && editData.getOppAccount() != null && bean.getAcctView().getId().equals((Object)editData.getOppAccount().getId());
        String companyID = editData.getCompany().getId().toString();
        String acctBankID = payerAcctBank.getId().toString();
        String currencyID = editData.getCurrency().getId().toString();
        Map resultMap = BatchFetchParamFacadeFactory.getRemoteInstance().instanceBalanceResult(companyID, acctBankID, currencyID);
        balance = (BigDecimal)resultMap.get("acctBankBalance");
        AccountBankGroupInfo acctBankGroup = (AccountBankGroupInfo)resultMap.get("acctBankGroup");
        BigDecimal acctBankGroupBalance = (BigDecimal)resultMap.get("acctBankGroupBalance");
        strategy = payerAcctBank.getCtrlStrategy();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        if (strategy != null) {
            boolean bl = isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(bean.getOrignalAmt());
        }
        BigDecimal amount = balance.subtract(editData.getActRecAmt());
        RecPayAcctBankStratageCtrl.ctrlAcctBank(strategy, isCtrlAcctBank, payerAcctBank, isRemind, amount);
        if (acctBankGroup == null) {
            return;
        }
        strategy = acctBankGroup.getStrategy();
        boolean bl = isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            acctBankGroupBalance = acctBankGroupBalance.add(bean.getOrignalAmt());
        }
        amount = acctBankGroupBalance.subtract(editData.getActRecAmt());
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getRemoteInstance().getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        amount = totalbalance.subtract(editData.getActRecAmt());
        if (amount.compareTo(Constants.ZERO) < 0 && isRemind && (result = MsgBox.showConfirm2(null, (String)(msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"GroupBALLESSTHANODAMT")))) == 2) {
            SysUtil.abort();
        }
    }

    public static void acctBankBalanceSettleBillCtrlSingle(Context ctx, IObjectValue model, AccountMgrStrategyInfo strategy, boolean isPay) throws EASBizException, BOSException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        boolean isCtrlAccountBank = true;
        AccountBankInfo acctBank = info.getPayerBankAcct();
        AccountViewInfo acctView = info.getPayerAcct();
        CurrencyInfo currency = info.getCurrency();
        if (acctBank == null) {
            return;
        }
        if (isCtrlAccountBank && strategy == null) {
            isCtrlAccountBank = false;
        }
        if (isCtrlAccountBank && strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            isCtrlAccountBank = false;
        }
        if (info.getAmount().compareTo(Constants.ZERO) <= 0) {
            isCtrlAccountBank = false;
        }
        CompanyOrgUnitInfo company = info.getCompany();
        BigDecimal balance = Constants.ZERO;
        BigDecimal amount = Constants.ZERO;
        if (isCtrlAccountBank) {
            String CS132 = "";
            IPaymentBill iPaymentBill = null;
            if (ctx == null) {
                CS132 = ContextHelperFactory.getRemoteInstance().getStringParam("CS132", (IObjectPK)new ObjectUuidPK(company.getId()));
                iPaymentBill = PaymentBillFactory.getRemoteInstance();
            } else {
                CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)new ObjectUuidPK(company.getId()));
                iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
            }
            if (acctBank != null && acctBank.isIsSetBankInterface() && !"1".equals(CS132)) {
                String acctBankID = acctBank.getId().toString();
                String currencyID = currency.getId().toString();
                balance = iPaymentBill.getBalanceValue(acctBankID, currencyID);
                amount = balance.subtract(info.getAmount());
            } else {
                balance = RecPayAcctBankStratageCtrl.getSettleBillBalance(ctx, company, acctBank, acctView, currency, new Date(), isPay);
                boolean isSaved = SettlementBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()));
                boolean isHasEffected = info.isHasEffected();
                if (isSaved) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("hasEffected");
                    SettlementBillInfo newinfo = SettlementBillFactory.getLocalInstance((Context)ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
                    if (newinfo != null) {
                        isHasEffected = newinfo.isHasEffected();
                    }
                }
                amount = !isSaved || !isHasEffected || isPay ? balance.subtract(info.getAmount()) : balance;
            }
            RecPayAcctBankStratageCtrl.acctBankStrageCtrl(acctBank, strategy, amount);
        }
    }

    public static void acctBankBalanceSettleBillCtrlGroup(Context ctx, IObjectValue model, AccountMgrStrategyInfo strategy, boolean isPay) throws EASBizException, BOSException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        boolean isCtrlAccountBankGroup = true;
        AccountBankInfo acctBank = info.getPayerBankAcct();
        CurrencyInfo currency = info.getCurrency();
        if (acctBank == null) {
            return;
        }
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBank.getId().toString());
        if (acctBankGroup == null) {
            return;
        }
        if (isCtrlAccountBankGroup && strategy == null) {
            isCtrlAccountBankGroup = false;
        }
        if (isCtrlAccountBankGroup && strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            isCtrlAccountBankGroup = false;
        }
        if (info.getAmount().compareTo(Constants.ZERO) <= 0) {
            isCtrlAccountBankGroup = false;
        }
        CompanyOrgUnitInfo company = info.getCompany();
        BigDecimal amount = Constants.ZERO;
        if (isCtrlAccountBankGroup) {
            BigDecimal totalbalance = RecPayAcctBankStratageCtrl.getTotalSettleBillBalance(ctx, company, acctBankGroup, currency, new Date(), isPay);
            boolean isSaved = SettlementBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()));
            amount = !isSaved || !info.isHasEffected() || isPay ? totalbalance.subtract(info.getAmount()) : totalbalance;
            RecPayAcctBankStratageCtrl.acctBankGroupCtrl(acctBankGroup, strategy, amount);
        }
    }

    public static BigDecimal getSettleBillBalance(Context ctx, CompanyOrgUnitInfo company, AccountBankInfo acctBank, AccountViewInfo view, CurrencyInfo currency, Date date, boolean isPay) throws BOSException, EASBizException {
        return RecPayHelper.getSettleBillTotalBalance(ctx, company, view, acctBank, currency, isPay);
    }

    public static BigDecimal getTotalSettleBillBalance(Context ctx, CompanyOrgUnitInfo company, AccountBankGroupInfo acctBankGroup, CurrencyInfo currency, Date date, boolean isPay) throws BOSException, EASBizException {
        BigDecimal totalBal = Constants.ZERO;
        BigDecimal bal = Constants.ZERO;
        AcctBankGroupEntriesCollection entries = acctBankGroup.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankGroupEntriesInfo entry = entries.get(i);
            AccountBankInfo acctBank = entry.getAcctBank();
            bal = RecPayAcctBankStratageCtrl.getSettleBillBalance(ctx, company, acctBank, null, currency, date, isPay);
            totalBal = totalBal.add(bal);
        }
        return totalBal;
    }
}

