/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class VoucherImport2JournalByEntryBuilder
extends DefaultBookNotifyBuilder {
    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        set.add(billId);
        return this.getJournalColl(ctx, set);
    }

    private JournalInfo createBaseJournalInfo(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(voucherInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYVOUCHER);
        journalInfo.setBizDate(DateTimeUtils.truncateDate((Date)voucherInfo.getBizDate()));
        journalInfo.setVoucherType(voucherInfo.getVoucherType());
        journalInfo.setVoucherNumber(voucherInfo.getNumber());
        journalInfo.setBillType(BillTypeEnum.voucher);
        journalInfo.setBillNumber(voucherInfo.getNumber());
        Date bookDate = voucherInfo.getBookedDate();
        journalInfo.setCreateDate(bookDate);
        journalInfo.setPeriod(voucherInfo.getPeriod());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }

    private JournalCollection createBankJournalByEntry(Context ctx, VoucherEntryInfo voucherEntryInfo, AccountViewInfo accountViewInfo, JournalInfo tempJournal) throws BOSException, EASBizException {
        JournalCollection journalColl = new JournalCollection();
        String accountId = accountViewInfo.getId().toString();
        VoucherAssistRecordCollection voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
        if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0) {
            JournalInfo journalInfo = new JournalInfo();
            journalInfo.putAll((IObjectValue)tempJournal);
            AccountBankInfo bankAcct = this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)bankAcct)) {
                journalInfo.setAccountBank(bankAcct);
                journalColl.add(journalInfo);
            }
        } else {
            for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
                AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
                AccountBankInfo accountBankInfo = null;
                if (assistantHGInfo != null) {
                    accountBankInfo = assistantHGInfo.getBankAccount();
                }
                if (accountBankInfo == null) {
                    accountBankInfo = this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber());
                }
                JournalInfo journalInfo = new JournalInfo();
                journalInfo.putAll((IObjectValue)tempJournal);
                journalInfo.setAccountBank(accountBankInfo);
                if (accountBankInfo != null && accountBankInfo.getAccount() != null) {
                    journalInfo.setAccountView(accountBankInfo.getAccount());
                }
                if (assistRecordInfo.getSettlementType() != null) {
                    journalInfo.setSettlementType(assistRecordInfo.getSettlementType());
                }
                journalInfo.setSettlementNumber(assistRecordInfo.getSettlementCode());
                if (assistRecordInfo.getDescription() != null) {
                    String desc = assistRecordInfo.getDescription();
                    journalInfo.setDescription(desc);
                }
                if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    journalInfo.setCreditAmount(assistRecordInfo.getOriginalAmount());
                } else if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    journalInfo.setDebitAmount(assistRecordInfo.getOriginalAmount());
                }
                journalInfo.setBizDate(assistRecordInfo.getBizDate());
                journalColl.add(journalInfo);
            }
        }
        return journalColl;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set entryset) throws BOSException, EASBizException {
        int i;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryset, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = ev.getSelector();
        sic.add("*");
        sic.add("bill.*");
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.isCash"));
        sic.add(new SelectorItemInfo("account.isBank"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("assistRecords.*"));
        sic.add(new SelectorItemInfo("assistRecords.settlementType.*"));
        sic.add(new SelectorItemInfo("assistRecords.assGrp.*"));
        sic.add(new SelectorItemInfo("assistRecords.assGrp.bankAccount.*"));
        sic.add(new SelectorItemInfo("assistRecords.assGrp.bankAccount.name"));
        sic.add(new SelectorItemInfo("assistRecords.assGrp.bankAccount.account.*"));
        sic.add(new SelectorItemInfo("assistRecords.assGrp.bankAccount.account.name"));
        SorterItemCollection sorter = ev.getSorter();
        SorterItemInfo sorterinfo = new SorterItemInfo("bill.bookedDate");
        sorterinfo.setSortType(SortType.DESCEND);
        sorter.add(sorterinfo);
        SorterItemInfo sorterinfo2 = new SorterItemInfo("bill.createTime");
        sorterinfo2.setSortType(SortType.DESCEND);
        sorter.add(sorterinfo2);
        sorter.add(new SorterItemInfo("bill.id"));
        sorter.add(new SorterItemInfo("seq"));
        IVoucherEntry voucher = VoucherEntryFactory.getLocalInstance((Context)ctx);
        VoucherEntryCollection cashOrBankVoucherEntry = voucher.getVoucherEntryCollection(ev);
        JournalCollection journalCollection = new JournalCollection();
        int size = cashOrBankVoucherEntry.size();
        for (i = 0; i < size; ++i) {
            VoucherEntryInfo voucherEntryInfo1 = cashOrBankVoucherEntry.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo1.getAccount();
            JournalInfo journalInfo = this.createBaseJournalInfo(ctx, voucherEntryInfo1.getBill());
            if (accountViewInfo.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
            } else if (accountViewInfo.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setCurrency(voucherEntryInfo1.getCurrency());
            journalInfo.setAccountView(voucherEntryInfo1.getAccount());
            journalInfo.setBillEntryID(voucherEntryInfo1.getId().toString());
            journalInfo.setDescription(voucherEntryInfo1.getDescription());
            if (voucherEntryInfo1.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                journalInfo.setCreditAmount(voucherEntryInfo1.getOriginalAmount());
            } else if (voucherEntryInfo1.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                journalInfo.setDebitAmount(voucherEntryInfo1.getOriginalAmount());
            }
            if (accountViewInfo.isIsBank()) {
                journalCollection.addCollection(this.createBankJournalByEntry(ctx, voucherEntryInfo1, accountViewInfo, journalInfo));
                continue;
            }
            if (!accountViewInfo.isIsCash()) continue;
            journalCollection.add(journalInfo);
        }
        for (i = journalCollection.size() - 1; i >= 0; --i) {
            JournalInfo journal = journalCollection.get(i);
            journal.setBillType(BillTypeEnum.voucherEntry);
            journal.setBillId(journal.getBillEntryID());
        }
        return journalCollection;
    }

    protected AccountBankInfo getBankAccountOnNoAssist(Context ctx, String accountId, String acctNumber) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = null;
        IAccountBank accountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        evi.setFilter(fi);
        evi.getSelector().add("*");
        evi.getSelector().add("account.*");
        AccountBankCollection accountBankCollection = accountBank.getAccountBankCollection(evi);
        if (acctNumber == null) {
            acctNumber = "";
        }
        if (accountBankCollection == null || accountBankCollection.size() == 0) {
            return accountBankInfo;
        }
        if (accountBankCollection.size() > 1) {
            throw new BookNotifyException(BookNotifyException.MULTI_ACCOUNT, new Object[]{acctNumber});
        }
        accountBankInfo = accountBankCollection.get(0);
        return accountBankInfo;
    }
}

