/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class XTable
implements Serializable {
    private static Logger logger = Logger.getLogger((String)XTable.class.getName());
    private Map table = new HashMap();
    private List columnKeys;
    private List pkColumn;

    public XTable() {
        this.columnKeys = new ArrayList();
        this.pkColumn = new ArrayList();
    }

    public XTable(IObjectCollection collection, String[] columnKeys) {
        this.columnKeys = new ArrayList();
        if (columnKeys != null) {
            for (int i = 0; i < columnKeys.length; ++i) {
                this.addColumn(columnKeys[i]);
            }
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue object = collection.getObject(i);
            Map row = this.addRow(object.getString("id"));
            if (columnKeys != null) {
                for (int j = 0; j < columnKeys.length; ++j) {
                    Object value = object.get(columnKeys[j]);
                    if (value instanceof IObjectValue) {
                        row.put(columnKeys[j], ((IObjectValue)value).get("id").toString());
                        continue;
                    }
                    row.put(columnKeys[j], value);
                }
            }
            this.setUserObject(row, object);
        }
    }

    public XTable(IObjectCollection collection, String columnKey) {
        this.columnKeys = new ArrayList();
        if (columnKey != null) {
            this.addColumn(columnKey);
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue object = collection.getObject(i);
            Map row = this.addRow(object.getString("id"));
            if (columnKey != null) {
                Object value = object.get(columnKey);
                if (value instanceof IObjectValue) {
                    row.put(columnKey, ((IObjectValue)value).get("id").toString());
                } else {
                    row.put(columnKey, value);
                }
            }
            this.setUserObject(row, object);
        }
    }

    public void setUserObject(Map row, Object object) {
        this.setRowProperty(row, "UserObject", object);
    }

    public void getUserObject(Map row) {
        this.getRowProperty(row, "UserObject");
    }

    public XTable(IRowSet rs, String[] keyFields) {
        try {
            this.createByRowSet(rs, keyFields);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
    }

    public void deleteRow(String rowKey) {
        this.table.remove(rowKey);
    }

    public String[] getRowKeys() {
        return this.table.keySet().toArray(new String[this.getRowCount()]);
    }

    public boolean existColumn(String columnKey) {
        return this.columnKeys.contains(columnKey);
    }

    public void addColumn(String columnKey, Map column) {
        if (this.existColumn(columnKey)) {
            return;
        }
        this.addColumn(columnKey);
        Set keys = column.keySet();
        for (String key : keys) {
            Map row = this.getRow(key);
            if (row == null) {
                row = this.addRow(key);
            }
            row.put(columnKey, column.get(key));
        }
    }

    public void addColumn(String columnKey) {
        this.columnKeys.add(columnKey);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Map row = this.getRow(i);
            row.put(columnKey, null);
        }
    }

    public String getRowKey(int index) {
        return (String)this.table.keySet().toArray()[index];
    }

    public Map getRow(int index) {
        return (Map)this.table.values().toArray()[index];
    }

    public Map getRow(String rowKey) {
        return (Map)this.table.get(rowKey);
    }

    public List getRows() {
        ArrayList<Map> rows = new ArrayList<Map>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public List getContainRows(String columnKey, String[] values) {
        HashSet<String> valueSet = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            valueSet.add(values[i]);
        }
        FilterItemCollection items = new FilterItemCollection();
        items.add(new FilterItemInfo(columnKey, valueSet, CompareType.INCLUDE));
        return this.getRows(items);
    }

    public List getEqualRows(String columnKey, String value) {
        FilterItemCollection items = new FilterItemCollection();
        items.add(new FilterItemInfo(columnKey, (Object)value));
        return this.getRows(items);
    }

    public List getRows(FilterItemCollection items) {
        if (items.size() == 0) {
            return this.getRows();
        }
        ArrayList<Map> rows = new ArrayList<Map>();
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            Map row = this.getRow(i);
            boolean isAccord = true;
            for (int j = 0; j < items.size(); ++j) {
                Object o;
                FilterItemInfo item = items.get(j);
                String colKey = item.getPropertyName();
                Object value = item.getCompareValue();
                if (item.getCompareType().equals((Object)CompareType.EQUALS)) {
                    if (row.get(colKey).equals(value)) continue;
                    isAccord = false;
                    continue;
                }
                if (item.getCompareType().equals((Object)CompareType.INCLUDE)) {
                    if (((Set)value).contains(row.get(colKey))) continue;
                    isAccord = false;
                    continue;
                }
                if (item.getCompareType().equals((Object)CompareType.GREATER)) {
                    o = row.get(colKey);
                    if (o instanceof Date) {
                        if (((Date)o).after((Date)value)) continue;
                        isAccord = false;
                        continue;
                    }
                    if (o instanceof BigDecimal) {
                        if (((BigDecimal)o).compareTo((BigDecimal)value) > 0) continue;
                        isAccord = false;
                        continue;
                    }
                    if (!(o instanceof Integer) || ((Integer)o).compareTo((Integer)value) > 0) continue;
                    isAccord = false;
                    continue;
                }
                if (item.getCompareType().equals((Object)CompareType.LESS)) {
                    o = row.get(colKey);
                    if (o instanceof Date) {
                        if (((Date)o).before((Date)value)) continue;
                        isAccord = false;
                        continue;
                    }
                    if (o instanceof BigDecimal) {
                        if (((BigDecimal)o).compareTo((BigDecimal)value) < 0) continue;
                        isAccord = false;
                        continue;
                    }
                    if (!(o instanceof Integer) || ((Integer)o).compareTo((Integer)value) < 0) continue;
                    isAccord = false;
                    continue;
                }
                if (!item.getCompareType().equals((Object)CompareType.GREATER_EQUALS)) continue;
                o = row.get(colKey);
                if (o instanceof Date) {
                    if (!((Date)o).before((Date)value)) continue;
                    isAccord = false;
                    continue;
                }
                if (o instanceof BigDecimal) {
                    if (((BigDecimal)o).compareTo((BigDecimal)value) >= 0) continue;
                    isAccord = false;
                    continue;
                }
                if (!(o instanceof Integer) || ((Integer)o).compareTo((Integer)value) >= 0) continue;
                isAccord = false;
            }
            if (!isAccord) continue;
            rows.add(row);
        }
        return rows;
    }

    public int getRowCount() {
        return this.table.size();
    }

    public Map addRow(String rowKey) {
        if (this.hasRowKey(rowKey)) {
            return this.getRow(rowKey);
        }
        HashMap row = new HashMap();
        for (int i = 0; i < this.columnKeys.size(); ++i) {
            row.put(this.columnKeys.get(i), null);
        }
        this.table.put(rowKey, row);
        return row;
    }

    private boolean hasRowKey(String rowKey) {
        return this.table.containsKey(rowKey);
    }

    public Object getCell(int rowIndex, String columnKey) {
        Map row = this.getRow(rowIndex);
        return row.get(columnKey);
    }

    public Object getCell(String rowKey, String columnKey) {
        Map row = this.getRow(rowKey);
        return row.get(columnKey);
    }

    public Map getColumn(String columnKey) {
        HashMap<String, Object> column = new HashMap<String, Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            column.put(this.getRowKey(i), this.getCell(i, columnKey));
        }
        return column;
    }

    public void setRowProperty(Map row, String propertyName, Object propertyValue) {
        row.put(propertyName, propertyValue);
    }

    public Object getRowProperty(Map row, String propertyName) {
        return row.get(propertyName);
    }

    public String getColumnKey(int i) {
        return (String)this.columnKeys.get(i);
    }

    public String[] getColumnKeys() {
        return this.columnKeys.toArray(new String[this.getColumnCount()]);
    }

    public void createByRowSet(IRowSet rowSet, String[] keyFields) throws SQLException {
        int i;
        if (keyFields == null) {
            return;
        }
        ResultSetMetaData meta = rowSet.getMetaData();
        int fieldCount = meta.getColumnCount();
        this.columnKeys = new ArrayList();
        this.pkColumn = new ArrayList();
        for (i = 0; i < keyFields.length; ++i) {
            this.pkColumn.add(keyFields);
        }
        for (i = 0; i < fieldCount; ++i) {
            String columnKey = meta.getColumnName(i + 1).toLowerCase();
            this.columnKeys.add(columnKey);
        }
        while (rowSet.next()) {
            String rowKey = "";
            for (int i2 = 0; i2 < keyFields.length; ++i2) {
                String keyAdd = rowSet.getString(keyFields[i2]);
                rowKey = rowKey + keyAdd;
            }
            Map row = this.addRow(rowKey);
            for (int i3 = 0; i3 < this.columnKeys.size(); ++i3) {
                row.put(this.getColumnKey(i3), rowSet.getObject(this.getColumnKey(i3)));
            }
        }
    }

    public boolean isPrimaryKey(int index) {
        return this.pkColumn.contains(this.getColumnKey(index));
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public void mergeWithXTable(XTable xTable) {
        for (int i = 0; i < xTable.getColumnCount(); ++i) {
            String columnKey = xTable.getColumnKey(i);
            if (this.existColumn(columnKey)) continue;
            this.addColumn(columnKey, xTable.getColumn(columnKey));
        }
    }

    public void unionWithXTable(XTable xTable) {
        String[] rowKeys = xTable.getRowKeys();
        for (int i = 0; i < xTable.getRowCount(); ++i) {
            Map row = xTable.getRow(0);
            String rowKey = rowKeys[i];
            Map rowAdd = this.getRow(rowKey = rowKey.substring(0, rowKey.length() - 1));
            if (rowAdd == null) {
                rowAdd = this.addRow(rowKey);
            }
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (this.isPrimaryKey(j)) continue;
                BigDecimal value = (BigDecimal)rowAdd.get(this.getColumnKey(j));
                if (value == null) {
                    rowAdd.put(this.getColumnKey(j), row.get(this.getColumnKey(j)));
                    continue;
                }
                value = value.add((BigDecimal)row.get(this.getColumnKey(j)));
            }
        }
    }

    public String toString() {
        int i;
        String description = "\n" + this.getRowCount() + "\n";
        for (i = 0; i < this.getRowCount(); ++i) {
            Map row = this.getRow(i);
            for (int j = 0; j < this.columnKeys.size(); ++j) {
                description = description + row.get(this.columnKeys.get(j)) + " ";
            }
            description = description + "\n";
        }
        description = description + "\n" + this.getColumnCount() + "\n";
        for (i = 0; i < this.getColumnKeys().length; ++i) {
            description = description + this.getColumnKeys()[i] + "\n";
        }
        return super.toString() + description;
    }

    public void resetRowKey() {
    }
}

