/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasSubSidiaryLedgerFacadeFactory;
import com.kingdee.eas.fi.cas.CasSubsidiaryLedgerHelper;
import com.kingdee.eas.fi.cas.client.CasSubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.RptBaseHandler;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.IInAcct;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InAcctFormualParam;
import com.kingdee.eas.fm.fs.InAcctFormualParamCollection;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AbstractCasSubsidiaryLedgerHandler
extends RptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource";
    public static final String EARLIEST_OPENDATE = "earliest_opendate";
    public static final String LATEST_OPENDATE = "latest_opendate";
    public static final String EARLIEST_SETTLEDATE = "earliest_settledate";
    public static final String LATEST_SETTLEDATE = "latest_settledate";
    public static Map settleAndOpenDateMap = new HashMap();
    private CurrencyCollection currencyCol;

    public void fillFirstCol(KDTable tblMain, IRowSet rs) throws SQLException {
    }

    private BigDecimal getDebitOrCreditTotal(String companyNumber, String innerAcctNumber, String currencyId, java.util.Date from, java.util.Date to, BalanceDirectionEnum direction) throws EASBizException, BOSException {
        BigDecimal result = null;
        IInAcct iInAcct = InAcctFactory.getRemoteInstance();
        if (this.currencyCol == null) {
            this.currencyCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        }
        CurrencyInfo currencyInfo = this.currencyCol.get((Object)BOSUuid.read((String)currencyId));
        String currencyNumber = currencyInfo.getNumber();
        result = direction.equals((Object)BalanceDirectionEnum.DEBIT) ? iInAcct.inAcct(companyNumber, innerAcctNumber, currencyNumber, from, to, InAcctDataTypeEnum.JF) : iInAcct.inAcct(companyNumber, innerAcctNumber, currencyNumber, from, to, InAcctDataTypeEnum.DF);
        return result;
    }

    private BigDecimal getTotal(IMetaDataPK mainQueryPK, String innerAcctNumber, String currencyId, java.util.Date from, java.util.Date to, BalanceDirectionEnum direction) throws BOSException, SQLException {
        EntityViewInfo ev = new EntityViewInfo();
        HashSet<String> innerAcctSet = new HashSet<String>();
        if (innerAcctNumber.indexOf(",") == -1) {
            innerAcctSet.add(innerAcctNumber);
        } else {
            String[] innerAcctArray = innerAcctNumber.split(",");
            for (int i = 0; i < innerAcctArray.length; ++i) {
                innerAcctSet.add(innerAcctArray[i]);
            }
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("innerAccount.number", innerAcctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        ev.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)from, CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)to, CompareType.LESS));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        if (direction.equals((Object)BalanceDirectionEnum.DEBIT)) {
            sb.append(" ISNULL(SUM(DEBITAMOUNT),0) AS RESULT");
        } else {
            sb.append(" ISNULL(SUM(CREDITAMOUNT),0) AS RESULT");
        }
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        if (rs.next()) {
            return rs.getBigDecimal("RESULT");
        }
        return FMConstants.ZERO;
    }

    private BigDecimal getAdjustBalance(IMetaDataPK mainQueryPK, String innerAcctNumber, String currencyId, java.util.Date from, BankInfo clearingHouseParam) throws SQLException, BOSException, EASBizException {
        HashSet<String> innerAcctSet = new HashSet<String>();
        if (innerAcctNumber.indexOf(",") == -1) {
            innerAcctSet.add(innerAcctNumber);
        } else {
            String[] innerAcctArray = innerAcctNumber.split(",");
            for (int i = 0; i < innerAcctArray.length; ++i) {
                innerAcctSet.add(innerAcctArray[i]);
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("innerAccount.number", innerAcctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        ev.setFilter(fi);
        java.util.Date settDate = null;
        if (clearingHouseParam == null) {
            settDate = CasSubSidiaryLedgerFacadeFactory.getRemoteInstance().getEarliestSettleDate(innerAcctNumber);
        }
        if (settDate == null) {
            return FMConstants.ZERO;
        }
        if (!from.after(settDate)) {
            return FMConstants.ZERO;
        }
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)settDate, CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((java.util.Date)from), CompareType.LESS));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT ");
        sb.append(" SUM(DEBITAMOUNT)-SUM(CREDITAMOUNT) AS BALANCE");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        BigDecimal result = null;
        if (rs.next()) {
            result = rs.getBigDecimal("BALANCE");
        }
        if (result == null) {
            result = FMConstants.ZERO;
        }
        return result;
    }

    private BigDecimal getBalance(IMetaDataPK mainQueryPK, SubsidiaryLedgerFilterParam param, java.util.Date dateFrom, String companyNumber, BOSUuid currencyId, String innerNumber) throws EASBizException, BOSException, SQLException {
        IInAcct iInAcct = InAcctFactory.getRemoteInstance();
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        String currencyNumber = currencyInfo.getNumber();
        BigDecimal adjustBalance = this.getAdjustBalance(mainQueryPK, innerNumber, currencyId.toString(), dateFrom, null);
        dateFrom = this.adjustDate(dateFrom);
        BigDecimal balance = iInAcct.inAcct(companyNumber, innerNumber, currencyNumber, dateFrom, null, InAcctDataTypeEnum.C);
        balance = balance.add(adjustBalance);
        return balance;
    }

    private BigDecimal getBalance(IMetaDataPK mainQueryPK, SubsidiaryLedgerFilterParam param, java.util.Date dateFrom, String companyNumber, BOSUuid currencyId, String innerNumber, BankInfo clearingHouseParam) throws EASBizException, BOSException, SQLException {
        IInAcct iInAcct = InAcctFactory.getRemoteInstance();
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        String currencyNumber = currencyInfo.getNumber();
        BigDecimal adjustBalance = this.getAdjustBalance(mainQueryPK, innerNumber, currencyId.toString(), dateFrom, clearingHouseParam);
        dateFrom = this.adjustDate(dateFrom, clearingHouseParam);
        BigDecimal balance = CasSubSidiaryLedgerFacadeFactory.getRemoteInstance().inAcct(null, innerNumber, currencyNumber, dateFrom, null, InAcctDataTypeEnum.C);
        balance = balance.add(adjustBalance);
        return balance;
    }

    private java.util.Date adjustDate(java.util.Date date, BankInfo clearingHouseParam) {
        java.util.Date openDate = (java.util.Date)AbstractCasSubsidiaryLedgerHandler.getSettleAndOpenDateMap().get(EARLIEST_OPENDATE);
        java.util.Date settDate = (java.util.Date)AbstractCasSubsidiaryLedgerHandler.getSettleAndOpenDateMap().get(LATEST_SETTLEDATE);
        if (settDate == null) {
            return null;
        }
        if (date.before(openDate)) {
            return openDate;
        }
        if (date.after(settDate)) {
            return settDate;
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    private java.util.Date adjustDate(java.util.Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            java.util.Date openDate = clearingHouse.getOpenDate();
            java.util.Date settDate = clearingHouse.getSettleDate();
            if (date.before(openDate)) {
                return openDate;
            }
            if (date.after(settDate)) {
                return settDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    private java.util.Date adjustDate(java.util.Date date, String acctNumbers) {
        Object clearingHouse = null;
        try {
            Map returnValue = CasSubSidiaryLedgerFacadeFactory.getRemoteInstance().getCleanHouseDate(acctNumbers);
            java.util.Date openDate = (java.util.Date)returnValue.get(EARLIEST_OPENDATE);
            java.util.Date settDate = (java.util.Date)returnValue.get(LATEST_SETTLEDATE);
            if (date.before(openDate)) {
                return openDate;
            }
            if (date.after(settDate)) {
                return settDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    protected java.util.Date adjustBeginDate(java.util.Date date) {
        BankInfo clearingHouse = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            java.util.Date openDate = clearingHouse.getOpenDate();
            if (date.before(openDate)) {
                return openDate;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    protected java.util.Date adjustBeginDateUsingCHParam(java.util.Date date) {
        java.util.Date openDate = (java.util.Date)AbstractCasSubsidiaryLedgerHandler.getSettleAndOpenDateMap().get(EARLIEST_OPENDATE);
        if (date.before(openDate)) {
            return openDate;
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    protected java.util.Date getSettDate() {
        BankInfo clearingHouse = null;
        java.util.Date settDate = null;
        try {
            clearingHouse = FSClientHelper.getClearingHouse();
            settDate = clearingHouse.getSettleDate();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return settDate;
    }

    private java.util.Date getSettDate(BankInfo clearingHouseParam) {
        if (clearingHouseParam == null) {
            try {
                clearingHouseParam = FSClientHelper.getClearingHouse();
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return clearingHouseParam.getSettleDate();
    }

    public void fillTableFromRowset(KDTable tblMain, IRowSet rs, BigDecimal balance, BalanceDirectionEnum direction) {
        BalanceDirectionEnum tmpDirection = direction;
        try {
            IRow row = null;
            GregorianCalendar date = new GregorianCalendar();
            while (rs.next()) {
                row = tblMain.addRow();
                date.setTime(rs.getDate("date"));
                if (row.getCell("year") != null) {
                    row.getCell("year").setValue((Object)new Integer(date.get(1)));
                    row.getCell("month").setValue((Object)new Integer(date.get(2) + 1));
                    row.getCell("day").setValue((Object)new Integer(date.get(5)));
                }
                if (row.getCell("companyName") != null) {
                    row.getCell("companyName").setValue((Object)rs.getString("companyName"));
                }
                if (row.getCell("innerAccountName") != null) {
                    row.getCell("innerAccountName").setValue((Object)rs.getString("innerAccountName"));
                }
                if (row.getCell("currencyName") != null) {
                    row.getCell("currencyName").setValue((Object)rs.getString("currencyName"));
                }
                row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(date.getTime()));
                SubsidiaryBillTypeEnum bizType = SubsidiaryBillTypeEnum.getEnum((int)Integer.parseInt(rs.getString("bizType")));
                row.getCell("bizType").setValue((Object)bizType.toString());
                row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
                row.getCell("payeeBankAcct").setValue((Object)rs.getString("payeeBankAcct"));
                row.getCell("payerBankAcct").setValue((Object)rs.getString("payerBankAcct"));
                row.getCell("cpInnerAccountName").setValue((Object)rs.getString("cpInnerAccountName"));
                row.getCell("description").setValue((Object)rs.getString("description"));
                BigDecimal creditAmount = rs.getBigDecimal("creditAmount");
                row.getCell("creditAmount").setValue((Object)creditAmount);
                BigDecimal debitAmount = rs.getBigDecimal("debitAmount");
                row.getCell("debitAmount").setValue((Object)debitAmount);
                row.getCell("booker").setValue((Object)rs.getString("bookkeeperName"));
                if (balance == null) continue;
                if (creditAmount != null) {
                    balance = balance.subtract(creditAmount);
                }
                if (debitAmount != null) {
                    balance = balance.add(debitAmount);
                }
                tmpDirection = balance.compareTo(FMConstants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(FMConstants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
                row.getCell("direction").setValue((Object)tmpDirection);
                row.getCell("balance").setValue((Object)balance.abs());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            SysUtil.abort((Throwable)e);
        }
    }

    protected void setColumnFmt(KDTable tblMain, BOSUuid currencyId) {
        String strFormat = currencyId == null ? "%r-[ ]{###,###,###.##}15.2n" : FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblMain.getColumn("date").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("balance").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setDayTotal(KDTable tblMain, String strFormat) {
        tblMain.getColumn("day").setGroup(true);
        IRow row = tblMain.getGroupManager().getStatRowTemplate(2);
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(new Color(16119270));
        row.getCell("description").setValue((Object)EASResource.getString((String)resourcePath, (String)"DayTotal"));
        row.getCell("creditAmount").setExpressions("SUM");
        row.getCell("debitAmount").setExpressions("SUM");
        row.setUserObject((Object)new Integer(row.getRowIndex()));
    }

    private void setMonthTotal(KDTable tblMain, String strFormat) {
        tblMain.getColumn("month").setGroup(true);
        IRow row = tblMain.getGroupManager().getStatRowTemplate(1);
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(new Color(16119270));
        row.getCell("description").setValue((Object)EASResource.getString((String)resourcePath, (String)"MonthTotal"));
        row.getCell("day").setValue((Object)new Integer(0));
        row.setUserObject((Object)new Integer(row.getRowIndex()));
    }

    private void setYearTotal(KDTable tblMain, String strFormat) {
        tblMain.getColumn("year").setGroup(true);
        IRow row = tblMain.getGroupManager().getStatRowTemplate(0);
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("description").setValue((Object)EASResource.getString((String)resourcePath, (String)"YearTotal"));
        row.getCell("month").setValue((Object)new Integer(0));
        row.getCell("day").setValue((Object)new Integer(0));
    }

    public String getFirstColKey() {
        return "day";
    }

    public void initTree(KDTree treeList, CasSubsidiaryLedgerFilterParam param) throws EASBizException, BOSException {
        if (param.isOrderByCompany()) {
            CompanyOrgUnitCollection companyCol = null;
            String[] companyIds = param.getCompanyIds();
            companyCol = FMClientHelper.getCompanyOrgUnitCollection((String[])companyIds);
            FSClientHelper.fillInnerAcctByCompanySupportCache((KDTree)treeList, (CompanyOrgUnitCollection)companyCol, (boolean)param.isDispUnUsed());
        } else {
            CasSubsidiaryLedgerHelper.fillInnerAcctByType(treeList, param.getCompanyIds(), param.isDispUnUsed());
            treeList.setRootVisible(true);
        }
    }

    protected void fillOneDetailRow(IRowSet rs, IRow row, BigDecimal balance, BigDecimal debitAmt, BigDecimal creditAmt, BalanceDirectionEnum direction) throws SQLException {
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(rs.getDate("date")));
        row.getCell("bizType").setValue((Object)SubsidiaryBillTypeEnum.getEnum((int)rs.getInt("bizType")));
        row.getCell("id").setValue((Object)rs.getString("id"));
        row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        row.getCell("payeeBankAcct").setValue((Object)rs.getString("payeeBankAcct"));
        row.getCell("payerBankAcct").setValue((Object)rs.getString("payerBankAcct"));
        row.getCell("cpInnerAccountName").setValue((Object)rs.getString("cpInnerAccountName"));
        row.getCell("description").setValue((Object)rs.getString("description"));
        if (creditAmt.compareTo(FMConstants.ZERO) != 0) {
            row.getCell("creditAmount").setValue((Object)creditAmt);
        }
        if (debitAmt.compareTo(FMConstants.ZERO) != 0) {
            row.getCell("debitAmount").setValue((Object)debitAmt);
        }
        row.getCell("booker").setValue((Object)rs.getString("bookkeeperName"));
        row.getCell("direction").setValue((Object)direction);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("settleType").setValue((Object)rs.getString("settleType.name"));
        row.getCell("settleNumber").setValue((Object)rs.getString("settleNumber"));
    }

    public void fillData3(IMetaDataPK mainQueryPK, KDTable tblMain, IRowSet rs, SubsidiaryLedgerFilterParam param, String companyNumber, BOSUuid currencyId, String acctNumber) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal;
        GregorianCalendar beginCal;
        java.util.Date toDate;
        java.util.Date date;
        this.setColumnFmt(tblMain, currencyId);
        String beginBalanceDesc = EASResource.getString((String)resourcePath, (String)"Balance");
        String dayTotalDesc = EASResource.getString((String)resourcePath, (String)"DayTotal");
        String monthTotalDesc = EASResource.getString((String)resourcePath, (String)"MonthTotal");
        String yearTotalDesc = EASResource.getString((String)resourcePath, (String)"YearTotal");
        IRow row = null;
        BigDecimal balance = FMConstants.ZERO;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BalanceDirectionEnum direction = null;
        BigDecimal tmpDayDebitTotal = FMConstants.ZERO;
        BigDecimal tmpDayCreditTotal = FMConstants.ZERO;
        GregorianCalendar cal = new GregorianCalendar();
        if (param.isByDay()) {
            date = param.getFromDate();
            toDate = param.getToDate();
        } else {
            GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
            date = begincal.getTime();
            GregorianCalendar endcal = new GregorianCalendar(param.getEndYear(), param.getEndMonth(), 0);
            toDate = endcal.getTime();
        }
        settleAndOpenDateMap = CasSubSidiaryLedgerFacadeFactory.getRemoteInstance().getCleanHouseDate(acctNumber);
        java.util.Date settDate = (java.util.Date)settleAndOpenDateMap.get(LATEST_SETTLEDATE);
        balance = this.getBalance(mainQueryPK, param, date, null, currencyId, acctNumber, null);
        if (param.isDispBalance()) {
            row = tblMain.addRow();
            this.fillBeginBalanceRowUsingCHParam(date, row, balance, beginBalanceDesc);
        }
        if (rs == null || rs.size() == 0) {
            return;
        }
        String currencyNumber = this.getCurrencyNumber(currencyId.toString());
        String clearHouseNumber = "";
        HashSet<String> acctSet = new HashSet<String>();
        if (acctNumber.indexOf(",") == -1) {
            acctSet.add(acctNumber);
        } else {
            String[] acctArray = acctNumber.split(",");
            for (int i = 0; i < acctArray.length; ++i) {
                acctSet.add(acctArray[i]);
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", acctSet, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        IInnerAccount iInner = InnerAccountFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("clearingHouse.id"));
        view.getSelector().add(new SelectorItemInfo("clearingHouse.number"));
        view.setFilter(filter);
        CoreBaseCollection co = iInner.getCollection(view);
        if (co.size() <= 0) {
            throw new FSException(FSException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"wu_jiesuanxinxi")});
        }
        clearHouseNumber = ((InnerAccountInfo)co.get(0)).getClearingHouse().getNumber();
        InAcctFormualParamCollection inAcctResultColl = this.getInAcctResultColl(rs, clearHouseNumber, acctNumber, currencyNumber, param.isDispMouthTotal(), param.isDispYearTotal());
        HashMap<String, BigDecimal> totalAmtMap = new HashMap<String, BigDecimal>();
        InAcctFormualParam formualParam = null;
        int size = inAcctResultColl.size();
        for (int i = 0; i < size; ++i) {
            formualParam = inAcctResultColl.get(i);
            totalAmtMap.put(formualParam.getKey(), formualParam.getResult());
        }
        rs.beforeFirst();
        rs.next();
        java.util.Date tempDate = rs.getDate("date");
        cal.setTime(tempDate);
        int tmpYear = cal.get(1);
        int tmpMonth = cal.get(2);
        int tmpDay = cal.get(5);
        Date fromDate = rs.getDate("date");
        int fromDateDay = cal.get(5);
        int fromDateMonth = cal.get(2);
        int fromDateYear = cal.get(1);
        rs.beforeFirst();
        while (rs.next()) {
            date = rs.getDate("date");
            cal.setTime(date);
            int day = cal.get(5);
            int month = cal.get(2);
            int year = cal.get(1);
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (day == tmpDay && param.isDisDayTotal()) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (day != tmpDay && param.isDisDayTotal()) {
                row = tblMain.addRow();
                this.fillDayTotalRow(tempDate, dayTotalDesc, row, tmpDayDebitTotal, tmpDayCreditTotal, balance, direction);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            if (month != tmpMonth && param.isDispMouthTotal()) {
                beginCal = new GregorianCalendar(tmpYear, tmpMonth, 1);
                endCal = new GregorianCalendar(tmpYear, tmpMonth + 1, 0, 23, 59, 59);
                row = tblMain.addRow();
                this.fillTotalRow(monthTotalDesc, row, clearHouseNumber, acctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction, totalAmtMap);
            }
            if (year != tmpYear && param.isDispYearTotal()) {
                beginCal = new GregorianCalendar(tmpYear, 0, 1);
                endCal = new GregorianCalendar(tmpYear, 11, 31);
                row = tblMain.addRow();
                this.fillTotalRow(yearTotalDesc, row, clearHouseNumber, acctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction, totalAmtMap);
            }
            if (month != tmpMonth && param.isDispBalance()) {
                row = tblMain.addRow();
                endCal = new GregorianCalendar(year, month, 1);
                this.fillBeginBalanceRow(endCal.getTime(), row, balance, beginBalanceDesc);
            }
            direction = (balance = balance.add(debitAmt).subtract(creditAmt)).compareTo(FMConstants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(FMConstants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
            row = tblMain.addRow();
            this.fillOneDetailRow(rs, row, balance, debitAmt, creditAmt, direction);
            tempDate = date;
            tmpDay = day;
            tmpMonth = month;
            tmpYear = year;
        }
        if (param.isDisDayTotal()) {
            row = tblMain.addRow();
            this.fillDayTotalRow(date, dayTotalDesc, row, tmpDayDebitTotal, tmpDayCreditTotal, balance, direction);
        }
        if (param.isDispMouthTotal()) {
            beginCal = new GregorianCalendar(tmpYear, tmpMonth, 1);
            if (fromDate.after(beginCal.getTime())) {
                beginCal.set(fromDateYear, fromDateMonth, fromDateDay);
            }
            if (tempDate.before((endCal = new GregorianCalendar(tmpYear, tmpMonth + 1, 0, 23, 59, 59)).getTime())) {
                endCal.set(tmpYear, tmpMonth, tmpDay);
            }
            row = tblMain.addRow();
            if (param.isByDay()) {
                if (tempDate.before(toDate)) {
                    toDate = tempDate;
                }
            } else {
                toDate = new GregorianCalendar(tmpYear, tmpMonth + 1, 0, 23, 59, 59).getTime();
            }
            this.fillTotalRowLastMonthYear(monthTotalDesc, row, clearHouseNumber, acctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction, totalAmtMap, toDate);
        }
        if (param.isDispYearTotal()) {
            beginCal = new GregorianCalendar(tmpYear, 0, 1);
            endCal = new GregorianCalendar(tmpYear, tmpMonth + 1, 0, 23, 59, 59);
            if (tempDate.before(endCal.getTime())) {
                endCal.set(tmpYear, tmpMonth, tmpDay);
            }
            row = tblMain.addRow();
            if (param.isByDay()) {
                if (tempDate.before(toDate)) {
                    toDate = tempDate;
                }
            } else {
                toDate = new GregorianCalendar(param.getEndYear(), param.getEndMonth(), 0).getTime();
            }
            this.fillTotalRowLastMonthYear(yearTotalDesc, row, clearHouseNumber, acctNumber, currencyId.toString(), beginCal.getTime(), endCal.getTime(), balance, direction, totalAmtMap, toDate);
        }
    }

    private void fillTotalRowLastMonthYear(String description, IRow row, String companyNumber, String innerAcctNumber, String currencyId, java.util.Date beginDate, java.util.Date endDate, BigDecimal balance, BalanceDirectionEnum direction, Map totalAmtMap, java.util.Date toDate) throws SQLException, EASBizException, BOSException {
        String currencyNumber = this.getCurrencyNumber(currencyId);
        InAcctFormualParam param = new InAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF, false);
        BigDecimal debitAmount = (BigDecimal)totalAmtMap.get(param.getKey());
        param = new InAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF, false);
        BigDecimal creditAmount = (BigDecimal)totalAmtMap.get(param.getKey());
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(toDate));
        row.getCell("debitAmount").setValue((Object)creditAmount);
        row.getCell("creditAmount").setValue((Object)debitAmount);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
    }

    protected void fillBeginBalanceRow(java.util.Date date, IRow row, BigDecimal balance, String description, BankInfo clearingHouseParam) {
        BalanceDirectionEnum direction = balance.compareTo(Constants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(Constants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(this.adjustBeginDateUsingCHParam(date, clearingHouseParam)));
    }

    private void fillBeginBalanceRowUsingCHParam(java.util.Date date, IRow row, BigDecimal balance, String description, BankInfo clearingHouseParam) {
        BalanceDirectionEnum direction = balance.compareTo(Constants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(Constants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(this.adjustBeginDateUsingCHParam(date, clearingHouseParam)));
    }

    protected java.util.Date adjustBeginDateUsingCHParam(java.util.Date date, BankInfo clearingHouseParam) {
        java.util.Date openDate;
        if (clearingHouseParam == null) {
            try {
                clearingHouseParam = FSClientHelper.getClearingHouse();
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        if (date.before(openDate = clearingHouseParam.getOpenDate())) {
            return openDate;
        }
        return DateTimeUtils.truncateDate((java.util.Date)date);
    }

    private InAcctFormualParamCollection getInAcctResultColl(IRowSet rs, String companyNumber, String innerAcctNumber, String currencyNumber, boolean isShowMonthTotal, boolean isShowYearTotal) throws BOSException, EASBizException {
        InAcctFormualParamCollection coll = new InAcctFormualParamCollection();
        InAcctFormualParam param = null;
        Calendar calendar = Calendar.getInstance();
        Calendar beginCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        Date date = null;
        int month = 0;
        int year = 0;
        int day = 0;
        Date fromDate = null;
        int fromDateDay = 0;
        int fromDateMonth = 0;
        int fromDateYear = 0;
        try {
            rs.beforeFirst();
            rs.next();
            date = rs.getDate("date");
            calendar.setTime(date);
            year = calendar.get(1);
            month = calendar.get(2);
            day = calendar.get(5);
            fromDate = rs.getDate("date");
            fromDateYear = calendar.get(1);
            fromDateMonth = calendar.get(2);
            fromDateDay = calendar.get(5);
            while (rs.next()) {
                date = rs.getDate("date");
                calendar.setTime(date);
                if (year != calendar.get(1) && isShowYearTotal) {
                    param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                    beginCalendar.set(year, 0, 1);
                    endCalendar.set(year, 11, 31);
                    param.setBeginDate(beginCalendar.getTime());
                    param.setEndDate(endCalendar.getTime());
                    param.setDataType(InAcctDataTypeEnum.JF);
                    coll.add(param);
                    param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                    beginCalendar.set(year, 0, 1);
                    endCalendar.set(year, 11, 31);
                    param.setBeginDate(beginCalendar.getTime());
                    param.setEndDate(endCalendar.getTime());
                    param.setDataType(InAcctDataTypeEnum.DF);
                    coll.add(param);
                }
                if (month != calendar.get(2) && isShowMonthTotal) {
                    param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                    beginCalendar.set(year, month, 1);
                    if (fromDate.after(beginCalendar.getTime())) {
                        beginCalendar.set(fromDateYear, fromDateMonth, fromDateDay);
                    }
                    endCalendar.set(year, month + 1, 0, 23, 59, 59);
                    param.setBeginDate(beginCalendar.getTime());
                    param.setEndDate(endCalendar.getTime());
                    param.setDataType(InAcctDataTypeEnum.JF);
                    coll.add(param);
                    param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                    beginCalendar.set(year, month, 1);
                    if (fromDate.after(beginCalendar.getTime())) {
                        beginCalendar.set(fromDateYear, fromDateMonth, fromDateDay);
                    }
                    endCalendar.set(year, month + 1, 0, 23, 59, 59);
                    param.setBeginDate(beginCalendar.getTime());
                    param.setEndDate(endCalendar.getTime());
                    param.setDataType(InAcctDataTypeEnum.DF);
                    coll.add(param);
                }
                year = calendar.get(1);
                month = calendar.get(2);
                day = calendar.get(5);
            }
            if (isShowYearTotal) {
                param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                beginCalendar.set(year, 0, 1);
                endCalendar.set(year, month + 1, 0, 23, 59, 59);
                if (date.before(endCalendar.getTime())) {
                    endCalendar.set(year, month, day);
                }
                param.setBeginDate(beginCalendar.getTime());
                param.setEndDate(endCalendar.getTime());
                param.setDataType(InAcctDataTypeEnum.JF);
                param.setYearTotal(true);
                coll.add(param);
                param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                beginCalendar.set(year, 0, 1);
                endCalendar.set(year, month + 1, 0, 23, 59, 59);
                if (date.before(endCalendar.getTime())) {
                    endCalendar.set(year, month, day);
                }
                param.setBeginDate(beginCalendar.getTime());
                param.setEndDate(endCalendar.getTime());
                param.setDataType(InAcctDataTypeEnum.DF);
                param.setYearTotal(true);
                coll.add(param);
            }
            if (isShowMonthTotal) {
                param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                beginCalendar.set(year, month, 1);
                if (fromDate.after(beginCalendar.getTime())) {
                    beginCalendar.set(fromDateYear, fromDateMonth, fromDateDay);
                }
                endCalendar.set(year, month + 1, 0, 23, 59, 59);
                if (date.before(endCalendar.getTime())) {
                    endCalendar.set(year, month, day);
                }
                param.setBeginDate(beginCalendar.getTime());
                param.setEndDate(endCalendar.getTime());
                param.setDataType(InAcctDataTypeEnum.JF);
                param.setYearTotal(false);
                coll.add(param);
                param = this.getInAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber);
                beginCalendar.set(year, month, 1);
                if (fromDate.after(beginCalendar.getTime())) {
                    beginCalendar.set(fromDateYear, fromDateMonth, fromDateDay);
                }
                endCalendar.set(year, month + 1, 0, 23, 59, 59);
                if (date.before(endCalendar.getTime())) {
                    endCalendar.set(year, month, day);
                }
                param.setBeginDate(beginCalendar.getTime());
                param.setEndDate(endCalendar.getTime());
                param.setDataType(InAcctDataTypeEnum.DF);
                param.setYearTotal(false);
                coll.add(param);
            }
            rs.beforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fs", "SubsidiaryLedgerQuery");
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)mainQueryPK);
        coll = InAcctFactory.getRemoteInstance().inAcct(coll);
        return coll;
    }

    private InAcctFormualParam getInAcctFormualParam(String companyNumber, String innerAcctNumber, String currencyNumber) {
        InAcctFormualParam param = new InAcctFormualParam();
        param.setCompanyNumber(companyNumber);
        param.setInnerAcctNumber(innerAcctNumber);
        param.setCurrencyNumber(currencyNumber);
        return param;
    }

    public Map getBalanceMap(IMetaDataPK mainQueryPK, KDTable tblMain, IRowSet rs, SubsidiaryLedgerFilterParam param, String companyNumber, BOSUuid currencyId, String acctNumber, InnerAccountCollection innerAcctColl) throws EASBizException, BOSException, SQLException {
        java.util.Date date;
        BankInfo clearingHouseParam = FSClientHelper.getClearingHouse();
        if (param.isByDay()) {
            date = param.getFromDate();
        } else {
            GregorianCalendar begincal = new GregorianCalendar(param.getBeginYear(), param.getBeginMonth() - 1, 1);
            date = begincal.getTime();
        }
        return this.getBalanceMap(mainQueryPK, param, date, companyNumber, currencyId, acctNumber, clearingHouseParam, innerAcctColl);
    }

    private Map getBalanceMap(IMetaDataPK mainQueryPK, SubsidiaryLedgerFilterParam param, java.util.Date dateFrom, String companyNumber, BOSUuid currencyId, String innerNumber, BankInfo clearingHouseParam, InnerAccountCollection innerAcctColl) throws BOSException, EASBizException, SQLException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currencyInfo = null;
        currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        String currencyNumber = currencyInfo.getNumber();
        Map adjustBalanceMap = this.getAdjustBalanceMap(mainQueryPK, innerNumber, currencyId.toString(), dateFrom, clearingHouseParam, innerAcctColl);
        dateFrom = this.adjustDate(dateFrom, clearingHouseParam);
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo paramInfo = null;
        InnerAccountInfo innerAccountInfo = null;
        for (int k = 0; k < innerAcctColl.size(); ++k) {
            innerAccountInfo = innerAcctColl.get(k);
            paramInfo = new FPFormulaInfo();
            paramInfo.setParams(new Object[]{companyNumber, innerAccountInfo.getNumber(), currencyNumber, dateFrom, null, InAcctDataTypeEnum.C});
            paramColl.add(paramInfo);
        }
        FPFormulaCollection col = SummaryLedgerFactory.getRemoteInstance().exec(InacctTypeEnum.INACCT, paramColl);
        Map balanceMap = this.transFPFormulaCollection(col);
        return this.combine(balanceMap, adjustBalanceMap);
    }

    private Map combine(Map balanceMap, Map adjustBalanceMap) {
        HashMap returnMap = new HashMap(balanceMap);
        Iterator keyIt = returnMap.keySet().iterator();
        while (keyIt.hasNext()) {
            String innerAccountNumber = keyIt.next().toString();
            if (adjustBalanceMap.get(innerAccountNumber) == null) continue;
            BigDecimal adjBalance = (BigDecimal)adjustBalanceMap.get(innerAccountNumber);
            BigDecimal balance = (BigDecimal)balanceMap.get(innerAccountNumber);
            balanceMap.put(innerAccountNumber, balance.add(adjBalance));
        }
        return returnMap;
    }

    private Map transFPFormulaCollection(FPFormulaCollection col) {
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        for (int i = 0; i < col.size(); ++i) {
            FPFormulaInfo info = col.get(i);
            balanceMap.put(info.getParams()[1].toString(), info.getResult());
        }
        return balanceMap;
    }

    private Map getAdjustBalanceMap(IMetaDataPK mainQueryPK, String innerAcctNumber, String currencyId, java.util.Date from, BankInfo clearingHouseParam, InnerAccountCollection innerAcctColl) throws SQLException, BOSException, EASBizException {
        java.util.Date settDate;
        HashMap<String, BigDecimal> adjustBalanceMap = new HashMap<String, BigDecimal>();
        HashSet<String> innerAcctSet = new HashSet<String>();
        if (innerAcctColl.size() == 1) {
            innerAcctSet.add(innerAcctColl.get(0).getNumber());
        } else {
            for (int i = 0; i < innerAcctColl.size(); ++i) {
                innerAcctSet.add(innerAcctColl.get(i).getNumber());
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("innerAccount.number", innerAcctSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        ev.setFilter(fi);
        if (clearingHouseParam == null) {
            clearingHouseParam = FSClientHelper.getClearingHouse();
        }
        if ((settDate = clearingHouseParam.getSettleDate()) == null) {
            return adjustBalanceMap;
        }
        if (!from.after(settDate)) {
            return adjustBalanceMap;
        }
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)settDate, CompareType.GREATER_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("Date", (Object)DateTimeUtils.truncateDate((java.util.Date)from), CompareType.LESS));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        StringBuffer sb = new StringBuffer(128);
        sb.append("SELECT inneraccountnumber,");
        sb.append(" SUM(DEBITAMOUNT)-SUM(CREDITAMOUNT) AS BALANCE");
        sb.append(" from (");
        sb.append(sql);
        sb.append(") a group by inneraccountnumber ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        if (rs.next()) {
            adjustBalanceMap.put(rs.getString("inneraccountnumber"), rs.getBigDecimal("BALANCE"));
        }
        return adjustBalanceMap;
    }

    protected void fillDayTotalRow(java.util.Date date, String description, IRow row, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, BalanceDirectionEnum direction) {
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("description").setValue((Object)description);
        row.getCell("debitAmount").setValue((Object)debitAmt);
        row.getCell("creditAmount").setValue((Object)creditAmt);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("direction").setValue((Object)direction);
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(date));
    }

    private void fillBeginBalanceRowUsingCHParam(java.util.Date date, IRow row, BigDecimal balance, String description) {
        BalanceDirectionEnum direction = balance.compareTo(FMConstants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(FMConstants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(this.adjustBeginDateUsingCHParam(date)));
    }

    protected void fillBeginBalanceRow(java.util.Date date, IRow row, BigDecimal balance, String description) {
        BalanceDirectionEnum direction = balance.compareTo(FMConstants.ZERO) == 0 ? BalanceDirectionEnum.BALANCE : (balance.compareTo(FMConstants.ZERO) > 0 ? BalanceDirectionEnum.DEBIT : BalanceDirectionEnum.CREDIT);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(this.adjustBeginDateUsingCHParam(date)));
    }

    private void fillTotalRow(String description, IRow row, IMetaDataPK mainQueryPK, String companyNumber, String acctNumber, String currencyId, java.util.Date beginDate, java.util.Date endDate, java.util.Date settDate, BigDecimal balance, BalanceDirectionEnum direction) throws SQLException, EASBizException, BOSException {
        BigDecimal creditAmount;
        BigDecimal debitAmount;
        if (endDate.before(settDate)) {
            debitAmount = this.getDebitOrCreditTotal(null, acctNumber, currencyId.toString(), beginDate, endDate, BalanceDirectionEnum.DEBIT);
            creditAmount = this.getDebitOrCreditTotal(null, acctNumber, currencyId.toString(), beginDate, endDate, BalanceDirectionEnum.CREDIT);
        } else if (beginDate.after(settDate)) {
            debitAmount = this.getTotal(mainQueryPK, acctNumber, currencyId.toString(), beginDate, endDate, BalanceDirectionEnum.DEBIT);
            creditAmount = this.getTotal(mainQueryPK, acctNumber, currencyId.toString(), beginDate, endDate, BalanceDirectionEnum.CREDIT);
        } else {
            debitAmount = this.getDebitOrCreditTotal(null, acctNumber, currencyId.toString(), beginDate, settDate, BalanceDirectionEnum.DEBIT);
            creditAmount = this.getDebitOrCreditTotal(null, acctNumber, currencyId.toString(), beginDate, settDate, BalanceDirectionEnum.CREDIT);
            BigDecimal debitAdjustAmount = this.getTotal(mainQueryPK, acctNumber, currencyId.toString(), settDate, endDate, BalanceDirectionEnum.DEBIT);
            BigDecimal creditAdjustAmount = this.getTotal(mainQueryPK, acctNumber, currencyId.toString(), settDate, endDate, BalanceDirectionEnum.CREDIT);
            if (debitAdjustAmount == null) {
                debitAdjustAmount = FMConstants.ZERO;
            }
            if (creditAdjustAmount == null) {
                creditAdjustAmount = FMConstants.ZERO;
            }
            debitAmount = debitAmount.add(debitAdjustAmount);
            creditAmount = creditAmount.add(creditAdjustAmount);
        }
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("date").setValue((Object)FMConstants.FORMAT_DAY.format(endDate));
        row.getCell("debitAmount").setValue((Object)debitAmount);
        row.getCell("creditAmount").setValue((Object)creditAmount);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
    }

    public static Map getSettleAndOpenDateMap() {
        return settleAndOpenDateMap;
    }

    private String getCurrencyNumber(String currencyId) throws BOSException {
        if (this.currencyCol == null) {
            this.currencyCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        }
        CurrencyInfo currencyInfo = this.currencyCol.get((Object)BOSUuid.read((String)currencyId));
        return currencyInfo.getNumber();
    }

    private void fillTotalRow(String description, IRow row, String companyNumber, String innerAcctNumber, String currencyId, java.util.Date beginDate, java.util.Date endDate, BigDecimal balance, BalanceDirectionEnum direction, Map totalAmtMap) throws SQLException, EASBizException, BOSException {
        String currencyNumber = this.getCurrencyNumber(currencyId);
        InAcctFormualParam param = new InAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF, false);
        BigDecimal debitAmount = (BigDecimal)totalAmtMap.get(param.getKey());
        param = new InAcctFormualParam(companyNumber, innerAcctNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF, false);
        BigDecimal creditAmount = (BigDecimal)totalAmtMap.get(param.getKey());
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("date").setValue((Object)Constants.FORMAT_DAY.format(endDate));
        row.getCell("debitAmount").setValue((Object)creditAmount);
        row.getCell("creditAmount").setValue((Object)debitAmount);
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("direction").setValue((Object)direction);
        row.getCell("description").setValue((Object)description);
    }
}

