/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.CompanyF7Factory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.client.CasPaymentBillUI;
import com.kingdee.eas.fi.cas.client.CasReceivingBillUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AgentRecPayClientHelper {
    private static Logger logger = Logger.getLogger((String)AgentRecPayClientHelper.class.getName());
    private static HashMap paymentBillUIMap = null;
    private static HashMap receivingBillUIMap = null;

    public static void paymentBill_initDataStatus(Map agentRelatedProps) {
        IUIObject ui = (IUIObject)agentRelatedProps.get("ui");
        PaymentBillInfo editData = (PaymentBillInfo)agentRelatedProps.get("editData");
        String oprtState = (String)agentRelatedProps.get("OprtState");
        HashMap paramValue = (HashMap)agentRelatedProps.get("paramValue");
        boolean isAuditedBill = BillStatusEnum.AUDITED.equals((Object)editData.getBillStatus());
        boolean isPayed = BillStatusEnum.PAYED.equals((Object)editData.getBillStatus());
        Map payUIMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)ui);
        KDBizPromptBox prmtAgentCompany = (KDBizPromptBox)payUIMap.get("prmtAgentCompany");
        KDBizPromptBox prmtMainOrgCompany = (KDBizPromptBox)payUIMap.get("prmtMainOrgCompany");
        KDBizPromptBox prmtPayerAccountBank = (KDBizPromptBox)payUIMap.get("prmtPayerAccountBank");
        KDBizPromptBox prmtOppAccount = (KDBizPromptBox)payUIMap.get("prmtOppAccount");
        KDBizPromptBox prmtPayerAccount = (KDBizPromptBox)payUIMap.get("prmtPayerAccount");
        KDTable kdtEntries = (KDTable)payUIMap.get("kdtEntries");
        KDComboBox comboPayeeType = (KDComboBox)payUIMap.get("comboPayeeType");
        KDBizPromptBox prmtPayee = (KDBizPromptBox)payUIMap.get("prmtPayee");
        KDBizPromptBox txtPayeeAccountBank = (KDBizPromptBox)payUIMap.get("txtPayeeAccountBank");
        KDBizPromptBox txtPayeeBank = (KDBizPromptBox)payUIMap.get("txtPayeeBank");
        KDSpinner spinAccessoryAmt = (KDSpinner)payUIMap.get("spinAccessoryAmt");
        CompanyF7Factory.initCompanyBizUnitF7((IUIObject)ui, (KDBizPromptBox)prmtAgentCompany);
        prmtAgentCompany.setEditable(true);
        KDComboBox comboCurrency = (KDComboBox)payUIMap.get("comboCurrency");
        boolean hasSourceBill = !EmptyUtil.isEmpty((String)editData.getSourceBillId());
        BillStatusEnum billStatus = editData.getBillStatus();
        if (CasRecPayBillTypeEnum.RealType.equals((Object)editData.getPaymentBillType())) {
            if (editData.getAuditor() != null) {
                prmtPayerAccountBank.setEnabled(false);
            }
            if (billStatus == BillStatusEnum.AUDITED && editData.getPayerAccountBank() == null) {
                prmtPayerAccount.setEnabled(true);
            }
        }
        boolean isSaveOrSubmit = billStatus == null || billStatus == BillStatusEnum.SAVE || billStatus == BillStatusEnum.SUBMIT;
        boolean isView = "FINDVIEW".equalsIgnoreCase(oprtState) || OprtState.VIEW.equals(oprtState);
        boolean isEdit = OprtState.EDIT.equals(oprtState);
        boolean canNotEditMainOrgCompany = hasSourceBill || isView || !isSaveOrSubmit || isEdit;
        boolean canNotEditAgentCompany = hasSourceBill || isView || editData.getAuditor() != null;
        prmtAgentCompany.setEnabled(!canNotEditAgentCompany);
        prmtMainOrgCompany.setEnabled(!canNotEditMainOrgCompany);
        if (CasRecPayBillTypeEnum.AgentType.equals((Object)editData.getPaymentBillType())) {
            boolean auditCanEdit = (Boolean)paramValue.get("CS031");
            kdtEntries.getColumn("amount").getStyleAttributes().setLocked(true);
            IKDComponent[] components = new IKDComponent[]{prmtPayerAccountBank, prmtPayerAccount, prmtOppAccount};
            FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)true);
            IKDComponent[] componentsForPayees = new IKDComponent[]{comboPayeeType, prmtPayee, txtPayeeAccountBank, txtPayeeBank};
            FMClientHelper.setCompEnable((IKDComponent[])componentsForPayees, (boolean)false);
            kdtEntries.getColumn("oppAccount").getStyleAttributes().setLocked(false);
            AccountBankInfo payerAccountBank = editData.getPayerAccountBank();
            BOSUuid acctCompanyID = payerAccountBank != null ? payerAccountBank.getCompany().getId() : null;
            BOSUuid billCompanyID = editData.getCompany().getId();
            if (payerAccountBank != null && !billCompanyID.equals((Object)acctCompanyID)) {
                prmtPayerAccount.setRequired(false);
            }
            if (isPayed || isAuditedBill && !auditCanEdit) {
                FMClientHelper.setCompEnable((IKDComponent[])components, (boolean)false);
            }
            comboCurrency.setEnabled(false);
        }
    }

    public static void receivingBill_initDataStatus(Map agentRelatedProps) {
        BillStatusEnum billStatus;
        boolean hasSourceBill;
        IUIObject ui = (IUIObject)agentRelatedProps.get("ui");
        ReceivingBillInfo editData = (ReceivingBillInfo)agentRelatedProps.get("editData");
        String oprtState = (String)agentRelatedProps.get("OprtState");
        Map payUIMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)ui);
        HashMap actionMap = ((CoreUIObject)ui).getActionManager().getActionSet();
        KDBizPromptBox prmtRealRecCompany = (KDBizPromptBox)payUIMap.get("prmtRealRecCompany");
        KDBizPromptBox prmtMainOrgCompany = (KDBizPromptBox)payUIMap.get("prmtMainOrgCompany");
        KDBizPromptBox prmtPayeeAccountBank = (KDBizPromptBox)payUIMap.get("prmtPayeeAccountBank");
        KDFormattedTextField txtActRecAmt = (KDFormattedTextField)payUIMap.get("txtActRecAmt");
        KDComboBox comboCurrency = (KDComboBox)payUIMap.get("comboCurrency");
        KDTable kdtEntries = (KDTable)payUIMap.get("kdtEntries");
        CompanyF7Factory.initCompanyBizUnitF7((IUIObject)ui, (KDBizPromptBox)prmtRealRecCompany);
        prmtRealRecCompany.setEditable(true);
        boolean bl = hasSourceBill = !EmptyUtil.isEmpty((String)editData.getSourceBillId());
        if (CasRecPayBillTypeEnum.AgentType.equals((Object)editData.getReceivingBillType()) && BillStatusEnum.RECED.equals((Object)editData.getBillStatus())) {
            prmtPayeeAccountBank.setEnabled(false);
        }
        if (CasRecPayBillTypeEnum.RealType.equals((Object)editData.getReceivingBillType())) {
            prmtMainOrgCompany.setEnabled(false);
            txtActRecAmt.setEnabled(false);
            comboCurrency.setEnabled(false);
            kdtEntries.getColumn("amount").getStyleAttributes().setLocked(true);
            ItemAction actionAddLine = (ItemAction)actionMap.get("actionAddLine");
            ItemAction actionRemoveLine = (ItemAction)actionMap.get("actionRemoveLine");
            ItemAction actionInsertLine = (ItemAction)actionMap.get("actionInsertLine");
            actionAddLine.setEnabled(false);
            actionRemoveLine.setEnabled(false);
            actionInsertLine.setEnabled(false);
        }
        boolean isSaveOrSubmit = (billStatus = editData.getBillStatus()) == null || billStatus == BillStatusEnum.SAVE || billStatus == BillStatusEnum.SUBMIT;
        boolean isView = "FINDVIEW".equalsIgnoreCase(oprtState) || OprtState.VIEW.equals(oprtState);
        boolean isEdit = OprtState.EDIT.equals(oprtState);
        boolean notSumitSettle = SettlementStatusEnum.UNSUBMIT.equals((Object)editData.getSettlementStatus()) || editData.getSettlementStatus() == null;
        boolean canNotEditMainOrgCompany = hasSourceBill || isView || !isSaveOrSubmit || isEdit;
        boolean canNotEditAgentCompany = hasSourceBill || isView || BillStatusEnum.RECED.equals((Object)editData.getBillStatus());
        prmtRealRecCompany.setEnabled(!canNotEditAgentCompany && notSumitSettle);
        prmtMainOrgCompany.setEnabled(!canNotEditMainOrgCompany);
    }

    public static void paymentBill_verifyInput(Map agentRelatedProps) {
        SettBizTypeInfo bizTypeInfo;
        IUIObject ui = (IUIObject)agentRelatedProps.get("ui");
        Map payUIMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)ui);
        KDBizPromptBox prmtAgentCompany = (KDBizPromptBox)payUIMap.get("prmtAgentCompany");
        KDBizPromptBox prmtPayerAccountBank = (KDBizPromptBox)payUIMap.get("prmtPayerAccountBank");
        KDBizPromptBox f7BizType = (KDBizPromptBox)payUIMap.get("f7BizType");
        if (prmtAgentCompany.getValue() == null) {
            return;
        }
        AccountBankInfo acctBank = (AccountBankInfo)prmtPayerAccountBank.getValue();
        if (acctBank != null && acctBank.getInnerAcct() != null && f7BizType.getValue() != null && !SettBizTypeEnum.PAYOUTSIDE.equals((Object)(bizTypeInfo = (SettBizTypeInfo)f7BizType.getData()).getType()) && !SettBizTypeEnum.LINKPAY.equals((Object)bizTypeInfo.getType())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"241_AgentRecPayClientHelper"));
            SysUtil.abort();
        }
    }

    public static void receivingBill_verifyInput(Map agentRelatedProps) {
        IUIObject ui = (IUIObject)agentRelatedProps.get("ui");
        Map payUIMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)ui);
        KDBizPromptBox prmtRealRecCompany = (KDBizPromptBox)payUIMap.get("prmtRealRecCompany");
        KDBizPromptBox prmtMainOrgCompany = (KDBizPromptBox)payUIMap.get("prmtMainOrgCompany");
        KDBizPromptBox prmtPayeeAccountBank = (KDBizPromptBox)payUIMap.get("prmtPayeeAccountBank");
        CompanyOrgUnitInfo mainOrg = (CompanyOrgUnitInfo)prmtMainOrgCompany.getValue();
        if (prmtPayeeAccountBank.getValue() != null) {
            AccountBankInfo acctBank = (AccountBankInfo)prmtPayeeAccountBank.getValue();
            if (!mainOrg.getId().equals((Object)acctBank.getCompany().getId())) {
                ClientVerifyHelper.verifyEmpty((CoreUIObject)((CoreUIObject)ui), (KDBizPromptBox)prmtRealRecCompany);
            }
        }
    }

    private static Map getComponentsMap(CoreUIObject ui) {
        if (ui == null) {
            return null;
        }
        HashMap<String, Component> componentsContainer = null;
        if (ui instanceof CasPaymentBillUI) {
            componentsContainer = paymentBillUIMap;
        } else if (ui instanceof CasReceivingBillUI) {
            componentsContainer = receivingBillUIMap;
        }
        if (componentsContainer == null || componentsContainer.isEmpty()) {
            componentsContainer = new HashMap<String, Component>();
            Set allLeafComponents = UIUtil.getAllComponents((Container)ui);
            for (Component comp : allLeafComponents) {
                if (comp == null) continue;
                componentsContainer.put(comp.getName(), comp);
            }
        }
        return componentsContainer;
    }

    public static void main(String[] args) {
        try {
            Component component;
            CasPaymentBillUI payUI = new CasPaymentBillUI();
            CasReceivingBillUI recUI = new CasReceivingBillUI();
            Map payMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)payUI);
            Map recMap = AgentRecPayClientHelper.getComponentsMap((CoreUIObject)recUI);
            for (String key : payMap.keySet()) {
                component = (Component)payMap.get(key);
            }
            for (String key : recMap.keySet()) {
                component = (Component)recMap.get(key);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

