/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.AbstractAntiRepeatSettingFilterUI;
import com.kingdee.eas.fi.cas.client.AntiRepeatSettingFilterParam;
import com.kingdee.eas.fi.gl.GlUtils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AntiRepeatSettingFilterUI
extends AbstractAntiRepeatSettingFilterUI {
    private static final long serialVersionUID = -4426065586523482652L;
    private static final Logger logger = CoreUIObject.getLogger(AntiRepeatSettingFilterUI.class);

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setVisible(false);
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmCompany);
        return true;
    }

    protected void setDefaultValue() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.prmCompany.setValue((Object)currentCompany);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany)) {
            this.prmCompany.setEnabled(true);
        } else {
            this.prmCompany.setEnabled(false);
        }
        this.prmCompany.setEnabledMultiSelection(false);
        this.txName.setText(null);
        this.txNumber.setText(null);
        this.CBIsEnable.setSelected(true);
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmCompany;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        CompanyOrgUnitCollection coll;
        AntiRepeatSettingFilterParam filterParam = new AntiRepeatSettingFilterParam();
        filterParam.setName(this.txName.getText());
        filterParam.setNumber(this.txNumber.getText());
        filterParam.setEnable(this.CBIsEnable.isSelected());
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl()) && !EmptyUtil.isEmpty((AbstractObjectCollection)(coll = this.getMainOrgColl()))) {
            CompanyOrgUnitInfo companyInfo = coll.get(0);
            String longNumber = companyInfo.getLongNumber();
            HashSet<String> idSet = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(companyInfo.getId().toString()) || "11111111-1111-1111-1111-111111111111CCE7AED4".equals(companyInfo.getId().toString())) {
                fi.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
                fi.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
                view.setFilter(fi);
            } else if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
                HashSet<String> adminsIdSet = new HashSet<String>();
                adminsIdSet.add("00000000-0000-0000-0000-000000000000CCE7AED4");
                adminsIdSet.add("11111111-1111-1111-1111-111111111111CCE7AED4");
                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
                fi.getFilterItems().add(new FilterItemInfo("id", adminsIdSet, CompareType.INCLUDE));
                fi.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
                fi.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
                fi.setMaskString("(#0 OR #1) AND #2 AND #3");
                view.setFilter(fi);
            } else {
                HashSet<String> longNumberSet = new HashSet<String>();
                while (longNumber.length() > 0) {
                    longNumberSet.add(longNumber);
                    if (longNumber.lastIndexOf("!") > -1) {
                        longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                        continue;
                    }
                    longNumber = "";
                }
                fi.getFilterItems().add(new FilterItemInfo("longNumber", longNumberSet, CompareType.INCLUDE));
                fi.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)false));
                fi.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
                view.setFilter(fi);
            }
            try {
                coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    idSet.add(coll.get(i).getId().toString());
                }
                filterParam.setMainOrgCollIDSet(idSet);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        Object mainBizOrgValue = this.prmCompany.getValue();
        AntiRepeatSettingFilterParam filterParam = (AntiRepeatSettingFilterParam)param;
        if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((CompanyOrgUnitInfo)mainBizOrgValue).getId().toString()));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmCompany.setValue((Object)coll.get(0));
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        }
        this.txName.setText(filterParam.getName());
        this.txNumber.setText(filterParam.getNumber());
        this.CBIsEnable.setSelected(filterParam.isEnable());
    }

    protected Class getParamClass() {
        return AntiRepeatSettingFilterParam.class;
    }
}

