/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonFilterPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.AntiRepeatSettingFactory;
import com.kingdee.eas.fi.cas.AntiRepeatSettingInfo;
import com.kingdee.eas.fi.cas.RepeatBillTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractAntiRepeatSettingUI;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.rpm.RPMException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class AntiRepeatSettingUI
extends AbstractAntiRepeatSettingUI {
    private static final long serialVersionUID = 2274107484333925207L;
    private static final Logger logger = CoreUIObject.getLogger(AntiRepeatSettingUI.class);
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
    private CoreUI thisUi;
    private CommonFilterPanel commonFilterPanel;
    private IPromptBoxFactory promptBoxFactory;

    private void initTable(String query, String filter) throws BOSException, ParserException {
        if (query.equals(RepeatBillTypeEnum.CasPaymentBillQuery.getName())) {
            query = "com.kingdee.eas.fi.cas.CasPaymentBillQuery";
        } else if (query.equals(RepeatBillTypeEnum.CBPaymentWebQuery.getName())) {
            query = "com.kingdee.eas.fm.cbs.app.CBSPaymentQuery";
        } else if (query.equals(RepeatBillTypeEnum.SettlementBillQuery.getName())) {
            query = "com.kingdee.eas.fm.fs.SettlementBillQuery";
        }
        MetaDataPK queryObjectPK = new MetaDataPK(query);
        FMDefaultQueryProcessor processor = new FMDefaultQueryProcessor();
        String filterSql = filter;
        FilterInfo filterInfo = null;
        filterInfo = EmptyUtil.isEmpty((String)filterSql) ? new FilterInfo() : new FilterInfo(filterSql);
        FilterInfo filterLockInfo = new FilterInfo();
        if (null == this.commonFilterPanel) {
            this.commonFilterPanel = new CommonFilterPanel(queryObjectPK, filterInfo, filterLockInfo, (IProcessor)processor, this.promptBoxFactory, 1100, 400);
            this.commonFilterPanel.setBounds(new Rectangle(10, 358, 856, 287));
            this.thisUi.add((Component)this.commonFilterPanel, (Object)new KDLayout.Constraints(10, 358, 876, 450, 261));
        } else {
            this.commonFilterPanel.setQueryInfo(queryObjectPK);
            this.commonFilterPanel.setFilterInfo(filterInfo);
            this.commonFilterPanel.reInitTable();
        }
        this.thisUi.repaint();
    }

    public void onLoad() throws Exception {
        this.thisUi = this;
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    @Override
    protected void kDBillRadioButton_mouseClicked(MouseEvent e) throws Exception {
        String query = RepeatBillTypeEnum.CasPaymentBillQuery.getName();
        this.initTable(query, "");
        this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"300_AntiRepeatSettingUI"));
        this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"301_AntiRepeatSettingUI"));
        this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"7_AgentPayBillControllerBean"));
        this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"302_AntiRepeatSettingUI"));
        this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"188_PaymentBillControllerBean"));
        this.chkIsSettle.setVisible(true);
        this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"303_AntiRepeatSettingUI"));
        this.chkIsBizType.setVisible(true);
        this.chkIsUsge.setSelected(false);
        this.chkIsSummary.setSelected(false);
        this.chkIsSourceSystem.setSelected(false);
        this.chkIsSourceId.setSelected(false);
        this.chkIsActualName.setSelected(false);
        this.chkIsUsgeSummary.setSelected(false);
        this.chkIsBizType.setSelected(false);
    }

    @Override
    protected void kDCbsRadioButton_mouseClicked(MouseEvent e) throws Exception {
        String query = RepeatBillTypeEnum.CBPaymentWebQuery.getName();
        this.initTable(query, "");
        this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"304_AntiRepeatSettingUI"));
        this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"305_AntiRepeatSettingUI"));
        this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"306_AntiRepeatSettingUI"));
        this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"307_AntiRepeatSettingUI"));
        this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"188_PaymentBillControllerBean"));
        this.chkIsSettle.setVisible(false);
        this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"303_AntiRepeatSettingUI"));
        this.chkIsBizType.setVisible(false);
        this.chkIsUsge.setSelected(false);
        this.chkIsSummary.setSelected(false);
        this.chkIsSourceSystem.setSelected(false);
        this.chkIsSourceId.setSelected(false);
        this.chkIsActualName.setSelected(false);
        this.chkIsUsgeSummary.setSelected(false);
        this.chkIsBizType.setSelected(false);
    }

    @Override
    protected void kDSettleRadioButton_mouseClicked(MouseEvent e) throws Exception {
        String query = RepeatBillTypeEnum.SettlementBillQuery.getName();
        this.initTable(query, "");
        this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"300_AntiRepeatSettingUI"));
        this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"301_AntiRepeatSettingUI"));
        this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"7_AgentPayBillControllerBean"));
        this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"302_AntiRepeatSettingUI"));
        this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"308_AntiRepeatSettingUI"));
        this.chkIsSettle.setVisible(false);
        this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"309_AntiRepeatSettingUI"));
        this.chkIsBizType.setVisible(true);
        this.chkIsUsge.setSelected(false);
        this.chkIsSummary.setSelected(false);
        this.chkIsSourceSystem.setSelected(false);
        this.chkIsSourceId.setSelected(false);
        this.chkIsActualName.setSelected(false);
        this.chkIsUsgeSummary.setSelected(false);
        this.chkIsBizType.setSelected(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verifyInput();
        if (this.txtDays.getValue() != null) {
            String msg;
            int days = Integer.parseInt(this.txtDays.getValue().toString());
            if (days <= 0) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"310_AntiRepeatSettingUI");
                MsgBox.showWarning((String)msg);
                SysUtil.abort();
            }
            if (days > 90) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"311_AntiRepeatSettingUI");
                MsgBox.showWarning((String)msg);
                SysUtil.abort();
            }
        }
        if (!(this.chkIsSubmit.isSelected() || this.chkIsApprove.isSelected() || this.chkIsSettle.isSelected())) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"312_AntiRepeatSettingUI");
            MsgBox.showWarning((String)msg);
            SysUtil.abort();
        }
    }

    private void verifyInput() throws Exception {
        AntiRepeatSettingInfo info;
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.editData.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.editData.getCompany().getId().toString()));
        if (this.getBizInterface().exists(filter) && OprtState.ADDNEW.equals(this.getOprtState())) {
            throw new RPMException(RPMException.REPEAT_NUMBER, new Object[]{this.editData.getNumber()});
        }
        if (this.editData.getFilter() != null && this.editData.getFilter().length() > 4000) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"313_AntiRepeatSettingUI"));
            SysUtil.abort();
        }
        if (this.editData.getId() != null && AntiRepeatSettingFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(this.editData.getId())) && (info = AntiRepeatSettingFactory.getRemoteInstance().getAntiRepeatSettingInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()))).isIsEnable()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"314_AntiRepeatSettingUI"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        AntiRepeatSettingInfo info = new AntiRepeatSettingInfo();
        info.setCreator(this.contextHelper.getCurrentUser());
        info.setCompany(this.contextHelper.getCurrentCompany());
        info.setIsCompany(true);
        info.setIsCurrency(true);
        info.setIsAmount(true);
        info.setIsPayeeAccount(true);
        info.setIsToBe(true);
        info.setDays(7);
        info.setIsEnable(false);
        info.setBillType(RepeatBillTypeEnum.CasPaymentBillQuery);
        info.setFilter("");
        info.setFilterAct("");
        info.setIsActualName(false);
        info.setIsApprove(true);
        info.setIsBizTpye(false);
        info.setIsSettle(false);
        info.setIsSourceId(false);
        info.setIsSourceSystem(false);
        info.setIsSummary(false);
        info.setIsSummit(true);
        info.setIsUsge(false);
        info.setIsUsgeSummary(false);
        info.setName(null);
        info.setNumber(null);
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.kDBillRadioButton.isSelected()) {
            this.editData.setBillType(RepeatBillTypeEnum.CasPaymentBillQuery);
        } else if (this.kDCbsRadioButton.isSelected()) {
            this.editData.setBillType(RepeatBillTypeEnum.CBPaymentWebQuery);
        } else if (this.kDSettleRadioButton.isSelected()) {
            this.editData.setBillType(RepeatBillTypeEnum.SettlementBillQuery);
        }
        FilterInfo filter = null;
        FilterInfo filterAct = null;
        boolean verify = this.commonFilterPanel.verify();
        if (!verify) {
            SysUtil.abort();
        }
        try {
            filterAct = this.commonFilterPanel.getInnerFilterInfo();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        filter = this.commonFilterPanel.getFilterInfo();
        this.editData.setFilter(filter.toString());
        this.editData.setFilterAct(filterAct.toString());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (this.editData.getBillType() != null && this.editData.getBillType().equals((Object)RepeatBillTypeEnum.CBPaymentWebQuery)) {
                this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"304_AntiRepeatSettingUI"));
                this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"305_AntiRepeatSettingUI"));
                this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"306_AntiRepeatSettingUI"));
                this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"307_AntiRepeatSettingUI"));
                this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"188_PaymentBillControllerBean"));
            } else if (this.editData.getBillType() != null && this.editData.getBillType().equals((Object)RepeatBillTypeEnum.CasPaymentBillQuery)) {
                this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"300_AntiRepeatSettingUI"));
                this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"301_AntiRepeatSettingUI"));
                this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"7_AgentPayBillControllerBean"));
                this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"302_AntiRepeatSettingUI"));
                this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"188_PaymentBillControllerBean"));
            } else if (this.editData.getBillType() != null && this.editData.getBillType().equals((Object)RepeatBillTypeEnum.SettlementBillQuery)) {
                this.chkIsCurrency.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"300_AntiRepeatSettingUI"));
                this.chkIsAmount.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"301_AntiRepeatSettingUI"));
                this.chkIsUsge.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"7_AgentPayBillControllerBean"));
                this.chkIsUsgeSummary.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"302_AntiRepeatSettingUI"));
                this.chkIsBizType.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"308_AntiRepeatSettingUI"));
            }
            this.initTable(this.editData.getBillType().getName(), this.editData.getFilter());
            if (this.editData.getBillType().equals((Object)RepeatBillTypeEnum.CasPaymentBillQuery)) {
                this.kDBillRadioButton.setSelected(true);
                this.chkIsSettle.setVisible(true);
                this.chkIsBizType.setVisible(true);
                this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"303_AntiRepeatSettingUI"));
            } else if (this.editData.getBillType().equals((Object)RepeatBillTypeEnum.CBPaymentWebQuery)) {
                this.kDCbsRadioButton.setSelected(true);
                this.chkIsSettle.setVisible(false);
                this.chkIsBizType.setVisible(false);
                this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"303_AntiRepeatSettingUI"));
            } else if (this.editData.getBillType().equals((Object)RepeatBillTypeEnum.SettlementBillQuery)) {
                this.kDSettleRadioButton.setSelected(true);
                this.chkIsSettle.setVisible(false);
                this.chkIsBizType.setVisible(true);
                this.chkIsApprove.setText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"309_AntiRepeatSettingUI"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prmtCompany.setValue((Object)this.editData.getCompany());
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            this.chkIsSubmit.setSelected(true);
            this.chkIsApprove.setSelected(true);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.chkIsCompany.setEnabled(false);
        this.chkIsCurrency.setEnabled(false);
        this.chkIsAmount.setEnabled(false);
        this.chkIsPayeeAccount.setEnabled(false);
        this.contCompany.setEnabled(false);
        this.actionSubmit.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopy.setVisible(false);
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.filter.setRequired(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionSubmitOption.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        AntiRepeatSettingInfo info = AntiRepeatSettingFactory.getRemoteInstance().getAntiRepeatSettingInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        if (info != null && !info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"315_AntiRepeatSettingUI")});
        }
        if (info != null && info.isIsEnable()) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.rpm.RpmResources", (String)"25_IsEnable_NotEdit")});
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        AntiRepeatSettingInfo info = AntiRepeatSettingFactory.getRemoteInstance().getAntiRepeatSettingInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        if (info != null && !info.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"316_AntiRepeatSettingUI")});
        }
        if (info != null && info.isIsEnable()) {
            throw new RPMException(RPMException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"317_AntiRepeatSettingUI")});
        }
        super.actionRemove_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AntiRepeatSettingFactory.getRemoteInstance();
    }

    @Override
    protected void chkIsUsge_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsUsge.isSelected()) {
            this.chkIsUsgeSummary.setSelected(false);
            this.chkIsUsgeSummary.setEnabled(false);
        } else if (this.chkIsSummary.isSelected()) {
            this.chkIsUsgeSummary.setEnabled(false);
        } else {
            this.chkIsUsgeSummary.setEnabled(true);
        }
    }

    @Override
    protected void chkIsSummary_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsSummary.isSelected()) {
            this.chkIsUsgeSummary.setSelected(false);
            this.chkIsUsgeSummary.setEnabled(false);
        } else if (this.chkIsUsge.isSelected()) {
            this.chkIsUsgeSummary.setEnabled(false);
        } else {
            this.chkIsUsgeSummary.setEnabled(true);
        }
    }

    @Override
    protected void chkIsUsgeSummary_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsUsgeSummary.isSelected()) {
            this.chkIsSummary.setSelected(false);
            this.chkIsSummary.setEnabled(false);
            this.chkIsUsge.setSelected(false);
            this.chkIsUsge.setEnabled(false);
        } else {
            this.chkIsSummary.setEnabled(true);
            this.chkIsUsge.setEnabled(true);
        }
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        return sic;
    }
}

