/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ArApRecPayLogic {
    private static final Logger logger = Logger.getLogger(ArApRecPayLogic.class);
    private ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    private static final String path = "com.kingdee.eas.fi.ar.ARRecPayResource";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.cas.CasResource";
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final HashMap mapPrecOfCurrency = new HashMap(32);

    public void setRedBill(KDTable kdtEntries, boolean isRedBill, SourceTypeEnum sourceType) throws EASBizException, BOSException {
        if (isRedBill) {
            this.setRedFont(kdtEntries, Color.RED, sourceType);
        } else {
            this.setRedFont(kdtEntries, Color.BLACK, sourceType);
        }
    }

    public void setRedFont(KDTable kdtEntries, Color colorType, SourceTypeEnum sourceType) {
        String[] redArray = this.arapHelper.getRedArray(sourceType);
        int num = kdtEntries.getRowCount();
        for (int row = 0; row < num; ++row) {
            for (int i = 0; i < redArray.length; ++i) {
                kdtEntries.getColumn(redArray[i]).getStyleAttributes().setFontColor(colorType);
            }
        }
    }

    public void freeze(KDTable tblMain) {
        tblMain.getViewManager().freeze(-1, tblMain.getColumnCount() - 1);
    }

    public void setTableRowHide(KDTable kdtEntries, String[] rowNames, boolean isHide) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setHided(isHide);
        }
    }

    public void setTableRowLock(KDTable kdtEntries, String[] rowNames, boolean isLock) {
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null) continue;
            kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public boolean isCanCanceRec(String billId) throws BOSException, CasForArApException {
        IDynamicObject dynamicObject = DynamicObjectFactory.getRemoteInstance();
        IObjectCollection collection = dynamicObject.getCollection(BOSObjectType.create((String)"E8E08EAC"), "where billID = '" + billId + "'");
        if (collection.size() > 0) {
            throw new CasForArApException(CasForArApException.BILLVERIFIED);
        }
        return true;
    }

    public static void verify(CoreUIObject ui, KDBizPromptBox bizBox) {
        ArApRecPayLogic.verify(ui, null, bizBox, null);
    }

    public static void verify(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? ArApRecPayLogic.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = ArApRecPayLogic.getCompLabelText(component);
        return MessageFormat.format(EASResource.getString((String)path, (String)"NotRight_1"), text);
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }

    public void setItemActionsEnabled(ItemAction[] underControls, boolean flag) {
        int n = underControls.length;
        for (int i = 0; i < n; ++i) {
            if (underControls[i] == null) continue;
            underControls[i].setEnabled(flag);
        }
    }

    public void setItemActionsVisible(ItemAction[] underControls, boolean flag) {
        int n = underControls.length;
        for (int i = 0; i < n; ++i) {
            if (underControls[i] == null) continue;
            underControls[i].setVisible(flag);
        }
    }

    public void initNumber(ArApSysParamInfo cache, CoreBaseInfo info, KDTextField txtField, String companyId, String oprt) {
        boolean isExist = false;
        boolean isModifialbe = false;
        boolean isAddView = false;
        boolean isAddnewBreak = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            isExist = cache.isExistCodingRule();
            if (isExist) {
                CodingRuleInfo codeInfo = cache.getCodeRuleInfo();
                isModifialbe = codeInfo.isIsModifiable();
                isAddView = codeInfo.isIsAddView();
                isAddnewBreak = codeInfo.isIsaddnewbreak();
            }
            String number = "";
            if (isExist) {
                if (!FMHelper.isEmpty((String)info.getString("number"))) {
                    txtField.setEditable(isModifialbe);
                    return;
                }
                txtField.setEditable(isModifialbe);
                txtField.setRequired(isModifialbe);
                if (OprtState.ADDNEW.equals(oprt)) {
                    if (isAddView) {
                        number = codingRuleManager.getNumber((IObjectValue)info, companyId);
                    } else if (isAddnewBreak) {
                        number = codingRuleManager.readNumber((IObjectValue)info, companyId);
                    }
                    if (!FMHelper.isEmpty((String)number)) {
                        info.setString("number", number);
                        txtField.setText(number);
                    }
                }
            } else {
                txtField.setEnabled(true);
                txtField.setEditable(true);
                txtField.setRequired(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    public static void initNumber(CoreBaseInfo info, IColumn col, String companyId) {
        boolean rst = ArApRecPayLogic.hasNumber(info, companyId);
        if (!rst) {
            col.getStyleAttributes().setLocked(false);
        } else {
            col.getStyleAttributes().setLocked(true);
            col.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        }
    }

    public static boolean hasNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist((IObjectValue)info, companyId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String getNumber(CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        catch (Exception e) {
            result = null;
            logger.error((Object)e);
        }
        if (result != null && result.equals("")) {
            result = null;
        }
        return result;
    }

    public void setTableValuesABS(KDTable kdtEntries, String[] commonRows, String signal) {
        int sign = Integer.valueOf(signal);
        BigDecimal tempAmt = null;
        IRow row = null;
        int size = kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = kdtEntries.getRow(i);
            int rowSize = commonRows.length;
            for (int j = 0; j < rowSize; ++j) {
                tempAmt = (BigDecimal)row.getCell(commonRows[j]).getValue();
                if (tempAmt != null && sign == 1) {
                    row.getCell(commonRows[j]).setValue((Object)tempAmt.abs());
                }
                if (tempAmt != null && sign == -1) {
                    row.getCell(commonRows[j]).setValue((Object)tempAmt.abs().negate());
                }
                if (tempAmt == null || sign != 0) continue;
                row.getCell(commonRows[j]).setValue((Object)ZERO);
            }
        }
    }

    public void setTableValuesNegate(KDTable kdtEntries, String[] commonRows) {
        BigDecimal tempAmt = null;
        IRow row = null;
        int size = kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = kdtEntries.getRow(i);
            int rowSize = commonRows.length;
            for (int j = 0; j < rowSize; ++j) {
                tempAmt = (BigDecimal)row.getCell(commonRows[j]).getValue();
                if (tempAmt == null) continue;
                row.getCell(commonRows[j]).setValue((Object)tempAmt.negate());
            }
        }
    }

    public void checkStartPeriod(Component ui, CompanyOrgUnitInfo companyInfo, SourceTypeEnum sourceType) throws EASBizException, BOSException {
        if (sourceType.equals((Object)SourceTypeEnum.AR)) {
            CashClientHelper.getARStartPeriodInfo(ui, companyInfo);
        } else if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            CashClientHelper.getAPStartPeriodInfo(ui, companyInfo);
        }
    }

    public void fillPayeeOrPayer(KDBizPromptBox promptBox, String id, String name, String number, boolean notifyEvent) {
        if (id == null && name == null) {
            return;
        }
        Object assactInfo = null;
        if (BOSUuid.getBOSObjectType((String)id, (boolean)true).equals((Object)new CustomerInfo().getBOSType())) {
            CustomerInfo customerInfo = new CustomerInfo();
            customerInfo.setId(BOSUuid.read((String)id));
            customerInfo.setName(name);
            customerInfo.setNumber(number);
            assactInfo = customerInfo;
        } else if (BOSUuid.getBOSObjectType((String)id, (boolean)true).equals((Object)new SupplierInfo().getBOSType())) {
            SupplierInfo supplierInfo = new SupplierInfo();
            supplierInfo.setId(BOSUuid.read((String)id));
            supplierInfo.setName(name);
            supplierInfo.setNumber(number);
            assactInfo = supplierInfo;
        } else {
            CurrentInfo dataBaseInfo = new CurrentInfo();
            dataBaseInfo.setId(BOSUuid.read((String)id));
            dataBaseInfo.setName(name);
            dataBaseInfo.setNumber(number);
            assactInfo = dataBaseInfo;
        }
        if (notifyEvent) {
            promptBox.setData(assactInfo);
        } else {
            promptBox.setDataNoNotify(assactInfo);
        }
    }

    public static String getNumberFtm(int precision) {
        StringBuffer numberFormate = new StringBuffer("##,###,###,###,###,##0");
        if (precision > 0) {
            numberFormate.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            numberFormate.append("0");
        }
        return numberFormate.toString();
    }

    public static String getNumberFtm() {
        return "%r-[ ]{###,###,###.##}15.2n";
    }

    public static CurrencyInfo getCurrencyInfo(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CurrencyInfo info = null;
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            info = iCurrency.getCurrencyInfo((IObjectPK)pk);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return info;
    }

    public String[] setColumnFormat(String[] rowNames, int pre) {
        String format = ArApRecPayLogic.getNumberFtm(pre);
        String[] rowFormatStr = new String[rowNames.length];
        int n = rowNames.length;
        for (int i = 0; i < n; ++i) {
            if (rowNames[i] == null) continue;
            rowFormatStr[i] = new StringBuffer(rowNames[i]).append("@").append(format).toString();
        }
        return rowFormatStr;
    }
}

