/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import java.util.HashSet;

public class ArApRecPayQueryProcessor
extends FMDefaultQueryProcessor {
    protected IUIObject owner;
    protected CompanyOrgUnitInfo companyInfo;
    protected SourceTypeEnum source;
    private boolean isInit;
    protected ArApRecPayHelper arapHelper = new ArApRecPayHelper();

    public ArApRecPayQueryProcessor(IUIObject owner, CompanyOrgUnitInfo companyInfo, SourceTypeEnum source, boolean isInit) {
        this.owner = owner;
        this.companyInfo = companyInfo;
        this.source = source;
        this.isInit = isInit;
    }

    private ArApRecPayQueryProcessor(CompanyOrgUnitInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    public void process() throws Exception {
        super.process();
        String field = this.getField();
        Object editor = this.getEditor();
        CustomerQueryPanel ui = (CustomerQueryPanel)((CommonQueryPanel)this.get("COMMON_QUERY_PANEL")).getCustomerQueryPanel().get(0);
        FilterItemCollection filterItems = ui.getFilterInfo().getFilterItems();
        String sCompanyId = null;
        CompanyOrgUnitInfo curCompany = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            if (!"company.id".equalsIgnoreCase(filterItems.get(i).getPropertyName())) continue;
            sCompanyId = filterItems.get(i).getCompareValue().toString();
            break;
        }
        if (sCompanyId != null) {
            String oql = "";
            oql = "  where id = '" + sCompanyId + "'";
            CompanyOrgUnitCollection companyOrgCol = null;
            companyOrgCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(oql);
            if (companyOrgCol.size() > 0) {
                curCompany = companyOrgCol.get(0);
            }
        }
        if (curCompany == null) {
            curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (editor instanceof KDBizPromptBox) {
            KDBizPromptBox prmtBox = (KDBizPromptBox)editor;
            String query = prmtBox.getQueryInfo();
            if (EmptyUtil.isEmpty((String)query)) {
                return;
            }
            if (curCompany.getAccountTable() == null) {
                return;
            }
            String accountTable = curCompany.getAccountTable().getId().toString();
            String cuId = curCompany.getCU() == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : curCompany.getCU().getId().toString();
            EntityViewInfo evi = null;
            if (field.equalsIgnoreCase("oppAccount.number") || field.equalsIgnoreCase("oppAccount.name") || field.equalsIgnoreCase("oppAccount.id") || field.equalsIgnoreCase("entryOppAccount.number") || field.equalsIgnoreCase("entryOppAccount.name") || field.equalsIgnoreCase("oppAccount1.name") || field.equalsIgnoreCase("oppAccount1.number")) {
                this.setEntryOppAcctEvi(prmtBox, curCompany, cuId, null, accountTable);
                prmtBox.setCommitFormat("$number$;$name$");
            }
            if (field.equalsIgnoreCase("adminOrgUnit.name") || field.equalsIgnoreCase("adminOrgUnit.name")) {
                UIUtil.setAdminAllCU((IUIObject)this.owner, (KDBizPromptBox)prmtBox, (boolean)false, (boolean)true, (boolean)true);
            }
            if (field.equalsIgnoreCase("entryRecBillType.name") || field.equalsIgnoreCase("recBillType.name")) {
                this.setRecType(prmtBox);
            }
            if ("paymentType.name".equals(field)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                if (this.source.getValue() == 100) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5"));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5"));
                }
                filter.setMaskString("#0 or #1 ");
                viewInfo.setFilter(filter);
                prmtBox.setEntityViewInfo(viewInfo);
                prmtBox.setEditFormat("$name$");
                prmtBox.setCommitFormat("$name$");
            }
            if (field.equalsIgnoreCase("payeeAccount.number") || field.equalsIgnoreCase("payeeAccount.name") || field.equalsIgnoreCase("payerAccount.number") || field.equalsIgnoreCase("payerAccount.name")) {
                evi = CasRecPayHandler.getCustomAcctEvi(cuId, accountTable, true);
                prmtBox.setEntityViewInfo(evi);
                this.setPayeerAcctEvi(prmtBox, curCompany, cuId, null, accountTable, true);
                prmtBox.setCommitFormat("$number$;$name$");
            }
            if (field.equalsIgnoreCase("payerAccount.number")) {
                evi = CasRecPayHandler.getCustomAcctEvi(cuId, accountTable, true);
                prmtBox.setEntityViewInfo(evi);
                this.setPayeerAcctEvi(prmtBox, curCompany, cuId, null, accountTable, false);
                prmtBox.setCommitFormat("$number$;$name$");
            }
            if (field.equalsIgnoreCase("payerType.name") || field.equalsIgnoreCase("payeeType.name")) {
                this.makeAsstActType(prmtBox, curCompany.getId().toString());
            }
            if (field.equalsIgnoreCase("payBillType.number") || field.equalsIgnoreCase("recBillType.number") || field.equalsIgnoreCase("entryRecBillType.number")) {
                new ArApRecPayHelper().initBillType(prmtBox, this.source, this.isInit, false);
                prmtBox.setCommitFormat("$number$;$name$");
            }
            String companyCUID = null;
            String companyID = null;
            if (null != curCompany && null != curCompany.getCU() && null != curCompany.getCU().getId()) {
                companyCUID = curCompany.getCU().getId().toString();
                companyID = curCompany.getId().toString();
            }
            if (field.equalsIgnoreCase("costCenter.name")) {
                CasForArApUtil.setNewCostCenterF7(prmtBox, companyCUID, companyID);
                prmtBox.setAutoFocusNextComponent(true);
                prmtBox.setCommitParser(null);
            }
        } else if (editor instanceof KDComboBox) {
            if (field.equalsIgnoreCase("billStatus")) {
                KDComboBox combox = (KDComboBox)editor;
                combox.removeAllItems();
                combox.addItem((Object)BillStatusEnum.SAVE);
                combox.addItem((Object)BillStatusEnum.SUBMIT);
                combox.addItem((Object)BillStatusEnum.AUDITED);
                if (this.source == SourceTypeEnum.AP) {
                    combox.addItem((Object)BillStatusEnum.PAYED);
                } else {
                    combox.addItem((Object)BillStatusEnum.RECED);
                }
            }
        } else if (editor instanceof KDDatePicker && (field.equalsIgnoreCase("createTime") || "lastUpdateTime".equals(field))) {
            ((KDDatePicker)editor).setTimeEnabled(false);
        }
    }

    private void makeAsstActType(KDBizPromptBox prmtBox, String companyID) throws BOSException, EASBizException {
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyID);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(ev);
        HashSet<String> idSet = new HashSet<String>();
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(asstActTypeColl.get(i).getAsstActType().getId().toString());
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        FilterInfo evifilter = new FilterInfo();
        evifilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        customEvi.setFilter(evifilter);
        prmtBox.setEntityViewInfo(customEvi);
        prmtBox.setEditFormat("$name$");
        prmtBox.setCommitFormat("$name$");
        prmtBox.setHasCUDefaultFilter(false);
    }

    private void setEntryOppAcctEvi(KDBizPromptBox prmtOppAccountEntry, CompanyOrgUnitInfo currentCompany, String cuId, String currencyId, String accountTable) throws EASBizException, BOSException {
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = this.arapHelper.getCustomAcctEvi(currentCompany.getId().toString(), accountTable);
        AccountPromptBox opseelect = new AccountPromptBox(this.owner, currentCompany, evi.getFilter(), false, true);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }

    private void setRecType(KDBizPromptBox prmtBillType) throws EASBizException, BOSException {
        prmtBillType.getQueryAgent().resetRuntimeEntityView();
        this.arapHelper.initBillType(prmtBillType, this.source, false, false);
    }

    private void setPayeerAcctEvi(KDBizPromptBox prmtOppAccountEntry, CompanyOrgUnitInfo currentCompany, String cuId, String currencyId, String accountTable, boolean isAR) throws EASBizException, BOSException {
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = this.arapHelper.getAccountEvi(currentCompany, isAR, accountTable, currencyId, false);
        AccountPromptBox opseelect = new AccountPromptBox(this.owner, currentCompany, evi.getFilter(), false, true);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }

    private void setCostCenter(KDBizPromptBox prmtCostCenterUnit, String companyID) throws EASBizException, BOSException {
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        HashSet<String> costCenterSet = new HashSet<String>();
        OrgUnitCollection orgIds = iOrgUnitRel.getFromUnit(companyID, 1, 5);
        for (int i = 0; orgIds != null && i < orgIds.size(); ++i) {
            costCenterSet.add(orgIds.get(i).getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", costCenterSet, CompareType.INCLUDE);
        FilterItemInfo filterItemIsBiz = new FilterItemInfo("isBizUnit", (Object)"true", CompareType.EQUALS);
        FilterItemInfo filterItemIsSealUp = new FilterItemInfo("isSealUp", (Object)"false", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.getFilterItems().add(filterItemIsBiz);
        filterInfo.getFilterItems().add(filterItemIsSealUp);
        viewInfo.setFilter(filterInfo);
        prmtCostCenterUnit.setEntityViewInfo(viewInfo);
    }
}

