/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.StringUtils;

public class BankBalanceAdjFilterParam
implements FilterParam {
    private static final long serialVersionUID = 3986300109306749077L;
    private String companyId;
    private String bankId;
    private String currencyId;
    private String periodId;
    private Integer periodYear;
    private Integer periodNum;
    private boolean isDestroyed;
    private String acctTableId;
    private transient PeriodInfo periodInfo;

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void setDestroyed(boolean isDestroyed) {
        this.isDestroyed = isDestroyed;
    }

    public Integer getPeriodNum() {
        return this.periodNum;
    }

    public void setPeriodNum(Integer periodNum) {
        this.periodNum = periodNum;
    }

    public Integer getPeriodYear() {
        return this.periodYear;
    }

    public void setPeriodYear(Integer periodYear) {
        this.periodYear = periodYear;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo itemInfo = null;
        if (!StringUtils.isEmpty((String)this.companyId)) {
            itemInfo = new FilterItemInfo("company.id", (Object)this.companyId);
            filter.getFilterItems().add(itemInfo);
        }
        if (!StringUtils.isEmpty((String)this.bankId)) {
            itemInfo = new FilterItemInfo("bank.id", (Object)this.bankId);
            filter.getFilterItems().add(itemInfo);
        }
        if (!StringUtils.isEmpty((String)this.currencyId)) {
            itemInfo = new FilterItemInfo("currency.id", (Object)this.currencyId);
            filter.getFilterItems().add(itemInfo);
        }
        if (!StringUtils.isEmpty((String)this.getPeriodId())) {
            itemInfo = new FilterItemInfo("period.id", (Object)this.periodId);
            filter.getFilterItems().add(itemInfo);
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection items = new SorterItemCollection();
        items.add(new SorterItemInfo("createDate"));
        return items;
    }

    public String getPeriodId() {
        if ((this.periodId == null || this.periodId.length() == 0) && this.periodYear != null && this.periodNum != null) {
            try {
                this.innerGetPeriod();
                this.periodId = this.periodInfo.getId().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.periodId;
    }

    public void setPeriodId(String periodId) {
        this.periodId = periodId;
    }

    private void innerGetPeriod() throws Exception {
        this.periodInfo = PeriodUtils.getPeriodInfo(null, (int)this.periodYear, (int)this.periodNum, (IObjectPK)new ObjectUuidPK(this.companyId));
    }

    public PeriodInfo getPeriodInfo() {
        if (this.periodInfo == null) {
            try {
                this.innerGetPeriod();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.periodInfo == null) {
            try {
                this.periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this.periodId));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.periodInfo;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }
}

