/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentUIFacadeFactory;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustmentFilterUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentFilterUI
extends AbstractBankBalanceAdjustmentFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankBalanceAdjustmentFilterUI.class.getName());
    private CompanyOrgUnitInfo company;
    private CompanyOrgUnitInfo[] companys;
    private String acctTableId;
    private boolean isSharedOrg;
    private Map paramMap;

    public BankBalanceAdjustmentFilterUI() throws Exception {
        this(null);
    }

    public BankBalanceAdjustmentFilterUI(Map paramMap) throws Exception {
        this.company = this.currentCompany;
        this.companys = null;
        this.acctTableId = null;
        this.isSharedOrg = true;
        this.paramMap = null;
        this.paramMap = paramMap;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle") + " - " + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryUITitle");
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        this.initBankAccountEvi();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        this.initBankAccountEvi();
    }

    public void initBankAccountEvi() throws Exception {
        if (this.prmtCompany.isEnabledMultiSelection()) {
            HashSet<String> compSet = new HashSet<String>();
            for (CompanyOrgUnitInfo comp : this.companys) {
                compSet.add(comp.getId().toString());
            }
            ClientUtils.setBankListIncludeShared2(this.prmtBankAccount, compSet, this.chkDestroyed.isSelected());
        } else {
            ClientUtils.setBankListIncludeShared2(this.prmtBankAccount, this.company.getId().toString(), this.chkDestroyed.isSelected());
        }
    }

    protected void init() throws Exception {
        this.initMainOrgF7();
        this.company = (CompanyOrgUnitInfo)this.paramMap.get("companyInfo");
        if (this.prmtCompany.isEnabledMultiSelection()) {
            this.prmtCompany.setData((Object)new Object[]{this.paramMap.get("companyInfo")});
        } else {
            this.prmtCompany.setData(this.paramMap.get("companyInfo"));
        }
        PeriodHelper.initPeriodSpinner(this.company, this.spPeriodYear, this.spPeriodNum);
        ClientUtils.setBankListIncludeShared(this.prmtBankAccount, this.company.getId().toString(), false);
        String strCompanyId = this.company.getId().toString();
        AccountBankCollection acctBankColl = CashClientHelper.getSharedAcctAccountBankCollection(strCompanyId, this.chkDestroyed.isSelected());
        if (acctBankColl != null && acctBankColl.size() > 0) {
            this.prmtBankAccount.setValue((Object)new Object[]{acctBankColl.get(0)});
        }
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        if (acctBankColl != null && acctBankColl.size() > 0 && acctBankColl.get(0).isIsByCurrency()) {
            ClientUtils.setSelectedItem(this.comboCurrency, acctBankColl.get(0).getCurrency().getId().toString());
        } else if (null != this.company.getBaseCurrency()) {
            ClientUtils.setSelectedItem(this.comboCurrency, this.company.getBaseCurrency().getId().toString());
        }
        this.comboCurrency.insertItemAt(null, 0);
        this.lblCurrency.setVisible(false);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() != null) {
            if (this.prmtCompany.isEnabledMultiSelection()) {
                Object[] companysObj = (Object[])this.prmtCompany.getData();
                this.companys = new CompanyOrgUnitInfo[companysObj.length];
                for (int i = 0; i < companysObj.length; ++i) {
                    this.companys[i] = (CompanyOrgUnitInfo)companysObj[i];
                }
                this.company = this.companys[0];
            } else {
                this.company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            }
            PeriodHelper.initPeriodSpinner(this.company, this.spPeriodYear, this.spPeriodNum);
            this.prmtBankAccount.setValue(null);
        }
    }

    protected void setDefaultValue() {
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        if (this.checkCurrentCompany()) {
            return this.currentCompany;
        }
        CompanyOrgUnitCollection companyColl = FMHelper.getUserOrgRangesWithRangeOfStart(null, (String)"cas_bankbalanceagjtable_01view", (boolean)false, (boolean)false, (boolean)false);
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    private boolean checkCurrentCompany() throws EASBizException, BOSException {
        if (this.currentCompany.isIsBizUnit() && !this.currentCompany.isIsOUSealUp() && !this.currentCompany.isIsAssistantOrg()) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            if (null == startPeriod) {
                return false;
            }
        } else {
            return false;
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        IPermission permission = PermissionFactory.getRemoteInstance();
        boolean hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), this.getPermissionItem());
        return hasPermission;
    }

    public Object getParam() {
        Object[] bankAccts;
        BankBalanceAdjustFilterParam param = new BankBalanceAdjustFilterParam();
        Object[] companys = null;
        companys = this.prmtCompany.isEnabledMultiSelection() ? (Object[])this.prmtCompany.getData() : new Object[]{this.prmtCompany.getData()};
        if (companys != null && companys.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int index = 0; index < companys.length; ++index) {
                CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companys[index];
                idSet.add(org.getId().toString());
            }
            param.setCompanys(idSet);
        }
        if ((bankAccts = (Object[])this.prmtBankAccount.getValue()) != null && bankAccts.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int index = 0; index < bankAccts.length; ++index) {
                if (bankAccts[index] == null) continue;
                idSet.add(((AccountBankInfo)bankAccts[index]).getId().toString());
            }
            param.setBankAcctIds(idSet);
        }
        Integer periodYear = (Integer)this.spPeriodYear.getValue();
        Integer periodNum = (Integer)this.spPeriodNum.getValue();
        param.setPeriodYear(periodYear);
        param.setPeriodNum(periodNum);
        try {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo(null, (int)periodYear, (int)periodNum, (CompanyOrgUnitInfo)this.company);
            param.setPeriodId(periodInfo.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setDestroyed(this.chkDestroyed.isSelected());
        param.setAudit(this.rdAudit.isSelected() ? param.Audit : (this.rdNoAudit.isSelected() ? param.NoAudit : param.All));
        return param;
    }

    public void clear() {
        super.clear();
        try {
            if (this.prmtCompany.getValue() == null) {
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                    CompanyOrgUnitInfo orgRang = this.getCompanyOrgUnitInfoByUserPermisson();
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)orgRang)) {
                        this.company = orgRang;
                        if (this.prmtCompany.isEnabledMultiSelection()) {
                            this.prmtCompany.setValue((Object)new Object[]{this.company});
                        } else {
                            this.prmtCompany.setValue((Object)this.company);
                        }
                    }
                } else if (this.prmtCompany.isEnabledMultiSelection()) {
                    this.prmtCompany.setValue((Object)new Object[]{ContextHelperFactory.getRemoteInstance().getCurrentCompany()});
                } else {
                    this.prmtCompany.setValue((Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
                }
            }
            PeriodHelper.initPeriodSpinner(this.company, this.spPeriodYear, this.spPeriodNum);
            this.chkDestroyed.setSelected(false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void spPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.setPeriodNum(this.company, this.spPeriodNum, (Integer)this.spPeriodYear.getValue());
    }

    @Override
    protected void chkDestroyed_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.chkDestroyed.isSelected()) {
            this.prmtBankAccount.setValue(null);
        }
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"WARNING_QUERY_Company"));
            return false;
        }
        Object[] bankAccts = (Object[])this.prmtBankAccount.getValue();
        if (bankAccts == null || bankAccts.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"331_BankBalanceAdjustmentCFilterUI"));
            SysUtil.abort();
        }
        Map<String, Integer> verifyMap = new HashMap<String, Integer>();
        verifyMap.put("beginYear", new Integer(AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear)));
        verifyMap.put("beginMonth", new Integer(AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum)));
        verifyMap.put("endYear", new Integer(AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear)));
        verifyMap.put("endMonth", new Integer(AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum)));
        try {
            verifyMap = BankBalanceAdjustmentUIFacadeFactory.getRemoteInstance().fetchDataFilterUIVerify(verifyMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum);
        try {
            String companyid = null;
            companyid = this.prmtCompany.isEnabledMultiSelection() ? ((CompanyOrgUnitInfo)((Object[])this.prmtCompany.getValue())[0]).getId().toString() : ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            this.acctTableId = CashAccountTool.getDisplayAcctTable(companyid, null, beginYear, beginMonth, endYear, endMonth);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return this.isSharedOrg();
    }

    public String getPermissionItem() {
        return "cas_bankbalanceagjtable_01view";
    }

    protected Class getParamClass() {
        return BankBalanceAdjustFilterParam.class;
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }

    public void setParam(Object vparam) {
        BankBalanceAdjustFilterParam param = (BankBalanceAdjustFilterParam)vparam;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)param.getCompanys(), CompareType.INCLUDE));
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
            if (this.prmtCompany.isEnabledMultiSelection()) {
                this.prmtCompany.setData((Object)companys.toArray());
            } else {
                this.prmtCompany.setData((Object)companys.get(0));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)param.getBankAcctIds(), CompareType.INCLUDE));
            AccountBankCollection bank = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            this.prmtBankAccount.setData((Object)bank.toArray());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.spPeriodYear.setValue((Object)param.getPeriodYear());
        this.spPeriodNum.setValue((Object)param.getPeriodNum());
        this.chkDestroyed.setSelected(param.isDestroyed());
        if (param.getAudit() == param.Audit) {
            this.rdAudit.setSelected(true);
        } else if (param.getAudit() == param.NoAudit) {
            this.rdNoAudit.setSelected(true);
        } else {
            this.rbAll.setSelected(true);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }
}

