/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class BankJournalFilterParam
implements FilterParam {
    private static final long serialVersionUID = 6893419932094201237L;
    private boolean isByDay;
    private int beginYear;
    private int endYear;
    private int beginMonth;
    private int endMonth;
    private Date fromDate;
    private Date toDate;
    private boolean isShowCancelAccount;
    private boolean isShowBeginBalance;
    private boolean isShowDayTotal;
    private boolean isShowMonthTotal;
    private boolean isShowYearTotal;
    private String acctTableId;
    private String accountBankId;
    private String companyId = null;
    private int flow = 0;

    public String getAccountBankId() {
        return this.accountBankId;
    }

    public void setAccountBankId(String accountBankId) {
        this.accountBankId = accountBankId;
    }

    public int getFlow() {
        return this.flow;
    }

    public void setFlow(int flow) {
        this.flow = flow;
    }

    public int getBeginMonth() {
        return this.beginMonth;
    }

    public void setBeginMonth(int beginMonth) {
        this.beginMonth = beginMonth;
    }

    public int getBeginYear() {
        return this.beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public int getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(int endMonth) {
        this.endMonth = endMonth;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public boolean isByDay() {
        return this.isByDay;
    }

    public void setByDay(boolean isByDay) {
        this.isByDay = isByDay;
    }

    public boolean isShowBeginBalance() {
        return this.isShowBeginBalance;
    }

    public void setShowBeginBalance(boolean isShowBeginBalance) {
        this.isShowBeginBalance = isShowBeginBalance;
    }

    public boolean isShowCancelAccount() {
        return this.isShowCancelAccount;
    }

    public void setShowCancelAccount(boolean isShowCancelAccount) {
        this.isShowCancelAccount = isShowCancelAccount;
    }

    public boolean isShowDayTotal() {
        return this.isShowDayTotal;
    }

    public void setShowDayTotal(boolean isShowDayTotal) {
        this.isShowDayTotal = isShowDayTotal;
    }

    public boolean isShowMonthTotal() {
        return this.isShowMonthTotal;
    }

    public void setShowMonthTotal(boolean isShowMonthTotal) {
        this.isShowMonthTotal = isShowMonthTotal;
    }

    public boolean isShowYearTotal() {
        return this.isShowYearTotal;
    }

    public void setShowYearTotal(boolean isShowYearTotal) {
        this.isShowYearTotal = isShowYearTotal;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2), CompareType.EQUALS));
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.companyId == null) {
            this.companyId = companyInfo.getId().toString();
        }
        if (this.flow == 2) {
            filterInfo.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)Constants.ZERO, CompareType.EQUALS));
        } else if (this.flow == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)Constants.ZERO, CompareType.EQUALS));
        }
        if (this.isByDay) {
            if (this.toDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.toDate), CompareType.LESS_EQUALS));
            }
            if (this.fromDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.fromDate), CompareType.GREATER_EQUALS));
            }
        } else {
            try {
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
                String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
                String sql = PeriodHelper.getPeriodCollSQL(periodTypeId, this.beginYear, this.beginMonth, this.endYear, this.endMonth);
                filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
}

