/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankJournalFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.AbstractBankJournalListUI;
import com.kingdee.eas.fi.cas.client.BankJournalAddBatchUI;
import com.kingdee.eas.fi.cas.client.BankJournalFilterParam;
import com.kingdee.eas.fi.cas.client.BankJournalFilterUI;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fi.cas.client.BankJournalPrintParame;
import com.kingdee.eas.fi.cas.client.BankJournalUI;
import com.kingdee.eas.fi.cas.client.BankJournalUIHelper;
import com.kingdee.eas.fi.cas.client.CasJournalQueryProcessor;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.FixRecPayJournalListUI;
import com.kingdee.eas.fi.cas.client.JournalDataProvider;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankJournalListUI
extends AbstractBankJournalListUI
implements IDelegationSupport {
    private Logger logger = Logger.getLogger((String)BankJournalListUI.class.getName());
    private BankJournalFilterUI filterUI;
    private BankJournalHandler handler = new BankJournalHandler();
    private CompanyOrgUnitInfo company = null;
    BankJournalPrintParame editParame = null;
    BankJournalFilterParam filterParma = null;
    private IPermission iPermission = PermissionFactory.getRemoteInstance();
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private static final String JOURNAL_SOURCE = "com.kingdee.eas.fi.cas.JournalResource";
    private IJournal iJournal;
    private Map paramMap;
    private boolean isSharedOrg = false;
    public static final String CASH_FILENAME = "/FI/CAS/BANKDEPOSIT";

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    public BankJournalListUI() throws Exception {
        this.editParame = BankJournalPrintParame.getInstance();
    }

    private IJournal getJournalInterface() throws BOSException {
        if (this.iJournal == null) {
            this.iJournal = JournalFactory.getRemoteInstance();
        }
        return this.iJournal;
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        if (this.company == null) {
            this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        this.preProcess();
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this.getFilterUI());
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        ActionListener[] actionListener = this.cboCurrency.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.removeActionListener(actionListener[i]);
        }
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramMap.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.cboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.cboCurrency, currencyColl, false);
        }
        if (this.company != null && this.company.getBaseCurrency() != null) {
            this.cboCurrency.setSelectedItem((Object)this.company.getBaseCurrency());
        }
        for (int i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.addActionListener(actionListener[i]);
        }
        this.tblMain.getViewManager().setFreezeView(0, 2);
        this.menuEdit.add((JMenuItem)new AbstractHidedMenuItem("shift ctrl alt F8"){

            public void action_actionPerformed() {
                BankJournalFilterParam para = (BankJournalFilterParam)BankJournalListUI.this.getFilterParam();
                Date fromDate = null;
                Date toDate = null;
                try {
                    if (para.isByDay()) {
                        fromDate = para.getFromDate();
                        toDate = para.getToDate();
                    } else {
                        PeriodInfo beginPeriod = null;
                        PeriodInfo endPeriod = null;
                        beginPeriod = PeriodHelper.getPeriodInfo(para.getBeginYear(), para.getBeginMonth(), BankJournalListUI.this.company);
                        endPeriod = PeriodHelper.getPeriodInfo(para.getEndYear(), para.getEndMonth(), BankJournalListUI.this.company);
                        fromDate = beginPeriod.getBeginDate();
                        toDate = endPeriod.getEndDate();
                    }
                    BankJournalListUI.this.getJournalInterface().reCalculateSummary(GlUtils.isCompanyUnion((CompanyOrgUnitInfo)BankJournalListUI.this.company) ? null : BankJournalListUI.this.company.getId().toString(), fromDate, toDate);
                    BankJournalListUI.this.fillData();
                }
                catch (Exception e) {
                    BankJournalListUI.this.logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.setBankAcctF7ForFinal(this.prmtBank, this.company.getId().toString());
        this.filterParma = (BankJournalFilterParam)this.getUIContext().get("filterParam");
        if (this.filterParma != null) {
            this.initViewQuery(this.filterParma);
        } else {
            super.onLoad();
        }
        String currencyId = ((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString();
        boolean flag1 = currencyId.equals(this.company.getBaseCurrency().getId().toString());
        boolean flag2 = (Boolean)this.paramMap.get("isShowLocalCurrency");
        if (!flag2 || flag1) {
            this.tblMain.getColumn("localDebit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("localCredit").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("localBalance").getStyleAttributes().setHided(true);
            boolean showLocal = ConvertUtils.BOOL(this.paramMap.get("CS003"));
            if (showLocal) {
                this.tblMain.getColumn("localDebit").getStyleAttributes().setHided(false);
                this.tblMain.getColumn("localCredit").getStyleAttributes().setHided(false);
                this.tblMain.getColumn("localBalance").getStyleAttributes().setHided(false);
            }
        }
        this.tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("localCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDMenuItemPreview.setEnabled(true);
        this.kDMenuItemPrint.setEnabled(true);
        this.actionTDPreView.setEnabled(true);
        this.actionTDPreView.setVisible(true);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrint.setVisible(true);
        this.actionFixRecPayJournal.setVisible(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemImportData.setAccelerator(KeyStroke.getKeyStroke("ctrl I"));
        this.tblMain.getColumn("createDate").getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    public void initViewQuery(BankJournalFilterParam param) throws Exception {
        this.setFilterParam(param);
        if (this.isAutoSetTitle()) {
            this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        } else {
            this.getMainStatusBar().setPerTitle(this.getTitle());
        }
        this.setIsNeedDefaultFilter(false);
        this.tblMain.checkParsed();
        CompanyOrgUnitInfo companyTmp = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        this.prmtCompany.setValue((Object)companyTmp);
        AccountBankInfo accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(this.getUIContext().get("acctBankId").toString()));
        this.prmtBank.setValue((Object)accBankInfo);
        this.prmtBank.setEnabled(false);
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.getUIContext().get("currencyId").toString()));
        this.cboCurrency.setSelectedItem((Object)currencyInfo);
        this.executeQuery(param);
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
    }

    public FilterParam getDefalutQueryParam() {
        FilterParam f = (FilterParam)this.getUIContext().get("filterParam");
        if (f != null) {
            return f;
        }
        return super.getDefalutQueryParam();
    }

    protected void checkUnion() throws EASBizException, BOSException {
        ClientUtils.checkCompanyAndPeriod((Component)((Object)this), this.paramMap);
    }

    public void setBankAcctF7ForFinal(KDBizPromptBox prmtBank, String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(this.company.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        prmtBank.setEntityViewInfo(view);
    }

    protected boolean isAutoSetTitle() {
        return false;
    }

    protected String getTitle() throws Exception {
        CompanyOrgUnitInfo curC = null;
        curC = this.paramMap.get("currentCompany") == null ? this.company : (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
            return null;
        }
        PeriodInfo curP = null;
        curP = this.paramMap.get("currentPeriod") == null ? CashClientHelper.getCurrentPeriod(curC) : (PeriodInfo)this.paramMap.get("currentPeriod");
        if (curP == null) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"PeriodTitle") + curP.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"year") + curP.getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"period");
    }

    private void preProcess() throws BOSException, EASBizException {
        this.paramMap = new HashMap();
        this.paramMap.put("isShowLocalCurrency", this.company);
        this.paramMap.put("currentCompany", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap.put("currencyCollection", null);
        this.paramMap.put("bookType", null);
        this.paramMap.put("startPeriod", null);
        this.paramMap.put("CS003", null);
        this.paramMap.put("mainQueryPK", this.mainQueryPK.getFullName());
        this.paramMap.put("uiClassName", this.getMetaDataPK().getFullName());
        this.paramMap = BankJournalFetchParamFacadeFactory.getRemoteInstance().fetchParam(this.paramMap);
        PeriodInfo startPeriod = (PeriodInfo)this.paramMap.get("startPeriod");
        PeriodInfo currentPeriod = (PeriodInfo)this.paramMap.get("currentPeriod");
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_02edit");
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        String id = null;
        if (selectBlock != null) {
            Date beginDate;
            JournalSourceEnum source;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            id = (String)row.getCell("id").getValue();
            if (row.getCell("id").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
                SysUtil.abort();
            }
            if ((source = (JournalSourceEnum)row.getCell("source").getValue()) == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"BillOrVoucherBook"));
                return;
            }
            Date date = ClientUtils.stringToDate((String)row.getCell("createDate").getValue());
            if (date.before(beginDate = CashClientHelper.getCurrentPeriod(this.company).getBeginDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)JOURNAL_SOURCE, (String)"CheckOutNoEdit"));
                return;
            }
            JournalInfo journal = this.getJournalInterface().getJournalInfo((IObjectPK)new ObjectUuidPK(id));
            if (journal.getTicketNumber() != null) {
                throw new CasException(CasException.HASVC);
            }
            if (!journal.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                throw new CasException(CasException.HASVERIFY);
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        List<String> selectValidIdList = this.getSelectValidIdList(true);
        String id = selectValidIdList.get(0);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this)).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getQueryDlg();
        if (!dialog.show()) {
            SysUtil.abort();
        }
        this.doQuery(dialog);
        FilterParam param = (FilterParam)this.getFilterUI().getParam();
        this.tblMain.checkParsed();
        this.executeQuery(param);
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_02addNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"accountBank", this.prmtBank.getValue());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        uiContext.put((Object)"company", this.prmtCompany.getData());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(BankJournalUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    @Override
    public void actionInputOne_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_02addNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"accountBank", this.prmtBank.getValue());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        uiContext.put((Object)"company", this.prmtCompany.getData());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(BankJournalUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    @Override
    public void actionInputMany_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_02addNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"accountBank", this.prmtBank.getValue());
        uiContext.put((Object)"currency", this.cboCurrency.getSelectedItem());
        uiContext.put((Object)"company", this.prmtCompany.getData());
        IUIFactory fy = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)this));
        IUIWindow wnd = fy.create(BankJournalAddBatchUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_04remove");
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        if (this.tblMain.getSelectManager().size() == 0 || this.tblMain.getSelectManager() == null) {
            return;
        }
        if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        for (i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (id == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
                    return;
                }
                JournalSourceEnum source = (JournalSourceEnum)row.getCell("source").getValue();
                if (source == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) {
                    MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"BillOrVoucherBook"));
                    return;
                }
                PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
                int currYear = currPeriodInfo.getPeriodYear();
                int currPeriodNumber = currPeriodInfo.getPeriodNumber();
                Integer year = (Integer)this.tblMain.getRow(j).getCell("periodYear").getValue();
                Integer period = (Integer)this.tblMain.getRow(j).getCell("periodNumber").getValue();
                if (year < currYear || year == currYear && period < currPeriodNumber) {
                    String stru = EASResource.getString((String)resourcePath, (String)"cm79");
                    MsgBox.showInfo((Component)((Object)this), (String)stru);
                    return;
                }
                ids.add(id);
            }
        }
        for (i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            IJournal iJournal = this.getJournalInterface();
            iJournal.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        }
        this.fillData();
        String strDeleteSuccessfully = EASResource.getString((String)resourcePath, (String)"cm44");
        MsgBox.showInfo((Component)((Object)this), (String)strDeleteSuccessfully);
    }

    public String getBillIdByBillNumber(String billNum, CompanyOrgUnitInfo curCompany, int billType) throws Exception {
        ISettlementBill iSettlementBill;
        SettlementBillCollection settlementBillCollection;
        IReceivingBill iReceivingBill;
        ReceivingBillCollection receivingBillCollection;
        Iterator iter;
        IPaymentBill iPaymentBill;
        PaymentBillCollection paymentBillCollection;
        String billId = null;
        String str = curCompany.getName();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("number", (Object)billNum));
        items.add(new FilterItemInfo("company.name", (Object)str));
        view.setFilter(filter);
        if (billType == 16 && (paymentBillCollection = (iPaymentBill = PaymentBillFactory.getRemoteInstance()).getPaymentBillCollection(view)) != null && paymentBillCollection.size() > 0 && (iter = paymentBillCollection.iterator()).hasNext()) {
            PaymentBillInfo paymentBillInfo = (PaymentBillInfo)iter.next();
            billId = paymentBillInfo.getId().toString();
        }
        if (billType == 15 && (receivingBillCollection = (iReceivingBill = ReceivingBillFactory.getRemoteInstance()).getReceivingBillCollection(view)) != null && receivingBillCollection.size() > 0 && (iter = receivingBillCollection.iterator()).hasNext()) {
            ReceivingBillInfo receivingBillInfo = (ReceivingBillInfo)iter.next();
            billId = receivingBillInfo.getId().toString();
        }
        if (billType == 17 && (settlementBillCollection = (iSettlementBill = SettlementBillFactory.getRemoteInstance()).getSettlementBillCollection(view)) != null && settlementBillCollection.size() > 0 && (iter = settlementBillCollection.iterator()).hasNext()) {
            SettlementBillInfo settlementBillInfo = (SettlementBillInfo)iter.next();
            billId = settlementBillInfo.getId().toString();
        }
        return billId;
    }

    @Override
    public void actionRegisterVoucher_actionPerformed(ActionEvent e) throws Exception {
        JournalInfo journalInfo;
        int i;
        HashSet<String> ids = new HashSet<String>();
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        for (int i2 = 0; i2 < this.tblMain.getSelectManager().size(); ++i2) {
            selectBlock = this.tblMain.getSelectManager().get(i2);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                JournalSourceEnum source;
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (id == null || (source = (JournalSourceEnum)row.getCell("source").getValue()) != JournalSourceEnum.BYBILL) continue;
                ids.add(id);
            }
        }
        if (ids.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        JournalCollection journals = this.getJournalInterface().getJournalCollection(view);
        int count = 0;
        for (i = 0; i < journals.size(); ++i) {
            Set<String> idSet;
            journalInfo = journals.get(i);
            String billId = null;
            VoucherInfo voucherInfo = null;
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            int billType = journalInfo.getBillType().getValue();
            String billNumber = journalInfo.getBillNumber();
            String[] billNumArray = null;
            billNumArray = billNumber.split(";");
            if (billNumArray.length == 1) {
                billId = journalInfo.getBillId();
                if (BillTypeEnum.settleBatch.equals((Object)journalInfo.getBillType())) {
                    idSet = SettleFacadeFactory.getRemoteInstance().getSettlementIdbySettBatchID(billId);
                    count = this.registerVoucherBatch(journalInfo, idSet, count);
                    continue;
                }
                if (billId != null && (BOSUuid.read((String)billId).getType().equals((Object)new TransUpBillEntryInfo().getBOSType()) || BOSUuid.read((String)billId).getType().equals((Object)new TransDownBillEntryInfo().getBOSType()))) {
                    billId = TransUpDownBillHelper.changeTransBillId((String)billId);
                }
                if ((voucherInfo = CashClientHelper.getVoucherInfo(null, billId)) == null || voucherInfo.getBizStatus().getValue() == 0) continue;
                journalInfo.setVoucherId(voucherInfo.getId().toString());
                journalInfo.setVoucherNumber(voucherInfo.getNumber());
                journalInfo.setVoucherType(voucherInfo.getVoucherType());
                this.setOppAccount(journalInfo, voucherInfo);
                IJournal iEntry = this.getJournalInterface();
                iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
                ++count;
                continue;
            }
            idSet = new HashSet();
            for (int j = 0; j < billNumArray.length; ++j) {
                billId = this.getBillIdByBillNumber(billNumArray[j], curCompany, billType);
                if (EmptyUtil.isEmpty((String)billId)) continue;
                idSet.add(billId);
            }
            count = this.registerVoucherBatch(journalInfo, idSet, count);
        }
        if (count == 0) {
            for (i = 0; i < journals.size(); ++i) {
                journalInfo = journals.get(i);
                if (journalInfo.getVoucherNumber() == null) continue;
                journalInfo.setVoucherId(null);
                journalInfo.setVoucherNumber(null);
                journalInfo.setVoucherType(null);
                IJournal iEntry = this.getJournalInterface();
                iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoVoucherReg"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RegisterVoucher_Success"));
        }
        this.fillData();
    }

    private int registerVoucherBatch(JournalInfo journalInfo, Set idSet, int count) throws BOSException, EASBizException {
        ArrayList<String> array = new ArrayList<String>();
        StringBuffer sb1 = new StringBuffer();
        VoucherInfo voucherInfo = null;
        String billId = "";
        List idList = FMHelper.set2List((Set)idSet);
        for (int i = 0; i < idList.size(); ++i) {
            billId = idList.get(i).toString();
            voucherInfo = CashClientHelper.getVoucherInfo(null, billId);
            if (voucherInfo == null || voucherInfo.getBizStatus().getValue() == 0 || array.contains(voucherInfo.getNumber())) continue;
            journalInfo.setVoucherType(voucherInfo.getVoucherType());
            array.add(voucherInfo.getNumber());
            sb1.append(voucherInfo.getNumber() + ";");
            ++count;
        }
        String tempString = "";
        if (sb1.length() > 0) {
            tempString = sb1.substring(0, sb1.length() - 1);
        }
        array.clear();
        journalInfo.setVoucherNumber(tempString);
        if (count > 1) {
            journalInfo.setVoucherType(null);
        }
        IJournal iEntry = this.getJournalInterface();
        iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
        return count;
    }

    private void setOppAccount(JournalInfo entryInfo, VoucherInfo voucherInfo) {
        HashMap mapDebit = new HashMap();
        HashMap mapCredit = new HashMap();
        CashHelper.analysisVoucher(voucherInfo, mapDebit, mapCredit);
        if (entryInfo.getOppAccountView() == null) {
            VoucherEntryInfo oppVoucherInfo = null;
            if (entryInfo.isIsDebit()) {
                Object[] voucherEntryCol = mapCredit.values().toArray();
                if (voucherEntryCol.length > 0) {
                    oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
                }
            } else {
                Object[] voucherEntryCol = mapDebit.values().toArray();
                if (voucherEntryCol.length > 0) {
                    oppVoucherInfo = (VoucherEntryInfo)voucherEntryCol[0];
                }
            }
            if (oppVoucherInfo != null) {
                entryInfo.setOppAccountView(oppVoucherInfo.getAccount());
            }
        }
    }

    private String getJournalResource(String resName) {
        return EASResource.getString((String)JOURNAL_SOURCE, (String)resName);
    }

    private List<String> getSelectValidIdList(boolean isSingleSelect) {
        ArrayList<String> idList = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int length = selectRows.length;
        if (length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getJournalResource("SelectValidRecord"));
            SysUtil.abort();
        }
        if (isSingleSelect && length > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getJournalResource("selectSingleRow"));
            SysUtil.abort();
        }
        for (int i = 0; i < length; ++i) {
            Object idObj = this.tblMain.getRow(selectRows[i]).getCell("id").getValue();
            if (idObj == null) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getJournalResource("SelectValidRecord"));
                SysUtil.abort();
            }
            idList.add(idObj.toString());
        }
        return idList;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        List<String> idList = this.getSelectValidIdList(true);
        String journalId = idList.get(0).toString();
        BankJournalUIHelper.showBillByJournalId((CoreUIObject)this, journalId);
    }

    protected void cboBankAccount_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo accountBank = (AccountBankInfo)this.prmtBank.getValue();
        if (accountBank == null) {
            this.tblMain.removeRows();
            return;
        }
        CurrencyInfo currency = null;
        if (accountBank.isIsByCurrency()) {
            currency = accountBank.getCurrency();
            this.cboCurrency.setEnabled(false);
        } else {
            currency = this.company.getBaseCurrency();
            this.cboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
    }

    @Override
    protected void prmtBank_dataChanged(DataChangeEvent e) throws Exception {
        BankJournalFilterParam f = (BankJournalFilterParam)this.getUIContext().get("filterParam");
        if (f != null) {
            return;
        }
        AccountBankInfo accountBank = (AccountBankInfo)this.prmtBank.getValue();
        this.InitIsCanMulUnionQuery(this.company, accountBank);
        if (accountBank == null) {
            this.tblMain.removeRows();
            return;
        }
        CurrencyInfo currency = null;
        if (accountBank.isIsByCurrency()) {
            currency = accountBank.getCurrency();
            this.cboCurrency.setEnabled(false);
        } else {
            currency = this.company.getBaseCurrency();
            this.cboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (this.filterParma != null) {
            return;
        }
        this.fillData();
    }

    @Override
    protected void prmtCashier_dataChanged(DataChangeEvent e) throws Exception {
        this.fillData();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected void execQuery() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        BankJournalFilterParam para = null;
        try {
            para = (BankJournalFilterParam)this.getFilterParam();
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(para.getCompanyId().toString()));
            para.setAcctTableId(this.getAcctTableId(para));
            CashHelper.setBankF7(this.prmtBank, this.company, para.isShowCancelAccount());
            if (para.getAccountBankId() != null) {
                AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(para.getAccountBankId()));
                this.prmtBank.setValue((Object)accountBankInfo);
            }
            this.InitIsCanMulUnionQuery(this.company, (AccountBankInfo)this.prmtBank.getValue());
            this.setCurrencyByAcctBank();
        }
        catch (Exception e1) {
            this.handleException(e1);
            SysUtil.abort((Throwable)e1);
        }
        String datePeriod = "";
        if (para.isByDay()) {
            datePeriod = Constants.FORMAT_DAY.format(para.getFromDate()) + " - " + Constants.FORMAT_DAY.format(para.getToDate());
        } else {
            Object[] args = new String[]{String.valueOf(para.getBeginYear()), String.valueOf(para.getBeginMonth()), String.valueOf(para.getEndYear()), String.valueOf(para.getEndMonth())};
            datePeriod = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
        }
        this.txtPeriod.setText(datePeriod);
        this.txtPeriod.setEditable(false);
        this.tblMain.checkParsed();
        this.prmtCompany.setValue((Object)this.company);
        if (this.prmtBank.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"266_BankStatementListUI"));
            SysUtil.abort();
        } else {
            try {
                this.fillData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setCurrencyByAcctBank() {
        AccountBankInfo acctBank = (AccountBankInfo)this.prmtBank.getValue();
        if (acctBank != null && acctBank.isIsByCurrency()) {
            int i;
            ActionListener[] actionListener = this.cboCurrency.getActionListeners();
            for (i = 0; i < actionListener.length; ++i) {
                this.cboCurrency.removeActionListener(actionListener[i]);
            }
            UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)acctBank.getCurrency());
            this.cboCurrency.setEnabled(false);
            for (i = 0; i < actionListener.length; ++i) {
                this.cboCurrency.addActionListener(actionListener[i]);
            }
        }
    }

    private String getAcctTableId(BankJournalFilterParam param) {
        if (!EmptyUtil.isEmpty((String)param.getAcctTableId())) {
            return param.getAcctTableId();
        }
        Map verifyMap = new HashMap<String, Object>();
        verifyMap.put("btnByDate", param.isByDay());
        verifyMap.put("dateFrom", param.getFromDate());
        verifyMap.put("dateTo", param.getToDate());
        if (param.isByDay()) {
            verifyMap.put("btnByPeriod", Boolean.FALSE);
        } else {
            verifyMap.put("btnByPeriod", Boolean.TRUE);
        }
        verifyMap.put("beginYear", new Integer(param.getBeginYear()));
        verifyMap.put("endYear", new Integer(param.getEndYear()));
        verifyMap.put("beginPeriod", new Integer(param.getBeginMonth()));
        verifyMap.put("endPeriod", new Integer(param.getEndMonth()));
        verifyMap.put("company", this.prmtCompany.getValue());
        try {
            verifyMap = BankJournalFetchParamFacadeFactory.getRemoteInstance().fetchParamForFilterUIVerify(verifyMap);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        String acctTableId = null;
        if (verifyMap.get("actualAcctTableId") == null) {
            if (param.isByDay()) {
                Date beginDate = param.getFromDate();
                Date endDate = param.getToDate();
                acctTableId = FMClientHelper.getActualAcctTable((Date)beginDate, (Date)endDate);
            } else {
                int beginYear = param.getBeginYear();
                int beginMonth = param.getBeginMonth();
                int endYear = param.getEndYear();
                int endMonth = param.getEndMonth();
                acctTableId = FMClientHelper.getActualAcctTable((int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
            }
        } else {
            acctTableId = (String)verifyMap.get("actualAcctTableId");
        }
        return acctTableId;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        return dialog;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new CasJournalQueryProcessor((IUIObject)this);
    }

    public void fillData() throws Exception {
        this.tblMain.getHeadMergeManager().mergeBlock(0, 25, 1, 25);
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        AccountBankInfo accountBank = (AccountBankInfo)this.prmtBank.getValue();
        if (currency == null || accountBank == null) {
            this.tblMain.removeRows();
            return;
        }
        BankJournalFilterParam para = (BankJournalFilterParam)this.getFilterParam();
        Object cashier = this.prmtCashier.getData();
        Set cashierIDSet = FMHelper.Array2Set((String[])AccessHelper.getIds((Object)cashier));
        AccountBankCollection acctBankColl = new AccountBankCollection();
        acctBankColl.add(accountBank);
        acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)para.getAcctTableId());
        accountBank = acctBankColl.get(0);
        BalanceDirectionEnum dc = null;
        AccountViewInfo account = new AccountViewInfo();
        if (accountBank.getAccount() != null) {
            try {
                account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBank.getAccount().getId().toString()));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
            this.txtAccount.setText(account.toString());
            dc = account.getDC();
        }
        Set accountBankSet = this.getSharedAcctSet(accountBank);
        Set accountSet = this.getAccountSet(accountBankSet, account, para.getAcctTableId());
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean GL_005 = ContextHelperFactory.getRemoteInstance().getBooleanParam("GL_005", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        this.handler.setGlDc(GL_005);
        IRowSet rs = this.handler.getRowset(this.mainQueryPK, this.mainQuery, currency.getId().toString(), accountBankSet, accountSet, cashierIDSet, para);
        this.tblMain.removeRows();
        this.handler.setColumnFormat(this.tblMain, currency.getId());
        String numberFtm = "%r-[ ]0.5n";
        this.tblMain.getColumn("exchange").getStyleAttributes().setNumberFormat(numberFtm);
        KDCheckBox chkBox = new KDCheckBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)chkBox);
        this.tblMain.getColumn("verify").setEditor((ICellEditor)cellEditor);
        this.paramMap.put("currentCompany", this.company);
        this.handler.fillData_New(this.tblMain, rs, currency, accountBank.getNumber(), accountBank.getId().toString(), accountBank.getAccount().getNumber(), para, CashDataSourceEnum.B, this.paramMap, cashierIDSet, dc, this.chkMulUnionQuery.isSelected());
        this.tblMain.reLayoutAndPaint();
    }

    private Set getAccountSet(Set accountBankSet, AccountViewInfo account, String acctTableId) throws BOSException {
        HashSet<String> acctSet = new HashSet<String>();
        if (this.chkMulUnionQuery.isSelected() && accountBankSet.size() > 1) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)accountBankSet, CompareType.INCLUDE));
            AccountBankCollection acctBankColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)acctTableId);
            for (int index = 0; index < acctBankColl.size(); ++index) {
                acctSet.add(acctBankColl.get(index).getAccount().getId().toString());
            }
        } else {
            acctSet.add(account.getId().toString());
        }
        return acctSet;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return this.getJournalInterface();
    }

    @Override
    protected String getEditUIName() {
        return BankJournalUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionInputOne.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.actionInputMany.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copyline"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionTDPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionRegisterVoucher.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionFixRecPayJournal.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.actionMergeByBatchNo.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_merge"));
        this.actionSplitByBatchNo.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_split"));
        int bookType = -1;
        if (this.paramMap.get("bookType") == null) {
            String companyId = this.company.getId().toString();
            try {
                bookType = CashHelper.getBookType(companyId);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        } else {
            bookType = (Integer)this.paramMap.get("bookType");
        }
        this.actionImportData.setVisible(true);
        this.actionFixRecPayJournal.setVisible(false);
        this.actionInputOne.setVisible(true);
        this.actionInputOne.setEnabled(true);
        this.actionAddNew.setEnabled(true);
        this.actionInputMany.setVisible(true);
        this.actionRemove.setVisible(true);
        this.actionEdit.setVisible(true);
        this.actionViewDetail.setVisible(true);
        if (bookType == 0) {
            this.actionRegisterVoucher.setEnabled(true);
            this.actionRegisterVoucher.setVisible(true);
        } else {
            this.actionRegisterVoucher.setEnabled(false);
            this.actionRegisterVoucher.setVisible(false);
        }
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionRegisterVoucher.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.actionCalculator.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankJournalFilterUI(this.paramMap);
        }
        return this.filterUI;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    protected ArrayList getEmportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fi.cas.BankJournal";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"258_BankJournalListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.BankJournalPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBank);
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        JournalDataProvider data = null;
        data = new JournalDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionTDPreView_actionPerformed(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBank);
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        JournalDataProvider data = null;
        data = new JournalDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        this.actionRefresh_actionPerformed(e);
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() throws Exception {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        UserDefineColumnInfo info = null;
        AccountBankInfo accountbank = null;
        String BankAccountNumber = "";
        String acccountbankNumber = "";
        if (this.prmtBank.getValue() != null) {
            accountbank = (AccountBankInfo)this.prmtBank.getValue();
            BankAccountNumber = accountbank.getBankAccountNumber();
            acccountbankNumber = accountbank.getNumber();
        }
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription(this.kDLabelContainer1.getBoundLabelText() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"40_AntiRepeatSettingControllerBean"));
        info.setAlias(this.kDLabelContainer1.getBoundLabelText() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"40_AntiRepeatSettingControllerBean"));
        info.setColumnValue(this.prmtBank.getValue().toString());
        udcc.add((Object)info);
        if (accountbank.getBank() != null) {
            BankInfo bankInfo = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getBank().getId().toString()));
            info = new UserDefineColumnInfo();
            info.setName("bankInfo");
            info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"332_BankJournalListUI"));
            info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"332_BankJournalListUI"));
            info.setColumnValue(bankInfo.getName());
            udcc.add((Object)info);
        }
        info = new UserDefineColumnInfo();
        info.setName("BankAccountNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"11_AgentPayBillControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"11_AgentPayBillControllerBean"));
        info.setColumnValue(BankAccountNumber);
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("acccountbankNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"261_QingCapitalSumFacadeControllerBean"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"261_QingCapitalSumFacadeControllerBean"));
        info.setColumnValue(acccountbankNumber);
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(this.kDLabelContainer4.getBoundLabelText());
        info.setAlias(this.kDLabelContainer4.getBoundLabelText());
        info.setColumnValue(this.cboCurrency.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription(this.kDLabelContainer2.getBoundLabelText());
        info.setAlias(this.kDLabelContainer2.getBoundLabelText());
        info.setColumnValue(this.txtAccount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("intTerm");
        info.setDescription(this.kDLabelPeriod.getBoundLabelText());
        info.setAlias(this.kDLabelPeriod.getBoundLabelText());
        info.setColumnValue(this.txtPeriod.getText());
        udcc.add((Object)info);
        Date fromDate = null;
        Timestamp toDate = null;
        BankJournalFilterParam para = (BankJournalFilterParam)this.getFilterParam();
        PeriodInfo beginPeriod = null;
        PeriodInfo endPeriod = null;
        beginPeriod = PeriodHelper.getPeriodInfo(para.getBeginYear(), para.getBeginMonth(), this.company);
        endPeriod = PeriodHelper.getPeriodInfo(para.getEndYear(), para.getEndMonth(), this.company);
        fromDate = beginPeriod.getBeginDate();
        toDate = endPeriod.getEndDate();
        info = new UserDefineColumnInfo();
        info.setName("startPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setColumnValue(fromDate.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("endPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setColumnValue(((Date)toDate).toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("company");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance"));
        info.setColumnValue(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getName());
        udcc.add((Object)info);
        return udcc;
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        CalculatorDialog calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        calc.setInitValue(null);
        calc.showDialog(2, true);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String companyString = EASResource.getString((String)resourcePath, (String)"TblCol_Company") + "\uff1a&[Company]";
        String periodRangeString = EASResource.getString((String)resourcePath, (String)"cm25") + "\uff1a&[PeriodRange]";
        String accountString = EASResource.getString((String)resourcePath, (String)"BankAccount") + "\uff1a&[BankAccount]";
        String currencyString = EASResource.getString((String)resourcePath, (String)"Currency") + "\uff1a&[Currency]";
        String headString = companyString + "&|" + periodRangeString;
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(headString, sb);
        headString = accountString + "&|" + currencyString;
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", this.company.getName());
        AccountBankInfo accountBank = (AccountBankInfo)this.prmtBank.getValue();
        map.put("BankAccount", accountBank + "");
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        map.put("Currency", currency + "");
        map.put("accountView", this.txtAccount.getText());
        Object periodString = null;
        map.put("PeriodRange", this.txtPeriod.getText());
        return map;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"createDate", "bizDate", "voucherType", "voucherNumber", "oppAccountNumber", "billType", "billNumber", "description", "settType", "settNumber", "debit", "credit", "balance", "cash", "oppUnit", "oppAcctNumber", "oppBank"};
        return locateNames;
    }

    public void actionMenuItemPrintParame_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"editParame", (Object)this.editParame);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.BankJournalPrintParameUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionChangeSource_actionPerformed(ActionEvent e) throws Exception {
        super.actionChangeSource_actionPerformed(e);
        if (this.tblMain.getSelectManager().size() == 0 || this.tblMain.getSelectManager() == null) {
            return;
        }
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (id == null) continue;
                IJournal iJournal = this.getJournalInterface();
                JournalInfo info = (JournalInfo)iJournal.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                JournalSourceEnum source = info.getSource();
                if (source == JournalSourceEnum.BYBILL) {
                    info.setSource(JournalSourceEnum.BYVOUCHER);
                } else if (source == JournalSourceEnum.BYVOUCHER) {
                    info.setSource(JournalSourceEnum.BYHAND);
                } else {
                    info.setSource(JournalSourceEnum.BYBILL);
                }
                iJournal.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), info);
            }
        }
        this.fillData();
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0, true);
        }
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fi.cas.BankJournal";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"258_BankJournalListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected void applyPreference() {
        super.applyPreference();
        boolean tblMove = this.tblMain.isColumnMoveable();
        this.tblMain.setColumnMoveable(true);
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("debit"), this.tblMain.getColumnIndex("localDebit"));
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("credit"), this.tblMain.getColumnIndex("localCredit"));
        this.tblMain.moveColumn(this.tblMain.getColumnIndex("balance"), this.tblMain.getColumnIndex("localBalance"));
        this.tblMain.setColumnMoveable(tblMove);
        this.handler.setLocalColumnHide(this.tblMain);
    }

    @Override
    public void actionFixRecPayJournal_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FixRecPayJournalListUI.class.getName(), (Map)uiContext, null, null);
        uiWindow.show();
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        FMFilterBaseUI multiOrgSupport = null;
        try {
            multiOrgSupport = this.getFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            e.printStackTrace();
        }
        return multiOrgSupport;
    }

    @Override
    protected void chkMulUnionQuery_itemStateChanged(ItemEvent e) throws Exception {
        boolean isMulUnionQuery = this.chkMulUnionQuery.isSelected();
        this.actionInputOne.setEnabled(!isMulUnionQuery);
        this.actionInputMany.setEnabled(!isMulUnionQuery);
        this.actionEdit.setEnabled(!isMulUnionQuery);
        this.actionRemove.setEnabled(!isMulUnionQuery);
        this.actionLocate.setEnabled(!isMulUnionQuery);
        this.actionRegisterVoucher.setEnabled(!isMulUnionQuery);
        this.actionImportData.setEnabled(!isMulUnionQuery);
        this.actionRefresh_actionPerformed(this.actionRefresh.getActionEvent());
    }

    protected void InitIsCanMulUnionQuery(CompanyOrgUnitInfo company, AccountBankInfo accountBank) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)company) || EmptyUtil.isEmpty((CoreBaseInfo)accountBank) || 0 == accountBank.getShareType().getValue()) {
            this.chkMulUnionQuery.setSelected(false);
            this.chkMulUnionQuery.setEnabled(false);
        } else {
            String bankAcctId = accountBank.getId().toString();
            String companyId = company.getId().toString();
            StringBuffer sSQL = new StringBuffer();
            sSQL.append("Select ShareAcct.Fid FROM T_BD_SharedAcct AS ShareAcct LEFT JOIN T_BD_SharedAcctEntries AS entry");
            sSQL.append(" ON ShareAcct.FID = entry.FParentID");
            sSQL.append(" Where (ShareAcct.FbankAccountid = '" + bankAcctId + "' or entry.FAccountBankid = '" + bankAcctId + "')");
            sSQL.append(" and FShareBalanceOfAcctCompanyid = '" + companyId + "'");
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sSQL.toString());
            IRowSet rs = exec.executeSQL();
            try {
                if (rs.next()) {
                    this.chkMulUnionQuery.setEnabled(true);
                } else {
                    this.chkMulUnionQuery.setSelected(false);
                    this.chkMulUnionQuery.setEnabled(false);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private Set getSharedAcctSet(AccountBankInfo accountBank) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (this.chkMulUnionQuery.isSelected()) {
            String id;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            if (2 == accountBank.getShareType().getValue()) {
                id = accountBank.getShareAcct().getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
            } else if (1 == accountBank.getShareType().getValue()) {
                id = accountBank.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)id));
            }
            SharedAcctCollection colls = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
            idSet.add(colls.get(0).getBankAccount().getId().toString());
            for (int index = 0; index < colls.get(0).getEntries().size(); ++index) {
                SharedAcctEntriesInfo info = colls.get(0).getEntries().get(index);
                if (info == null || info.getAccountBank() == null) continue;
                idSet.add(info.getAccountBank().getId().toString());
            }
        } else {
            idSet.add(accountBank.getId().toString());
        }
        return idSet;
    }

    private JournalCollection getJournalColls(IJournal iJournal, List<String> idList, FilterInfo filterInfo) throws BOSException {
        HashSet<String> selectIdSet = new HashSet<String>(idList);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("batchNo");
        selectors.add("voucherId");
        selectors.add("verifyStatus");
        selectors.add("source");
        selectors.add("createDate");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", selectIdSet, CompareType.INCLUDE));
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            filter.mergeFilter(filterInfo, "AND");
        }
        view.setFilter(filter);
        view.setSelector(selectors);
        return iJournal.getJournalCollection(view);
    }

    private List<String> getValidBillIds() {
        ArrayList<String> idList = new ArrayList<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            Object idObj = this.tblMain.getRow(i).getCell("id").getValue();
            if (idObj == null) continue;
            idList.add(idObj.toString());
        }
        if (idList.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)this.getJournalResource("hasNotValidData"));
            SysUtil.abort();
        }
        if (idList.size() == 1) {
            SysUtil.abort();
        }
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionMergeByBatchNo_actionPerformed(ActionEvent e) throws Exception {
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        List<String> idList = this.getValidBillIds();
        try {
            MutexUtils.requestMutex((CoreUI)this, idList);
            IJournal iJournal = this.getJournalInterface();
            FilterInfo filter = new FilterInfo();
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
            filter.getFilterItems().add(new FilterItemInfo("batchNo", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("verifyStatus", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)currentPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            JournalCollection collection = this.getJournalColls(iJournal, idList, filter);
            int length = collection.size();
            if (length == 0) {
                MsgBox.showError((Component)((Object)this), (String)this.getJournalResource("hasNotValidData"));
                ThreadPool.destroyPorgressDialog();
                return;
            }
            if (length == 1) {
                return;
            }
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < length; ++i) {
                idSet.add(collection.get(i).getId().toString());
            }
            iJournal.mergeByBatchNo(idSet);
            this.refreshList();
        }
        finally {
            MutexUtils.releaseMutex(idList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSplitByBatchNo_actionPerformed(ActionEvent e) throws Exception {
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        List<String> idList = this.getSelectValidIdList(false);
        try {
            MutexUtils.requestMutex((CoreUI)this, idList);
            IJournal iJournal = this.getJournalInterface();
            JournalCollection collection = this.getJournalColls(iJournal, idList, null);
            HashSet<String> idSet = new HashSet<String>();
            String error = null;
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
            int length = collection.size();
            for (int i = 0; i < length; ++i) {
                JournalInfo info = collection.get(i);
                String billId = info.getId().toString();
                if (info.getCreateDate().before(currentPeriod.getBeginDate()) || !VerifyScopeEnum.NOVA.equals((Object)info.getVerifyStatus()) || !iJournal.isMergedByBatchNo(billId)) {
                    error = this.getJournalResource("checkSplitByBatchNo");
                    break;
                }
                String batchNo = info.getBatchNo();
                if (batchNo == null) {
                    error = this.getJournalResource("checkBatchNoNotEmpty");
                    break;
                }
                idSet.add(billId);
            }
            if (error != null) {
                MsgBox.showError((Component)((Object)this), error);
                ThreadPool.destroyPorgressDialog();
                return;
            }
            if (idSet.size() > 0) {
                iJournal.splitByBatchNo(idSet);
                this.refreshList();
            }
        }
        finally {
            MutexUtils.releaseMutex(idList);
        }
    }
}

