/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.IRowSetAddBf;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankJournalRowSetAddBf
implements IRowSetAddBf {
    private static Logger logger = Logger.getLogger((String)BankJournalRowSetAddBf.class.getName());
    private static final String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";
    protected static final String resourcePath1 = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private static final String GUO_CHI_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.overHypoPage");
    private static final String CHENG_QIAN_YE = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.TaoDaResource.bearForwardPage");
    protected static final String BEN_RI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"DayTotal");
    protected static final String BEN_NIAN_LEI_JI = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"YearTotal");
    protected static final String BEN_QI_HE_JI = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"MonthTotal");
    protected static final String RI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart");
    protected static final String YEAR_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"YearBalance");
    protected static final String QI_CHU_YU_E = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"BeginBalance");
    private BigDecimal bfDebtSum = FMConstants.ZERO;
    private BigDecimal bfCredSum = FMConstants.ZERO;
    private String bfBel = "";
    private String dc = "";
    private String curDate = "";
    private PeriodInfo lastPeriod = null;

    @Override
    public IRowSet addBf(IRowSet rowSet, int rowLineCount) {
        try {
            if (rowSet.size() <= rowLineCount) {
                return rowSet;
            }
            rowSet.beforeFirst();
            while (rowSet.getRow() < rowLineCount - 1) {
                rowSet.next();
                this.calculate(rowSet);
            }
            this.insertBfRow(rowSet, GUO_CHI_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
            while (!rowSet.isLast()) {
                if (rowSet.getRow() % rowLineCount == 0) {
                    this.insertBfRow(rowSet, CHENG_QIAN_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
                    this.clearValues();
                    continue;
                }
                rowSet.next();
                this.calculate(rowSet);
                if (rowSet.getRow() % rowLineCount != rowLineCount - 1) continue;
                this.insertBfRow(rowSet, GUO_CHI_YE, this.bfDebtSum, this.bfCredSum, this.bfBel, this.dc);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
        return rowSet;
    }

    private void clearValues() {
        this.bfDebtSum = FMConstants.ZERO;
        this.bfCredSum = FMConstants.ZERO;
        this.bfBel = "";
        this.dc = "";
    }

    private void distinguish(IRowSet rowSet) throws SQLException {
        String desc = rowSet.getString("description");
        if (!FMHelper.isEmpty((String)desc) && (desc.equals(BEN_RI_HE_JI) || desc.equals(BEN_QI_HE_JI) || desc.equals(BEN_NIAN_LEI_JI))) {
            try {
                this.bfDebtSum = FMHelper.parseBigDecimal((String)rowSet.getString("debit"));
            }
            catch (NullPointerException e) {
                this.bfDebtSum = FMConstants.ZERO;
            }
            try {
                this.bfCredSum = FMHelper.parseBigDecimal((String)rowSet.getString("credit"));
            }
            catch (NullPointerException e) {
                this.bfCredSum = FMConstants.ZERO;
            }
        } else if (!FMHelper.isEmpty((String)desc) && (desc.equals(QI_CHU_YU_E) || desc.equals(RI_CHU_YU_E))) {
            this.bfDebtSum = FMConstants.ZERO;
            this.bfCredSum = FMConstants.ZERO;
        }
    }

    private void calculate(IRowSet rowSet) throws SQLException, EASBizException, BOSException {
        String desc = rowSet.getString("description");
        String createDate = rowSet.getString("createDate");
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (createDate != null) {
            Date currentDate = DateHelper.stringToDate((String)createDate);
            PeriodInfo curPeriod = PeriodHelper.getPeriodInfo(currentDate, curCompany);
            if (this.lastPeriod == null || !this.lastPeriod.equals((Object)curPeriod)) {
                this.clearValues();
                this.curDate = createDate;
                this.lastPeriod = curPeriod;
            }
        }
        if (FMHelper.isEmpty((String)desc) || !desc.equals(QI_CHU_YU_E) && !desc.equals(RI_CHU_YU_E) && !desc.equals(BEN_RI_HE_JI) && !desc.equals(BEN_QI_HE_JI) && !desc.equals(BEN_NIAN_LEI_JI)) {
            if (rowSet.getString("debit") != null) {
                this.bfDebtSum = this.bfDebtSum.add(FMHelper.parseBigDecimal((String)rowSet.getString("debit")));
            }
            if (rowSet.getString("credit") != null) {
                this.bfCredSum = this.bfCredSum.add(FMHelper.parseBigDecimal((String)rowSet.getString("credit")));
            }
            this.bfBel = rowSet.getString("balance") == null ? "" : rowSet.getString("balance");
            this.dc = rowSet.getString("dc") == null ? "" : rowSet.getString("dc");
        }
    }

    private void insertBfRow(IRowSet rowSet, String desc, BigDecimal bfDebtSum, BigDecimal bfcredSum, String bfcredBel, String dc) throws SQLException {
        int rowNum = rowSet.getRow();
        rowSet.moveToInsertRow();
        Set notNullColumn = FMHelper.Array2Set((String[])new String[]{"balance", "localBalance", "description", "debit", "localDebit", "credit", "localCredit", "dc"});
        ResultSetMetaData metaData = rowSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            String columnName = metaData.getColumnName(i);
            if (notNullColumn.contains(columnName)) continue;
            rowSet.updateString(i, "");
        }
        rowSet.updateString("createDate", null);
        rowSet.updateString("description", desc);
        rowSet.updateString("debit", bfDebtSum.toString());
        rowSet.updateString("localDebit", bfDebtSum.toString());
        rowSet.updateString("credit", bfcredSum.toString());
        rowSet.updateString("localCredit", bfcredSum.toString());
        rowSet.updateString("dc", dc);
        rowSet.updateString("balance", bfcredBel);
        rowSet.updateString("localBalance", bfcredBel);
        rowSet.insertRow();
        rowSet.beforeFirst();
        rowSet.absolute(rowNum + 1);
    }
}

