/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractBankJournalUI;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.JournalDataProvider;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class BankJournalUI
extends AbstractBankJournalUI
implements IMultiOrgSupport {
    private IContextHelper context = ContextHelperFactory.getRemoteInstance();
    private CompanyOrgUnitInfo company = null;
    private DefaultF7ContextManager F7ContextManager = null;
    private BankJournalHandler handler = new BankJournalHandler();
    private boolean isLoading = true;
    private static final String casResourcePath = "com.kingdee.eas.fi.cas.CasResource";
    public static final String BANKDEPOSIT_FILENAME = "/FI/CAS/BANKDEPOSIT";

    protected void initDataStatus() {
        super.initDataStatus();
    }

    public static void showWindow(IUIObject ui, String id) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankJournalUI.class.getName(), (Map)uiContext, null, "VIEW");
        uiWindow.show();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            try {
                CashHelper.initCombCurrency(this.comboCurrency, false, this.editData.getCompany());
                this.handler.initCombAccountBank(this.comboBankAcct, this.editData.getCompany());
                this.handler.initComboVoucherType(this.comboVoucherType, this.editData.getCompany());
                this.handler.initComboSettlementType(this.comboSettleType);
                this.handler.initComboBillType(this.comboBillType, true);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.handler.setSelectObject(this.comboBankAcct, this.editData.getAccountBank());
        this.handler.setSelectObject(this.comboCurrency, this.editData.getCurrency());
        this.handler.setSelectObject(this.comboBillType, (Object)this.editData.getBillType());
        this.handler.setSelectObject(this.comboVoucherType, this.editData.getVoucherType());
        this.handler.setSelectObject(this.comboSettleType, this.editData.getSettlementType());
        if (this.editData.getPeriod() != null) {
            this.txtPeriod.setText(this.editData.getPeriod().toString());
            String[] args = new String[]{String.valueOf(this.editData.getPeriod().getPeriodYear()), String.valueOf(this.editData.getPeriod().getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
            this.prmtCompany.setValue((Object)this.editData.getCompany());
        }
        this.f7Description.setValue((Object)this.editData.getDescription());
        if (this.txtDebitAmount.getBigDecimalValue() != null && this.txtDebitAmount.getBigDecimalValue().compareTo(SysConstant.BIGZERO) == 0) {
            this.txtDebitAmount.setValue(null);
        }
        if (this.txtCreditAmount.getBigDecimalValue() != null && this.txtCreditAmount.getBigDecimalValue().compareTo(SysConstant.BIGZERO) == 0) {
            this.txtCreditAmount.setValue(null);
        }
        this.isLoading = false;
        if (this.editData.getAccountView() != null) {
            this.txtAcct.setText(this.editData.getAccountView().getNumber() + "-" + this.editData.getAccountView().getName());
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            try {
                this.initControl();
                this.handler.setSelectObject(this.comboBankAcct, this.editData.getAccountBank());
                this.comboSettleType.setSelectedIndex(0);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.comboBillType.getSelectedItem() != null) {
            this.editData.setBillType((BillTypeEnum)((Object)this.comboBillType.getSelectedItem()));
        } else {
            this.editData.setNull("billType");
        }
        if (this.editData.getDebitAmount() != null && this.editData.getDebitAmount().compareTo(FMConstants.ZERO) > 0) {
            this.editData.setIsDebit(true);
        } else {
            this.editData.setIsDebit(false);
        }
        AccountBankInfo bankAcct = this.editData.getAccountBank();
        if (bankAcct != null) {
            this.editData.setAccountView(bankAcct.getAccount());
        }
    }

    @Override
    protected void pkCreateDate_dataChanged(DataChangeEvent e) throws Exception {
        Date oldDate = (Date)e.getOldValue();
        Date newDate = (Date)e.getNewValue();
        if (DateTimeUtils.truncateDate((Date)oldDate).getTime() == DateTimeUtils.truncateDate((Date)newDate).getTime()) {
            return;
        }
        Date beginDate = CashClientHelper.getCurrentPeriod(this.company == null ? this.editData.getCompany() : this.company).getBeginDate();
        if (!this.isLoading && ((Date)e.getNewValue()).before(beginDate)) {
            this.pkCreateDate.setValue((Object)beginDate);
        } else {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)((Date)e.getNewValue()), (CompanyOrgUnitInfo)(this.company == null ? this.editData.getCompany() : this.company));
            if (period == null) {
                this.txtPeriod.setText(null);
                this.editData.setPeriod(null);
                return;
            }
            String[] args = new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
            this.editData.setPeriod(period);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(true);
        AccountBankInfo newAccountBankInfo = null;
        AccountBankInfo accountBankInfo = null;
        CurrencyInfo localCurrency = null;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            accountBankInfo = (AccountBankInfo)this.getUIContext().get("accountBank");
            if (accountBankInfo != null) {
                IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
                newAccountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()));
            }
            localCurrency = this.context.getCompanyBaseCurrency(this.company);
            PeriodInfo period = CashClientHelper.getCurrentPeriod(this.company);
            if (date.before(period.getBeginDate())) {
                date = period.getBeginDate();
            }
            if (date.after(period.getEndDate())) {
                date = period.getEndDate();
            }
            journal.setBizDate(DateTimeUtils.truncateDate((Date)date));
            journal.setCreateDate(date);
            journal.setPeriod(period);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        journal.setCashier(user);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setType(JournalTypeEnum.BANK);
        journal.setCompany(this.company);
        journal.setAccountBank(accountBankInfo);
        if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
            journal.setCurrency(newAccountBankInfo.getCurrency());
            this.comboCurrency.setEnabled(false);
        } else {
            journal.setCurrency(localCurrency);
        }
        return journal;
    }

    public void onLoad() throws Exception {
        this.company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        super.onLoad();
        if (this.company == null) {
            this.company = this.editData.getCompany();
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.initViewControl();
            AccountBankInfo accountBank = (AccountBankInfo)this.getUIContext().get("accountBank");
            if (!accountBank.isIsClosed()) {
                for (int i = 0; i < this.comboBankAcct.getItemCount(); ++i) {
                    AccountBankInfo acct = (AccountBankInfo)this.comboBankAcct.getItemAt(i);
                    if (!acct.getId().equals((Object)accountBank.getId())) continue;
                    this.comboBankAcct.setSelectedIndex(i);
                    break;
                }
            } else if (this.comboBankAcct.getItemCount() > 0) {
                this.comboBankAcct.setSelectedItem(this.comboBankAcct.getItemAt(0));
            }
        }
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        if (this.oprtState.equals(OprtState.EDIT)) {
            AccountBankInfo accountBankInfo = this.editData.getAccountBank();
            AccountBankInfo newAccountBankInfo = null;
            if (accountBankInfo != null) {
                IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
                newAccountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()));
            }
            if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
                this.comboCurrency.setEnabled(false);
            }
            this.prmtCompany.setEnabled(false);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.pkCreateDate.setSupportedEmpty(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void initViewControl() throws EASBizException, BOSException {
        this.prmtCompany.setValue((Object)this.company);
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState()) && !OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.company);
        }
        this.initControl();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.handler.initF7Acct((IUIObject)this, this.f7OpAccount, this.company, currency);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankbook_02addNew");
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.cas.BankJournalTDQuery");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.notePrint(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.notePrint(false);
    }

    private void notePrint(boolean isprint) {
        ArrayList<String> idList = new ArrayList<String>();
        if (EmptyUtil.isEmpty((Object)this.editData.getId())) {
            String id = (String)this.getUIContext().get("ID");
            idList.add(id);
        } else {
            idList.add(this.editData.getId().toString());
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        JournalDataProvider data = new JournalDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isprint) {
            appHlp.print(BANKDEPOSIT_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(BANKDEPOSIT_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    private void initControl() throws EASBizException, BOSException {
        this.txtDebitAmount.setSupportedEmpty(true);
        this.txtDebitAmount.setHorizontalAlignment(4);
        this.txtCreditAmount.setSupportedEmpty(true);
        this.txtCreditAmount.setHorizontalAlignment(4);
        this.txtDebitAmount.setRemoveingZeroInDispaly(false);
        this.txtCreditAmount.setRemoveingZeroInDispaly(false);
        this.txtDebitAmount.setCommitsOnValidEdit(true);
        this.txtCreditAmount.setCommitsOnValidEdit(true);
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            block5: {
                try {
                    CashHelper.initCombCurrency(this.comboCurrency, false, this.company);
                }
                catch (Exception e) {
                    if (e.getCause() == null || !(e.getCause() instanceof PermissionServiceException)) break block5;
                    IPermItem iPermItem = PermItemFactory.getRemoteInstance();
                    PermissionItemInfo permissionItemInfo = iPermItem.getPermissionItemInfo("bd_assistant_currency_view");
                    Object[] object = new Object[]{permissionItemInfo.getAlias()};
                    throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, object);
                }
            }
            this.handler.initCombAccountBank(this.comboBankAcct, this.company);
            this.handler.initComboVoucherType(this.comboVoucherType, this.company);
            this.handler.initComboSettlementType(this.comboSettleType);
            this.handler.initComboBillType(this.comboBillType, true);
        }
        this.menuView.setVisible(false);
        this.menuEdit.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(true);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionPrintPreview.setVisible(true);
        this.actionCopy.setVisible(false);
        this.actionSave.setVisible(false);
        this.f7Description.setEditable(true);
        this.f7Description.setMaxLength(255);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        ExtendParser descEP = new ExtendParser(this.f7Description);
        this.f7Description.setCommitParser((IParser)descEP);
        this.txtBillNumber.setMaxLength(250);
        this.txtPeriod.setMaxLength(50);
        this.txtSettleNumber.setMaxLength(50);
        this.txtVoucherNumber.setMaxLength(50);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionAddNew.setEnabled(false);
        } else {
            this.actionPrint.setVisible(false);
            this.actionPrintPreview.setVisible(false);
        }
    }

    protected void initWorkButton() {
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        super.initWorkButton();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    @Override
    protected void comboBankAcct_actionPerformed(ActionEvent e) throws Exception {
        AccountBankInfo bankAcct = (AccountBankInfo)this.comboBankAcct.getSelectedItem();
        if (bankAcct == null) {
            return;
        }
        AccountBankInfo newAccountBankInfo = null;
        CurrencyInfo localCurrency = null;
        if (bankAcct != null) {
            IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
            newAccountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcct.getId()));
        }
        localCurrency = this.context.getCompanyBaseCurrency(this.company);
        if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)newAccountBankInfo.getCurrency());
            this.comboCurrency.setEnabled(false);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)localCurrency);
            this.comboCurrency.setEnabled(true);
        }
        if (bankAcct.getAccount() == null || bankAcct.getAccount().getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"261_BankJournalUI"));
            SysUtil.abort();
        }
        AccountViewInfo acct = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankAcct.getAccount().getId()));
        this.txtAcct.setText(acct.getNumber() + "-" + acct.getName());
        super.comboBankAcct_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object[] objects;
        String msg;
        int result;
        AccountBankInfo bankInfo;
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_BankJournalAddBatchUI"));
            SysUtil.abort();
        }
        if (null != this.comboBankAcct.getSelectedItem() && (bankInfo = (AccountBankInfo)this.comboBankAcct.getSelectedItem()).isIsClosed()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"434_BankJournalAddBatchUI"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        PeriodInfo curPeriod = CashClientHelper.getCurrentPeriod(company);
        String currentYear = String.valueOf(curPeriod.getPeriodYear());
        String currentMonth = String.valueOf(curPeriod.getNumber()).substring(4);
        boolean isPeriod = CashHelper.isDatePeriod(this.editData.getBizDate(), curPeriod, company);
        if (!isPeriod && (result = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(msg = EASResource.getString((String)casResourcePath, (String)"oneBizDateNotPeriod"), objects = new Object[]{DateFormat.getDateInstance().format(this.editData.getBizDate()), currentYear, currentMonth}))) == 2) {
            SysUtil.abort();
        }
        this.handler.verifyJournal((CoreUIObject)this, this.editData, curPeriod);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        if (this.company != null) {
            this.handler.initF7Acct((IUIObject)this, this.f7OpAccount, this.company, currency);
        }
        this.txtDebitAmount.setPrecision(currency.getPrecision());
        this.txtCreditAmount.setPrecision(currency.getPrecision());
        super.comboCurrency_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("voucherType.*"));
        sic.add(new SelectorItemInfo("ticketType.name"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("accountView.*"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    @Override
    protected void f7Description_dataChanged(DataChangeEvent e) throws Exception {
        super.f7Description_dataChanged(e);
        if (this.f7Description.getValue() == null) {
            return;
        }
        String description = this.f7Description.getValue().toString();
        this.editData.setDescription(description);
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal result;
        KDFormattedTextField txt = null;
        if (this.txtDebitAmount.hasFocus()) {
            txt = this.txtDebitAmount;
        }
        if (this.txtCreditAmount.hasFocus()) {
            txt = this.txtCreditAmount;
        }
        CalculatorDialog calc = new CalculatorDialog((Container)((Object)this));
        if (txt != null) {
            calc.setInitValue(txt.getBigDecimalValue());
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = 2;
        if (currency != null) {
            pre = currency.getPrecision();
        }
        if ((result = calc.showDialog(pre, true)) == null) {
            return;
        }
        if (result != null && txt != null) {
            txt.setValue((Object)result);
        }
    }

    @Override
    protected void txtCreditAmount_focusLost(FocusEvent e) throws Exception {
        BigDecimal amount = this.txtCreditAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtCreditAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtDebitAmount.setValue(null);
        } else {
            this.txtCreditAmount.setValue(null);
        }
        super.txtCreditAmount_focusLost(e);
    }

    @Override
    protected void txtDebitAmount_focusLost(FocusEvent e) throws Exception {
        BigDecimal amount = this.txtDebitAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtDebitAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtCreditAmount.setValue(null);
        } else {
            this.txtDebitAmount.setValue(null);
        }
        super.txtDebitAmount_focusLost(e);
    }

    @Override
    protected void txtCreditAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtCreditAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtCreditAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtDebitAmount.setValue(null);
        }
        super.txtCreditAmount_dataChanged(e);
    }

    @Override
    protected void txtDebitAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtDebitAmount.getBigDecimalValue();
        if (amount == null) {
            return;
        }
        if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            this.txtDebitAmount.setValue(null);
        }
        if (amount.compareTo(FMConstants.ZERO) != 0) {
            this.txtCreditAmount.setValue(null);
        }
        super.txtDebitAmount_dataChanged(e);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (chgVo == null || !chgVo.isDiffrent()) {
            return;
        }
        if (chgVo.getNewOrg() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_BankJournalAddBatchUI"));
            SysUtil.abort();
        }
        PeriodInfo startPeriod = null;
        PeriodInfo currentPeriod = null;
        try {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)chgVo.getNewOrg()));
            currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)chgVo.getNewOrg()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (null == startPeriod) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"435_BankJournalAddBatchUI"));
            this.prmtCompany.setValue(chgVo.getOldOrg());
            return;
        }
        Context mainContext = this.orgContextManager.getMainOrgContext();
        this.context = ContextHelperFactory.getRemoteInstanceWithContext((Context)mainContext);
        this.company = this.context.getCurrentCompany();
        this.editData.setCompany(this.company);
        try {
            this.initViewControl();
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.pkCreateDate.setValue((Object)this.editData.getCreateDate());
            this.pkBizDate.setValue((Object)this.editData.getBizDate());
            String[] args = new String[]{String.valueOf(currentPeriod.getPeriodYear()), String.valueOf(currentPeriod.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
        }
    }

    public IF7ContextChange getF7ContextManager() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return "company.id";
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        return "cas_bankbook_02addNew";
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }
}

