/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class BankStatementFilterParam
implements FilterParam {
    private static final long serialVersionUID = 1082894864824464878L;
    private int startPeriodYear;
    private int startPeriodNum;
    private int endPeriodYear;
    private int endPeriodNum;
    private java.sql.Date beginDate;
    private java.sql.Date endDate;
    private boolean isByDate;
    private boolean isMonthStart;
    private boolean isDaySum;
    private boolean isMonthSum;
    private boolean isYearSum;
    private boolean isDestroyed;
    private String companyId;
    private String accountBankId;
    private boolean isAdjustPeriod;
    private String acctTableId;

    public boolean isAdjustPeriod() {
        return this.isAdjustPeriod;
    }

    public void setAdjustPeriod(boolean isAdjustPeriod) {
        this.isAdjustPeriod = isAdjustPeriod;
    }

    public String getAccountBankId() {
        return this.accountBankId;
    }

    public void setAccountBankId(String accountBankId) {
        this.accountBankId = accountBankId;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.isByDate) {
            if (this.beginDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.beginDate), CompareType.GREATER_EQUALS));
            }
            if (this.endDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)this.endDate), CompareType.LESS_EQUALS));
            }
        } else {
            try {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyId));
                String periodTypeId = companyInfo.getAccountPeriodType().getId().toString();
                String sql = PeriodHelper.getPeriodCollSQL(periodTypeId, this.startPeriodYear, this.startPeriodNum, this.endPeriodYear, this.endPeriodNum);
                filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        FilterItemInfo itemInfo = new FilterItemInfo("company.id", (Object)this.companyId);
        filter.getFilterItems().add(itemInfo);
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection items = new SorterItemCollection();
        items.add(new SorterItemInfo("createDate"));
        items.add(new SorterItemInfo("sortedID"));
        items.add(new SorterItemInfo("createTime"));
        items.add(new SorterItemInfo("lineNo"));
        return items;
    }

    public java.sql.Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(java.sql.Date beginDate) {
        this.beginDate = beginDate;
    }

    public java.sql.Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(java.sql.Date endDate) {
        this.endDate = endDate;
    }

    public int getEndPeriodNum() {
        return this.endPeriodNum;
    }

    public void setEndPeriodNum(int endPeriodNum) {
        this.endPeriodNum = endPeriodNum;
    }

    public int getEndPeriodYear() {
        return this.endPeriodYear;
    }

    public void setEndPeriodYear(int endPeriodYear) {
        this.endPeriodYear = endPeriodYear;
    }

    public boolean isByDate() {
        return this.isByDate;
    }

    public void setIsByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public boolean isDaySum() {
        return this.isDaySum;
    }

    public void setIsDaySum(boolean isDaySum) {
        this.isDaySum = isDaySum;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void setIsDestroyed(boolean isDestroyed) {
        this.isDestroyed = isDestroyed;
    }

    public boolean isMonthStart() {
        return this.isMonthStart;
    }

    public void setIsMonthStart(boolean isMonthStart) {
        this.isMonthStart = isMonthStart;
    }

    public boolean isMonthSum() {
        return this.isMonthSum;
    }

    public void setIsMonthSum(boolean isMonthSum) {
        this.isMonthSum = isMonthSum;
    }

    public boolean isYearSum() {
        return this.isYearSum;
    }

    public void setIsYearSum(boolean isYearSum) {
        this.isYearSum = isYearSum;
    }

    public int getStartPeriodNum() {
        return this.startPeriodNum;
    }

    public void setStartPeriodNum(int startPeriodNum) {
        this.startPeriodNum = startPeriodNum;
    }

    public int getStartPeriodYear() {
        return this.startPeriodYear;
    }

    public void setStartPeriodYear(int startPeriodYear) {
        this.startPeriodYear = startPeriodYear;
    }

    public void setByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public void setMonthStart(boolean isMonthStart) {
        this.isMonthStart = isMonthStart;
    }

    public void setDaySum(boolean isDaySum) {
        this.isDaySum = isDaySum;
    }

    public void setMonthSum(boolean isMonthSum) {
        this.isMonthSum = isMonthSum;
    }

    public void setYearSum(boolean isYearSum) {
        this.isYearSum = isYearSum;
    }

    public void setDestroyed(boolean isDestroyed) {
        this.isDestroyed = isDestroyed;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
}

