/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.VoucherCheckUIFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractBankStatementFilterUI;
import com.kingdee.eas.fi.cas.client.BankStatementFilterParam;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankStatementFilterUI
extends AbstractBankStatementFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankStatementFilterUI.class.getName());
    private BankStatementFilterParam param = null;
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private PeriodInfo startPeriod = null;
    private String acctTableId = null;
    private Map paramMap;
    private Map paramMapVerify;
    private boolean isSharedOrg = false;

    public BankStatementFilterUI() throws Exception {
    }

    public BankStatementFilterUI(Map paramMap1) throws Exception {
        this.paramMap = paramMap1;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStatementUITitle") + " - " + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryUITitle");
    }

    protected void init() throws Exception {
        PeriodCollection colls = PeriodHelper.getPeriodc(this.currentCompany);
        this.companyInfo = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        if (!this.companyInfo.isIsBizUnit()) {
            return;
        }
        if (this.paramMap.get("currentCompany") != null && this.paramMap.get("currentPeriod") != null && this.paramMap.get("startPeriod") != null) {
            PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spStartYear, this.spStart, this.spEndYear, this.spEnd);
        } else {
            PeriodHelper.initPeriodSpinner(this.spStartYear, this.spStart, this.spEndYear, this.spEnd);
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(company, SystemEnum.CASHMANAGEMENT));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
        PeriodInfo period = (PeriodInfo)this.paramMap.get("currentPeriod");
        this.spStartYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spStart.setValue((Object)new Integer(period.getPeriodNumber()));
        this.spEndYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spEnd.setValue((Object)new Integer(period.getPeriodNumber()));
        this.startPeriod = (PeriodInfo)this.paramMap.get("startPeriod");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.paramMap.get("UserOrgRanges");
            for (int i = 0; i < orgRang.size(); ++i) {
                company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                this.prmtCompany.setValue((Object)company);
                this.currentCompany = company;
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || !company.isIsBizUnit() || company.isIsOUSealUp() || company.isIsAssistantOrg()) continue;
                this.prmtCompany.setValue((Object)company);
                PeriodHelper.initPeriodSpinner(this.currentCompany, this.spStartYear, this.spStart, this.spEndYear, this.spEnd);
                pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(company, SystemEnum.CASHMANAGEMENT));
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
                break;
            }
        } else {
            pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        CashHelper.setBankF7IncludeShared(this.prmtAccountBank, this.companyInfo, this.chkDestroyed.isSelected());
    }

    public void clear() {
        super.clear();
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
                CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.paramMap.get("UserOrgRanges");
                for (int i = 0; i < orgRang.size(); ++i) {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                    if (!company.isIsBizUnit() || company.isIsOUSealUp() || company.isIsAssistantOrg()) continue;
                    this.prmtCompany.setValue((Object)company);
                    PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(company, SystemEnum.CASHMANAGEMENT));
                    SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
                    break;
                }
            } else {
                this.prmtCompany.setValue((Object)companyInfo);
            }
            if (this.currentCompany.isIsBizUnit()) {
                PeriodHelper.initPeriodSpinner(this.currentCompany, this.spStartYear, this.spStart, this.spEndYear, this.spEnd);
                PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
        this.chkDestroyed.setSelected(false);
        this.chkPeriodStartAmt.setSelected(true);
        this.chkDayAmount.setSelected(true);
        this.chkMonthAmount.setSelected(true);
        this.chkYearAmount.setSelected(true);
        this.radioPeriod.setSelected(true);
    }

    @Override
    protected void radioPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.radioPeriod.isSelected()) {
            this.filterByPeriod(true);
            this.filterByDate(false);
        }
    }

    @Override
    protected void radioDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radioDate.isSelected()) {
            this.filterByPeriod(false);
            this.filterByDate(true);
        }
    }

    private void filterByPeriod(boolean bFlag) {
        this.lblPeriod.setVisible(bFlag);
        this.lblPeriodTo.setVisible(bFlag);
        this.spStartYear.setVisible(bFlag);
        this.spStart.setVisible(bFlag);
        this.lblPeriodStart.setVisible(bFlag);
        this.lblStart.setVisible(bFlag);
        this.spEndYear.setVisible(bFlag);
        this.spEnd.setVisible(bFlag);
        this.lblEndYear.setVisible(bFlag);
        this.lblEnd.setVisible(bFlag);
    }

    private void filterByDate(boolean bFlag) {
        this.lblStartDate.setVisible(bFlag);
        this.lblEndDate.setVisible(bFlag);
        this.dateStart.setVisible(bFlag);
        this.dateEnd.setVisible(bFlag);
    }

    public Object getParam() {
        BankStatementFilterParam condition = new BankStatementFilterParam();
        int startYear = Integer.parseInt(this.spStartYear.getValue().toString());
        int start = Integer.parseInt(this.spStart.getValue().toString());
        int endYear = Integer.parseInt(this.spEndYear.getValue().toString());
        int end = Integer.parseInt(this.spEnd.getValue().toString());
        condition.setStartPeriodYear(startYear);
        condition.setStartPeriodNum(start);
        condition.setEndPeriodYear(endYear);
        condition.setEndPeriodNum(end);
        condition.setIsByDate(this.radioDate.isSelected());
        if (this.radioDate.isSelected()) {
            condition.setIsByDate(this.radioDate.isSelected());
            condition.setBeginDate(DateHelper.getSQLBegin((java.util.Date)this.dateStart.getSqlDate()));
            condition.setEndDate(DateHelper.getSQLEnd((java.util.Date)this.dateEnd.getSqlDate()));
            condition.setAdjustPeriod(false);
        } else {
            condition.setIsByDate(this.radioDate.isSelected());
            condition.setStartPeriodYear(startYear);
            condition.setStartPeriodNum(start);
            condition.setEndPeriodYear(endYear);
            condition.setEndPeriodNum(end);
            try {
                CompanyOrgUnitInfo company = null;
                company = EmptyUtil.isEmpty((Object)this.prmtCompany.getValue()) ? this.companyInfo : (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                PeriodInfo periodInfoFrom = PeriodUtils.getPeriodInfo((int)startYear, (int)start, (CompanyOrgUnitInfo)this.companyInfo);
                PeriodInfo periodInfoTo = PeriodUtils.getPeriodInfo((int)endYear, (int)end, (CompanyOrgUnitInfo)this.companyInfo);
                Date startDate = new Date(periodInfoFrom.getBeginDate().getTime());
                Date endDate = new Date(periodInfoTo.getEndDate().getTime());
                condition.setAdjustPeriod(periodInfoFrom.isIsAdjustPeriod());
                condition.setBeginDate(startDate);
                condition.setEndDate(endDate);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        condition.setIsMonthStart(this.chkPeriodStartAmt.isSelected());
        condition.setIsDaySum(this.chkDayAmount.isSelected());
        condition.setIsMonthSum(this.chkMonthAmount.isSelected());
        condition.setIsYearSum(this.chkYearAmount.isSelected());
        condition.setIsDestroyed(this.chkDestroyed.isSelected());
        if (this.acctTableId == null) {
            this.getAcctTableID();
        }
        condition.setAcctTableId(this.acctTableId);
        condition.setCompanyId(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        if (this.prmtAccountBank.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        condition.setAccountBankId(((AccountBankInfo)this.prmtAccountBank.getData()).getId().toString());
        return condition;
    }

    public void setParam(Object obj) {
        this.param = (BankStatementFilterParam)obj;
        if (this.param == null) {
            return;
        }
        this.setParamToUI();
    }

    private void setParamToUI() {
        if (this.param == null) {
            return;
        }
        this.radioDate.setSelected(this.param.isByDate());
        this.dateStart.setValue((Object)this.param.getBeginDate());
        this.dateEnd.setValue((Object)this.param.getEndDate());
        this.spStartYear.setValue((Object)new Integer(this.param.getStartPeriodYear()));
        this.spStart.setValue((Object)new Integer(this.param.getStartPeriodNum()));
        this.spEndYear.setValue((Object)new Integer(this.param.getEndPeriodYear()));
        this.spEnd.setValue((Object)new Integer(this.param.getEndPeriodNum()));
        this.chkPeriodStartAmt.setSelected(this.param.isMonthStart());
        this.chkDayAmount.setSelected(this.param.isDaySum());
        this.chkMonthAmount.setSelected(this.param.isMonthSum());
        this.chkYearAmount.setSelected(this.param.isYearSum());
        this.chkDestroyed.setSelected(this.param.isDestroyed());
        if (this.param.isByDate()) {
            this.radioDate.setSelected(true);
        } else {
            this.radioPeriod.setSelected(true);
        }
        try {
            if (EmptyUtil.isEmpty((String)this.param.getCompanyId())) {
                this.param.setCompanyId(this.companyInfo.getId().toString());
            }
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.param.getCompanyId()));
            this.prmtCompany.setValue((Object)companyInfo);
            if (!EmptyUtil.isEmpty((String)this.param.getAccountBankId())) {
                AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(this.param.getAccountBankId()));
                this.prmtAccountBank.setValue((Object)accountBankInfo);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setParamToUI();
    }

    public boolean verify() {
        java.util.Date endDate;
        if (null == this.prmtCompany.getValue()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"436_BankJournalFilterUI"));
            SysUtil.abort();
        }
        this.paramMapVerify = new HashMap();
        boolean byDate = this.radioDate.isSelected();
        if (byDate) {
            CashClientHelper.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.fi.cas.client.CashMgtResource", this.dateStart, "cm63");
            CashClientHelper.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.fi.cas.client.CashMgtResource", this.dateEnd, "cm63");
            Date beginDate = this.dateStart.getSqlDate();
            endDate = this.dateEnd.getSqlDate();
            this.paramMapVerify.put("byDate", Boolean.TRUE);
            this.paramMapVerify.put("beginDate", DateTimeUtils.truncateDate((java.util.Date)new java.util.Date(beginDate.getTime())));
            this.paramMapVerify.put("endDate", DateTimeUtils.truncateDate((java.util.Date)new java.util.Date(endDate.getTime())));
        } else {
            int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spStartYear);
            int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spStart);
            int endYear = AccessHelper.getSpiValue((KDSpinner)this.spEndYear);
            int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spEnd);
            this.paramMapVerify.put("byDate", Boolean.FALSE);
            this.paramMapVerify.put("beginYear", new Integer(beginYear));
            this.paramMapVerify.put("beginMonth", new Integer(beginMonth));
            this.paramMapVerify.put("endYear", new Integer(endYear));
            this.paramMapVerify.put("endMonth", new Integer(endMonth));
            this.paramMapVerify.put("company", this.prmtCompany.getValue());
        }
        try {
            this.paramMapVerify = VoucherCheckUIFacadeFactory.getRemoteInstance().fetchDataForVerfiy(this.paramMapVerify);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if ("PeriodNULL".equals(this.paramMapVerify.get("actualAcctTableId"))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"262_BankStatementFilterUI"));
            return false;
        }
        if (!this.radioPeriod.isSelected()) {
            java.util.Date startDate = (java.util.Date)this.dateStart.getValue();
            endDate = (java.util.Date)this.dateEnd.getValue();
            if ((startDate = DateTimeUtils.truncateDate((java.util.Date)startDate)).after(endDate = DateTimeUtils.truncateDate((java.util.Date)endDate))) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryDate_AlertMsg"));
                return false;
            }
        }
        this.getAcctTableID();
        return true;
    }

    private void getAcctTableID() {
        int beginYear = 0;
        int beginMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        if (this.radioPeriod.isSelected()) {
            beginYear = AccessHelper.getSpiValue((KDSpinner)this.spStartYear);
            beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spStart);
            endYear = AccessHelper.getSpiValue((KDSpinner)this.spEndYear);
            endMonth = AccessHelper.getSpiValue((KDSpinner)this.spEnd);
            try {
                if (EmptyUtil.isEmpty((Object)this.prmtCompany.getValue())) {
                    this.acctTableId = CashAccountTool.getDisplayAcctTable(null, null, beginYear, beginMonth, endYear, endMonth);
                } else {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                    this.acctTableId = CashAccountTool.getDisplayAcctTable(company.getId().toString(), null, beginYear, beginMonth, endYear, endMonth);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
        if (this.radioDate.isSelected()) {
            java.util.Date beginDate = DateTimeUtils.truncateDate((java.util.Date)this.dateStart.getSqlDate());
            java.util.Date endDate = DateTimeUtils.truncateDate((java.util.Date)this.dateEnd.getSqlDate());
            String company = null;
            if (this.prmtCompany.getValue() != null) {
                company = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            }
            this.acctTableId = FMClientHelper.getActualAcctTable(company, (java.util.Date)beginDate, (java.util.Date)endDate);
        }
    }

    @Override
    protected void dateEnd_dataChanged(DataChangeEvent e) throws Exception {
        this.adjustDateRange();
    }

    private void adjustDateRange() {
        Date startDate = this.dateStart.getSqlDate();
        Date endDate = this.dateEnd.getSqlDate();
        if (EmptyUtil.isEmpty((Object)startDate) || EmptyUtil.isEmpty((Object)endDate)) {
            return;
        }
        if (DateTimeUtils.dayBefore((java.util.Date)startDate, (java.util.Date)this.startPeriod.getBeginDate())) {
            startDate = new Date(this.startPeriod.getBeginDate().getTime());
            this.dateStart.setValue((Object)startDate);
        }
        if (DateTimeUtils.dayBefore((java.util.Date)endDate, (java.util.Date)startDate)) {
            this.dateEnd.setValue((Object)startDate);
        }
    }

    @Override
    protected void dateStart_dataChanged(DataChangeEvent e) throws Exception {
        this.adjustDateRange();
    }

    protected Class getParamClass() {
        return BankStatementFilterParam.class;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getPermissionItem() {
        return "cas_bankstatement_01view";
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (null == chgVo.getNewOrg()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"436_BankJournalFilterUI"));
            SysUtil.abort();
        }
        this.currentCompany = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        try {
            PeriodHelper.initPeriodSpinner(this.currentCompany, this.spStartYear, this.spStart, this.spEndYear, this.spEnd);
            PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spStartYear, (KDSpinner)this.spStart, (KDSpinner)this.spEndYear, (KDSpinner)this.spEnd, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return false;
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }

    @Override
    protected void chkDestroyed_actionPerformed(ActionEvent e) throws Exception {
        CashHelper.setBankF7IncludeShared(this.prmtAccountBank, this.companyInfo, this.chkDestroyed.isSelected());
    }
}

