/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.ICells;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementException;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.client.BankStatementFilterParam;
import com.kingdee.eas.fi.cas.client.BankStatementOptionUI;
import com.kingdee.eas.fi.cas.client.ExcelImportHelper;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.TxtReader;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;

public class BankStatementHandler {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.BankStatementException";
    private static final String resourcePath1 = "com.kingdee.eas.fi.cas.BankStatementResource";
    protected static final String BALANCE = "balance";
    public static final String FLD_DATE = "createDate";
    public static final String FLD_DESC = "description";
    public static final String FLD_STYPE = "settleType";
    public static final String FLD_SNUM = "settleNumber";
    public static final String FLD_DEBIT = "debitAmount";
    public static final String FLD_CREDIT = "creditAmount";
    public static String viewFormat;
    private static SettlementTypeCollection col;

    protected static void verfiyCreditDebit(Component uiComp, Object oCredits, Object oDebits) {
        BigDecimal credit = null;
        BigDecimal debit = null;
        debit = oDebits != null ? new BigDecimal(oDebits.toString()) : SysConstant.BIGZERO;
        credit = oCredits != null ? new BigDecimal(oCredits.toString()) : SysConstant.BIGZERO;
        if (debit.signum() == 0 && credit.signum() == 0) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStatement_DebitCreditPrompt"));
            SysUtil.abort();
        }
        if (debit.signum() > 0 && credit.signum() > 0) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStatement_DebitCredit"));
            SysUtil.abort();
        }
    }

    public static BankStatementCollection importData(String file, String userOptionName, boolean dc, String companyId) throws Exception {
        KDSSheet sheet;
        if (!BankStatementHandler.isValidFile(file)) {
            return null;
        }
        KDSBook kdsBook = null;
        if (file.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
            kdsBook = POIXlsReader.parse((String)file);
        } else if (file.toLowerCase(Locale.ENGLISH).endsWith(".txt")) {
            kdsBook = TxtReader.parse((String)file);
        } else if (file.toLowerCase(Locale.ENGLISH).endsWith(".xlsx")) {
            kdsBook = POIXlsxReader.parse((String)file);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"OnlyTxtAndXls"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"ImportFailure"));
            SysUtil.abort();
        }
        if ((sheet = kdsBook.getSheet((Object)new Integer(0))) == null || sheet.getCells() == null) {
            return null;
        }
        return BankStatementHandler.convertToBankStmts(sheet, userOptionName, dc, companyId);
    }

    private static BankStatementCollection convertToBankStmts(KDSSheet sheet, String userOptionName, boolean dc, String companyId) throws Exception {
        ICells cells = sheet.getCells();
        String[] fields = BankStatementHandler.getImportFields(userOptionName, companyId);
        BankStatementHandler.checkIfExcelValid(sheet, fields);
        int iRow = 1;
        KDSCell cell = null;
        KDSCell cellPre = null;
        boolean fGo = true;
        BankStatementCollection stmts = new BankStatementCollection();
        BankStatementInfo stmtInfo = null;
        BigDecimal tmpAmt = null;
        java.util.Date date = null;
        while (fGo) {
            stmtInfo = new BankStatementInfo();
            for (int i = 0; i < fields.length; ++i) {
                cell = cells.getCell(iRow, i, false);
                Object value = cell.getValue();
                if (StringUtils.isEmpty((String)value.toString())) continue;
                String key = fields[i];
                if (key.equals("amount")) {
                    if (viewFormat.equals("dataDCNoneFormat")) {
                        tmpAmt = BankStatementHandler.objToBigDecimal(value);
                        if (tmpAmt.compareTo(Constants.ZERO) > 0) {
                            stmtInfo.setCreditAmount(tmpAmt);
                            stmtInfo.setDebitAmount(Constants.ZERO);
                        } else if (tmpAmt.compareTo(Constants.ZERO) < 0) {
                            stmtInfo.setDebitAmount(tmpAmt.abs());
                            stmtInfo.setCreditAmount(Constants.ZERO);
                        }
                    }
                    if (!viewFormat.equals("dataDCSignFormat")) continue;
                    cellPre = cells.getCell(iRow, i - 1, false);
                    String flag = cellPre.getValue().toString();
                    boolean isDebit = BankStatementHandler.isDebitFlag(flag);
                    if (!isDebit) {
                        tmpAmt = BankStatementHandler.objToBigDecimal(value);
                        stmtInfo.setDebitAmount(tmpAmt);
                        stmtInfo.setCreditAmount(Constants.ZERO);
                        continue;
                    }
                    tmpAmt = BankStatementHandler.objToBigDecimal(value);
                    stmtInfo.setCreditAmount(tmpAmt);
                    stmtInfo.setDebitAmount(Constants.ZERO);
                    continue;
                }
                if (key.equals(FLD_DATE)) {
                    try {
                        date = value instanceof GregorianCalendar ? ((GregorianCalendar)value).getTime() : BankStatementHandler.parseDate((String)value);
                        date = DateTimeUtils.truncateDate((java.util.Date)date);
                    }
                    catch (Exception e) {
                        MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"DateErr"));
                        SysUtil.abort();
                    }
                    stmtInfo.setCreateDate(date);
                    continue;
                }
                if (key.equals(FLD_STYPE)) {
                    stmtInfo.setSettleType(BankStatementHandler.getSettType(value.toString()));
                    continue;
                }
                if (key.equals(FLD_DESC)) {
                    String description = value.toString();
                    if (description.length() > 255) {
                        MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"descToLong"));
                        SysUtil.abort();
                        continue;
                    }
                    stmtInfo.setDescription(description);
                    continue;
                }
                if (key.equals(FLD_CREDIT)) {
                    tmpAmt = BankStatementHandler.objToBigDecimal(value);
                    stmtInfo.setCreditAmount(tmpAmt);
                    if (tmpAmt.compareTo(FMConstants.ZERO) == 0) continue;
                    stmtInfo.setDebitAmount(FMConstants.ZERO);
                    continue;
                }
                if (key.equals(FLD_DEBIT)) {
                    tmpAmt = BankStatementHandler.objToBigDecimal(value);
                    stmtInfo.setDebitAmount(tmpAmt);
                    continue;
                }
                String sVal = value.toString().trim();
                stmtInfo.put(key, sVal);
            }
            if (stmtInfo.get(FLD_DATE) == null && (stmtInfo.get(FLD_CREDIT) == null || stmtInfo.get(FLD_DEBIT) == null)) {
                fGo = false;
                continue;
            }
            stmts.add(stmtInfo);
            ++iRow;
        }
        return stmts;
    }

    private static boolean isDebitFlag(String flag) {
        boolean isDebit = flag.trim().equals("1") || flag.trim().equals("+") || flag.trim().equals("\uff0b") || flag.indexOf(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"263_BankStatementHandler")) >= 0;
        return isDebit;
    }

    public static java.util.Date parseDate(String s) {
        try {
            java.util.Date date = DateTimeUtils.parseDate((String)s, (String)"yyyy-MM-dd");
            return TypeConversionUtils.objToDate((Object)date);
        }
        catch (Exception exception) {
            try {
                return DateTimeUtils.parseDate((String)s, (String)"yyyyMMdd");
            }
            catch (Exception exception2) {
                try {
                    return ExcelImportHelper.getDate(Double.parseDouble(s));
                }
                catch (Exception exception3) {
                    return TypeConversionUtils.objToDate((Object)s);
                }
            }
        }
    }

    private static BigDecimal objToBigDecimal(Object obj) {
        BigDecimal tmpAmt = null;
        try {
            if (obj instanceof String) {
                String t = obj.toString().trim();
                obj = t.replaceAll(",", "");
                obj = obj.toString().replaceAll("\uffe5", "");
            }
            tmpAmt = TypeConversionUtils.objToBigDecimal((Object)obj);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"NumberErr"));
            SysUtil.abort();
        }
        if (tmpAmt != null && tmpAmt.abs().compareTo(FMConstants.MAX_VALUE) == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath1, (String)"NumberTooBig"));
            SysUtil.abort();
        }
        return tmpAmt;
    }

    private static SettlementTypeInfo getSettType(String name) throws BOSException {
        ISettlementType iSettleType = SettlementTypeFactory.getRemoteInstance();
        if (col == null) {
            col = iSettleType.getSettlementTypeCollection();
        }
        SettlementTypeInfo info = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            if (!info.getName().equals(name) && !info.getNumber().equals(name)) continue;
            return info;
        }
        return null;
    }

    private static void checkIfExcelValid(KDSSheet sheet, String[] fields) throws Exception {
        if (sheet.getRowCount() == 0) {
            throw new BankStatementException(BankStatementException.NO_ROW);
        }
        ICells cells = sheet.getCells();
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 1; j < sheet.getRowCount(); ++j) {
                if (fields[i].equals("date")) {
                    try {
                        ExcelImportHelper.getDate(Double.parseDouble((String)cells.getCell(j, i, false).getValue()));
                        continue;
                    }
                    catch (Exception e) {
                        String name = EASResource.getString((String)resourcePath, (String)"INVALID_DATE_FORMAT");
                        name = name.replaceAll("#R#", String.valueOf(j + 1));
                        name = name.replaceAll("#C#", String.valueOf(i + 1));
                        throw new BankStatementException(new NumericExceptionSubItem(BankStatementException.INVALID_DATE_FORMAT.getCode(), name));
                    }
                }
                if (!fields[i].equals("amount")) continue;
                try {
                    Object cell = cells.getCell(j, i, false).getValue();
                    if (EmptyUtil.isEmpty((Object)cell)) continue;
                    BankStatementHandler.objToBigDecimal(cell.toString());
                    continue;
                }
                catch (Exception e) {
                    String name = EASResource.getString((String)resourcePath, (String)"INVALID_AMOUNT_FORMAT");
                    name = name.replaceAll("#R#", String.valueOf(j + 1));
                    name = name.replaceAll("#C#", String.valueOf(i + 1));
                    throw new BankStatementException(new NumericExceptionSubItem(BankStatementException.INVALID_AMOUNT_FORMAT.getCode(), name));
                }
            }
        }
    }

    private static boolean checkIsEmptyData(ICells cells, int row, int fieldCount) {
        boolean isEmpty = true;
        for (int i = 0; i < fieldCount; ++i) {
            String value = (String)cells.getCell(row, i, false).getValue();
            if (EmptyUtil.isEmpty((String)value)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    protected static String[] getImportFields(String userOptionName, String companyId) throws Exception {
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        Map map = userOption.getUserOptionMap("00000000-0000-0000-0000-00000000000013B7DE7F", companyId, BankStatementOptionUI.class.getName(), userOptionName);
        if (map == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"264_BankStatementHandler"));
            SysUtil.abort();
        }
        String selectField = map.get("order").toString();
        viewFormat = map.get("viewFormat").toString();
        int i = 0;
        int fromIndex = 0;
        while (selectField.indexOf(",", fromIndex) != -1) {
            ++i;
            fromIndex = selectField.indexOf(",", fromIndex) + 1;
        }
        String[] fields = new String[i + 1];
        int j = 0;
        while (selectField.indexOf(",") != -1) {
            String field = selectField.substring(0, selectField.indexOf(","));
            selectField = selectField.substring(selectField.indexOf(",") + 1);
            fields[j] = field;
            ++j;
        }
        fields[j] = selectField;
        return fields;
    }

    private static boolean isValidFile(String sFile) {
        if (StringUtils.isEmpty((String)sFile)) {
            return false;
        }
        File file = new File(sFile);
        return file.exists();
    }

    protected static BankStatementInfo getStartAmts(BankStatementFilterParam param, String bankId, String currencyId, String accountId, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(ConvertUtils.PK((Object)companyId));
        PeriodInfo beginPeriodInfo = PeriodHelper.getPeriodInfo(param.getStartPeriodYear(), param.getStartPeriodNum(), companyInfo);
        PeriodInfo endPeriodInfo = PeriodHelper.getPeriodInfo(param.getEndPeriodYear(), param.getEndPeriodNum(), companyInfo);
        IBankStatement iStmt = BankStatementFactory.getRemoteInstance();
        return iStmt.getDateStartData(ConvertUtils.PK((Object)companyId), ConvertUtils.PK((Object)bankId), ConvertUtils.PK((Object)currencyId), param.getBeginDate(), param.getEndDate(), ConvertUtils.PK((Object)beginPeriodInfo), ConvertUtils.PK((Object)endPeriodInfo), ConvertUtils.PK((Object)accountId), ConvertUtils.PK((Object)param.getAcctTableId()));
    }

    protected static PeriodCollection getQryPeriods(BankStatementFilterParam param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        ObjectUuidPK companyPK = null;
        CompanyOrgUnitInfo company = null;
        if (EmptyUtil.isEmpty((String)param.getCompanyId())) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            companyPK = new ObjectUuidPK(company.getId().toString());
        } else {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
            companyPK = new ObjectUuidPK(param.getCompanyId());
        }
        PeriodCollection periods = null;
        if (param.isByDate()) {
            periods = PeriodUtils.getPeriodCollection(null, (java.util.Date)beginDate, (java.util.Date)endDate, (IObjectPK)companyPK);
        } else {
            String periodtypeId = company.getAccountPeriodType().getId().toString();
            int beginYear = param.getStartPeriodYear();
            int beginMonth = param.getStartPeriodNum();
            int endYear = param.getEndPeriodYear();
            int endMonth = param.getEndPeriodNum();
            periods = PeriodHelper.getPeriodColl(null, periodtypeId, beginYear, beginMonth, endYear, endMonth);
        }
        BankStatementHandler.sortPeriodColl(periods);
        if (!(periods != null && periods.size() != 0 || param.isByDate() || param.getStartPeriodYear() != param.getEndPeriodYear() || param.getStartPeriodNum() != param.getEndPeriodNum())) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((int)param.getStartPeriodYear(), (int)param.getStartPeriodNum(), (IObjectPK)companyPK);
            periods.add(periodInfo);
        }
        return periods;
    }

    private static void sortPeriodColl(PeriodCollection coll) {
        Object[] collAry = coll.toArray();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                PeriodInfo new01 = (PeriodInfo)o1;
                PeriodInfo new02 = (PeriodInfo)o2;
                return new01.getBeginDate().compareTo(new02.getBeginDate());
            }
        };
        Arrays.sort(collAry, c);
        coll.clear();
        for (int i = 0; i < collAry.length; ++i) {
            coll.add((PeriodInfo)collAry[i]);
        }
    }

    static {
        col = null;
    }
}

