/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctEntriesCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractBankStatementUI;
import com.kingdee.eas.fi.cas.client.BankStatementHandler;
import com.kingdee.eas.fi.cas.client.BankStatementImportUI;
import com.kingdee.eas.fi.cas.client.BankStatementOptionUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BankStatementUI
extends AbstractBankStatementUI
implements IMultiOrgSupport {
    private Logger logger = Logger.getLogger((String)BankStatementUI.class.getName());
    public static final String COL_DATE = "bizDate";
    public static final String COL_PERIOD = "period";
    public static final String COL_DESC = "description";
    public static final String COL_SETTLETYPE = "settleType";
    public static final String COL_SETTLENUM = "settleNumber";
    public static final String SEQUENCENUM = "sequenceNumber";
    public static final String COL_OPPUNIT = "oppUnit";
    public static final String TRADENUM = "tradeNumber";
    public static final String COL_DEBIT = "debitAmount";
    public static final String COL_CREDIT = "creditAmount";
    public static final String COL_REF = "referencedAmt";
    public static final String COL_CASHIER = "cashier";
    public static final String COL_OPPACCT = "oppAccountNumber";
    public static final String COL_VOUCHERNUM = "voucherNumber";
    private BankStatementCollection bankStmtsOld = new BankStatementCollection();
    private BankStatementCollection bankStmts = new BankStatementCollection();
    private PeriodInfo startPeriod = null;
    private CalculatorDialog calc = null;
    private DefaultF7ContextManager F7ContextManager = null;
    private IContextHelper context = ContextHelperFactory.getRemoteInstance();
    private static final String casResourcePath = "com.kingdee.eas.fi.cas.CasResource";
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    PeriodInfo casPeriod = CashClientHelper.getCurrentPeriod(this.companyInfo);
    private boolean canAddPreviousBill = true;
    protected boolean isFirstOpenAndAdd = true;

    public boolean isModify() {
        this.storeFields();
        return !this.bankStmts.equals((Object)this.bankStmtsOld);
    }

    public void onLoad() throws Exception {
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        this.prmtCompany.setValue((Object)this.companyInfo);
        this.casPeriod = CashClientHelper.getCurrentPeriod(this.companyInfo);
        this.setOprtState("ADDNEW");
        this.initUI(this.companyInfo);
        this.initBtnIcon();
        super.onLoad();
        this.getDetailTable().setActiveCellStatus(1);
        this.initTable(this.kdtEntries);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        this.storeFields();
        this.bankStmtsOld = (BankStatementCollection)((Object)this.bankStmts.clone());
        this.menuItemSave.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.separator1.setVisible(false);
        this.separator2.setVisible(false);
        this.separator3.setVisible(false);
        this.separatorEdit1.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.kdtEntries.getColumn(COL_DATE).getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    private void initUI(CompanyOrgUnitInfo info) throws Exception {
        this.getDetailTable().checkParsed();
        this.canAddPreviousBill = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        try {
            this.setBankF7(this.prmtBank, info, false);
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this.startPeriod = ClientUtils.getStartPeriodInfo((Component)((Object)this), info);
        ClientUtils.setCurrencyList(this.comboCurrency, false);
        this.setCellEditor();
        this.kdtEntries.getColumn(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_REF).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.actionCalculateAmt.setEnabled(true);
    }

    private void initBtnIcon() {
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnImportOption.setIcon(EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.btnCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnCopyLine.setToolTipText(this.btnCopy.getText());
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine.setToolTipText(this.btnAddLine.getText());
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnInsertLine.setToolTipText(this.btnInsertLine.getText());
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemoveLine.setToolTipText(this.btnRemoveLine.getText());
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnCalculator.setToolTipText(this.btnCalculator.getText());
    }

    private void setCellEditor() throws BOSException {
        String formatString = "yyyy-MM-dd";
        this.getDetailTable().getColumn(COL_DATE).getStyleAttributes().setNumberFormat(formatString);
        KDDatePicker dateStated = new KDDatePicker();
        KDTDefaultCellEditor dateEditor = new KDTDefaultCellEditor(dateStated);
        this.getDetailTable().getColumn(COL_DATE).setEditor((ICellEditor)dateEditor);
        this.getDetailTable().getColumn(COL_PERIOD).getStyleAttributes().setLocked(true);
        KDComboBox comboSettleType = new KDComboBox();
        KDTDefaultCellEditor settleEditor = new KDTDefaultCellEditor((JComboBox)comboSettleType);
        this.getDetailTable().getColumn(COL_SETTLETYPE).setEditor((ICellEditor)settleEditor);
        ClientUtils.setSettleTypeList(comboSettleType);
        KDTextField txtDesc = new KDTextField();
        txtDesc.setMaxLength(255);
        KDTDefaultCellEditor descEditor = new KDTDefaultCellEditor((JTextField)txtDesc);
        this.getDetailTable().getColumn(COL_SETTLENUM).setEditor((ICellEditor)descEditor);
        KDTextField txtNum = new KDTextField();
        txtNum.setMaxLength(80);
        KDTDefaultCellEditor seqEditor = new KDTDefaultCellEditor((JTextField)txtDesc);
        this.getDetailTable().getColumn(COL_DESC).setEditor((ICellEditor)seqEditor);
    }

    @Override
    public void loadFields() {
        if (this.editData == null) {
            return;
        }
        if (this.companyInfo.getInvalidDate() != null && this.companyInfo.getInvalidDate().before(new Date())) {
            this.setBtnsStatus(false);
        }
        if (this.editData.getAccountBank() != null) {
            this.prmtBank.setValue((Object)this.editData.getAccountBank());
            try {
                this.prmtBank_dataChanged(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.editData.getCurrency() != null) {
            ClientUtils.setSelectedItem(this.comboCurrency, this.editData.getCurrency().getId().toString());
        }
        if (this.kdtEntries.getRowCount() == 0) {
            IRow row = this.kdtEntries.addRow();
            row.getCell(COL_DATE).setValue((Object)this.editData.getCreateDate());
            row.getCell(COL_CREDIT).setValue((Object)this.editData.getCreditAmount());
            row.getCell(COL_DEBIT).setValue((Object)this.editData.getDebitAmount());
        }
        try {
            this.setDateRelatedPeriod(0);
        }
        catch (Exception e) {
            this.setBtnsStatus(false);
        }
    }

    @Override
    public void storeFields() {
        this.bankStmts.clear();
        int rows = this.kdtEntries.getRowCount();
        if (rows < 1) {
            return;
        }
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        AccountViewInfo accountInfo = (AccountViewInfo)this.txtAccount.getUserObject();
        ConcurrentHashMap<String, AccountViewInfo> acctMap = new ConcurrentHashMap<String, AccountViewInfo>();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            BankStatementInfo info = new BankStatementInfo();
            info.setLineNo(i);
            Date createDate = (Date)row.getCell(COL_DATE).getValue();
            createDate = DateTimeUtils.truncateDate((Date)createDate);
            Timestamp ts = new Timestamp(createDate.getTime());
            info.setCreateDate(createDate);
            info.setPeriod((PeriodInfo)row.getCell(COL_PERIOD).getUserObject());
            if (row.getCell(COL_DESC).getValue() != null) {
                info.setDescription((String)row.getCell(COL_DESC).getValue());
            }
            if (row.getCell(COL_SETTLETYPE).getValue() != null && row.getCell(COL_SETTLETYPE).getValue() instanceof SettlementTypeInfo) {
                info.setSettleType((SettlementTypeInfo)row.getCell(COL_SETTLETYPE).getValue());
            }
            if (row.getCell(COL_SETTLENUM).getValue() != null) {
                info.setSettleNumber((String)row.getCell(COL_SETTLENUM).getValue());
            }
            if (row.getCell(SEQUENCENUM).getValue() != null) {
                info.setSequenceNumber((String)row.getCell(SEQUENCENUM).getValue());
            }
            if (row.getCell(TRADENUM).getValue() != null) {
                info.setTradeNumber((String)row.getCell(TRADENUM).getValue());
            }
            if (row.getCell(COL_CASHIER).getValue() != null) {
                info.setCashier((String)row.getCell(COL_CASHIER).getValue());
            }
            if (row.getCell(COL_OPPACCT).getValue() != null) {
                info.setOppAccountNumber((String)row.getCell(COL_OPPACCT).getValue());
            }
            if (row.getCell(COL_OPPUNIT).getValue() != null) {
                info.setOppUnit((String)row.getCell(COL_OPPUNIT).getValue());
            }
            if (row.getCell(COL_VOUCHERNUM).getValue() != null) {
                info.setVoucherNumber((String)row.getCell(COL_VOUCHERNUM).getValue());
            }
            info.setCompany(this.companyInfo);
            info.setAccountBank(bankInfo);
            info.setCurrency(currencyInfo);
            info.setVerifyStatus(VerifyScopeEnum.NOVA);
            info.setSource(BSSourceEnum.MANUAL);
            info.setBizTime(ts);
            this.bankStmts.add(info);
            BigDecimal debit = TypeConversionUtils.objToBigDecimal((Object)row.getCell(COL_DEBIT).getValue());
            BigDecimal credit = TypeConversionUtils.objToBigDecimal((Object)row.getCell(COL_CREDIT).getValue());
            if (debit == null) {
                debit = SysConstant.BIGZERO;
            }
            if (credit == null) {
                credit = SysConstant.BIGZERO;
            }
            info.setDebitAmount(debit);
            info.setCreditAmount(credit);
            if (debit.signum() != 0) {
                info.setIsDebit(true);
            } else {
                info.setIsDebit(false);
            }
            String key = info.getAccountBank().getId().toString() + info.getCreateDate().toString();
            if (acctMap.containsKey(key)) {
                AccountViewInfo accountViewInfo = (AccountViewInfo)acctMap.get(key);
                info.setAccountView(accountViewInfo);
                continue;
            }
            Date bizDate = info.getCreateDate();
            CompanyOrgUnitInfo cUnitInfo = info.getCompany();
            AccountBankInfo accountBankInfo = info.getAccountBank();
            if (null == bizDate || null == cUnitInfo || null == accountBankInfo) continue;
            AccountViewInfo accountViewInfo = this.getAccountView(bizDate, cUnitInfo, accountBankInfo);
            if (null != accountViewInfo) {
                info.setAccountView(accountViewInfo);
                acctMap.put(key, accountViewInfo);
                continue;
            }
            if (bankInfo != null) {
                try {
                    bankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getId().toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.setAccountView(bankInfo.getAccount());
                continue;
            }
            info.setAccountView(accountInfo);
        }
    }

    private void setDateRelatedPeriod(int iRowIndex) throws Exception {
        Date date = (Date)this.kdtEntries.getRow(iRowIndex).getCell(0).getValue();
        if (this.startPeriod == null || date == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)date, (Date)this.startPeriod.getBeginDate())) {
            this.kdtEntries.getRow(iRowIndex).getCell(COL_PERIOD).setUserObject(null);
            this.kdtEntries.getRow(iRowIndex).getCell(COL_PERIOD).setValue(null);
            this.kdtEntries.getRow(iRowIndex).getCell(COL_DATE).setValue((Object)this.startPeriod.getBeginDate());
            this.setDateRelatedPeriod(iRowIndex);
            return;
        }
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this.companyInfo);
        if (periodInfo != null && periodInfo.getId() != null) {
            this.kdtEntries.getRow(iRowIndex).getCell(1).setUserObject((Object)periodInfo);
            Object[] args = new String[]{String.valueOf(periodInfo.getPeriodYear()), String.valueOf(periodInfo.getPeriodNumber())};
            this.kdtEntries.getRow(iRowIndex).getCell(COL_PERIOD).setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args));
        } else {
            this.kdtEntries.getRow(iRowIndex).getCell(COL_PERIOD).setUserObject(null);
            this.kdtEntries.getRow(iRowIndex).getCell(COL_PERIOD).setValue(null);
        }
        String currencyid = ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString();
        String format = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyid));
        StyleAttributes attrDebit = this.kdtEntries.getColumn(COL_DEBIT).getStyleAttributes();
        attrDebit.setNumberFormat(format);
        attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes attrCebit = this.kdtEntries.getColumn(COL_CREDIT).getStyleAttributes();
        attrCebit.setNumberFormat(format);
        attrCebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes attrReferenced = this.kdtEntries.getColumn(COL_REF).getStyleAttributes();
        attrReferenced.setNumberFormat(format);
        attrReferenced.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        this.editData = (BankStatementInfo)dataObject;
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int scale = currencyInfo.getPrecision();
        KDFormattedTextField amtField = new KDFormattedTextField(1);
        amtField.setPrecision(scale);
        amtField.setSupportedEmpty(true);
        KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amtField);
        this.kdtEntries.getColumn(COL_DEBIT).setEditor((ICellEditor)amtEditor);
        this.kdtEntries.getColumn(COL_CREDIT).setEditor((ICellEditor)amtEditor);
        this.kdtEntries.getColumn(COL_REF).setEditor((ICellEditor)amtEditor);
        String numberFmt = FMClientHelper.getNumberFtm((int)scale);
        this.kdtEntries.getColumn(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtEntries.getColumn(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtEntries.getColumn(COL_REF).getStyleAttributes().setNumberFormat(numberFmt);
    }

    @Override
    protected void prmtBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBank.getValue() == null) {
            this.txtAccount.setText(null);
            this.txtAccount.setUserObject(null);
            return;
        }
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        if (bankInfo.isIsClosed()) {
            this.setCtrlEnable(false);
        } else {
            this.setCtrlEnable(true);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.editData)) {
            this.editData.setCompany(bankInfo.getCompany());
        }
        this.companyInfo = this.company = CashClientHelper.getAcctMainSharedAcct(bankInfo);
        CurrencyInfo localCurrency = null;
        localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.company);
        if (bankInfo != null && bankInfo.isIsByCurrency()) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)bankInfo.getCurrency());
            this.comboCurrency.setEnabled(false);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)localCurrency);
            this.comboCurrency.setEnabled(true);
        }
        Date bizDate = this.casPeriod.getBeginDate();
        CompanyOrgUnitInfo cUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBank.getValue();
        if (null != bizDate && null != cUnitInfo && null != accountBankInfo) {
            AccountViewInfo accountViewInfo = this.getAccountView(bizDate, cUnitInfo, accountBankInfo);
            if (EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                accountViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId()));
            }
            this.txtAccount.setText(accountViewInfo.toString());
            this.txtAccount.setUserObject((Object)accountViewInfo);
        }
    }

    private AccountViewInfo getAccountView(Date bizDate, CompanyOrgUnitInfo cUnitInfo, AccountBankInfo accountBankInfo) {
        String acctTableId = FMClientHelper.getActualAcctTable((String)cUnitInfo.getId().toString(), (Date)bizDate, (Date)bizDate);
        HashSet<String> idSet = new HashSet<String>();
        String accountBankId = accountBankInfo.getId().toString();
        idSet.add(accountBankId);
        try {
            Map map = FMHelper.getJBAcctBankAcctViewMap(null, idSet, null, (String)acctTableId);
            AccountViewInfo acctOfBankAccount = (AccountViewInfo)map.get(accountBankInfo.getId().toString());
            if (null != acctOfBankAccount) {
                return acctOfBankAccount;
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return null;
    }

    private void setCtrlEnable(boolean enable) {
        this.getDetailTable().getStyleAttributes().setLocked(!enable);
        this.actionAddLine.setEnabled(enable);
        this.actionEdit.setEnabled(enable);
        this.actionRemove.setEnabled(enable);
        this.actionSubmit.setEnabled(enable);
        this.actionImport.setEnabled(enable);
        this.actionImportOption.setEnabled(enable);
        this.actionInsertLine.setEnabled(enable);
        this.actionCopyLine.setEnabled(enable);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionRemoveLine.setEnabled(enable);
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow copiedRow = this.getDetailTable().getRow(rowIndex);
            if (copiedRow != null) {
                IRow newRow = this.getDetailTable().addRow(this.getDetailTable().getRowCount());
                int n = this.getDetailTable().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    newRow.getCell(i).setValue(copiedRow.getCell(i).getValue());
                    if (copiedRow.getCell(i).getUserObject() == null) continue;
                    newRow.getCell(i).setUserObject(copiedRow.getCell(i).getUserObject());
                }
            }
        }
        SysUtil.abort();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        IObjectValue detailData = this.createNewData();
        IRow row = this.kdtEntries.addRow();
        BankStatementInfo info = (BankStatementInfo)detailData;
        row.getCell(COL_DATE).setValue((Object)info.getCreateDate());
        row.getCell(COL_DESC).setValue((Object)info.getDescription());
        this.setDateRelatedPeriod(this.kdtEntries.getRowCount() - 1);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IObjectValue detailData = this.createNewData();
            IRow row = this.kdtEntries.addRow(rowIndex + 1);
            BankStatementInfo info = (BankStatementInfo)detailData;
            row.getCell(COL_DATE).setValue((Object)info.getCreateDate());
            row.getCell(COL_DESC).setValue((Object)info.getDescription());
            this.setDateRelatedPeriod(rowIndex + 1);
        } else {
            IObjectValue detailData = this.createNewData();
            IRow row = this.kdtEntries.addRow();
            BankStatementInfo info = (BankStatementInfo)detailData;
            row.getCell(COL_DATE).setValue((Object)info.getCreateDate());
            row.getCell(COL_DESC).setValue((Object)info.getDescription());
            this.setDateRelatedPeriod(this.kdtEntries.getRowCount() - 1);
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtBank.getValue() == null) {
            return;
        }
        String param = this.context.getStringParam("CS114", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        if (param != null && param.toString().equals("1")) {
            ObjectUuidPK acctBankPK = new ObjectUuidPK(((AccountBankInfo)this.prmtBank.getValue()).getId());
            AccountBankInfo acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)acctBankPK);
            if (acctBank.isIsSetBankInterface()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"notAllowBankInterface"));
                return;
            }
        }
        String bankAccountId = ((AccountBankInfo)this.prmtBank.getValue()).getId().toString();
        BankStatementCollection bankStatementCollection = BankStatementImportUI.showDialogWindows((IUIObject)this, bankAccountId, this.companyInfo);
        this.loadDataToTable(bankStatementCollection);
    }

    private void loadDataToTable(BankStatementCollection stmts) throws Exception {
        if (stmts == null) {
            return;
        }
        this.kdtEntries.removeRows();
        BankStatementInfo stmtInfo = null;
        Object amt = null;
        IRow row = null;
        int n = stmts.size();
        for (int i = 0; i < n; ++i) {
            stmtInfo = stmts.get(i);
            row = this.kdtEntries.getRow(i);
            if (row == null) {
                row = this.kdtEntries.addRow();
            }
            if (stmtInfo.getDebitAmount() != null) {
                if (stmtInfo.getDebitAmount().scale() < 0) {
                    stmtInfo.setDebitAmount(stmtInfo.getDebitAmount().setScale(0));
                }
                stmtInfo.setDebitAmount(stmtInfo.getDebitAmount().setScale(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getPrecision(), 4));
            }
            if (stmtInfo.getCreditAmount() != null) {
                if (stmtInfo.getCreditAmount().scale() < 0) {
                    stmtInfo.setCreditAmount(stmtInfo.getCreditAmount().setScale(0));
                }
                stmtInfo.setCreditAmount(stmtInfo.getCreditAmount().setScale(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getPrecision(), 4));
            }
            row.getCell(COL_DATE).setValue((Object)stmtInfo.getCreateDate());
            row.getCell(COL_DEBIT).setValue((Object)stmtInfo.getDebitAmount());
            row.getCell(COL_CREDIT).setValue((Object)stmtInfo.getCreditAmount());
            if (!StringUtils.isEmpty((String)stmtInfo.getDescription())) {
                String desc = stmtInfo.getDescription();
                row.getCell(COL_DESC).setValue((Object)desc);
            }
            row.getCell(COL_SETTLETYPE).setValue((Object)stmtInfo.getSettleType());
            if (!StringUtils.isEmpty((String)stmtInfo.getSettleNumber())) {
                row.getCell(COL_SETTLENUM).setValue((Object)stmtInfo.getSettleNumber());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getSequenceNumber())) {
                row.getCell(SEQUENCENUM).setValue((Object)stmtInfo.getSequenceNumber());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getTradeNumber())) {
                row.getCell(TRADENUM).setValue((Object)stmtInfo.getTradeNumber());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getCashier())) {
                row.getCell(COL_CASHIER).setValue((Object)stmtInfo.getCashier());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getOppUnit())) {
                row.getCell(COL_OPPUNIT).setValue((Object)stmtInfo.getOppUnit());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getOppAccountNumber())) {
                row.getCell(COL_OPPACCT).setValue((Object)stmtInfo.getOppAccountNumber());
            }
            if (!StringUtils.isEmpty((String)stmtInfo.getVoucherNumber())) {
                row.getCell(COL_VOUCHERNUM).setValue((Object)stmtInfo.getVoucherNumber());
            }
            this.setDateRelatedPeriod(i);
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_02addNew");
        this.verifyInput(e);
        this.storeFields();
        this.isFirstOpenAndAdd = false;
        String param = this.context.getStringParam("CS114", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        if (param != null && param.toString().equals("1")) {
            ObjectUuidPK acctBankPK = new ObjectUuidPK(((AccountBankInfo)this.prmtBank.getValue()).getId());
            AccountBankInfo acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)acctBankPK);
            if (acctBank.isIsSetBankInterface()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"notAllowBankInterface"));
                return;
            }
        }
        if (!this.bankStmts.isEmpty()) {
            BankStatementFactory.getRemoteInstance().batchSumbit(this.bankStmts);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"SAVE_Successfully"));
            this.setDataObject(this.createNewData());
            this.loadFields();
        }
        this.getDetailTable().removeRows();
        this.addLine();
        this.setDateRelatedPeriod(0);
        this.storeFields();
        this.bankStmtsOld = (BankStatementCollection)((Object)this.bankStmts.clone());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int iCol = e.getColIndex();
        String colKey = this.getDetailTable().getColumn(iCol).getKey();
        if (colKey.equals(COL_DATE)) {
            this.setDateRelatedPeriod(e.getRowIndex());
        }
        if (colKey.equals(COL_DEBIT) || colKey.equals(COL_CREDIT)) {
            int iRow = e.getRowIndex();
            IRow row = this.getDetailTable().getRow(iRow);
            BigDecimal debit = TypeConversionUtils.objToBigDecimal((Object)row.getCell(COL_DEBIT).getValue());
            BigDecimal credit = TypeConversionUtils.objToBigDecimal((Object)row.getCell(COL_CREDIT).getValue());
            debit = debit == null ? SysConstant.BIGZERO : debit;
            BigDecimal bigDecimal = credit = credit == null ? SysConstant.BIGZERO : credit;
            if (debit.compareTo(Constants.MAX_VALUE) == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                row.getCell(COL_DEBIT).setValue(null);
            }
            if (credit.compareTo(Constants.MAX_VALUE) == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                row.getCell(COL_CREDIT).setValue(null);
            }
            if (credit.signum() > 0 && debit.signum() > 0) {
                if (colKey.equals(COL_DEBIT)) {
                    row.getCell(COL_CREDIT).setValue(null);
                } else {
                    row.getCell(COL_DEBIT).setValue(null);
                }
            }
        }
    }

    @Override
    protected void kdtEntries_editStarted(KDTEditEvent e) throws Exception {
        int iCol = e.getColIndex();
        int iRow = e.getRowIndex();
        String colKey = this.getDetailTable().getColumn(iCol).getKey();
        if (!colKey.equals(COL_CREDIT) || !colKey.equals(COL_DEBIT)) {
            return;
        }
        IRow row = this.getDetailTable().getRow(iRow);
        BigDecimal value = TypeConversionUtils.objToBigDecimal((Object)row.getCell(colKey).getValue());
        if (colKey.equals(COL_CREDIT) && value == null) {
            row.getCell(COL_CREDIT).setValue((Object)SysConstant.BIGZERO);
        }
        if (colKey.equals(COL_DEBIT) && value == null) {
            row.getCell(COL_DEBIT).setValue((Object)SysConstant.BIGZERO);
        }
        super.kdtEntries_editStarted(e);
    }

    protected IObjectValue createNewData() {
        Map uiCtx = this.getUIContext();
        BankStatementInfo info = new BankStatementInfo();
        info.setCompany(this.companyInfo);
        Object newAccountBankInfo = null;
        AccountBankInfo accountBankInfo = null;
        CurrencyInfo localCurrency = null;
        if (uiCtx.get("BANK") != null) {
            AccountBankInfo bankInfo = (AccountBankInfo)uiCtx.get("BANK");
            info.setAccountBank(bankInfo);
            try {
                accountBankInfo = !this.isFirstOpenAndAdd && this.prmtBank.getValue() != null ? (AccountBankInfo)this.prmtBank.getValue() : (AccountBankInfo)this.getUIContext().get("accountBank");
                info.setAccountBank(accountBankInfo);
                this.company = info.getCompany();
                this.companyInfo = info.getCompany();
                localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.companyInfo);
                AccountViewInfo acctInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId()));
                info.setAccountView(acctInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (uiCtx.get("currency") != null) {
            info.setCurrency((CurrencyInfo)uiCtx.get("currency"));
        }
        if (this.kdtEntries.getRowCount() > 0) {
            KDTSelectBlock selectBlock = this.kdtEntries.getSelectManager().get();
            if (selectBlock != null) {
                int rowIndex = selectBlock.getBottom();
                info.setCreateDate((Date)this.kdtEntries.getRow(rowIndex).getCell(COL_DATE).getValue());
            } else {
                info.setCreateDate((Date)this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell(COL_DATE).getValue());
            }
        } else {
            Date date = new Date();
            if (date.after(this.casPeriod.getEndDate())) {
                date = this.casPeriod.getEndDate();
            }
            if (date.before(this.casPeriod.getBeginDate())) {
                date = this.casPeriod.getBeginDate();
            }
            info.setCreateDate(date);
        }
        info.setVerifyStatus(VerifyScopeEnum.NOVA);
        if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
            info.setCurrency(newAccountBankInfo.getCurrency());
            this.comboCurrency.setEnabled(false);
        } else if (accountBankInfo != null && accountBankInfo.isIsByCurrency()) {
            info.setCurrency(accountBankInfo.getCurrency());
        } else {
            info.setCurrency(localCurrency);
        }
        return info;
    }

    private void initTable(KDTable table) {
        table.removeRows();
        Date date = new Date();
        if (date.after(this.casPeriod.getEndDate())) {
            date = this.casPeriod.getEndDate();
        }
        if (date.before(this.casPeriod.getBeginDate())) {
            date = this.casPeriod.getBeginDate();
        }
        for (int i = 0; i < 2; ++i) {
            IRow row = table.addRow();
            row.getCell(COL_DATE).setValue((Object)date);
            try {
                this.setDateRelatedPeriod(i);
                continue;
            }
            catch (Exception e) {
                this.setBtnsStatus(false);
            }
        }
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    IObjectValue detailData = BankStatementUI.this.createNewData();
                    BankStatementInfo info = (BankStatementInfo)detailData;
                    IRow row = BankStatementUI.this.kdtEntries.getRow(BankStatementUI.this.kdtEntries.getRowCount() - 1);
                    row.getCell(BankStatementUI.COL_DATE).setValue((Object)info.getCreateDate());
                    row.getCell(BankStatementUI.COL_DESC).setValue((Object)info.getDescription());
                    BankStatementUI.this.setDateRelatedPeriod(BankStatementUI.this.kdtEntries.getRowCount() - 1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    IObjectValue detailData = BankStatementUI.this.createNewData();
                    BankStatementInfo info = (BankStatementInfo)detailData;
                    IRow row = BankStatementUI.this.kdtEntries.getRow(BankStatementUI.this.kdtEntries.getRowCount() - 1);
                    row.getCell(BankStatementUI.COL_DATE).setValue((Object)info.getCreateDate());
                    row.getCell(BankStatementUI.COL_DESC).setValue((Object)info.getDescription());
                    BankStatementUI.this.setDateRelatedPeriod(BankStatementUI.this.kdtEntries.getRowCount() - 1);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankStatementFactory.getRemoteInstance();
    }

    private void setBtnsStatus(boolean fStatus) {
        this.actionSubmit.setEnabled(fStatus);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionAddLine.setEnabled(fStatus);
        this.actionInsertLine.setEnabled(fStatus);
        this.actionRemoveLine.setEnabled(fStatus);
        this.actionCopyLine.setEnabled(fStatus);
    }

    protected void verifyInput(ActionEvent e) {
        int result;
        if (this.prmtBank.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Bank_NullMsg"));
            SysUtil.abort();
        } else {
            AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getData();
            if (bankInfo.isIsClosed()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"434_BankJournalAddBatchUI"));
                SysUtil.abort();
            }
        }
        if (this.txtAccount.getUserObject() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Bank_NullMsg"));
            SysUtil.abort();
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Currency_NullMsg"));
            SysUtil.abort();
        }
        Object oCredits = null;
        Object oDebits = null;
        IRow row = null;
        PeriodInfo periodInfo = null;
        String msg = EASResource.getString((String)casResourcePath, (String)"moreDateNotPeriod");
        String rowMsg = EASResource.getString((String)casResourcePath, (String)"moreDateNotPeriodDetail");
        StringBuffer detail = new StringBuffer();
        try {
            periodInfo = ClientUtils.getCurrentPeriod((Component)((Object)this), this.companyInfo);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        Date beginDate = periodInfo.getBeginDate();
        Date bizDate = null;
        String currentYear = String.valueOf(periodInfo.getPeriodYear());
        String currentMonth = String.valueOf(periodInfo.getNumber()).substring(4);
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell(COL_PERIOD).getUserObject() == null) {
                String message = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Period_Is_Null"), i + 1);
                MsgBox.showWarning((Component)((Object)this), (String)message);
                this.kdtEntries.getSelectManager().set(i, 0);
                SysUtil.abort();
            }
            if (!CashHelper.isDatePeriod(bizDate = (Date)row.getCell(COL_DATE).getValue(), periodInfo, this.companyInfo)) {
                Object[] objects = new Object[]{String.valueOf(i + 1), DateFormat.getDateInstance().format(bizDate), currentYear, currentMonth};
                detail.append(MessageFormat.format(rowMsg, objects)).append("\n");
            }
            if (!this.canAddPreviousBill && bizDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"bizDateNull"));
                SysUtil.abort();
            }
            if (!this.canAddPreviousBill && bizDate.compareTo(beginDate) < 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"cannotAddPervioursBill"));
                SysUtil.abort();
            }
            oDebits = row.getCell(COL_DEBIT).getValue();
            oCredits = row.getCell(COL_CREDIT).getValue();
            BankStatementHandler.verfiyCreditDebit((Component)((Object)this), oCredits, oDebits);
            oCredits = null;
            oDebits = null;
        }
        if (!CashHelper.isEmpty(detail.toString()) && (result = MsgBox.showConfirm3((Component)((Object)this), (String)msg, (String)detail.toString())) == 1) {
            SysUtil.abort();
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        if (obj == null) {
            return;
        }
        BankStatementInfo info = (BankStatementInfo)obj;
        row.getCell(COL_DATE).setValue((Object)info.getCreateDate());
        row.getCell(COL_DESC).setValue((Object)info.getDescription());
    }

    @Override
    public void actionImportOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportOption_actionPerformed(e);
        if (this.companyInfo != null) {
            BankStatementOptionUI.showDialogWindows((IUIObject)this, this.companyInfo);
        }
    }

    @Override
    public void actionCalc_actionPerformed(ActionEvent e) throws Exception {
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = 2;
        if (currency != null) {
            pre = currency.getPrecision();
        }
        BigDecimal value = this.calc.showDialog(pre, true);
        if (this.kdtEntries.getSelectManager() != null) {
            int row = this.kdtEntries.getSelectManager().getActiveRowIndex();
            int col = this.kdtEntries.getSelectManager().getActiveColumnIndex();
            if (row == -1 || col == -1) {
                return;
            }
            String selectColName = this.kdtEntries.getColumn(col).getKey();
            if (selectColName.equals(COL_DEBIT) || selectColName.equals(COL_CREDIT)) {
                BigDecimal preVal = TypeConversionUtils.objToBigDecimal((Object)this.kdtEntries.getRow(row).getCell(col).getValue());
                this.kdtEntries.getRow(row).getCell(col).setValue((Object)value);
                this.kdtEntries_editStopped(new KDTEditEvent((Object)this.kdtEntries.getRow(row).getCell(col), (Object)preVal, (Object)value, row, col, false, 1));
            }
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void actionCalculateAmt_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal recentAmt = Constants.ZERO;
        String bankId = AccessHelper.getF7Id((KDBizPromptBox)this.prmtBank);
        String currencyId = AccessHelper.getCboId((KDComboBox)this.comboCurrency);
        String companyId = this.companyInfo.getId().toString();
        if (this.kdtEntries.getRow(0) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"268_BankStatementUI"));
            return;
        }
        Date startDate = (Date)this.kdtEntries.getRow(0).getCell(COL_DATE).getValue();
        startDate = DateHelper.getNextDay((Date)startDate);
        recentAmt = BankStatementFactory.getRemoteInstance().getRecentAmt(bankId, currencyId, companyId, startDate);
        BigDecimal creditAmt = Constants.ZERO;
        BigDecimal debitAmt = Constants.ZERO;
        BigDecimal refAmt = Constants.ZERO;
        boolean creditNotNull = true;
        boolean debitcreditNotNull = true;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            creditAmt = Constants.ZERO;
            debitAmt = Constants.ZERO;
            refAmt = Constants.ZERO;
            creditNotNull = true;
            debitcreditNotNull = true;
            if (this.kdtEntries.getRow(i).getCell(COL_CREDIT).getValue() != null) {
                creditAmt = new BigDecimal(this.kdtEntries.getRow(i).getCell(COL_CREDIT).getValue().toString());
            } else {
                creditNotNull = false;
            }
            if (this.kdtEntries.getRow(i).getCell(COL_DEBIT).getValue() != null) {
                debitAmt = new BigDecimal(this.kdtEntries.getRow(i).getCell(COL_DEBIT).getValue().toString());
            } else {
                debitcreditNotNull = false;
            }
            refAmt = recentAmt.add(creditAmt).subtract(debitAmt);
            if (creditNotNull || debitcreditNotNull) {
                this.kdtEntries.getRow(i).getCell(COL_REF).setValue((Object)refAmt);
                CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
                FMClientHelper.setNumberFormat((IRow)this.kdtEntries.getRow(i), (String)COL_REF, (String)currencyInfo.getId().toString());
            }
            this.kdtEntries.getRow(i).getCell(COL_REF).getStyleAttributes().setLocked(true);
            recentAmt = refAmt;
        }
    }

    public void addLine() {
        IObjectValue detailData = this.createNewData();
        IRow row = this.kdtEntries.addRow();
        BankStatementInfo info = (BankStatementInfo)detailData;
        row.getCell(COL_DATE).setValue((Object)info.getCreateDate());
        row.getCell(COL_DESC).setValue((Object)info.getDescription());
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (chgVo == null || !chgVo.isDiffrent()) {
            return;
        }
        if (chgVo.getNewOrg() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_BankJournalAddBatchUI"));
            SysUtil.abort();
        }
        try {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)chgVo.getNewOrg()));
            if (null == startPeriod) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"435_BankJournalAddBatchUI"));
                this.prmtCompany.setValue(chgVo.getOldOrg());
                return;
            }
            Context mainContext = this.orgContextManager.getMainOrgContext();
            this.context = ContextHelperFactory.getRemoteInstanceWithContext((Context)mainContext);
            this.companyInfo = this.context.getCurrentCompany();
            this.initUI(this.companyInfo);
            if ((CompanyOrgUnitInfo)this.getUIContext().get("company") == this.companyInfo) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, this.getUIContext().get("currency"));
                this.prmtBank.setValue(this.getUIContext().get("accountBank"));
                try {
                    this.prmtBank_dataChanged(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ClientUtils.getStartPeriodInfo((Component)((Object)this), this.companyInfo);
            this.casPeriod = CashClientHelper.getCurrentPeriod(this.companyInfo);
            CashHelper.initCombCurrency(this.comboCurrency, false, this.companyInfo);
            this.setBankF7(this.prmtBank, this.company, false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public IF7ContextChange getF7ContextManager() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return null;
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        return "cas_bankstatement_02addNew";
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    private void setBankF7(KDBizPromptBox prmt, CompanyOrgUnitInfo info, boolean isClosed) throws BOSException, EASBizException {
        int i;
        ClientUtils.setBankListIncludeShared(prmt, info.getId().toString(), isClosed);
        String companyId = info.getId().toString();
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)companyId)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (!isClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bankAccount.id");
        sic.add("bankAccount.company.id");
        sic.add("entries.accountBank.company.id");
        view.setSelector(sic);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            SharedAcctInfo sharedAcct = coll.get(i2);
            AccountBankInfo bankAcct = sharedAcct.getBankAccount();
            if (bankAcct.getCompany().getId().equals((Object)info.getId())) {
                sharedAcctSet.add(bankAcct.getId().toString());
                continue;
            }
            SharedAcctEntriesCollection colls = sharedAcct.getEntries();
            for (int index = 0; index < colls.size(); ++index) {
                bankAcct = colls.get(index).getAccountBank();
                if (!bankAcct.getCompany().getId().equals((Object)info.getId())) continue;
                sharedAcctSet.add(bankAcct.getId().toString());
            }
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!isClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(this.company.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e);
        }
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        prmt.setEntityViewInfo(evi);
        EventListener[] el = prmt.getListeners(DataChangeListener.class);
        for (i = 0; i < el.length; ++i) {
            prmt.removeDataChangeListener((DataChangeListener)el[i]);
        }
        for (i = 0; i < el.length; ++i) {
            prmt.addDataChangeListener((DataChangeListener)el[i]);
        }
        prmt.setValue((Object)acctBankCol.get(0));
    }
}

