/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.AccessHelper;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BankVCFilterParam;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.client.AbstractBankVCFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankVCFilterUI
extends AbstractBankVCFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankVCFilterUI.class.getName());
    private CompanyOrgUnitInfo company;
    AccountBankCollection acctBankColl = null;
    private boolean isLoaded;
    private boolean isSharedOrg = false;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";

    public BankVCFilterUI() throws Exception {
    }

    public BankVCFilterUI(BankVCFilterParam param) throws Exception {
        this.setParam(param);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isLoaded) {
            this.init();
        }
        this.isLoaded = true;
        this.prmtCompany.setEnabled(this.isSharedOrg());
    }

    protected void init() throws Exception {
        NewCompanyF7 f7Selector = new NewCompanyF7();
        f7Selector.setUIActionPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.client", "BankVcCheckUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.prmtCompany.setSelector((KDPromptSelector)f7Selector);
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        if (curCompany == null) {
            curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (curCompany.isIsBizUnit()) {
            IPermission iPermisson = PermissionFactory.getRemoteInstance();
            boolean flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "cas_bankVcCheck_01view");
            if (flag) {
                this.company = curCompany;
                this.prmtCompany.setValue((Object)curCompany);
            } else {
                this.company = this.getCompanyOrgUnitInfoByUserPermisson();
                this.prmtCompany.setValue((Object)this.company);
            }
        } else {
            this.company = this.getCompanyOrgUnitInfoByUserPermisson();
            this.prmtCompany.setValue((Object)this.company);
        }
        if (this.company != null && this.company.isIsBizUnit()) {
            PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
            String strCompanyId = this.company.getId().toString();
            this.acctBankColl = CashClientHelper.getAccountBankCollection(strCompanyId, false);
            if (this.acctBankColl != null) {
                this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
            }
        }
        String date = this.spYear.getValue() + "-" + this.spPeriodNum.getValue() + "-01";
        Date periodDate = DateUtil.stringToDate((String)date);
        this.beginDate.setValue((Object)periodDate);
        Date eDate = DateUtil.getLastDayOfMonth((Date)periodDate);
        if (eDate.after(DateTimeUtils.truncateDate((Date)new Date()))) {
            this.endDate.setValue((Object)DateTimeUtils.truncateDate((Date)new Date()));
        } else {
            this.endDate.setValue((Object)DateUtil.getLastDayOfMonth((Date)periodDate));
        }
        this.chkDestroyed.setSelected(false);
    }

    public void clear() {
        super.clear();
        try {
            if (this.prmtCompany.getData() == null) {
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                    CompanyOrgUnitInfo orgRang = this.getCompanyOrgUnitInfoByUserPermisson();
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)orgRang)) {
                        this.company = orgRang;
                        this.prmtCompany.setValue((Object)this.company);
                    }
                } else {
                    this.prmtCompany.setValue((Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
                }
                if (this.company != null && this.company.isIsBizUnit()) {
                    FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency());
                    PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
                }
            }
            this.radioBtnPeriod.setSelected(true);
            if (this.company != null && this.company.isIsBizUnit()) {
                PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.company == null || this.company.isIsBizUnit()) {
            // empty if block
        }
        this.chkDestroyed.setSelected(false);
    }

    private void setStateByPeriod(boolean bln) {
        this.lblPeriod.setVisible(bln);
        this.spYear.setVisible(bln);
        this.lblPeriodNum.setVisible(bln);
        this.spPeriodNum.setVisible(bln);
    }

    private void setStateByDate(boolean bln) {
        this.lblBeginDate.setVisible(bln);
        this.beginDate.setVisible(bln);
        this.lblEndDate.setVisible(bln);
        this.endDate.setVisible(bln);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() == null || e.getNewValue() == e.getOldValue()) {
            return;
        }
        this.company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        if (!this.company.isIsBizUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_BankBalanceAdjustmentBFilterUI"));
            this.prmtCompany.setData(e.getOldValue());
            SysUtil.abort();
        }
        PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
        String strCompanyId = this.company.getId().toString();
        this.acctBankColl = CashClientHelper.getAccountBankCollection(strCompanyId, true);
        CasContrastGLHelper.initComboCurrency(this.cboCurrency, true, this.company);
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
    }

    @Override
    protected void radioBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.radioBtnPeriod.isSelected()) {
            this.setStateByPeriod(true);
            this.setStateByDate(false);
            PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
        }
    }

    @Override
    protected void radioBtnDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radioBtnDate.isSelected()) {
            this.setStateByPeriod(false);
            this.setStateByDate(true);
        }
    }

    public Object getParam() {
        BankVCFilterParam param = new BankVCFilterParam();
        param.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getData());
        if (this.radioBtnPeriod.isSelected()) {
            param.setType(4);
            int year = (Integer)this.spYear.getValue();
            param.setPeriodYear(year);
            int periodNum = (Integer)this.spPeriodNum.getValue();
            param.setPeriodNum(periodNum);
            PeriodInfo periodInfo = CasContrastGLHelper.getPeriodInfo(year, periodNum, (CompanyOrgUnitInfo)this.prmtCompany.getData());
            param.setBeginDate(DateUtil.getSQLEnd((Date)FMHelper.getDate((int)1900, (int)1, (int)1)));
            param.setEndDate(DateUtil.getSQLEnd((Date)periodInfo.getEndDate()));
        } else if (this.radioBtnDate.isSelected()) {
            param.setType(3);
            param.setBeginDate(DateUtil.getSQLBegin((Date)this.beginDate.getSqlDate()));
            param.setEndDate(DateUtil.getSQLEnd((Date)this.endDate.getSqlDate()));
        }
        String actualAcctTableId = null;
        if (this.radioBtnPeriod.isSelected()) {
            int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spYear);
            int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum);
            try {
                String companyid = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString();
                actualAcctTableId = CashAccountTool.getDisplayAcctTable(companyid, null, beginYear, beginMonth, beginYear, beginMonth);
            }
            catch (EASBizException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
            catch (BOSException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
        } else {
            String companyid = ((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString();
            Date _beginDate = DateTimeUtils.truncateDate((Date)this.beginDate.getSqlDate());
            Date _endDate = DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate());
            actualAcctTableId = FMClientHelper.getActualAcctTable((String)companyid, (Date)_beginDate, (Date)_endDate);
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        String displayFormat = accountBankInfo.getDisplayFormat();
        try {
            accountBankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)accountBankInfo, null, (String)actualAcctTableId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        accountBankInfo.setDisplayFormat(displayFormat);
        param.setAccountBank(accountBankInfo);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        param.setCurrency(currencyInfo);
        param.setDestroyedAccount(this.chkDestroyed.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (!(param instanceof BankVCFilterParam)) {
            return;
        }
        BankVCFilterParam filterParam = (BankVCFilterParam)param;
        try {
            if (EmptyUtil.isEmpty((CoreBaseInfo)filterParam.getCompany())) {
                this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
            } else {
                this.prmtCompany.setValue((Object)filterParam.getCompany());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.spYear.setValue((Object)new Integer(filterParam.getPeriodYear()), false);
        this.spPeriodNum.setValue((Object)new Integer(filterParam.getPeriodNum()));
        this.beginDate.setValue((Object)filterParam.getBeginDate());
        this.endDate.setValue((Object)filterParam.getEndDate());
        switch (filterParam.getType()) {
            case 4: {
                this.radioBtnPeriod.setSelected(true);
                break;
            }
            case 3: {
                this.radioBtnDate.setSelected(true);
            }
        }
        this.chkDestroyed.setSelected(filterParam.isDestroyedAccount());
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)filterParam.getCurrency());
        this.prmtBankAccount.setDataNoNotify((Object)filterParam.getAccountBank());
    }

    @Override
    protected void spYear_stateChanged(ChangeEvent e) throws Exception {
        super.spYear_stateChanged(e);
        this.spPeriodNum.setModel((SpinnerModel)PeriodHelper.getMonthSnm(this.company, (Integer)this.spYear.getValue()));
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtBankAccount, (String)"Bank_NullMsg");
        if (!this.hasDate()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"WARNING_QUERY_DateRange"));
            return false;
        }
        String strCheck = this.getCheckMessage();
        if (strCheck != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)strCheck));
            return false;
        }
        return super.verify();
    }

    private boolean hasDate() {
        if (this.radioBtnPeriod.isSelected()) {
            if (this.spYear.getValue() != null && this.spPeriodNum.getValue() != null) {
                return true;
            }
            this.spYear.grabFocus();
            this.spPeriodNum.grabFocus();
            return false;
        }
        if (this.radioBtnDate.isSelected()) {
            if (this.beginDate.getSqlDate() != null && this.endDate.getSqlDate() != null) {
                return true;
            }
            this.beginDate.grabFocus();
            this.endDate.grabFocus();
            return false;
        }
        return true;
    }

    private String getCheckMessage() {
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = ClientUtils.getCurrentPeriod(null, this.company);
        }
        catch (EASBizException e) {
            return null;
        }
        catch (BOSException e) {
            return null;
        }
        if (this.radioBtnPeriod.isSelected()) {
            int currentYear = currentPeriod.getPeriodYear();
            int year = (Integer)this.spYear.getValue();
            int currentNum = currentPeriod.getPeriodNumber();
            int spNum = (Integer)this.spPeriodNum.getValue();
            if (year <= currentYear && (year != currentYear || spNum <= currentNum) && spNum <= 12) {
                this.spYear.grabFocus();
                this.spPeriodNum.grabFocus();
                return null;
            }
        }
        if (this.radioBtnDate.isSelected()) {
            if (DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.beginDate.getSqlDate()))) {
                this.beginDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            this.endDate.grabFocus();
            return null;
        }
        return null;
    }

    public void bankAccountQueryInfo() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        if (!this.chkDestroyed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.prmtBankAccount.setSelectorCollection(selectors);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void chkDestroyed_itemStateChanged(ItemEvent e) throws Exception {
        super.chkDestroyed_itemStateChanged(e);
        if (!this.chkDestroyed.isSelected()) {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtBankAccount.getValue();
            if (accountBank == null) {
                return;
            }
            if (accountBank.getCloseDate() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtBankAccount.setEntityViewInfo(evi);
                if (this.acctBankColl != null) {
                    this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
                } else {
                    this.prmtBankAccount.setValue(null);
                }
            }
        }
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAccount_willCommit(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAccount_willShow(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        CurrencyInfo currency = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) && bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            this.cboCurrency.setEnabled(false);
        } else {
            currency = this.company.getBaseCurrency();
            this.cboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
    }

    protected Class getParamClass() {
        return BankVCFilterParam.class;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        if (this.checkCurrentCompany()) {
            return this.currentCompany;
        }
        CompanyOrgUnitCollection companyColl = FMHelper.getUserOrgRangesWithRangeOfStart(null, (String)"cas_bankVcCheck_01view", (boolean)false, (boolean)false, (boolean)false);
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    private boolean checkCurrentCompany() throws EASBizException, BOSException {
        if (this.currentCompany.isIsBizUnit() && !this.currentCompany.isIsOUSealUp() && !this.currentCompany.isIsAssistantOrg()) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            if (null == startPeriod) {
                return false;
            }
        } else {
            return false;
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        IPermission permission = PermissionFactory.getRemoteInstance();
        boolean hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), this.getPermissionItem());
        return hasPermission;
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return false;
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

