/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankVCResultFilterParam;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.client.AbstractBankVCResultFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankVCResultFilterUI
extends AbstractBankVCResultFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BankVCResultFilterUI.class);
    private CompanyOrgUnitInfo company = null;
    String strCompanyId = null;
    AccountBankCollection acctBankColl = null;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private boolean isLoaded;
    private BankVCResultFilterParam param;

    public BankVCResultFilterUI() throws Exception {
    }

    public BankVCResultFilterUI(BankVCResultFilterParam param) throws Exception {
        this.param = param;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isLoaded) {
            this.init();
        }
        this.isLoaded = true;
    }

    public void clear() {
        super.clear();
        this.radioBtnPeriod.setSelected(true);
        try {
            PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        try {
            this.acctBankColl = CashClientHelper.getAccountBankCollection(this.strCompanyId, false);
            if (this.prmtBankAccount.getValue() != null) {
                this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.company.getBaseCurrency());
    }

    private void init() throws Exception {
        this.company = this.param == null || this.param.getCompanyInfo() == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : this.param.getCompanyInfo();
        PeriodHelper.initPeriodSpinner(this.company, this.spYear, this.spPeriodNum);
        this.strCompanyId = this.company.getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.acctBankColl = CashClientHelper.getAccountBankCollection(this.strCompanyId, false);
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
        CasContrastGLHelper.initComboCurrency(this.cboCurrency, true);
    }

    private void setStateByPeriod(boolean bln) {
        this.lblPeriod.setVisible(bln);
        this.spYear.setVisible(bln);
        this.lblPeriodNum.setVisible(bln);
        this.spPeriodNum.setVisible(bln);
    }

    private void setStateByDate(boolean bln) {
        this.lblBeginDate.setVisible(bln);
        this.beginDate.setVisible(bln);
        this.lblEndDate.setVisible(bln);
        this.endDate.setVisible(bln);
    }

    @Override
    protected void radioBtnPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.radioBtnPeriod_stateChanged(e);
        if (this.radioBtnPeriod.isSelected()) {
            this.setStateByPeriod(true);
            this.setStateByDate(false);
        }
    }

    @Override
    protected void radioBtnDate_stateChanged(ChangeEvent e) throws Exception {
        super.radioBtnDate_stateChanged(e);
        if (this.radioBtnDate.isSelected()) {
            this.setStateByPeriod(false);
            this.setStateByDate(true);
        }
    }

    public Object getParam() {
        if (this.param != null && this.param.isDirectShow()) {
            return this.param;
        }
        BankVCResultFilterParam param = new BankVCResultFilterParam();
        param.setCompanyInfo(this.company);
        if (this.radioBtnPeriod.isSelected()) {
            param.setType(4);
        } else if (this.radioBtnDate.isSelected()) {
            param.setType(3);
        }
        int year = (Integer)this.spYear.getValue();
        param.setPeriodYear(year);
        int periodNum = (Integer)this.spPeriodNum.getValue();
        param.setPeriodNum(periodNum);
        PeriodInfo periodInfo = CasContrastGLHelper.getPeriodInfo(year, periodNum);
        if (this.radioBtnPeriod.isSelected()) {
            param.setBeginDate(DateHelper.getSQLBegin((Date)periodInfo.getBeginDate()));
            param.setEndDate(DateHelper.getSQLEnd((Date)periodInfo.getEndDate()));
        } else {
            param.setBeginDate(DateHelper.getSQLBegin((Date)this.beginDate.getSqlDate()));
            param.setEndDate(DateHelper.getSQLEnd((Date)this.endDate.getSqlDate()));
        }
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        param.setAccountBank(accountBankInfo);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        param.setCurrency(currencyInfo);
        param.setIsCurrentResult(this.chkCurrentResult.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (!(param instanceof BankVCResultFilterParam)) {
            return;
        }
        this.param = (BankVCResultFilterParam)((Object)param);
        this.loadData();
    }

    public void loadData() {
        if (this.param == null) {
            return;
        }
        this.company = this.param.getCompanyInfo() == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : this.param.getCompanyInfo();
        switch (this.param.getType()) {
            case 4: {
                this.radioBtnPeriod.setSelected(true);
                this.spYear.setValue((Object)new Integer(this.param.getPeriodYear()));
                this.spPeriodNum.setValue((Object)new Integer(this.param.getPeriodNum()));
                break;
            }
            case 3: {
                this.radioBtnDate.setSelected(true);
                this.beginDate.setValue((Object)this.param.getBeginDate());
                this.endDate.setValue((Object)this.param.getEndDate());
            }
        }
        this.prmtBankAccount.setValue((Object)this.param.getAccountBank());
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.param.getCurrency());
        this.chkCurrentResult.setSelected(this.param.isCurrentResult());
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
    }

    public boolean verify() {
        if (!this.chkCurrentResult.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtBankAccount, (String)"Bank_NullMsg");
        }
        if (this.radioBtnDate.isSelected() && DateTimeUtils.truncateDate((Date)this.endDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.beginDate.getSqlDate()))) {
            this.beginDate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"EndDateBeforeBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void bankAccountQueryInfo() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
        if (!this.chkDestroyed.isSelected()) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBankAccount.setEntityViewInfo(evi);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void chkDestroyed_itemStateChanged(ItemEvent e) throws Exception {
        super.chkDestroyed_itemStateChanged(e);
        if (!this.chkDestroyed.isSelected()) {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtBankAccount.getValue();
            if (accountBank == null) {
                return;
            }
            if (accountBank.getCloseDate() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.strCompanyId));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)"false"));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtBankAccount.setEntityViewInfo(evi);
                this.acctBankColl = CashClientHelper.getAccountBankCollection(this.strCompanyId, false);
                if (this.acctBankColl != null) {
                    this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
                } else {
                    this.prmtBankAccount.setValue(null);
                }
            }
        }
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAccount_willCommit(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAccount_willShow(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void spYear_stateChanged(ChangeEvent e) throws Exception {
        super.spYear_stateChanged(e);
        this.spPeriodNum.setModel((SpinnerModel)PeriodHelper.getMonthSnm(this.company, (Integer)this.spYear.getValue()));
    }

    @Override
    protected void chkCurrentResult_actionPerformed(ActionEvent e) throws Exception {
        super.chkCurrentResult_actionPerformed(e);
        if (this.chkCurrentResult.isSelected()) {
            this.prmtBankAccount.setEnabled(false);
            this.cboCurrency.setEnabled(false);
            this.spYear.setEnabled(false);
            this.spPeriodNum.setEnabled(false);
            this.beginDate.setEnabled(false);
            this.endDate.setEnabled(false);
        } else {
            this.prmtBankAccount.setEnabled(true);
            this.cboCurrency.setEnabled(true);
            this.spYear.setEnabled(true);
            this.spPeriodNum.setEnabled(true);
            this.beginDate.setEnabled(true);
            this.endDate.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerParams getCustomerParams() {
        Object param = this.getParam();
        if (param == null) {
            return null;
        }
        CustomerParams cp = new CustomerParams();
        ObjectOutputStream objectOs = null;
        try {
            ByteOutputStream byteOs = new ByteOutputStream();
            objectOs = new ObjectOutputStream((OutputStream)byteOs);
            objectOs.writeObject(param);
            byte[] bytes = byteOs.getBytes();
            String paramValue = new String(FMHelper.encode((byte[])bytes));
            cp.addCustomerParam("fmcustomer", paramValue);
            FMHelper.close((ObjectOutputStream)objectOs);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            FMHelper.close(objectOs);
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setCustomerParams(CustomerParams cp) {
        Object param;
        block9: {
            if (cp == null) {
                return;
            }
            String paramValue = cp.getCustomerParam("fmcustomer");
            if (FMHelper.isEmpty((String)paramValue)) {
                return;
            }
            param = null;
            ObjectInputStream objectIs = null;
            try {
                byte[] bytes = FMHelper.decode((byte[])paramValue.getBytes());
                ByteInputStream byteIs = new ByteInputStream(bytes, bytes.length);
                objectIs = new ObjectInputStream((InputStream)byteIs);
                param = objectIs.readObject();
                FMHelper.close((ObjectInputStream)objectIs);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            catch (ClassNotFoundException e2) {
                logger.error((Object)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FMHelper.close(objectIs);
            }
        }
        this.setParam(param);
    }

    public void setFilterParam(BankVCResultFilterParam param) {
        this.param = param;
    }
}

