/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultInfo;
import com.kingdee.eas.base.vc.VcVerifyInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.client.AbstractBankVcCheckResultUI;
import com.kingdee.eas.fi.cas.client.BankVCHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.FindListEvent;
import com.kingdee.eas.framework.client.IFindListListener;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class BankVcCheckResultUI
extends AbstractBankVcCheckResultUI {
    private AccountBankInfo bankInfo;
    private PeriodInfo periodInfo;
    private CurrencyInfo currencyInfo;
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CheckoutResource";
    private HashMap journalMap;
    private HashMap bankMap;
    private Set journalSet;
    private Set bankSet;
    private String numberFmt = "00.00";
    boolean isFirstFind = true;
    private static String locateFirst = "Msg_LocateFirst";
    private static String locateLast = "Msg_LocateLast";
    private FindDialog findDialog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAllClear.setEnabled(true);
        this.btnAllSelect.setEnabled(true);
        this.btnCancel.setVisible(false);
        this.initData();
        this.fillTable();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAllClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemCancel.setEnabled(false);
        this.menuItemCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.setButtonDefaultStyl(this.btnLocate);
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
    }

    private void initData() {
        this.bankInfo = (AccountBankInfo)this.getUIContext().get("bankInfo");
        this.periodInfo = (PeriodInfo)this.getUIContext().get("periodInfo");
        AccountViewInfo acctView = this.bankInfo.getAccount();
        this.currencyInfo = (CurrencyInfo)this.getUIContext().get("currencyInfo");
        int type = (Integer)this.getUIContext().get("type");
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        this.numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.currencyInfo.getId());
        this.txtBankAccount.setUserObject((Object)this.bankInfo);
        this.txtBankAccount.setText(this.bankInfo.getNumber() + " - " + this.bankInfo.getName());
        this.txtCurrency.setUserObject((Object)this.currencyInfo);
        this.txtCurrency.setText(this.currencyInfo.getName());
        this.txtAccountView.setUserObject((Object)acctView);
        this.txtAccountView.setText(acctView.getName());
        this.txtPeriod.setUserObject((Object)this.periodInfo);
        if (type == 3) {
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Lbl_Date"));
            this.txtPeriod.setText(beginDate + "\u2014" + endDate);
        } else {
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Lbl_PeriodDesc"));
            String[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
        }
    }

    private void fillTable() {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        this.tblMain.addColumn(0).setKey("group");
        this.tblMain.getColumn("group").getStyleAttributes().setHided(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setHashMap();
        VcVerifyInfo result = this.getVcResult();
        VcResultCollection resultColl = new VcResultCollection();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)resultColl)) {
            int m = resultColl.size();
            for (int i = 0; i < m; ++i) {
                IRow tmpRow;
                BankStatementInfo boInfo;
                BOSUuid boId;
                VcResultInfo resultInfo = resultColl.get(i);
                if (resultInfo == null || (boId = resultInfo.getBizObjectId()) == null) continue;
                if (resultInfo.getBizObjectFullName().endsWith("BankStatement")) {
                    boInfo = (BankStatementInfo)this.bankMap.get(boId.toString());
                    if (boInfo == null) continue;
                    tmpRow = this.tblMain.addRow();
                    tmpRow.setUserObject((Object)resultInfo);
                    tmpRow.getCell("group").setValue((Object)new Integer(resultInfo.getGroup()));
                    tmpRow.getCell("select").setValue((Object)Boolean.FALSE);
                    tmpRow.getCell("select").getStyleAttributes().setLocked(false);
                    tmpRow.getCell("record").setValue((Object)EASResource.getString((String)resourcePath, (String)"BankCheckRecord"));
                    tmpRow.getCell("date").setValue((Object)boInfo.getCreateDate());
                    tmpRow.getCell("date").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("settNumber").setValue((Object)boInfo.getSettleNumber());
                    tmpRow.getCell("settNumber").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("settType").setValue((Object)boInfo.getSettleType().getName());
                    tmpRow.getCell("settType").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("description").setValue((Object)boInfo.getDescription());
                    tmpRow.getCell("description").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("debitAmount").setValue((Object)boInfo.getDebitAmount());
                    tmpRow.getCell("debitAmount").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("creditAmount").setValue((Object)boInfo.getCreditAmount());
                    tmpRow.getCell("creditAmount").getStyleAttributes().setLocked(true);
                    tmpRow.getCell("debitAmount").getStyleAttributes().setNumberFormat(this.numberFmt);
                    tmpRow.getCell("creditAmount").getStyleAttributes().setNumberFormat(this.numberFmt);
                    continue;
                }
                boInfo = (JournalInfo)this.journalMap.get(boId.toString());
                if (boInfo == null) continue;
                tmpRow = this.tblMain.addRow();
                tmpRow.setUserObject((Object)resultInfo);
                tmpRow.getCell("group").setValue((Object)new Integer(resultInfo.getGroup()));
                tmpRow.getCell("select").setValue((Object)Boolean.FALSE);
                tmpRow.getCell("select").getStyleAttributes().setLocked(false);
                tmpRow.getCell("record").setValue((Object)EASResource.getString((String)resourcePath, (String)"BankJournalRecord"));
                tmpRow.getCell("date").setValue((Object)boInfo.getCreateDate());
                tmpRow.getCell("bizDate").setValue((Object)boInfo.getBizDate());
                tmpRow.getCell("settNumber").setValue((Object)boInfo.getSettlementNumber());
                tmpRow.getCell("settType").setValue((Object)boInfo.getSettlementType().getName());
                tmpRow.getCell("description").setValue((Object)boInfo.getDescription());
                if (boInfo.getVoucherNumber() != null) {
                    tmpRow.getCell("voucherNumber").setValue((Object)boInfo.getVoucherNumber());
                }
                if (boInfo.getVoucherType() != null) {
                    tmpRow.getCell("voucherType").setValue((Object)boInfo.getVoucherType().getName());
                }
                tmpRow.getCell("debitAmount").setValue((Object)boInfo.getDebitAmount());
                tmpRow.getCell("creditAmount").setValue((Object)boInfo.getCreditAmount());
                tmpRow.getCell("debitAmount").getStyleAttributes().setNumberFormat(this.numberFmt);
                tmpRow.getCell("creditAmount").getStyleAttributes().setNumberFormat(this.numberFmt);
                if (boInfo.getBillNumber() != null) {
                    tmpRow.getCell("billNumber").setValue((Object)boInfo.getBillNumber());
                }
                if (boInfo.getBillType() == null) continue;
                tmpRow.getCell("billType").setValue((Object)boInfo.getBillType());
            }
        }
        this.tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.setDataMerge();
    }

    private void setHashMap() {
        int scale = 2;
        if (this.currencyInfo != null) {
            scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.currencyInfo.getId());
        }
        VcVerifyInfo result = this.getVcResult();
        VcResultCollection resultColl = new VcResultCollection();
        HashSet<String> bankIdSet = new HashSet<String>();
        HashSet<String> journalIdSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)resultColl)) {
            int m = resultColl.size();
            for (int i = 0; i < m; ++i) {
                BOSUuid boId;
                VcResultInfo resultInfo = resultColl.get(i);
                if (resultInfo == null || (boId = resultInfo.getBizObjectId()) == null) continue;
                if (resultInfo.getBizObjectFullName().endsWith("BankStatement")) {
                    bankIdSet.add(boId.toString());
                    continue;
                }
                journalIdSet.add(boId.toString());
            }
        }
        try {
            this.setBankHashMap(bankIdSet, scale);
            this.setJournalHashMap(journalIdSet, scale);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void setBankHashMap(Set bankIdSet, int scale) throws SQLException {
        IRowSet rs = BankVCHelper.getBankRowsetBySQL(bankIdSet, scale);
        this.bankMap = new HashMap();
        rs.beforeFirst();
        while (rs.next()) {
            BankStatementInfo bsInfo = new BankStatementInfo();
            String id = rs.getString("id");
            bsInfo.setId(BOSUuid.read((String)id));
            bsInfo.setCreateDate(rs.getDate("createDate"));
            bsInfo.setSettleNumber(rs.getString("settleNumber"));
            SettlementTypeInfo settleTypeInfo = new SettlementTypeInfo();
            settleTypeInfo.setName(rs.getString("settleType.name"));
            bsInfo.setSettleType(settleTypeInfo);
            bsInfo.setDescription(rs.getString("description"));
            bsInfo.setDebitAmount(rs.getBigDecimal("debitAmount"));
            bsInfo.setCreditAmount(rs.getBigDecimal("creditAmount"));
            this.bankMap.put(id, bsInfo);
        }
    }

    private void setJournalHashMap(Set journalIdSet, int scale) throws SQLException {
        IRowSet rs = BankVCHelper.getJournalRowsetBySQL(journalIdSet, scale);
        this.journalMap = new HashMap();
        rs.beforeFirst();
        while (rs.next()) {
            String id = rs.getString("id");
            JournalInfo journalInfo = new JournalInfo();
            journalInfo.setId(BOSUuid.read((String)id));
            journalInfo.setCreateDate((Date)rs.getDate("createDate"));
            journalInfo.setBizDate((Date)rs.getDate("bizDate"));
            journalInfo.setSettlementNumber(rs.getString("settlementNumber"));
            SettlementTypeInfo settleTypeInfo = new SettlementTypeInfo();
            settleTypeInfo.setName(rs.getString("settlementType.name"));
            journalInfo.setSettlementType(settleTypeInfo);
            journalInfo.setDescription(rs.getString("description"));
            journalInfo.setVoucherNumber(rs.getString("voucherNumber"));
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setName(rs.getString("voucherType.name"));
            journalInfo.setVoucherType(voucherTypeInfo);
            journalInfo.setDebitAmount(rs.getBigDecimal("debitAmount"));
            journalInfo.setCreditAmount(rs.getBigDecimal("creditAmount"));
            journalInfo.setBillNumber(rs.getString("BILLNUMBER"));
            if (rs.getString("BILLTYPE") != null) {
                journalInfo.setBillType(BillTypeEnum.getEnum(rs.getInt("BILLTYPE")));
            }
            this.journalMap.put(id, journalInfo);
        }
    }

    public void newSetDataMerge() {
        int rowSize = this.tblMain.getRowCount();
        this.tblMain.getColumn("group").setMergeable(true);
        this.tblMain.getColumn("group").setGroup(true);
        this.tblMain.getColumn("select").setMergeable(true);
        this.tblMain.getColumn("select").setGroup(true);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        int beginIndex = 0;
        int endIndex = 0;
        String strGroup = null;
        if (rowSize > 0) {
            strGroup = this.tblMain.getRow(0).getCell("group").getValue().toString();
        }
        for (int i = 0; i < rowSize; ++i) {
            String strTmpGroup = this.tblMain.getRow(i).getCell("group").getValue().toString();
            if (!strGroup.equals(strTmpGroup)) {
                this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
                beginIndex = i;
                endIndex = i;
                strGroup = strTmpGroup;
            } else {
                endIndex = i;
            }
            if (i != rowSize - 1) continue;
            this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
        }
        this.tblMain.getGroupManager().group();
    }

    public void setDataMerge() {
        int rowSize = this.tblMain.getRowCount();
        this.tblMain.getColumn("group").setMergeable(true);
        this.tblMain.getColumn("group").setGroup(true);
        this.tblMain.getColumn("select").setMergeable(true);
        this.tblMain.getColumn("select").setGroup(true);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        int beginIndex = 0;
        int endIndex = 0;
        int group = -1;
        if (rowSize > 0) {
            group = (Integer)this.tblMain.getRow(0).getCell("group").getValue();
        }
        for (int i = 0; i < rowSize; ++i) {
            Integer tmpGroup = (Integer)this.tblMain.getRow(i).getCell("group").getValue();
            if (tmpGroup != group) {
                this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
                beginIndex = i;
                endIndex = i;
                group = tmpGroup;
            } else {
                endIndex = i;
            }
            if (i != rowSize - 1) continue;
            this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
        }
        this.tblMain.getGroupManager().group();
    }

    private void test() {
        for (int i = 0; i < 4; ++i) {
            IRow tmpRow = this.tblMain.addRow();
            tmpRow.getCell("group").setValue((Object)new Integer(1));
            tmpRow.getCell("select").setValue((Object)Boolean.FALSE);
            tmpRow.getCell("date").setValue((Object)new Date());
            tmpRow.getCell("settNumber").setValue((Object)"1111");
            tmpRow.getCell("settType").setValue((Object)"222");
            tmpRow.getCell("description").setValue((Object)"333");
            tmpRow.getCell("voucherNumber").setValue((Object)"444");
            tmpRow.getCell("voucherType").setValue((Object)"555");
            tmpRow.getCell("debitAmount").setValue((Object)new BigDecimal("666"));
            tmpRow.getCell("creditAmount").setValue((Object)new BigDecimal("777"));
        }
    }

    public static void showDialogWindow(IUIObject ui, CompanyOrgUnitInfo companyInfo, AccountBankInfo bankAcct, CurrencyInfo currency, PeriodInfo period, Map cashMap, Map bankMap, Set setA, Set setB) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"journalSet", (Object)setA);
        uiContext.put((Object)"bankSet", (Object)setB);
    }

    public static void showDialogWindow(IUIObject ui, UIContext uiContext) throws UIException {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankVcCheckResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecordNullMsg"));
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"RecordNullMsg"));
            return;
        }
        int beginIndex = 0;
        int endIndex = 0;
        String strGroup = "";
        int rowSize = rowCount;
        if (rowSize > 0) {
            strGroup = this.tblMain.getRow(0).getCell("group").getValue().toString();
            this.tblMain.getRow(0).getCell("select").setValue((Object)Boolean.TRUE);
        }
        for (int i = 0; i < rowSize; ++i) {
            String strTmpGroup = this.tblMain.getRow(i).getCell("group").getValue().toString();
            if (!strGroup.equals(strTmpGroup)) {
                this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
                beginIndex = i;
                endIndex = i;
                strGroup = strTmpGroup;
            } else {
                endIndex = i;
            }
            if (i != rowSize - 1) continue;
        }
    }

    protected void displayResult(VcVerifyInfo vcVerifyInfo) {
        super.displayResult(vcVerifyInfo);
        this.fillTable();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        VcResultCollection ids = this.getResultCollSelected();
        if (ids == null || ids.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectRecordMsg"));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SaveResultSuccess"));
    }

    protected VcResultCollection getResultCollSelected() {
        VcResultCollection resultColl = new VcResultCollection();
        int m = this.tblMain.getRowCount();
        for (int i = 0; i < m; ++i) {
            Boolean isSelect = (Boolean)this.tblMain.getRow(i).getCell("select").getValue();
            if (!isSelect.booleanValue()) continue;
            VcResultInfo resultInfo = (VcResultInfo)this.tblMain.getRow(i).getUserObject();
            resultColl.add(resultInfo);
        }
        return resultColl;
    }

    protected void writeBackBO(VcResultCollection resultColl) {
        super.writeBackBO(resultColl);
    }

    @Override
    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ArrayList<ListFind> FindPropertyName = new ArrayList<ListFind>();
        for (int i = 0; i < this.getLocateNames().length; ++i) {
            if (this.tblMain.getColumn(this.getLocateNames()[i]) == null) continue;
            ListFind cEnum = new ListFind(this.getLocateNames()[i], this.tblMain.getHeadRow(0).getCell(this.getLocateNames()[i]).getValue().toString());
            FindPropertyName.add(cEnum);
        }
        if (FindPropertyName.size() == 0) {
            return;
        }
        if (this.findDialog == null) {
            this.findDialog = win instanceof Frame ? new FindDialog((Frame)win, "", FindPropertyName, false) : new FindDialog((Dialog)win, "", FindPropertyName, false);
            this.findDialog.addFindListListener(new IFindListListener(){

                public void FindNext(FindListEvent e) {
                    BankVcCheckResultUI.this.locate(e);
                }

                public void actionPerformed(ActionEvent e) {
                }

                public void FindClose(FindListEvent e) {
                    BankVcCheckResultUI.this.findDialog.dispose();
                    BankVcCheckResultUI.this.findDialog = null;
                }
            });
        }
        this.setFindDialogLocation(this.findDialog);
        this.findDialog.show();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"date", "bizDate", "voucherType", "voucherNumber", "billType", "billNumber", "description", "settType", "settNumber", "debitAmount", "creditAmount"};
        return locateNames;
    }

    private void setFindDialogLocation(FindDialog find) {
        find.setLocation(600, 100);
    }

    protected void locate(FindListEvent e) {
        boolean searchResult = false;
        int currentRow = 0;
        int RowCount = 0;
        this.locateForNotIdList(e);
        if (this.tblMain.getSelectManager().get() != null) {
            currentRow = this.tblMain.getSelectManager().get().getBeginRow();
        }
        int i = 0;
        if (RowCount == 0) {
            return;
        }
        if (e.getFindDeration() == 2) {
            if (i == RowCount) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                this.findDialog.show();
            } else {
                for (i = e.getFindDeration() == 2 ? currentRow + 1 : currentRow; i < RowCount; ++i) {
                    String Search;
                    Object o = null == this.tblMain.getRow(i) ? null : this.tblMain.getRow(i).getCell(e.getPropertyName()).getValue();
                    String string = Search = o == null ? null : o.toString();
                    if (Search == null) {
                        if (i != RowCount - 1) continue;
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                        this.findDialog.show();
                        continue;
                    }
                    if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                        searchResult = true;
                        this.isFirstFind = false;
                        this.tblMain.getSelectManager().select(i, 0);
                        this.tblMain.getLayoutManager().scrollRowToShow(i);
                        break;
                    }
                    if (i != RowCount - 1) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                    this.findDialog.show();
                }
            }
        } else {
            if (i == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                this.findDialog.show();
            }
            while (i > 0) {
                String Search;
                Object o = null == this.tblMain.getRow(i - 1) ? null : this.tblMain.getRow(i - 1).getCell(e.getPropertyName()).getValue();
                String string = Search = o == null ? null : o.toString();
                if (Search == null) {
                    if (i == 1) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                        this.findDialog.show();
                    }
                } else {
                    if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                        searchResult = true;
                        this.isFirstFind = false;
                        this.tblMain.getSelectManager().select(i - 1, 0);
                        this.tblMain.getLayoutManager().scrollRowToShow(i - 1);
                        break;
                    }
                    if (i == 1) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                        this.findDialog.show();
                    }
                }
                --i;
            }
        }
    }

    protected void locateForNotIdList(FindListEvent e) {
        IRow row;
        boolean searchResult = false;
        int currentRow = 0;
        if (this.tblMain.getSelectManager().get() != null) {
            currentRow = this.tblMain.getSelectManager().get().getBeginRow();
        }
        int i = 0;
        if (!this.isFirstFind) {
            i = e.getFindDeration() == 2 ? currentRow + 1 : currentRow;
        }
        if ((row = this.tblMain.getRow(i)) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
            this.findDialog.show();
            return;
        }
        if (e.getFindDeration() == 2) {
            if (row == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                this.findDialog.show();
            } else {
                while (row != null) {
                    row = this.tblMain.getRow(i);
                    if (row == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                        this.findDialog.show();
                        break;
                    }
                    this.tblMain.getSelectManager().select(i, 0);
                    if (this.tblMain.getRow(i).getCell(e.getPropertyName()).getValue() == null) {
                        if (row == null) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                            this.findDialog.show();
                        }
                        ++i;
                        continue;
                    }
                    String Search = this.tblMain.getRow(i).getCell(e.getPropertyName()).getValue().toString();
                    if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                        searchResult = true;
                        this.isFirstFind = false;
                        this.tblMain.getLayoutManager().scrollRowToShow(i);
                        break;
                    }
                    if (!searchResult) {
                        this.tblMain.getSelectManager().select(currentRow, 0);
                    }
                    if (row == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateLast)));
                        this.findDialog.show();
                    }
                    ++i;
                }
            }
        } else {
            while (row != null) {
                if (--i == -1) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                    this.findDialog.show();
                    break;
                }
                this.tblMain.getSelectManager().select(i, 0);
                row = this.tblMain.getRow(i);
                if (this.tblMain.getRow(i).getCell(e.getPropertyName()).getValue() == null) {
                    if (row != null) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                    this.findDialog.show();
                    continue;
                }
                String Search = this.tblMain.getRow(i).getCell(e.getPropertyName()).getValue().toString();
                if (Search != null && StringUtility.isMatch((String)Search, (String)e.getSearch(), (boolean)e.isIsMatch(), (int)2)) {
                    searchResult = true;
                    this.isFirstFind = false;
                    this.tblMain.getLayoutManager().scrollRowToShow(i);
                    break;
                }
                if (!searchResult) {
                    this.tblMain.getSelectManager().select(currentRow, 0);
                }
                if (row != null) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + locateFirst)));
                this.findDialog.show();
            }
        }
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String resPath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
        String companyString = this.lblBankAccount.getBoundLabelText() + "\uff1a&[company]";
        String accountString = this.lblBankAccount.getBoundLabelText() + "\uff1a&[bankAccount] ";
        String currencyString = this.lblCurrency.getBoundLabelText() + "\uff1a&[currency]";
        String acctView = this.lblAccountView.getBoundLabelText() + "\uff1a&[accountView]";
        String period = this.lblPeriod.getBoundLabelText() + "\uff1a&[period]";
        String headString = accountString + "&|" + currencyString;
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(headString, sb);
        headString = acctView + "&|" + period;
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        map.put("company", company.getName());
        String periodString = null;
        periodString = EASResource.getString((String)resourcePath, (String)"cm25", (Object[])new Object[]{this.txtPeriod.getText()});
        map.put("bankAccount", this.txtBankAccount.getText());
        map.put("currency", this.txtCurrency.getText());
        map.put("accountView", this.txtAccountView.getText());
        map.put("period", this.txtPeriod.getText());
        return map;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = BankVcCheckResultUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                this.initVarMap();
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }
}

