/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.VOCellEditor;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class BookNotifyClientHelper {
    private static String ResourcePath = "com.kingdee.eas.fi.cas.BookNotifyResource";
    private static final Logger logger = Logger.getLogger(BookNotifyClientHelper.class);

    public static void setTableCellEditorByEnum(KDTable tblMain, String enumClassName, String property) throws Exception {
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator it = (Iterator)Class.forName(enumClassName).getMethod("iterator", null).invoke(null, null);
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        comboBox.setModel(model);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    public static void setTableCellEditorByF7(KDTable tblMain, String f7, String property) throws Exception {
        BookNotifyClientHelper.setTableCellEditorByF7(tblMain, f7, null, property);
    }

    public static void setTableCellEditorByF7(KDTable tblMain, String f7, FilterInfo fi, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setQueryInfo(f7);
        if (fi != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            promptBox.setEntityViewInfo(evi);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByDate(KDTable tblMain, String property) throws Exception {
        KDDatePicker dpDate = new KDDatePicker();
        dpDate.setValue((Object)new Date());
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
    }

    public static FilterInfo getBankAccountFilter(boolean isIncludeClosed) {
        FilterInfo fi = new FilterInfo();
        String companyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        return fi;
    }

    public static FilterInfo getPlanItemFilter(String companyId, String currencyId, boolean isPayee) {
        Set itemTypeAry = BookNotifyClientHelper.getItemTypeAry(isPayee);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        if (currencyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)itemTypeAry, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)DateHelper.getDayBegin(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)DateHelper.getDayBegin(), CompareType.GREATER_EQUALS));
        return filter;
    }

    private static Set getItemTypeAry(boolean isPayee) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (isPayee) {
            set.add(new Integer(3));
            set.add(new Integer(4));
            set.add(new Integer(2));
        } else {
            set.add(new Integer(-3));
            set.add(new Integer(-4));
            set.add(new Integer(-2));
        }
        return set;
    }

    private static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, IObjectCollection coll, String property) throws Exception {
        if (comboBox == null) {
            comboBox = new KDComboBox();
        }
        if (coll != null) {
            DefaultComboBoxModel<IObjectValue> model = new DefaultComboBoxModel<IObjectValue>();
            for (int j = 0; j < coll.size(); ++j) {
                model.addElement(coll.getObject(j));
            }
            comboBox.setModel(model);
        }
        VOCellEditor editor = new VOCellEditor((JComboBox)comboBox);
        tblMain.getColumn(property).setEditor((ICellEditor)editor);
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, IObjectCollection coll, String property) throws Exception {
        BookNotifyClientHelper.setTableCellEditorByComboBox(tblMain, null, coll, property);
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, String property) throws Exception {
        BookNotifyClientHelper.setTableCellEditorByComboBox(tblMain, comboBox, null, property);
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(8);
        formattedTextField.setRoundingMode(4);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision, BigDecimal minValue) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setMinimumValue((Comparable)minValue);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setOppAccountF7(KDTable tblMain, String property) throws Exception {
        KDBizPromptBox oppAccountF7 = new KDBizPromptBox();
        FilterInfo fi = BookNotifyClientHelper.getAccountFilter();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)new CoreUI(), companyInfo, fi);
        oppAccountF7.setSelector((KDPromptSelector)acctPromptBox);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)oppAccountF7));
    }

    public static void setOppAccountF7(IRow row, String property) throws Exception {
        KDBizPromptBox oppAccountF7 = new KDBizPromptBox();
        FilterInfo fi = BookNotifyClientHelper.getAccountFilter();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)new CoreUI(), companyInfo, fi);
        oppAccountF7.setSelector((KDPromptSelector)acctPromptBox);
        row.getCell(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)oppAccountF7));
    }

    private static FilterInfo getAccountFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        filter.setMaskString("#0 and #1 and #2");
        return filter;
    }

    public static void setPersonF7(IUIObject ui, KDTable tblMain, String property) {
        KDBizPromptBox personF7 = new KDBizPromptBox();
        personF7.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        personF7.setSelector((KDPromptSelector)new PersonPromptBox(ui));
        personF7.setEditable(true);
        personF7.setDisplayFormat("$number$");
        personF7.setEditFormat("$number$");
        personF7.setCommitFormat("$number$");
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)personF7));
    }

    public static void setF7QueryInfo(KDBizPromptBox bizPromptBox, String queryInfo) {
        bizPromptBox.setQueryInfo(queryInfo);
        bizPromptBox.setEditable(true);
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
    }

    public static void initCurrentType(KDComboBox comboBox, boolean isSelectAll, SourceTypeEnum sourceType) throws Exception {
        Set idSet;
        comboBox.removeAllItems();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        CtrlUnitInfo CU = companyInfo.getCU();
        String cuid = CU.getId().toString();
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getRemoteInstance();
        CU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuid));
        FilterInfo filter = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuid, (String)CU.getLongNumber());
        String maskString = filter.getMaskString();
        if (SourceTypeEnum.AR.equals((Object)sourceType) || SourceTypeEnum.AP.equals((Object)sourceType)) {
            idSet = BookNotifyClientHelper.getAsstActTypeIdSet(companyInfo.getCU().getId().toString());
            if (idSet == null || idSet.size() < 1) {
                return;
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            if (maskString != null) {
                filter.setMaskString("(" + maskString + ") AND #2");
            }
        } else if (SourceTypeEnum.CP.equals((Object)sourceType)) {
            filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)"T_BD_Person"));
            if (maskString != null) {
                filter.setMaskString("(" + maskString + ") AND #2");
            }
        } else {
            idSet = BookNotifyClientHelper.getAsstActTypeIdSet(companyInfo.getCU().getId().toString());
            if (idSet != null && idSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                if (maskString != null) {
                    filter.setMaskString("(" + maskString + ") AND (#2 OR #3)");
                } else {
                    filter.setMaskString("(#0 AND (#1 OR #2))");
                }
            } else if (maskString != null) {
                filter.setMaskString("(" + maskString + ") AND #2");
            }
            filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)"T_BD_Person"));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        comboBox.addItems(asstActTypeCollection.toArray());
        if (isSelectAll) {
            comboBox.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
    }

    private static String getMaskString(String org) {
        String mask = null;
        return mask;
    }

    private static Set getAsstActTypeIdSet(String cuId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("asstActType.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isAccountCussent", (Object)FMConstants.TRUE));
        evi.setFilter(filter);
        IAsstActTypeDefault iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection coll = iAsstActTypeDefault.getAsstActTypeDefaultCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getAsstActType().getId().toString());
        }
        return idSet;
    }

    private AsstActTypeCollection getAsstActTypeColl() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        AsstActTypeCollection asstActTypeColl = new AsstActTypeCollection();
        IAsstActType asstActType = AsstActTypeFactory.getRemoteInstance();
        Set idSet = BookNotifyClientHelper.getAsstActTypeIdSet(companyInfo.getCU().getId().toString());
        if (idSet == null || idSet.size() < 1) {
            return asstActTypeColl;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        asstActTypeColl = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeColl;
    }

    public static VoucherEntryInfo getEntryInfo(String entryId) throws BOSException, EASBizException {
        IVoucherEntry entry = VoucherEntryFactory.getRemoteInstance();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add("*");
        sel.add("currency.*");
        sel.add("account.*");
        sel.add("bill.*");
        sel.add("bill.company.*");
        sel.add("assistRecords.*");
        VoucherEntryInfo entryinfo = (VoucherEntryInfo)entry.getValue((IObjectPK)new ObjectUuidPK(entryId), sel);
        return entryinfo;
    }

    public static int getSelectIndex(KDComboBox comboBox, String id) {
        for (int i = 1; i < comboBox.getItemCount(); ++i) {
            CoreBaseInfo info;
            if (!(comboBox.getItemAt(i) instanceof CoreBaseInfo) || !id.equals((info = (CoreBaseInfo)comboBox.getItemAt(i)).getId().toString())) continue;
            return i;
        }
        return 0;
    }

    public static AccountBankCollection getAccountBankCollection(VoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountBankCollection accountBankCollection;
        block9: {
            accountBankCollection = new AccountBankCollection();
            if (entryInfo == null) {
                return accountBankCollection;
            }
            AccountViewInfo accountViewInfo = entryInfo.getAccount();
            if (accountViewInfo == null) {
                return accountBankCollection;
            }
            if (!accountViewInfo.isIsBank()) break block9;
            VoucherAssistRecordCollection voucherAssistRecordCollection = entryInfo.getAssistRecords();
            if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0 || voucherAssistRecordCollection.get(0).getAssGrp() == null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
                fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountViewInfo.getId().toString()));
                evi.getSelector().add(new SelectorItemInfo("name"));
                evi.getSelector().add(new SelectorItemInfo("account.number"));
                evi.getSelector().add(new SelectorItemInfo("account.name"));
                evi.setFilter(fi);
                IAccountBank accountBank = null;
                if (accountBank == null) {
                    accountBank = AccountBankFactory.getRemoteInstance();
                }
                AccountBankCollection accountBankCollection2 = accountBank.getAccountBankCollection(evi);
                for (int j = 0; j < accountBankCollection2.size(); ++j) {
                    if (accountBankCollection.contains(accountBankCollection2.get(j))) continue;
                    accountBankCollection.add(accountBankCollection2.get(j));
                }
            } else {
                for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                    VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
                    AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
                    if (assistantHGInfo == null) continue;
                    AccountBankInfo accountBankInfo = assistantHGInfo.getBankAccount();
                    if (accountBankInfo == null) {
                        AccountBankCollection coll = BookNotifyClientHelper.getAccountBankCollOnNoAssist(accountViewInfo.getId().toString());
                        for (int k = 0; k < coll.size(); ++k) {
                            if (accountBankCollection.contains(coll.get(k))) continue;
                            accountBankCollection.add(coll.get(k));
                        }
                        break;
                    }
                    if (accountBankCollection.contains(accountBankInfo)) continue;
                    accountBankCollection.add(accountBankInfo);
                }
            }
        }
        return accountBankCollection;
    }

    public static AccountBankCollection getAccountBankCollectionByVoucherId(VoucherInfo voucherInfo) throws Exception {
        AccountBankCollection accountBankCollAll = new AccountBankCollection();
        if (voucherInfo == null) {
            return accountBankCollAll;
        }
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        for (int i = 0; i < entryCollection.size(); ++i) {
            VoucherEntryInfo entryInfo = entryCollection.get(i);
            AccountViewInfo accountViewInfo = entryInfo.getAccount();
            if (accountViewInfo == null || !accountViewInfo.isIsBank()) continue;
            AccountBankCollection accountBankCollection = new AccountBankCollection();
            VoucherAssistRecordCollection voucherAssistRecordCollection = entryInfo.getAssistRecords();
            if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0 || voucherAssistRecordCollection.get(0).getAssGrp() == null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
                fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountViewInfo.getId().toString()));
                evi.getSelector().add(new SelectorItemInfo("name"));
                evi.getSelector().add(new SelectorItemInfo("account.number"));
                evi.getSelector().add(new SelectorItemInfo("account.name"));
                evi.setFilter(fi);
                IAccountBank accountBank = null;
                if (accountBank == null) {
                    accountBank = AccountBankFactory.getRemoteInstance();
                }
                AccountBankCollection accountBankCollection2 = accountBank.getAccountBankCollection(evi);
                for (int j = 0; j < accountBankCollection2.size(); ++j) {
                    if (accountBankCollection.contains(accountBankCollection2.get(j))) continue;
                    accountBankCollection.add(accountBankCollection2.get(j));
                }
                accountBankCollAll.addCollection(accountBankCollection);
                continue;
            }
            for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
                AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
                if (assistantHGInfo == null) continue;
                AccountBankInfo accountBankInfo = assistantHGInfo.getBankAccount();
                if (accountBankInfo == null) {
                    AccountBankCollection coll = BookNotifyClientHelper.getAccountBankCollOnNoAssist(accountViewInfo.getId().toString());
                    for (int k = 0; k < coll.size(); ++k) {
                        if (accountBankCollection.contains(coll.get(k))) continue;
                        accountBankCollection.add(coll.get(k));
                    }
                    break;
                }
                if (accountBankCollection.contains(accountBankInfo)) continue;
                accountBankCollection.add(accountBankInfo);
            }
            accountBankCollAll.addCollection(accountBankCollection);
        }
        return accountBankCollAll;
    }

    public static AccountBankCollection getAccountBankCollectionByVoucherEntryId(String entryId) throws Exception {
        AccountBankCollection accountBankCollection;
        block8: {
            accountBankCollection = new AccountBankCollection();
            IVoucherEntry entry = VoucherEntryFactory.getRemoteInstance();
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("*");
            sel.add("account.*");
            sel.add("bill.*");
            sel.add("bill.company.*");
            sel.add("assistRecords.*");
            sel.add("assistRecords.assGrp.id");
            sel.add("assistRecords.assGrp.BankAccount.*");
            VoucherEntryInfo entryinfo = (VoucherEntryInfo)entry.getValue((IObjectPK)new ObjectUuidPK(entryId), sel);
            if (entryinfo == null) {
                return accountBankCollection;
            }
            IAccountBank accountBank = null;
            AccountViewInfo accountViewInfo = entryinfo.getAccount();
            if (!accountViewInfo.isIsBank()) break block8;
            VoucherAssistRecordCollection voucherAssistRecordCollection = entryinfo.getAssistRecords();
            if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0 || voucherAssistRecordCollection.get(0).getAssGrp() == null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
                fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountViewInfo.getId().toString()));
                evi.getSelector().add(new SelectorItemInfo("name"));
                evi.getSelector().add(new SelectorItemInfo("account.number"));
                evi.getSelector().add(new SelectorItemInfo("account.name"));
                evi.setFilter(fi);
                if (accountBank == null) {
                    accountBank = AccountBankFactory.getRemoteInstance();
                }
                AccountBankCollection accountBankCollection2 = accountBank.getAccountBankCollection(evi);
                for (int j = 0; j < accountBankCollection2.size(); ++j) {
                    if (accountBankCollection.contains(accountBankCollection2.get(j))) continue;
                    accountBankCollection.add(accountBankCollection2.get(j));
                }
            } else {
                for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                    VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
                    AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
                    if (assistantHGInfo == null) continue;
                    AccountBankInfo accountBankInfo = assistantHGInfo.getBankAccount();
                    if (accountBankInfo == null) {
                        AccountBankCollection coll = BookNotifyClientHelper.getAccountBankCollOnNoAssist(accountViewInfo.getId().toString());
                        for (int k = 0; k < coll.size(); ++k) {
                            if (accountBankCollection.contains(coll.get(k))) continue;
                            accountBankCollection.add(coll.get(k));
                        }
                        break;
                    }
                    if (accountBankCollection.contains(accountBankInfo)) continue;
                    accountBankCollection.add(accountBankInfo);
                }
            }
        }
        return accountBankCollection;
    }

    protected static AccountBankCollection getAccountBankCollOnNoAssist(String accountId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("account.number"));
        evi.getSelector().add(new SelectorItemInfo("account.name"));
        evi.setFilter(fi);
        AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return coll;
    }

    public static CurrencyCollection getCurrencyCollectionByVoucherId(VoucherInfo voucherInfo) throws Exception {
        CurrencyCollection currencyCollection = new CurrencyCollection();
        if (voucherInfo == null) {
            return currencyCollection;
        }
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (currencyCollection.contains(entryInfo.getCurrency())) continue;
            currencyCollection.add(entryInfo.getCurrency());
        }
        return currencyCollection;
    }

    public static AccountViewCollection getCashAccountCollection(VoucherInfo voucherInfo) throws Exception {
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        if (voucherInfo == null) {
            return accountViewCollection;
        }
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            AccountViewInfo account = entryInfo.getAccount();
            if (!account.isIsCash() || accountViewCollection.contains(account)) continue;
            accountViewCollection.add(account);
        }
        return accountViewCollection;
    }

    public static AccountViewCollection getAccountCollectionByVoucherId(String voucherId) throws Exception {
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)voucherId));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("bill.*");
        view.getSelector().add("account.*");
        view.getSelector().add("currency.*");
        VoucherEntryCollection entryCollection = VoucherEntryFactory.getRemoteInstance().getVoucherEntryCollection(view);
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (accountViewCollection.contains(entryInfo.getAccount())) continue;
            accountViewCollection.add(entryInfo.getAccount());
        }
        return accountViewCollection;
    }

    public static AccountViewCollection getAccountCollectionByVoucherId(VoucherInfo voucherInfo) throws Exception {
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (accountViewCollection.contains(entryInfo.getAccount())) continue;
            accountViewCollection.add(entryInfo.getAccount());
        }
        return accountViewCollection;
    }

    public static Date getBeginDateOfCurrentPeriod() throws Exception {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod != null) {
            return startPeriod.getBeginDate();
        }
        return new Date();
    }

    public static int getAccountType(VoucherInfo voucherInfo) {
        boolean hasCash = false;
        boolean hasBank = false;
        AccountViewCollection accountCollection = null;
        try {
            accountCollection = BookNotifyClientHelper.getAccountCollectionByVoucherId(voucherInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        AccountViewInfo accountInfo = null;
        for (int i = 0; i < accountCollection.size(); ++i) {
            accountInfo = accountCollection.get(i);
            if (accountInfo.isIsCash()) {
                hasCash = true;
                continue;
            }
            if (!accountInfo.isIsBank()) continue;
            hasBank = true;
        }
        if (!(!hasCash || hasCash && hasBank)) {
            return 1;
        }
        if (!(!hasBank || hasCash && hasBank)) {
            return 2;
        }
        if (hasCash && hasBank) {
            return 3;
        }
        return 0;
    }

    public static Date getVoucherBookDate(String voucherId) throws Exception {
        IVoucher voucher = VoucherFactory.getRemoteInstance();
        VoucherInfo voucherInfo = (VoucherInfo)voucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), BookNotifyClientHelper.getBookedDateVoucherSelector());
        return voucherInfo.getBookedDate();
    }

    public static SelectorItemCollection getVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.name"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.*"));
        return sic;
    }

    public static SelectorItemCollection getBookedDateVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bookedDate"));
        return sic;
    }

    public static IRow addLine(KDTable tblMain, IObjectValue detailData) {
        IRow row = tblMain.addRow();
        new TableBindHandler().loadLineFields(tblMain, row, detailData);
        return row;
    }

    public static void removeLine(KDTable tblMain) {
        if (tblMain.getSelectManager().size() == 0 || BookNotifyClientHelper.isTableColumnSelected(tblMain)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = tblMain.getSelectManager().get().getTop();
        if (tblMain.getRow(top) == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        tblMain.removeRow(top);
    }

    public static IRow insertLine(KDTable tblMain, IObjectValue detailData) {
        int top;
        if (tblMain.getSelectManager().size() == 0 || BookNotifyClientHelper.isTableColumnSelected(tblMain)) {
            SysUtil.abort();
        }
        if (tblMain.getRow(top = tblMain.getSelectManager().get().getTop()) == null) {
            SysUtil.abort();
        }
        IRow row = null;
        row = tblMain.getSelectManager().size() > 0 ? (BookNotifyClientHelper.isTableColumnSelected(tblMain) ? tblMain.addRow() : tblMain.addRow(top)) : tblMain.addRow();
        new TableBindHandler().loadLineFields(tblMain, row, detailData);
        return row;
    }

    public static IRow CopyLine(KDTable tblMain) {
        IRow row = null;
        IRow oldRow = null;
        if (tblMain.getSelectManager().size() > 0) {
            int top = tblMain.getSelectManager().get().getTop();
            oldRow = tblMain.getRow(top);
            row = BookNotifyClientHelper.isTableColumnSelected(tblMain) ? tblMain.addRow() : tblMain.addRow(top);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)ResourcePath, (String)"SelectValidRecord"));
            return null;
        }
        int size = tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            row.getCell(i).setValue(oldRow.getCell(i).getValue());
        }
        return row;
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }
}

