/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class BookNotifyFilterParam
implements FilterParam {
    private static Logger logger = Logger.getLogger((String)BookNotifyFilterParam.class.getName());
    private static final long serialVersionUID = 659160956691511966L;
    private static final int SELECT_ALL = 999;
    private boolean isByDate;
    private int spiBeginYear;
    private int spiEndYear;
    private int spiBeginMonth;
    private int spiEndMonth;
    private Date dptFromDate;
    private Date dptToDate;
    private int noticeType;
    private String billNumberFrom;
    private String billNumberTo;
    private int noticeState;

    public String getBillNumberFrom() {
        return this.billNumberFrom;
    }

    public void setBillNumberFrom(String billNumberFrom) {
        this.billNumberFrom = billNumberFrom;
    }

    public String getBillNumberTo() {
        return this.billNumberTo;
    }

    public void setBillNumberTo(String billNumberTo) {
        this.billNumberTo = billNumberTo;
    }

    public int getNoticeType() {
        return this.noticeType;
    }

    public void setNoticeType(int noticeType) {
        this.noticeType = noticeType;
    }

    public Date getDptFromDate() {
        return this.dptFromDate;
    }

    public void setDptFromDate(Date dptFromDate) {
        this.dptFromDate = dptFromDate;
    }

    public Date getDptToDate() {
        return this.dptToDate;
    }

    public void setDptToDate(Date dptToDate) {
        this.dptToDate = dptToDate;
    }

    public boolean isByDate() {
        return this.isByDate;
    }

    public void setByDate(boolean isByDate) {
        this.isByDate = isByDate;
    }

    public int getSpiBeginMonth() {
        return this.spiBeginMonth;
    }

    public void setSpiBeginMonth(int spiBeginMonth) {
        this.spiBeginMonth = spiBeginMonth;
    }

    public int getSpiBeginYear() {
        return this.spiBeginYear;
    }

    public void setSpiBeginYear(int spiBeginYear) {
        this.spiBeginYear = spiBeginYear;
    }

    public int getSpiEndMonth() {
        return this.spiEndMonth;
    }

    public void setSpiEndMonth(int spiEndMonth) {
        this.spiEndMonth = spiEndMonth;
    }

    public int getSpiEndYear() {
        return this.spiEndYear;
    }

    public void setSpiEndYear(int spiEndYear) {
        this.spiEndYear = spiEndYear;
    }

    public int getNoticeState() {
        return this.noticeState;
    }

    public void setNoticeState(int noticeState) {
        this.noticeState = noticeState;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId(), CompareType.EQUALS));
        if (this.isByDate) {
            if (this.dptFromDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)this.dptFromDate), CompareType.LESS_EQUALS));
            }
            if (this.dptToDate != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DateTimeUtils.truncateDate((Date)this.dptToDate), CompareType.GREATER_EQUALS));
            }
        } else {
            PeriodInfo beginPeriod = null;
            PeriodInfo endPeriod = null;
            try {
                beginPeriod = PeriodUtils.getPeriodInfo((int)this.spiBeginYear, (int)this.spiBeginMonth, (CompanyOrgUnitInfo)companyInfo);
                endPeriod = PeriodUtils.getPeriodInfo((int)this.spiEndYear, (int)this.spiEndMonth, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)beginPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endPeriod.getEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.noticeType != 999) {
            filterInfo.getFilterItems().add(new FilterItemInfo("noticeType", (Object)new Integer(this.noticeType)));
        }
        if (this.noticeState != 999) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)new Integer(this.noticeState)));
        }
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }
}

