/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.NoticeTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractBookNotifyUI;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JTextField;

public class BookNotifyUI
extends AbstractBookNotifyUI {
    protected String resourcePath = "com.kingdee.eas.fi.cas.CASResource";
    protected static final String COL_TYPE = "journalType";
    protected static final String COL_BIZDATE = "bizDate";
    protected static final String COL_PLANITEM = "planItem";
    protected static final String COL_OPPACCOUNTVIEW = "oppAccountView";
    protected static final String COL_ACCOUNTVIEW = "accountView";
    protected static final String COL_CURRENCY = "currency";
    protected static final String COL_BANKACCOUNT = "bankAccount";
    protected static final String COL_SETTLEMENTTYPE = "settlementType";
    protected static final String COL_JOURNALTYPE = "journalType";
    protected static final String COL_DEBITAMOUNT = "debitAmount";
    protected static final String COL_CREDITAMOUNT = "creditAmount";
    protected JournalCollection journalCollection = new JournalCollection();
    protected TableBindHandler tableHandler = new TableBindHandler();
    private boolean isPayee;

    public void onLoad() throws Exception {
        this.bindTable();
        this.tblMain.checkParsed();
        this.setTableCellEditor();
        this.setUIStatus(this.getOprtState());
        this.initWorkButton();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnCopyLine.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void setEnumRender() {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            JournalTypeEnum typeEnum = JournalTypeEnum.getEnum((int)Integer.parseInt(row.getCell("journalType").getValue().toString()));
            if (typeEnum == null) continue;
            row.getCell("journalType").setValue((Object)typeEnum);
        }
    }

    protected void setUIStatus(String oprtState) {
        this.btnEdit.setVisible(false);
        if (oprtState.equals(OprtState.VIEW)) {
            this.tblMain.getStyleAttributes().setLocked(true);
            this.tblMain.getSelectManager().setSelectMode(2);
            return;
        }
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            row.getCell("journalType").getStyleAttributes().setLocked(true);
            row.getCell(COL_CURRENCY).getStyleAttributes().setLocked(true);
        }
        this.tblMain.getColumn(COL_ACCOUNTVIEW).getStyleAttributes().setLocked(true);
    }

    public void bindTable() {
        this.tblMain.putBindContents("editData", new String[]{COL_BIZDATE, "type", "accountBank", COL_CURRENCY, COL_ACCOUNTVIEW, COL_PLANITEM, "description", COL_OPPACCOUNTVIEW, COL_SETTLEMENTTYPE, "settlementNumber", "ticketType", "ticketNumber", COL_DEBITAMOUNT, COL_CREDITAMOUNT});
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    public JournalCollection getJournalCollection(String builderName, String billId, String status) throws Exception {
        JournalCollection coll = null;
        if (status.equals(OprtState.ADDNEW)) {
            coll = this.getJournalCollectionByParsing(builderName, billId);
        } else if (status.equals("EDIT")) {
            coll = this.getJournalCollectionByBillID(billId);
            if (!(coll != null && coll.size() != 0 || coll != null && coll.size() != 0)) {
                VoucherCollection voucherCollection = VoucherFactory.getRemoteInstance().getVoucherCollection("select id,entries.id where id='" + billId + "'");
                if (voucherCollection.size() > 0) {
                    VoucherInfo vInfo = voucherCollection.get(0);
                    for (int i = 0; i < vInfo.getEntries().size(); ++i) {
                        coll.addCollection(this.getJournalCollectionByBillID(vInfo.getEntries().get(i).getId().toString()));
                    }
                }
                if (coll == null || coll.size() == 0) {
                    throw new BookNotifyException(BookNotifyException.NOT_CHECK);
                }
            }
        } else if (status.equals("VIEW") && ((coll = this.getJournalCollectionByBillID(billId)) == null || coll.size() == 0)) {
            VoucherCollection voucherCollection = VoucherFactory.getRemoteInstance().getVoucherCollection("select id,entries.id where id='" + billId + "'");
            if (voucherCollection.size() > 0) {
                VoucherInfo vInfo = voucherCollection.get(0);
                for (int i = 0; i < vInfo.getEntries().size(); ++i) {
                    coll.addCollection(this.getJournalCollectionByBillID(vInfo.getEntries().get(i).getId().toString()));
                }
            }
            if (coll == null || coll.size() == 0) {
                throw new BookNotifyException(BookNotifyException.NOT_CHECK);
            }
        }
        return coll;
    }

    private JournalCollection getJournalCollectionByParsing(String builderName, String billId) throws Exception {
        IBookNotifyFacade notifyFacade = BookNotifyFacadeFactory.getRemoteInstance();
        JournalCollection coll = notifyFacade.genJournalCollection(builderName, billId);
        for (int i = 0; i < coll.size(); ++i) {
            JournalInfo info = coll.get(i);
            if (info.getDebitAmount().compareTo(new BigDecimal("0")) == 0) {
                info.setDebitAmount(null);
            }
            if (info.getCreditAmount().compareTo(new BigDecimal("0")) != 0) continue;
            info.setCreditAmount(null);
        }
        return coll;
    }

    protected void setTableCellEditor() throws Exception {
        BookNotifyClientHelper.setTableCellEditorByDate(this.tblMain, COL_BIZDATE);
        BookNotifyClientHelper.setTableCellEditorByEnum(this.tblMain, JournalTypeEnum.class.getName(), "journalType");
        String settleTypeF7 = "com.kingdee.eas.basedata.assistant.app.SettlementTypeQuery";
        BookNotifyClientHelper.setTableCellEditorByF7(this.tblMain, settleTypeF7, COL_SETTLEMENTTYPE);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(this.tblMain, COL_DEBITAMOUNT);
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(this.tblMain, COL_CREDITAMOUNT);
    }

    public void loadData(String builderName, String billId, NoticeTypeEnum type, String status) throws Exception {
    }

    private JournalCollection getJournalCollectionByBillID(String billId) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("oppAccountBank.name"));
        sic.add(new SelectorItemInfo("planItem.name"));
        sic.add(new SelectorItemInfo("oppAccountView.number"));
        sic.add(new SelectorItemInfo("oppAccountView.name"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("*"));
        evi.setFilter(fi);
        JournalCollection coll = JournalFactory.getRemoteInstance().getJournalCollection(evi);
        JournalInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getDebitAmount().compareTo(new BigDecimal("0")) == 0) {
                info.setDebitAmount(null);
            }
            if (info.getCreditAmount().compareTo(new BigDecimal("0")) != 0) continue;
            info.setCreditAmount(null);
        }
        return coll;
    }

    public void storeData() {
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        super.tblMain_editStopping(e);
        IRow row = this.tblMain.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        if (colIndex == this.tblMain.getColumn("journalType").getColumnIndex()) {
            JournalTypeEnum journalTypeEnum = (JournalTypeEnum)e.getValue();
            if (journalTypeEnum == null) {
                return;
            }
            this.tblChangeOnJournalType(row, journalTypeEnum);
        }
        if (colIndex == this.tblMain.getColumn(COL_CURRENCY).getColumnIndex()) {
            CurrencyInfo currencyInfo = (CurrencyInfo)e.getValue();
            if (currencyInfo == null) {
                return;
            }
            this.tblChangeOnCurrency(row, currencyInfo);
            int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
            KDFormattedTextField amtField = new KDFormattedTextField(1);
            amtField.setPrecision(scale);
            amtField.setDataVerifierType(12);
            amtField.setSupportedEmpty(true);
            KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amtField);
            this.tblMain.getColumn(COL_DEBITAMOUNT).setEditor((ICellEditor)amtEditor);
            this.tblMain.getColumn(COL_CREDITAMOUNT).setEditor((ICellEditor)amtEditor);
        }
        if (colIndex == this.tblMain.getColumn(COL_BANKACCOUNT).getColumnIndex()) {
            AccountBankInfo accountBankInfo = (AccountBankInfo)e.getValue();
            if (accountBankInfo == null) {
                return;
            }
            this.tblChangeOnBankAccount(row, accountBankInfo);
        }
        if (colIndex == this.tblMain.getColumn(COL_DEBITAMOUNT).getColumnIndex()) {
            if (e.getValue() == null) {
                return;
            }
            row.getCell(COL_CREDITAMOUNT).setValue(null);
        }
        if (colIndex == this.tblMain.getColumn(COL_CREDITAMOUNT).getColumnIndex()) {
            if (e.getValue() == null) {
                return;
            }
            row.getCell(COL_DEBITAMOUNT).setValue(null);
        }
    }

    private void tblChangeOnJournalType(IRow row, JournalTypeEnum journalTypeEnum) throws Exception {
        if (journalTypeEnum == null) {
            return;
        }
        if (row == null) {
            return;
        }
        if (journalTypeEnum.equals((Object)JournalTypeEnum.CASH)) {
            row.getCell(COL_BANKACCOUNT).setValue(null);
            row.getCell(COL_ACCOUNTVIEW).setValue(null);
            row.getCell(COL_BANKACCOUNT).getStyleAttributes().setLocked(true);
            row.getCell(COL_ACCOUNTVIEW).getStyleAttributes().setLocked(false);
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)this.getCashAccountCollection(), COL_ACCOUNTVIEW);
        } else if (journalTypeEnum.equals((Object)JournalTypeEnum.BANK)) {
            row.getCell(COL_BANKACCOUNT).getStyleAttributes().setLocked(false);
            row.getCell(COL_ACCOUNTVIEW).getStyleAttributes().setLocked(true);
        }
    }

    public AccountViewCollection getCashAccountCollection() throws Exception {
        return new AccountViewCollection();
    }

    private void tblChangeOnCurrency(IRow row, CurrencyInfo currencyInfo) throws Exception {
        if (row == null) {
            return;
        }
        String currencyId = currencyInfo.getId().toString();
        FMClientHelper.setNumberFormat((IRow)row, (String)COL_DEBITAMOUNT, (String)currencyId);
        FMClientHelper.setNumberFormat((IRow)row, (String)COL_CREDITAMOUNT, (String)currencyId);
    }

    private void tblChangeOnBankAccount(IRow row, AccountBankInfo accountBankInfo) throws BOSException, EASBizException {
        if (accountBankInfo == null) {
            return;
        }
        if (row == null) {
            return;
        }
        IAccountBank ab = AccountBankFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        AccountBankInfo abInfo = ab.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()), selector);
        AccountViewInfo account = abInfo.getAccount();
        if (account == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"acccount"});
        }
        row.getCell(COL_ACCOUNTVIEW).setValue((Object)account);
    }

    protected void setTableColumnFormat() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            Object obj = row.getCell(COL_CURRENCY).getValue();
            if (!(obj instanceof CurrencyInfo)) continue;
            CurrencyInfo currencyInfo = (CurrencyInfo)obj;
            String currencyId = currencyInfo.getId().toString();
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)COL_DEBITAMOUNT, (String)currencyId);
            FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)COL_CREDITAMOUNT, (String)currencyId);
            int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
            KDFormattedTextField amtField = new KDFormattedTextField(1);
            amtField.setPrecision(scale);
            amtField.setDataVerifierType(12);
            amtField.setSupportedEmpty(true);
            KDTDefaultCellEditor amtEditor = new KDTDefaultCellEditor((JTextField)amtField);
            this.tblMain.getColumn(COL_DEBITAMOUNT).setEditor((ICellEditor)amtEditor);
            this.tblMain.getColumn(COL_CREDITAMOUNT).setEditor((ICellEditor)amtEditor);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)COL_BIZDATE);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)"journalType");
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (!row.getCell("journalType").getValue().equals(JournalTypeEnum.BANK)) continue;
            FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (IRow)row, (String)COL_BANKACCOUNT);
        }
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)COL_CURRENCY);
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)COL_OPPACCOUNTVIEW);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        BookNotifyClientHelper.addLine(this.tblMain, this.createNewData());
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        BookNotifyClientHelper.CopyLine(this.tblMain);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        BookNotifyClientHelper.insertLine(this.tblMain, this.createNewData());
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        BookNotifyClientHelper.removeLine(this.tblMain);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.storeData();
        new BankJournalHandler().submitJournals(this.journalCollection);
        this.showSubmitSuccess();
    }

    public JournalCollection getJournalCollection() {
        return this.journalCollection;
    }

    public void setJournalCollection(JournalCollection journalCollection) {
        this.journalCollection = journalCollection;
    }
}

