/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractCapitalSummaryLegerFilterUI;
import com.kingdee.eas.fi.cas.client.CapitalSummaryLegerFilterParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.CompanyTreeSelectUI;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CapitalSummaryLegerFilterUI
extends AbstractCapitalSummaryLegerFilterUI {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";
    private static Logger logger = Logger.getLogger((String)CapitalSummaryLegerFilterUI.class.getName());
    TreeMap result = new TreeMap();

    public boolean verify() {
        String[] companyIds = this.getCompanyIds();
        if (companyIds == null || companyIds.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoCompany"));
            return false;
        }
        return true;
    }

    protected void init() throws Exception {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            AccountTableInfo accountTableInfo = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountTable().getId().toString())));
            this.comboAccountTable.addItem((Object)accountTableInfo);
            PeriodTypeInfo periodTypeInfo = PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountPeriodType().getId().toString())));
            this.comboPeriodType.addItem((Object)periodTypeInfo);
        } else {
            AccountTableCollection accountTables = CashHelper.getAccountViewTable(this.currentCompany);
            this.comboAccountTable.addItems(accountTables.toArray());
            PeriodTypeCollection periodTypes = PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection();
            this.comboPeriodType.addItems(periodTypes.toArray());
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.currentCompany.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            evi.getSorter().add(new SorterItemInfo("periodYear"));
            evi.getSorter().add(new SorterItemInfo("periodNumber"));
            evi.setFilter(filter);
            PeriodCollection pc = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
            for (PeriodInfo pi : pc) {
                PeriodCollection periodSubCo;
                Integer year = new Integer(pi.getPeriodYear());
                if (!this.result.containsKey(year)) {
                    periodSubCo = new PeriodCollection();
                    periodSubCo.add(pi);
                    this.result.put(year, periodSubCo);
                    continue;
                }
                periodSubCo = (PeriodCollection)this.result.get(year);
                periodSubCo.add(pi);
            }
            int beginYear = (Integer)this.result.firstKey();
            int endYear = (Integer)this.result.lastKey();
            SpinnerNumberModel yearMo1 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
            this.spiBeginYear.setModel((SpinnerModel)yearMo1);
            SpinnerNumberModel yearMo2 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
            this.spiEndYear.setModel((SpinnerModel)yearMo2);
            this.setMonthModel(this.spiBeginMonth, beginYear);
            this.setMonthModel(this.spiEndMonth, beginYear);
        }
        FMClientHelper.initCurrency((KDComboBox)this.comboCurrency);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        super.init();
        this.clear();
        this.contPeriodFrom.setEnabled(true);
        this.contYearFrom.setEnabled(true);
        this.contTo.setEnabled(true);
        this.contYearTo.setEnabled(true);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.f7Bank);
    }

    private void setMonthModel(KDSpinner spi, int year) {
        PeriodCollection periodSubCo = (PeriodCollection)this.result.get(new Integer(year));
        int beginMonth = periodSubCo.get(0).getPeriodNumber();
        int endMonth = periodSubCo.get(periodSubCo.size() - 1).getPeriodNumber();
        SpinnerNumberModel monthMo1 = new SpinnerNumberModel(beginMonth, beginMonth, endMonth, 1);
        spi.setModel((SpinnerModel)monthMo1);
    }

    private void initCompany() throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            TreeModel tree = this.getTreeModel();
            if (tree == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getRoot();
            ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
            if (root.isCheckBoxEnabled()) {
                list.add(((OrgStructureInfo)root.getUserObject()).getUnit());
            }
            this.popNode(list, root);
            this.setCompanyIds(AccessHelper.getIds((Object)list.toArray()));
        } else {
            this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
        }
    }

    protected KDDialog initDialog() throws Exception {
        this.companySelectDlg = new KDDialog(FMClientHelper.getFrameAncestor((Component)((Object)this)), true);
        TreeModel treeCompany = this.getTreeModel();
        if (treeCompany == null) {
            return null;
        }
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI(treeCompany, this.getCompanyIds());
        companySelectUI.setDialog((JDialog)this.companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        this.companySelectDlg.getContentPane().setLayout(new BorderLayout());
        this.companySelectDlg.getContentPane().add((Component)companySelectUI, "Center");
        this.companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.companySelectDlg);
        this.companySelectDlg.setResizable(false);
        this.companySelectDlg.setTitle(companySelectUI.getUITitle());
        companySelectUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    try {
                        CapitalSummaryLegerFilterUI.this.companyValueChange(e.getNewValue());
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                        CapitalSummaryLegerFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
        return this.companySelectDlg;
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            if (node.isCheckBoxEnabled()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo fullUnit = org.getUnit();
                list.add(fullUnit);
            }
            this.popNode(list, node);
        }
    }

    public Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(key, (Object)this.getSetByArray(array), CompareType.INCLUDE));
        return view;
    }

    public String[] getCompanyIds() {
        ArrayList<String> companyRec = new ArrayList<String>();
        String[] companyIds = super.getCompanyIds();
        if (companyIds == null) {
            return null;
        }
        try {
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(this.getIncludeEntityView("id", companyIds));
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo company = companys.get(i);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || !company.isIsLeaf()) {
                    companyRec.add(company.getId().toString());
                    continue;
                }
                PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (period == null) continue;
                companyRec.add(company.getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return companyRec.toArray(new String[0]);
    }

    public Object getParam() {
        CapitalSummaryLegerFilterParam para = new CapitalSummaryLegerFilterParam();
        para.setCompanyIds(this.getCompanyIds());
        Object[] bankIds = AccessHelper.getF7Ids((KDBizPromptBox)this.f7Bank);
        if (bankIds == null) {
            IObjectPK[] pks = null;
            try {
                pks = BankFactory.getRemoteInstance().getPKList();
            }
            catch (EASBizException e) {
                SysUtil.abort();
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
            bankIds = new String[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                bankIds[i] = ((BOSUuid)pks[i].getKeyValue("id")).toString();
            }
            if (FMHelper.isEmpty((Object[])bankIds)) {
                bankIds = new String[]{BOSUuid.create((BOSObjectType)new BankInfo().getBOSType()).toString()};
            }
        }
        para.setBankIds((String[])bankIds);
        para.setByBank(this.btnByBank.isSelected());
        para.setBeginPeriod(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndPeriod(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        para.setIncludeCash(this.chkIsIncludeCashAccount.isSelected());
        para.setIncludeUnSettBill(this.chkIsIncludeUnsettledBill.isSelected());
        para.setNotShowAmtIsNull(this.chkIsNotShowNoAmount.isSelected());
        para.setShowTotal(this.chkIsShowTotal.isSelected());
        para.setShowSubTotal(this.chkIsShowSubTotal.isSelected());
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            para.setCurrencyIds(new String[]{AccessHelper.getCboId((KDComboBox)this.comboCurrency)});
        } else {
            CurrencyCollection currencys = null;
            try {
                currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            }
            catch (EASBizException e) {
                SysUtil.abort();
            }
            catch (BOSException e) {
                SysUtil.abort();
            }
            int size = currencys.size();
            String[] currencyIds = new String[size];
            for (int i = 0; i < size; ++i) {
                currencyIds[i] = currencys.get(i).getId().toString();
            }
            para.setCurrencyIds(currencyIds);
        }
        para.setCompanyTree(this.getCompanyTree());
        AccountTableInfo acctTable = (AccountTableInfo)this.comboAccountTable.getSelectedItem();
        para.setAcctTableId(acctTable.getId().toString());
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboPeriodType.getSelectedItem();
        para.setPeriodTypeId(periodType.getId().toString());
        return para;
    }

    public TreeModel getTreeModel() throws EASBizException, BOSException {
        AccountTableInfo acctTable = (AccountTableInfo)this.comboAccountTable.getSelectedItem();
        if (acctTable == null) {
            return null;
        }
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboPeriodType.getSelectedItem();
        if (periodType == null) {
            return null;
        }
        TreeModel tree = null;
        try {
            tree = NewOrgUtils.getCompanyTreeModel((String)acctTable.getId().toString(), (String)periodType.getId().toString(), (String)this.currentCompany.getId().toString(), (boolean)true, (IMetaDataPK)this.getListUI().getMetaDataPK(), (IMetaDataPK)FMHelper.getActionPK((ItemAction)this.getActionListOnLoad()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return tree;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        CapitalSummaryLegerFilterParam filterParam = (CapitalSummaryLegerFilterParam)param;
        String[] currencyId = filterParam.getCurrencyIds();
        CurrencyInfo currencyInfo = null;
        AccountTableInfo acctTable = null;
        PeriodTypeInfo periodType = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId[0]));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
            acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)filterParam.getAcctTableId())));
            periodType = PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)filterParam.getPeriodTypeId())));
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        this.btnByBank.setSelected(filterParam.isByBank());
        this.btnByCompany.setSelected(!filterParam.isByBank());
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginPeriod()));
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndPeriod()));
        this.chkIsIncludeCashAccount.setSelected(filterParam.isIncludeCash());
        this.chkIsShowTotal.setSelected(filterParam.isShowTotal());
        this.chkIsShowSubTotal.setSelected(filterParam.isShowSubTotal());
        this.chkIsIncludeUnsettledBill.setSelected(filterParam.isIsIncludeUnSettBill());
        this.chkIsNotShowNoAmount.setSelected(filterParam.isNotShowAmtIsNull());
        if (!FMHelper.isEmpty((Object[])filterParam.getBankIds())) {
            try {
                IBank bank = BankFactory.getRemoteInstance();
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])filterParam.getBankIds()), CompareType.INCLUDE));
                ev.setFilter(filter);
                this.f7Bank.setValue((Object)bank.getCollection(ev).toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.f7Bank.setValue(null);
        }
        this.comboAccountTable.setSelectedItem((Object)acctTable);
        this.comboPeriodType.setSelectedItem((Object)periodType);
    }

    @Override
    protected void spiBeginMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        super.spiBeginMonth_stateChanged(e);
    }

    @Override
    protected void spiBeginYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                PeriodHelper.setPeriodNum(companyInfo, this.spiBeginMonth, (Integer)this.spiBeginYear.getValue());
            }
            catch (Exception ex) {
                SysUtil.abort((Throwable)ex);
            }
        } else {
            this.setMonthModel(this.spiBeginMonth, (Integer)this.spiBeginYear.getValue());
        }
        super.spiBeginYear_stateChanged(e);
    }

    @Override
    protected void spiEndMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        super.spiEndMonth_stateChanged(e);
    }

    @Override
    protected void spiEndYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                PeriodHelper.setPeriodNum(companyInfo, this.spiEndMonth, (Integer)this.spiEndYear.getValue());
            }
            catch (Exception ex) {
                SysUtil.abort((Throwable)ex);
            }
        } else {
            this.setMonthModel(this.spiEndMonth, (Integer)this.spiEndYear.getValue());
        }
        super.spiEndYear_stateChanged(e);
    }

    @Override
    protected void btnByCompany_actionPerformed(ActionEvent e) throws Exception {
        this.chkIsShowTotal.setEnabled(false);
        super.btnByCompany_actionPerformed(e);
    }

    @Override
    protected void btnByBank_actionPerformed(ActionEvent e) throws Exception {
        this.chkIsShowTotal.setEnabled(true);
        super.btnByBank_actionPerformed(e);
    }

    public void clear() {
        super.clear();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnByBank.setEnabled(false);
            this.btnByCompany.setEnabled(false);
            this.btnByBank.setSelected(true);
            this.comboAccountTable.setEnabled(false);
            this.comboPeriodType.setEnabled(false);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboAccountTable, (Object)this.currentCompany.getAccountTable());
            FMClientHelper.setSelectObject((KDComboBox)this.comboPeriodType, (Object)this.currentCompany.getAccountPeriodType());
            this.btnByBank.setSelected(true);
        }
        this.chkIsShowTotal.setSelected(true);
        this.chkIsShowSubTotal.setSelected(false);
        this.f7Bank.setValue(null);
        this.chkIsIncludeCashAccount.setSelected(false);
        this.chkIsNotShowNoAmount.setVisible(false);
        try {
            if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            } else {
                GregorianCalendar cal = new GregorianCalendar();
                PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Date)cal.getTime(), (CompanyOrgUnitInfo)this.currentCompany);
                this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiBeginMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiEndMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            }
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany));
            try {
                IBank bank = BankFactory.getRemoteInstance();
                this.f7Bank.setValue((Object)bank.getCollection().toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.initCompany();
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
        this.spiBeginYear.requestFocus();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.spiBeginYear.requestFocus();
    }

    protected Class getParamClass() {
        return CapitalSummaryLegerFilterParam.class;
    }
}

