/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fi.cas.client.AbstractCapitalSummaryLegerUI;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerUI;
import com.kingdee.eas.fi.cas.client.CapitalSummaryLegerFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalSummaryLegerFilterUI;
import com.kingdee.eas.fi.cas.client.CapitalSummaryLegerHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class CapitalSummaryLegerUI
extends AbstractCapitalSummaryLegerUI {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";
    private static Logger logger = Logger.getLogger((String)CapitalSummaryLegerUI.class.getName());
    private XTable accountViews = null;
    private XTable banks;
    private XTable companys;
    private XTable currencys;
    private Map exchangeMap = new HashMap();
    private CapitalSummaryLegerFilterUI filterUI;
    private CapitalSummaryLegerHandler handler = new CapitalSummaryLegerHandler();
    CapitalSummaryLegerFilterParam para;
    private XTable xBalanceTable = null;
    private XTable xSumTable = null;

    @Override
    public void actionShowDetail_actionPerformed(ActionEvent e) throws Exception {
        CapitalSubLegerFilterParam param = new CapitalSubLegerFilterParam();
        KDTSelectBlock block = this.tblMain.getSelectManager().get(0);
        if (block == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        IRow selectRow = this.tblMain.getRow(block.getTop());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)selectRow.getCell("company").getUserObject();
        if (company == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NotOnlyUnionMsg"));
            SysUtil.abort();
            return;
        }
        param.setCompanyIds(new String[]{company.getId().toString()});
        PeriodInfo period = (PeriodInfo)selectRow.getCell("period").getValue();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(period.getBeginDate());
        int beginYear = period.getPeriodYear();
        int beginMonth = period.getPeriodNumber();
        param.setBeginYear(beginYear);
        param.setBeginMonth(beginMonth);
        param.setEndYear(beginYear);
        param.setEndMonth(beginMonth);
        param.setIncludeUnSettBill(this.para.isIsIncludeUnSettBill());
        param.setFromDate(period.getBeginDate());
        param.setToDate(period.getEndDate());
        FMSysDefinedEnum currency = FMSysDefinedEnum.SELECT_ALL;
        if (this.para.getCurrencyIds() != null && this.para.getCurrencyIds().length == 1) {
            currency = (CurrencyInfo)selectRow.getCell("currency").getValue();
        }
        AccountBankInfo acctBank = (AccountBankInfo)selectRow.getCell("bankAccount").getValue();
        AccountViewInfo acct = null;
        if (acctBank == null) {
            acct = (AccountViewInfo)selectRow.getCell("accountView").getValue();
        }
        CapitalSubLegerUI.showCapitalSubUI((IUIObject)this, param, currency, acctBank, acct);
        super.actionShowDetail_actionPerformed(e);
    }

    private void changeRowExpandState(IRow row) {
        ICell cell = row.getCell("company");
        Object oTreeNode = cell.getValue();
        if (oTreeNode instanceof CellTreeNode) {
            CellTreeNode treeNode = (CellTreeNode)oTreeNode;
            for (int i = row.getRowIndex() + 1; i < this.tblMain.getRowCount(); ++i) {
                IRow row2 = this.tblMain.getRow(i);
                Object oTreeNode2 = row2.getCell("company").getValue();
                if (oTreeNode2 instanceof CellTreeNode) {
                    CellTreeNode treeNode2 = (CellTreeNode)oTreeNode2;
                    if (treeNode2.getTreeLevel() <= treeNode.getTreeLevel()) break;
                    row2.getStyleAttributes().setHided(!treeNode.isCollapse());
                    treeNode2.setCollapse(!treeNode.isCollapse());
                    continue;
                }
                row2.getStyleAttributes().setHided(!treeNode.isCollapse());
            }
            treeNode.setCollapse(!treeNode.isCollapse());
        }
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getGroupManager().setGroup(false);
    }

    protected void execQuery() throws BOSException {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.para = (CapitalSummaryLegerFilterParam)this.getFilterParam();
        FMClientHelper.clearTable((KDTable)this.tblMain);
        try {
            this.handler.initTable(this.tblMain, this.para.getCurrencyIds(), this.para.isByBank());
            if (this.para.getCompanyIds() != null) {
                this.genCompanys(this.para.getCompanyIds());
                this.genAccountView(this.para.getAcctTableId());
                this.genCurrencys(this.para.getCurrencyIds());
                this.genBanks(this.para.getBankIds());
                this.xSumTable = this.handler.createSumTable(this.para);
                this.xBalanceTable = this.handler.createBalanceTable(this.para);
                this.fillData();
                this.hideZeroRow();
                this.changNegativeAmount();
            }
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private void fillCashData(CompanyOrgUnitInfo company, PeriodInfo period, int level) throws EASBizException, BOSException {
        List accts = this.accountViews.getEqualRows("cu", company.getCU().getId().toString());
        for (int j = 0; j < accts.size(); ++j) {
            AccountViewInfo acct = (AccountViewInfo)((Map)accts.get(j)).get("UserObject");
            IRow row = this.tblMain.addRow();
            if (this.para.isByBank()) {
                row.getCell("company").setValue((Object)company);
                row.getCell("company").setUserObject((Object)company);
            } else {
                CellTreeNode node = new CellTreeNode();
                node.setTreeLevel(level);
                row.getCell("company").setValue((Object)node);
                row.getCell("company").setUserObject((Object)company);
            }
            row.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"cash"));
            row.getCell("accountView").setValue((Object)acct);
            company.setId(BOSUuid.read((String)company.getId().toString()));
            CurrencyInfo currency = (CurrencyInfo)this.currencys.getRow(this.para.getCurrencyIds()[0]).get("UserObject");
            row.getCell("currency").setValue((Object)currency);
            row.getCell("period").setValue((Object)period);
            PeriodInfo nextPeriod = this.getNextPeriod(company, period);
            if (this.para.getCurrencyIds().length == 1) {
                BigDecimal exchange = SysConstant.BIGZERO;
                String strPre = null;
                exchange = this.getExchange(company.getId().toString(), this.para.getCurrencyIds()[0]);
                strPre = "%r-[ ]0." + CashHelper.getExchangePre(company.getId().toString(), this.para.getCurrencyIds()[0], null) + "n";
                row.getCell("exchange").getStyleAttributes().setNumberFormat(strPre);
                row.getCell("exchange").setValue((Object)exchange);
            }
            String rowKey = null;
            rowKey = this.para.isByBank() ? period.getPeriodYear() + "" + period.getPeriodNumber() + "null" + acct.getId().toString() + "null" + company.getId().toString() : period.getPeriodYear() + "" + period.getPeriodNumber() + company.getId().toString() + acct.getId().toString() + "null" + company.getId().toString();
            String nextRowKey = "";
            if (nextPeriod != null) {
                nextRowKey = this.para.isByBank() ? nextPeriod.getPeriodYear() + "" + nextPeriod.getPeriodNumber() + "null" + acct.getId().toString() + "null" + company.getId().toString() : nextPeriod.getPeriodYear() + "" + nextPeriod.getPeriodNumber() + company.getId().toString() + acct.getId().toString() + "null" + company.getId().toString();
            }
            this.fillRowData(row, rowKey, nextRowKey);
        }
    }

    public void fillData() throws EASBizException, BOSException {
        this.tblMain.setRefresh(false);
        for (int i = 0; i < this.para.getPeriodCol().size(); ++i) {
            PeriodInfo period = this.para.getPeriodCol().get(i);
            if (this.para.isByBank()) {
                this.fillDataByBanks(period);
                if (this.para.isIncludeCash()) {
                    for (int j = 0; j < this.companys.getRowCount(); ++j) {
                        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.companys.getRow(j).get("UserObject");
                        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                        this.fillCashData(company, period, 0);
                    }
                }
                if (this.para.isShowTotal()) {
                    this.setTotal(this.tblMain, this.para.getCurrencyIds());
                }
                if (!this.para.isShowSubTotal()) continue;
                this.setSubTotal(this.tblMain, this.para.getCurrencyIds(), this.para.isShowTotal());
                continue;
            }
            this.fillDataByCompanyTree((DefaultMutableTreeNode)this.para.getCompanyTree().getRoot(), period, 0);
        }
        this.tblMain.getGroupManager().group();
        if (!this.para.isByBank()) {
            ArrayList<String> amountColumns = new ArrayList<String>();
            String[] currencyIds = this.para.getCurrencyIds();
            for (int i = 0; i < currencyIds.length; ++i) {
                String currencyId = currencyIds[i];
                amountColumns.add("beginBalance_" + currencyId);
                amountColumns.add("debit_" + currencyId);
                amountColumns.add("credit_" + currencyId);
                amountColumns.add("endBalance_" + currencyId);
            }
            amountColumns.add("debitCount");
            amountColumns.add("creditCount");
            this.setUnionData(amountColumns.toArray(new String[0]));
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private void changNegativeAmount() {
        String[] currencyIds = this.para.getCurrencyIds();
        if (currencyIds.length == 1) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                BigDecimal endBalance = null;
                BigDecimal localEndBalance = null;
                if (row.isStat() && this.para.isByBank()) {
                    endBalance = (BigDecimal)((Variant)row.getCell("endBalance_" + currencyIds[0]).getValue()).getValue();
                    localEndBalance = (BigDecimal)((Variant)row.getCell("localEndBalance_" + currencyIds[0]).getValue()).getValue();
                } else {
                    endBalance = (BigDecimal)row.getCell("endBalance_" + currencyIds[0]).getValue();
                    localEndBalance = (BigDecimal)row.getCell("localEndBalance_" + currencyIds[0]).getValue();
                }
                if (endBalance != null) {
                    row.getCell("endBalance_" + currencyIds[0]).setValue((Object)endBalance.abs());
                    if (endBalance.signum() == 0) {
                        row.getCell("dc").setValue((Object)DirectionEnum.Balance);
                    } else if (endBalance.signum() > 0) {
                        row.getCell("dc").setValue((Object)DirectionEnum.Debit);
                    } else {
                        row.getCell("dc").setValue((Object)DirectionEnum.Credit);
                    }
                }
                if (localEndBalance == null) continue;
                row.getCell("localEndBalance_" + currencyIds[0]).setValue((Object)localEndBalance.abs());
            }
        }
    }

    private void hideZeroRow() {
        String[] currencyIds = this.para.getCurrencyIds();
        if (this.para.getCurrencyIds().length > 1) {
            CurrencyInfo baseCurrency;
            Object currencyId;
            int i;
            for (int i2 = 0; i2 < currencyIds.length; ++i2) {
                String currencyId2 = currencyIds[i2];
                this.tblMain.getColumn("beginBalance_" + currencyId2).getStyleAttributes().setHided(true);
                this.tblMain.getColumn("debit_" + currencyId2).getStyleAttributes().setHided(true);
                this.tblMain.getColumn("credit_" + currencyId2).getStyleAttributes().setHided(true);
                this.tblMain.getColumn("endBalance_" + currencyId2).getStyleAttributes().setHided(true);
            }
            HashSet<Object> currencyIdSet = new HashSet<Object>();
            for (i = 0; i < this.xSumTable.getRowCount(); ++i) {
                Map map = this.xSumTable.getRow(i);
                currencyId = map.get("currency");
                if (currencyId == null) continue;
                currencyIdSet.add(currencyId);
            }
            for (i = 0; i < this.xBalanceTable.getRowCount(); ++i) {
                Map map = this.xBalanceTable.getRow(i);
                currencyId = map.get("currency");
                if (currencyId == null) continue;
                currencyIdSet.add(currencyId);
            }
            if (currencyIdSet.size() == 0 && (baseCurrency = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency()) != null) {
                currencyIdSet.add(baseCurrency.getId().toString());
            }
            for (String string : currencyIdSet) {
                this.tblMain.getColumn("beginBalance_" + string).getStyleAttributes().setHided(false);
                this.tblMain.getColumn("debit_" + string).getStyleAttributes().setHided(false);
                this.tblMain.getColumn("credit_" + string).getStyleAttributes().setHided(false);
                this.tblMain.getColumn("endBalance_" + string).getStyleAttributes().setHided(false);
            }
        }
    }

    private void fillDataByBanks(PeriodInfo period) throws EASBizException, BOSException, UuidException {
        int size = this.banks.getRowCount();
        String[] currencyIds = this.para.getCurrencyIds();
        CurrencyInfo currency = (CurrencyInfo)this.currencys.getRow(currencyIds[0]).get("UserObject");
        for (int i = 0; i < size; ++i) {
            BankInfo bank = (BankInfo)this.banks.getRow(i).get("UserObject");
            AccountBankCollection col = CashHelper.getAccountBankCollection(this.para.getCompanyIds(), new String[]{bank.getId().toString()}, true);
            BigDecimal exchange = SysConstant.BIGZERO;
            String strPre = null;
            for (int j = 0; j < col.size(); ++j) {
                AccountBankInfo accountBank = col.get(j);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(accountBank.getCompany().getId());
                if (this.para.getCurrencyIds().length == 1) {
                    exchange = this.getExchange(accountBank.getCompany().getId().toString(), currencyIds[0]);
                    strPre = "%r-[ ]0." + CashHelper.getExchangePre(accountBank.getCompany().getId().toString(), currencyIds[0], null) + "n";
                }
                IRow row = this.tblMain.addRow();
                row.getCell("bank").setValue((Object)bank.getName());
                row.getCell("bankAccount").setValue((Object)accountBank);
                row.getCell("accountView").setValue((Object)accountBank.getAccount());
                row.getCell("period").setValue((Object)period);
                row.getCell("company").setValue((Object)accountBank.getCompany());
                row.getCell("company").setUserObject((Object)accountBank.getCompany());
                row.getCell("currency").setValue((Object)currency);
                row.getCell("exchange").setValue((Object)exchange);
                row.getCell("exchange").getStyleAttributes().setNumberFormat(strPre);
                String rowKey = period.getPeriodYear() + "" + period.getPeriodNumber() + bank.getId().toString() + accountBank.getAccount().getId().toString() + accountBank.getId().toString() + company.getId().toString();
                PeriodInfo nextPeriod = this.getNextPeriod(company, period);
                String nextRowKey = "";
                if (nextPeriod != null) {
                    nextRowKey = nextPeriod.getPeriodYear() + "" + nextPeriod.getPeriodNumber() + bank.getId().toString() + accountBank.getAccount().getId().toString() + accountBank.getId().toString() + company.getId().toString();
                }
                this.fillRowData(row, rowKey, nextRowKey);
            }
        }
    }

    private BigDecimal getExchange(String companyId, String currencyId) throws EASBizException, BOSException {
        String key = companyId + currencyId;
        BigDecimal exchange = null;
        if (this.exchangeMap.containsKey(key)) {
            exchange = (BigDecimal)this.exchangeMap.get(key);
        } else {
            exchange = CashHelper.getExchange(companyId, currencyId, null);
            this.exchangeMap.put(key, exchange);
        }
        return exchange;
    }

    private void fillDataByCompany(CompanyOrgUnitInfo company, PeriodInfo period, int level) throws BOSException, EASBizException {
        List accts;
        String[] companyIds = new String[]{company.getId().toString()};
        String[] currencyIds = this.para.getCurrencyIds();
        AccountBankCollection accountBankCollection = CashHelper.getAccountBankCollection(companyIds, this.para.getBankIds(), true);
        PeriodInfo nextPeriod = this.getNextPeriod(company, period);
        CurrencyInfo currency = (CurrencyInfo)this.currencys.getRow(currencyIds[0]).get("UserObject");
        BigDecimal exchange = SysConstant.BIGZERO;
        int stateLineCount = 0;
        int size = accountBankCollection.size();
        int curAccountCount = 0;
        for (int i = 0; i < size; ++i) {
            AccountBankInfo accountBank = accountBankCollection.get(i);
            String rowKey = period.getPeriodYear() + "" + period.getPeriodNumber() + company.getId().toString() + accountBank.getAccount().getId().toString() + accountBank.getId().toString() + company.getId().toString();
            String nextRowKey = "";
            if (nextPeriod != null) {
                nextRowKey = nextPeriod.getPeriodYear() + "" + nextPeriod.getPeriodNumber() + company.getId().toString() + accountBank.getAccount().getId().toString() + accountBank.getId().toString() + company.getId().toString();
            }
            IRow row = this.tblMain.addRow();
            CellTreeNode node = new CellTreeNode();
            node.setTreeLevel(level);
            node.setValue((Object)company);
            row.getCell("period").setValue((Object)period);
            row.getCell("company").setValue((Object)node);
            row.getCell("company").setUserObject((Object)company);
            row.getCell("bank").setValue((Object)accountBank.getBank());
            row.getCell("bankAccount").setValue((Object)accountBank);
            row.getCell("bankAccount").setUserObject((Object)accountBank);
            row.getCell("accountView").setValue((Object)accountBank.getAccount());
            row.getCell("currency").setValue((Object)currency);
            row.getCell("exchange").setValue((Object)exchange);
            this.fillRowData(row, rowKey, nextRowKey);
            ++curAccountCount;
            if (!this.para.isShowSubTotal() || i != size - 1 && accountBank.getBank().getId().toString().equals(accountBankCollection.get(i + 1).getBank().getId().toString())) continue;
            if (curAccountCount > 1) {
                IRow subRow = this.tblMain.addRow();
                subRow.setStat(true);
                CellTreeNode subNode = new CellTreeNode();
                subNode.setCollapse(false);
                subNode.setTreeLevel(level);
                subRow.getCell("period").setValue((Object)period);
                subRow.getCell("company").setValue((Object)subNode);
                subRow.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"subTotal", (Object[])new Object[]{accountBank.getBank().getName()}));
                subRow.getCell("dc").setValue((Object)DirectionEnum.Debit);
                this.setSumCell(this.tblMain, subRow.getCell("debitCount"), curAccountCount);
                this.setSumCell(this.tblMain, subRow.getCell("creditCount"), curAccountCount);
                for (int j = 0; j < currencyIds.length; ++j) {
                    this.setSumCell(this.tblMain, subRow.getCell("debit_" + currencyIds[j]), curAccountCount);
                    this.setSumCell(this.tblMain, subRow.getCell("localDebit_" + currencyIds[j]), curAccountCount);
                    this.setSumCell(this.tblMain, subRow.getCell("credit_" + currencyIds[j]), curAccountCount);
                    this.setSumCell(this.tblMain, subRow.getCell("localCredit_" + currencyIds[j]), curAccountCount);
                    this.setSumCell(this.tblMain, subRow.getCell("beginBalance_" + currencyIds[j]), curAccountCount);
                    this.setSumCell(this.tblMain, subRow.getCell("endBalance_" + currencyIds[j]), curAccountCount);
                }
                subRow.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
                ++stateLineCount;
            }
            curAccountCount = 0;
        }
        if (this.para.isShowSubTotal() && (size += stateLineCount) > 0) {
            IRow row = this.tblMain.addRow();
            row.setStat(true);
            CellTreeNode node = new CellTreeNode();
            node.setCollapse(false);
            node.setTreeLevel(level);
            row.getCell("period").setValue((Object)period);
            row.getCell("company").setValue((Object)node);
            row.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"subBankTotal"));
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
            this.setSumCell(this.tblMain, row.getCell("debitCount"), size);
            this.setSumCell(this.tblMain, row.getCell("creditCount"), size);
            for (int j = 0; j < currencyIds.length; ++j) {
                this.setSumCell(this.tblMain, row.getCell("debit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("localDebit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("credit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("localCredit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("beginBalance_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("endBalance_" + currencyIds[j]), size);
            }
            row.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
        }
        if (this.para.isIncludeCash()) {
            this.fillCashData(company, period, level);
        }
        if (this.para.isShowSubTotal() && this.para.isIncludeCash() && (size = (accts = this.accountViews.getEqualRows("cu", company.getCU().getId().toString())).size()) > 0) {
            IRow row = this.tblMain.addRow();
            row.setStat(true);
            CellTreeNode node = new CellTreeNode();
            node.setCollapse(false);
            node.setTreeLevel(level);
            row.getCell("period").setValue((Object)period);
            row.getCell("company").setValue((Object)node);
            row.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"subCashTotal"));
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
            this.setSumCell(this.tblMain, row.getCell("debitCount"), size);
            this.setSumCell(this.tblMain, row.getCell("creditCount"), size);
            for (int j = 0; j < currencyIds.length; ++j) {
                this.setSumCell(this.tblMain, row.getCell("debit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("localDebit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("credit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("localCredit_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("beginBalance_" + currencyIds[j]), size);
                this.setSumCell(this.tblMain, row.getCell("endBalance_" + currencyIds[j]), size);
            }
            row.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
        }
    }

    private void fillDataByCompanyTree(DefaultMutableTreeNode companyNode, PeriodInfo period, int level) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyNode.getUserObject();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || !company.isIsLeaf()) {
            this.fillDataByUnit(company, period, level);
            for (int i = 0; i < companyNode.getChildCount(); ++i) {
                this.fillDataByCompanyTree((DefaultMutableTreeNode)companyNode.getChildAt(i), period, level + 1);
            }
        } else {
            this.fillDataByCompany(company, period, level);
        }
    }

    private void fillDataByUnit(CompanyOrgUnitInfo company, PeriodInfo period, int level) throws EASBizException, BOSException {
        String[] currencyIds = this.para.getCurrencyIds();
        IRow row = this.tblMain.addRow();
        CellTreeNode node = new CellTreeNode();
        node.setTreeType(0);
        node.setHasChildren(true);
        node.setTreeLevel(level);
        node.setValue((Object)company);
        row.getCell("period").setValue((Object)period);
        row.getCell("company").setValue((Object)node);
        row.getCell("company").setUserObject((Object)company);
        CurrencyInfo currency = (CurrencyInfo)this.currencys.getRow(currencyIds[0]).get("UserObject");
        row.getCell("currency").setValue((Object)currency);
        if (currencyIds.length == 1) {
            BigDecimal exchange = SysConstant.BIGZERO;
            exchange = this.getExchange(company.getId().toString(), currencyIds[0]);
            row.getCell("exchange").setValue((Object)exchange);
        }
        row.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
    }

    private void fillRowData(IRow row, String rowKey, String nextKey) {
        String[] currencyIds = this.para.getCurrencyIds();
        int debitCount = 0;
        int creditCount = 0;
        for (int j = 0; j < currencyIds.length; ++j) {
            BigDecimal exchange;
            String currencyId = currencyIds[j];
            Map rowSum = this.xSumTable.getRow(rowKey + currencyId);
            Map rowBalance = this.xBalanceTable.getRow(rowKey + currencyId);
            BigDecimal beginBalance = SysConstant.BIGZERO;
            BigDecimal debitAmount = SysConstant.BIGZERO;
            BigDecimal creditAmount = SysConstant.BIGZERO;
            BigDecimal endBalance = SysConstant.BIGZERO;
            if (rowSum != null) {
                Object oCreditCount;
                Object oDebitCount;
                Object oCreditAmount;
                Object oDebitAmount = rowSum.get("debitamount");
                if (oDebitAmount != null) {
                    debitAmount = TypeConversionUtils.objToBigDecimal(oDebitAmount);
                }
                if ((oCreditAmount = rowSum.get("creditamount")) != null) {
                    creditAmount = TypeConversionUtils.objToBigDecimal(oCreditAmount);
                }
                if ((oDebitCount = rowSum.get("debitcount")) != null) {
                    debitCount += TypeConversionUtils.objToInt(oDebitCount);
                }
                if ((oCreditCount = rowSum.get("creditcount")) != null) {
                    creditCount += TypeConversionUtils.objToInt(oCreditCount);
                }
            }
            if (rowBalance != null) {
                beginBalance = TypeConversionUtils.objToBigDecimal(rowBalance.get("beginbalance"));
                if (beginBalance == null) {
                    beginBalance = SysConstant.BIGZERO;
                }
                endBalance = debitAmount.subtract(creditAmount).add(beginBalance);
            } else {
                endBalance = debitAmount.subtract(creditAmount);
            }
            if (this.xBalanceTable.getRow(nextKey + currencyId) == null) {
                Map nextRow = this.xBalanceTable.addRow(nextKey + currencyId);
                nextRow.put("beginbalance", endBalance);
            }
            row.getCell("beginBalance_" + currencyId).setValue((Object)beginBalance);
            row.getCell("debit_" + currencyId).setValue((Object)debitAmount);
            row.getCell("credit_" + currencyId).setValue((Object)creditAmount);
            if (currencyIds.length != 1) {
                row.getCell("dc").setValue((Object)DirectionEnum.Debit);
                row.getCell("endBalance_" + currencyId).setValue((Object)endBalance);
            } else {
                if (endBalance.signum() == 0) {
                    row.getCell("dc").setValue((Object)DirectionEnum.Balance);
                } else if (endBalance.signum() == -1) {
                    row.getCell("dc").setValue((Object)DirectionEnum.Credit);
                } else {
                    row.getCell("dc").setValue((Object)DirectionEnum.Debit);
                }
                row.getCell("endBalance_" + currencyId).setValue((Object)endBalance);
            }
            if (currencyIds.length != 1 || (exchange = (BigDecimal)row.getCell("exchange").getValue()) == null) continue;
            row.getCell("localBeginBalance_" + currencyId).setValue((Object)exchange.multiply(beginBalance));
            row.getCell("localDebit_" + currencyId).setValue((Object)exchange.multiply(debitAmount));
            row.getCell("localCredit_" + currencyId).setValue((Object)exchange.multiply(creditAmount));
            row.getCell("localEndBalance_" + currencyId).setValue((Object)exchange.multiply(endBalance));
        }
        row.getCell("debitCount").setValue((Object)new Integer(debitCount));
        row.getCell("creditCount").setValue((Object)new Integer(creditCount));
    }

    private void genAccountView(String accoutViewTableId) throws BOSException {
        HashSet<String> cuSet = new HashSet<String>();
        for (int i = 0; i < this.companys.getRowCount(); ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.companys.getRow(i).get("UserObject");
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
            cuSet.add(company.getCU().getId().toString());
        }
        if (cuSet.size() == 0) {
            this.accountViews = new XTable();
            return;
        }
        IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("cu.id", cuSet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        items.add(new FilterItemInfo("isCash", (Object)new Integer(1)));
        items.add(new FilterItemInfo("accountTableId.id", (Object)accoutViewTableId));
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("accountTable.*"));
        selector.add(new SelectorItemInfo("company.*"));
        view.getSorter().add(new SorterItemInfo("number"));
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(view);
        this.accountViews = new XTable((IObjectCollection)acctViewCol, "cu");
    }

    private void genBanks(String[] bankIds) throws BOSException {
        BankCollection bankCollection = BankFactory.getRemoteInstance().getBankCollection(CashHelper.getIncludeEntityView("id", bankIds));
        this.banks = new XTable((IObjectCollection)bankCollection, (String)null);
    }

    private void genCompanys(String[] companyIds) throws BOSException {
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(CashHelper.getIncludeEntityView("id", companyIds));
        this.companys = new XTable((IObjectCollection)companyCol, (String)null);
    }

    private void genCurrencys(String[] currencyIds) throws BOSException {
        CurrencyCollection currencyCol = CurrencyFactory.getRemoteInstance().getCurrencyCollection(CashHelper.getIncludeEntityView("id", currencyIds));
        this.currencys = new XTable((IObjectCollection)currencyCol, (String)null);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CapitalSummaryLegerFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    private PeriodInfo getNextPeriod(CompanyOrgUnitInfo company, PeriodInfo periodInfo) throws EASBizException, BOSException {
        PeriodInfo nextPeriod = PeriodHelper.getNextPeriodInfo(company, periodInfo);
        if (nextPeriod == null) {
            nextPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)periodInfo);
        }
        return nextPeriod;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog commonQueryDialog = super.getQueryDlg();
        commonQueryDialog.setWidth(400);
        commonQueryDialog.setHeight(350);
        return commonQueryDialog;
    }

    private void initTreeCollapse() {
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1) {
                    if (CapitalSummaryLegerUI.this.para.isByBank()) {
                        return;
                    }
                    if (!CapitalSummaryLegerUI.this.tblMain.getColumnKey(e.getColIndex()).equals("company")) {
                        return;
                    }
                    IRow row = CapitalSummaryLegerUI.this.tblMain.getRow(e.getRowIndex());
                    CapitalSummaryLegerUI.this.changeRowExpandState(row);
                }
            }
        });
    }

    protected void initWorkButton() {
        this.btnShowDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.kDMenuItemViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuView.setVisible(false);
        super.initWorkButton();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        boolean flag;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo) && !(flag = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NoFinishInit"));
            SysUtil.abort();
        }
        this.initTreeCollapse();
        this.tblMain.getViewManager().setFreezeView(0, 4);
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("shift ctrl alt F8"){

            public void action_actionPerformed() {
                CapitalSummaryLegerFilterParam para = (CapitalSummaryLegerFilterParam)CapitalSummaryLegerUI.this.getFilterParam();
                try {
                    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                    JournalFactory.getRemoteInstance().reCalculateSummary(GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo) ? null : companyInfo.getId().toString(), para.getBeginDate(), para.getEndDate());
                    CapitalSummaryLegerUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("shift ctrl alt F9"){

            public void action_actionPerformed() {
                CapitalSummaryLegerFilterParam para = (CapitalSummaryLegerFilterParam)CapitalSummaryLegerUI.this.getFilterParam();
                try {
                    JournalFactory.getRemoteInstance().reCalculateSummary(null, null, null);
                    CapitalSummaryLegerUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        super.onLoad();
    }

    private void setSubTotal(KDTable table, String[] currencyIds, boolean isShowTotal) {
        table.getColumn("bank").setGroup(true);
        table.getColumn("bank").setStat(true);
        table.getColumn("bank").setMergeable(false);
        int stateIndex = 0;
        if (isShowTotal) {
            stateIndex = 1;
        }
        IRow row = table.getGroupManager().getStatRowTemplate(stateIndex);
        row.getStyleAttributes().setBackground(ClientUtils.DAY_SUM_COLOR);
        row.getCell("bankAccount").setValue((Object)EASResource.getString((String)resourcePath, (String)"subTotal"));
        row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            this.handler.setRowFormat(row, currencyId);
            row.getCell("beginBalance_" + currencyId).setExpressions("SUM");
            row.getCell("localBeginBalance_" + currencyId).setExpressions("SUM");
            row.getCell("debit_" + currencyId).setExpressions("SUM");
            row.getCell("localDebit_" + currencyId).setExpressions("SUM");
            row.getCell("credit_" + currencyId).setExpressions("SUM");
            row.getCell("localCredit_" + currencyId).setExpressions("SUM");
            row.getCell("endBalance_" + currencyId).setExpressions("SUM");
            row.getCell("localEndBalance_" + currencyId).setExpressions("SUM");
        }
        row.getCell("debitCount").setExpressions("SUM");
        row.getCell("creditCount").setExpressions("SUM");
        row.getCell("period").setExpressions("=CELL(ROW_INDEX-1,COLUMN_INDEX).getValue()");
        row.getCell("currency").setExpressions("=CELL(ROW_INDEX-1,COLUMN_INDEX).getValue()");
    }

    private void setTotal(KDTable table, String[] currencyIds) {
        table.getColumn("period").setGroup(true);
        table.getColumn("period").setStat(true);
        table.getColumn("period").setMergeable(false);
        IRow row = table.getGroupManager().getStatRowTemplate(0);
        row.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
        row.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"total"));
        for (String currencyId : currencyIds) {
            this.handler.setRowFormat(row, currencyId);
            row.getCell("beginBalance_" + currencyId).setExpressions("SUM");
            row.getCell("localBeginBalance_" + currencyId).setExpressions("SUM");
            row.getCell("debit_" + currencyId).setExpressions("SUM");
            row.getCell("localDebit_" + currencyId).setExpressions("SUM");
            row.getCell("credit_" + currencyId).setExpressions("SUM");
            row.getCell("localCredit_" + currencyId).setExpressions("SUM");
            row.getCell("endBalance_" + currencyId).setExpressions("SUM");
            row.getCell("localEndBalance_" + currencyId).setExpressions("SUM");
        }
        row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        row.getCell("debitCount").setExpressions("SUM");
        row.getCell("creditCount").setExpressions("SUM");
        row.getCell("period").setExpressions("=CELL(ROW_INDEX-1,COLUMN_INDEX).getValue()");
        row.getCell("currency").setExpressions("=CELL(ROW_INDEX-1,COLUMN_INDEX).getValue()");
    }

    private void setUnionData(String[] amountColumns) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow rowAfter;
            CellTreeNode nodeAfter;
            IRow row = this.tblMain.getRow(i);
            CellTreeNode node = (CellTreeNode)row.getCell("company").getValue();
            if (node == null || !node.isHasChildren()) continue;
            int level = node.getTreeLevel();
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            for (int j = i + 1; j < this.tblMain.getRowCount() && (nodeAfter = (CellTreeNode)(rowAfter = this.tblMain.getRow(j)).getCell("company").getValue()) != null && nodeAfter.getTreeLevel() > level; ++j) {
                if (nodeAfter.isHasChildren() || !(nodeAfter.getValue() instanceof CompanyOrgUnitInfo)) continue;
                rowList.add(rowAfter);
            }
            for (int k = 0; k < amountColumns.length; ++k) {
                String colName = amountColumns[k];
                BigDecimal amount = FMConstants.ZERO;
                for (int rowIndex = 0; rowIndex < rowList.size(); ++rowIndex) {
                    IRow rowAdd = (IRow)rowList.get(rowIndex);
                    Object value = rowAdd.getCell(colName).getValue();
                    if (value == null) continue;
                    if (value instanceof BigDecimal) {
                        amount = amount.add((BigDecimal)value);
                        continue;
                    }
                    if (!(value instanceof Integer)) continue;
                    amount = amount.add(new BigDecimal(((Integer)value).toString()));
                }
                row.getCell(colName).setValue((Object)amount);
            }
        }
    }

    private void setSumCell(KDTable table, ICell cell, int sumCount) {
        int x = cell.getRowIndex();
        int y = cell.getColumnIndex();
        BigDecimal sum = FMConstants.ZERO;
        for (int i = x - sumCount; i < x; ++i) {
            if (table.getRow(i).isStat()) continue;
            ICell acuCell = table.getCell(i, y);
            if (acuCell.getValue() instanceof BigDecimal) {
                sum = sum.add((BigDecimal)acuCell.getValue());
                continue;
            }
            if (!(acuCell.getValue() instanceof Integer)) continue;
            sum = sum.add(new BigDecimal(((Integer)acuCell.getValue()).toString()));
        }
        cell.setValue((Object)sum);
    }
}

