/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CapitalVcSummaryFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CapitalVcSummaryFilterUIVerifyDTO;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractCapitalVcSummaryFilterUI;
import com.kingdee.eas.fi.cas.client.CapitalVcSummaryFilterParam;
import com.kingdee.eas.fi.cas.client.JournalHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.CompanyTreeSelectUI;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.query.QuerySolutionConvert;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CapitalVcSummaryFilterUI
extends AbstractCapitalVcSummaryFilterUI {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CapitalVcSummaryResource";
    private static Logger logger = Logger.getLogger((String)CapitalVcSummaryFilterUI.class.getName());
    private String actualAcctTableId = null;
    private String[] validCompanyIds = null;
    private Map paramMap;
    private Map periodMap = null;

    public CapitalVcSummaryFilterUI(Map paramHm) throws Exception {
        PeriodEntity pe = null;
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            pe = JournalHandler.requestPeriodEntity(this.currentCompany);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginPeriod, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndPeriod, (boolean)false, (boolean)false);
        }
        this.paramMap = paramHm;
    }

    protected void companyValueChange(Object object) throws Exception {
        if (CheckUtils.isArray((Object)object)) {
            CompanyOrgUnitInfo[] comps;
            for (CompanyOrgUnitInfo company : comps = (CompanyOrgUnitInfo[])ConvertUtils.ARRAY((Object)object, CompanyOrgUnitInfo.class)) {
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) continue;
                PeriodEntity pe = JournalHandler.requestPeriodEntity(company);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginPeriod, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndPeriod, (boolean)false, (boolean)false);
                break;
            }
        }
        super.companyValueChange(object);
    }

    public Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(key, (Object)this.getSetByArray(array), CompareType.INCLUDE));
        return view;
    }

    public Object getParam() {
        CapitalVcSummaryFilterParam para = new CapitalVcSummaryFilterParam();
        if (this.validCompanyIds != null) {
            para.setCompanyIds(this.validCompanyIds);
        } else {
            para.setCompanyIds(this.getCompanyIds());
        }
        para.setCompanyTree(this.getCompanyTree());
        String[] bankIds = AccessHelper.getF7Ids((KDBizPromptBox)this.f7Bank);
        para.setBankIds(bankIds);
        para.setBeginPeriod(AccessHelper.getSpiValue((KDSpinner)this.spiBeginPeriod));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndPeriod(AccessHelper.getSpiValue((KDSpinner)this.spiEndPeriod));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        para.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.comboCurrency));
        AccountTableInfo acctTable = (AccountTableInfo)this.comboAccountTable.getSelectedItem();
        para.setAcctTableId(acctTable.getId().toString());
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboPeriodType.getSelectedItem();
        para.setPeriodTypeId(periodType.getId().toString());
        para.setActualAcctTableId(this.actualAcctTableId);
        para.setHideNoDataAct(this.chkHideNoDataAccount.isSelected());
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        CapitalVcSummaryFilterParam filterParam = (CapitalVcSummaryFilterParam)param;
        String currencyId = filterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        AccountTableInfo acctTable = null;
        PeriodTypeInfo periodType = null;
        try {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)currencyId)));
            acctTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)filterParam.getAcctTableId())));
            periodType = PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)filterParam.getPeriodTypeId())));
            if (filterParam.getBankIds() != null && filterParam.getBankIds().length > 0) {
                IBank bank = BankFactory.getRemoteInstance();
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])filterParam.getBankIds()), CompareType.INCLUDE));
                ev.setFilter(filter);
                this.f7Bank.setValue((Object)bank.getCollection(ev).toArray());
            } else {
                this.f7Bank.setValue(null);
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
        this.spiBeginPeriod.setValue((Object)new Integer(filterParam.getBeginPeriod()));
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndPeriod.setValue((Object)new Integer(filterParam.getEndPeriod()));
        this.comboAccountTable.setSelectedItem((Object)acctTable);
        this.comboPeriodType.setSelectedItem((Object)periodType);
        this.chkHideNoDataAccount.setSelected(filterParam.isHideNoDataAct());
    }

    protected void init() throws Exception {
        this.initAccountTable();
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramMap.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.comboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.comboCurrency, currencyColl, false);
        }
        PeriodCollection pc = (PeriodCollection)this.paramMap.get("periodCollection");
        if (pc == null) {
            pc = this.getPeriodCollection(null);
        }
        if (null == pc || 0 == pc.size()) {
            throw new CasException(CasException.PERIODISNULL);
        }
        this.periodMap = new HashMap();
        this.periodMap.put("periodMap", pc);
        this.spiBeginYear_stateChanged(null);
        this.spiEndYear_stateChanged(null);
        super.init();
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.f7Bank);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginPeriod, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndPeriod, (boolean)false, (boolean)false);
            this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spiBeginPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
            this.spiEndPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        }
    }

    private void initAccountTable() throws BOSException, EASBizException, UuidException {
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            AccountTableInfo accountTableInfo = null;
            accountTableInfo = this.paramMap.get("accountTable") == null ? AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountTable().getId().toString()))) : (AccountTableInfo)this.paramMap.get("accountTable");
            this.comboAccountTable.addItem((Object)accountTableInfo);
            PeriodTypeInfo periodTypeInfo = null;
            periodTypeInfo = this.paramMap.get("periodType") == null ? PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountPeriodType().getId().toString()))) : (PeriodTypeInfo)this.paramMap.get("periodType");
            this.comboPeriodType.addItem((Object)periodTypeInfo);
            this.comboAccountTable.setEnabled(false);
            this.comboPeriodType.setEnabled(false);
        } else {
            AccountTableCollection accountTables = null;
            accountTables = this.paramMap.get("accountTableCol") == null ? CashHelper.getAccountViewTable(this.currentCompany) : (AccountTableCollection)this.paramMap.get("accountTableCol");
            this.comboAccountTable.addItems(accountTables.toArray());
            PeriodTypeCollection periodTypes = null;
            periodTypes = this.paramMap.get("periondCol") == null ? PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection() : (PeriodTypeCollection)this.paramMap.get("periondCol");
            this.comboPeriodType.addItems(periodTypes.toArray());
            FMClientHelper.setSelectObject((KDComboBox)this.comboAccountTable, (Object)this.currentCompany.getAccountTable());
            FMClientHelper.setSelectObject((KDComboBox)this.comboPeriodType, (Object)this.currentCompany.getAccountPeriodType());
        }
    }

    private PeriodCollection getPeriodCollection(Integer year) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (year != null) {
            filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year));
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            try {
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
                PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
                filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)curPeriod.getEndDate(), CompareType.LESS_EQUALS));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)((PeriodTypeInfo)this.comboPeriodType.getSelectedItem()).getId().toString()));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection pc = null;
        try {
            pc = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return pc;
    }

    private PeriodCollection getPeriodCollectionUsingFromCache(Integer year) throws EASBizException, BOSException {
        PeriodCollection pc = (PeriodCollection)this.periodMap.get("periodMap");
        return this.getRightPeriodCollection(pc, year);
    }

    private PeriodCollection getRightPeriodCollection(PeriodCollection pc, Integer year) throws EASBizException, BOSException {
        PeriodCollection pcreturn = new PeriodCollection();
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            PeriodInfo pcInfo = pc.get(i);
            if (!this.isYearMatch(pcInfo, year) || !this.isTypeMatch(pcInfo)) continue;
            pcreturn.add(pcInfo);
        }
        return pcreturn;
    }

    private boolean isTypeMatch(PeriodInfo pcInfo) {
        boolean isCondiMatch = false;
        String id = ((PeriodTypeInfo)this.comboPeriodType.getSelectedItem()).getId().toString();
        if (pcInfo.getPeriodType().getId().toString().equals(id)) {
            isCondiMatch = true;
        }
        return isCondiMatch;
    }

    private boolean isEndDateMatch(PeriodInfo pcInfo, Date endDate, boolean needCompareDate) {
        boolean isCondiMatch = false;
        if (needCompareDate) {
            Date periodEndDateDate = DateTimeUtils.truncateDate((Date)pcInfo.getEndDate());
            if (periodEndDateDate.compareTo(DateTimeUtils.truncateDate((Date)endDate)) <= 0) {
                isCondiMatch = true;
            }
        } else {
            isCondiMatch = true;
        }
        return isCondiMatch;
    }

    private boolean isStartDateMatch(PeriodInfo pcInfo, Date beginDate, boolean needCompareDate) {
        boolean isCondiMatch = false;
        if (needCompareDate) {
            Date periodBeginDate = DateTimeUtils.truncateDate((Date)pcInfo.getBeginDate());
            if (periodBeginDate.compareTo(DateTimeUtils.truncateDate((Date)beginDate)) >= 0) {
                isCondiMatch = true;
            }
        } else {
            isCondiMatch = true;
        }
        return isCondiMatch;
    }

    private boolean isYearMatch(PeriodInfo pcInfo, Integer year) {
        boolean isCondiMatch = false;
        if (pcInfo.getPeriodYear() == year.intValue()) {
            isCondiMatch = true;
        }
        return isCondiMatch;
    }

    public void clear() {
        super.clear();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboAccountTable, (Object)this.currentCompany.getAccountTable());
            FMClientHelper.setSelectObject((KDComboBox)this.comboPeriodType, (Object)this.currentCompany.getAccountPeriodType());
        }
        PeriodInfo periodInfo = null;
        try {
            periodInfo = this.paramMap.get("currentPeriod") != null ? (PeriodInfo)this.paramMap.get("currentPeriod") : SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            if (periodInfo == null) {
                GregorianCalendar cal = new GregorianCalendar();
                periodInfo = PeriodUtils.getPeriodInfo((Date)cal.getTime(), (CompanyOrgUnitInfo)this.currentCompany);
            } else {
                this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiBeginPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiEndPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany));
                this.f7Bank.setValue(null);
                this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiBeginPeriod.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                this.chkHideNoDataAccount.setSelected(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
    }

    private void initCompany() throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            TreeModel tree = this.getTreeModel();
            if (tree == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getRoot();
            ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
            if (root.isCheckBoxEnabled()) {
                list.add(((OrgStructureInfo)root.getUserObject()).getUnit());
            }
            this.popNode(list, root);
            this.setCompanyIds(AccessHelper.getIds((Object)list.toArray()));
        } else {
            this.setCompanyIds(new String[]{this.currentCompany.getId().toString()});
        }
    }

    protected KDDialog initDialog() throws Exception {
        this.companySelectDlg = new KDDialog(FMClientHelper.getFrameAncestor((Component)((Object)this)), true);
        TreeModel treeCompany = this.getTreeModel();
        if (treeCompany == null) {
            return null;
        }
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI(treeCompany, this.getCompanyIds());
        companySelectUI.setDialog((JDialog)this.companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        this.companySelectDlg.getContentPane().setLayout(new BorderLayout());
        this.companySelectDlg.getContentPane().add((Component)companySelectUI, "Center");
        this.companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.companySelectDlg);
        this.companySelectDlg.setResizable(false);
        this.companySelectDlg.setTitle(companySelectUI.getUITitle());
        companySelectUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    try {
                        CapitalVcSummaryFilterUI.this.companyValueChange(e.getNewValue());
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                        CapitalVcSummaryFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
        return this.companySelectDlg;
    }

    public TreeModel getTreeModel() throws EASBizException, BOSException {
        AccountTableInfo acctTable = (AccountTableInfo)this.comboAccountTable.getSelectedItem();
        if (acctTable == null) {
            return null;
        }
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboPeriodType.getSelectedItem();
        if (periodType == null) {
            return null;
        }
        TreeModel tree = null;
        try {
            CtrlUnitInfo currenrCompany = ContextHelperFactory.getRemoteInstance().getCurrentCtrlUnit();
            CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS020", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
            tree = NewOrgUtils.getTreeModel((OrgViewType)OrgViewType.COMPANY, (String)"", (boolean)false, (boolean)false, (boolean)false, (String)curCompany.getId().toString(), (boolean)val, null, (int)0, (IMetaDataPK)this.getListUI().getMetaDataPK(), (IMetaDataPK)FMHelper.getActionPK((ItemAction)this.getActionListOnLoad()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return tree;
    }

    protected boolean isAutoFillCurCompany() {
        return !GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            if (node.isCheckBoxEnabled()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo fullUnit = org.getUnit();
                list.add(fullUnit);
            }
            this.popNode(list, node);
        }
    }

    public boolean verify() {
        String detail;
        String message;
        int i;
        String[] companyIds = this.getCompanyIds();
        boolean rst = false;
        if (companyIds == null || companyIds.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoCompany"));
            return false;
        }
        List capitalVcSummaryFilterUIVerifyDTOList = null;
        Map paramMapVer = new HashMap<String, Object>();
        paramMapVer.put("CapitalVcSummaryFilterUIVerifyDTOList", null);
        paramMapVer.put("companyIDs", companyIds);
        paramMapVer.put("beginYear", (Integer)this.spiBeginYear.getValue());
        paramMapVer.put("endYear", (Integer)this.spiEndYear.getValue());
        paramMapVer.put("beginPeriod", (Integer)this.spiBeginPeriod.getValue());
        paramMapVer.put("endPeriod", (Integer)this.spiEndPeriod.getValue());
        try {
            paramMapVer = CapitalVcSummaryFetchParamFacadeFactory.getRemoteInstance().fetchDataBatchForFilterUIVerify(paramMapVer);
            capitalVcSummaryFilterUIVerifyDTOList = (List)paramMapVer.get("CapitalVcSummaryFilterUIVerifyDTOList");
        }
        catch (Exception e1) {
            MsgBox.showWarning((String)e1.getMessage());
            SysUtil.abort((Throwable)e1);
        }
        ArrayList<String> noInUseList = new ArrayList<String>();
        ArrayList<String> noShutList = new ArrayList<String>();
        ArrayList<String> ValidList = new ArrayList<String>();
        ArrayList<String> ValidAllCmpIDList = new ArrayList<String>();
        int size = capitalVcSummaryFilterUIVerifyDTOList.size();
        for (i = 0; i < size; ++i) {
            CapitalVcSummaryFilterUIVerifyDTO dto = (CapitalVcSummaryFilterUIVerifyDTO)capitalVcSummaryFilterUIVerifyDTOList.get(i);
            CompanyOrgUnitInfo company = dto.getCompany();
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || !company.isIsLeaf()) {
                ValidAllCmpIDList.add(company.getId().toString());
                continue;
            }
            boolean isStart = dto.isStart();
            if (!isStart) {
                noInUseList.add(dto.getCompany().getName());
                continue;
            }
            PeriodInfo startPeriod = dto.getStartPeriod();
            if (startPeriod == null) {
                noInUseList.add(dto.getCompany().getName());
                continue;
            }
            PeriodInfo beginPeriodInfo = dto.getBeginPeriodInfo();
            if (beginPeriodInfo == null || beginPeriodInfo.getBeginDate().before(startPeriod.getBeginDate())) {
                noInUseList.add(dto.getCompany().getName());
                continue;
            }
            PeriodInfo curPeriod = dto.getCurrentPeriod();
            PeriodInfo endPeriodInfo = dto.getEndPeriodInfo();
            if (endPeriodInfo == null || curPeriod.getBeginDate().before(endPeriodInfo.getBeginDate())) {
                noShutList.add(dto.getCompany().getName());
                continue;
            }
            ValidList.add(dto.getCompany().getId().toString());
            ValidAllCmpIDList.add(company.getId().toString());
        }
        if (noInUseList.size() > 0 && (noInUseList.size() > 5 ? MsgBox.isCancel((int)MsgBox.showConfirm3a((Component)((Object)this), (String)(message = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"269_CapitalVcSummaryFilterUI")), (String)(detail = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"270_CapitalVcSummaryFilterUI", (Object[])new Object[]{((Object)noInUseList).toString()})))) : MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)(message = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"270_CapitalVcSummaryFilterUI", (Object[])new Object[]{((Object)noInUseList).toString()})))))) {
            return false;
        }
        if (ValidList.size() <= 0) {
            String detail2 = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"274_CapitalVcSummaryFilterUI");
            MsgBox.showError((String)detail2);
            return false;
        }
        if (noShutList.size() > 0 && (noShutList.size() > 5 ? MsgBox.isCancel((int)MsgBox.showConfirm3a((Component)((Object)this), (String)(message = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"272_CapitalVcSummaryFilterUI")), (String)(detail = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"273_CapitalVcSummaryFilterUI", (Object[])new Object[]{((Object)noShutList).toString()})))) : MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)(message = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"273_CapitalVcSummaryFilterUI", (Object[])new Object[]{((Object)noShutList).toString()})))))) {
            return false;
        }
        rst = true;
        this.validCompanyIds = new String[ValidAllCmpIDList.size()];
        for (i = 0; i < ValidAllCmpIDList.size(); ++i) {
            this.validCompanyIds[i] = (String)ValidAllCmpIDList.get(i);
        }
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginPeriod);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndPeriod);
        try {
            CapitalVcSummaryFetchParamFacadeFactory.getRemoteInstance().checkActualAcctTable(this.validCompanyIds, beginYear, beginMonth, endYear, endMonth);
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        return rst;
    }

    public Set getCompanyIdSet() {
        HashSet<String> companyIdSet = new HashSet<String>();
        String[] companyIds = null;
        companyIds = this.validCompanyIds != null ? this.validCompanyIds : this.getCompanyIds();
        if (companyIds != null) {
            for (int i = 0; i < companyIds.length; ++i) {
                companyIdSet.add(companyIds[i]);
            }
        }
        return companyIdSet;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (super.isNewQuerySolution(cp)) {
            try {
                QuerySolutionConvert convert = new QuerySolutionConvert();
                Object param = convert.convertToBizParams(this.getParamClass(), cp);
                this.setParam(param);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.handUIException(e);
            }
        } else {
            try {
                Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
                if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                    this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
                } else {
                    this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        return super.getCustomerParams();
    }

    protected Class getParamClass() {
        return CapitalVcSummaryFilterParam.class;
    }
}

