/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractCasPaymentFilterUI;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.CasPaymentBillParam;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CasPaymentFilterUI
extends AbstractCasPaymentFilterUI
implements ISharedOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(CasPaymentFilterUI.class);
    private Map hm;
    private Context mainOrgContext;
    private boolean isSharedOrg = false;

    public CasPaymentFilterUI(Map paramValue) throws Exception {
        this.hm = paramValue;
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.mainOrgContext = new Context();
        this.mainOrgContext.put((Object)"UserInfo", (Object)user);
    }

    protected Class getParamClass() {
        return CasPaymentBillParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.chkIA.setVisible(false);
        this.customInit();
    }

    /*
     * Unable to fully structure code
     */
    private void customInit() throws Exception {
        date = new Date();
        this.pkDateFrom.setValue((Object)date);
        this.pkDateTo.setValue((Object)date);
        currencyColl = (CurrencyCollection)this.hm.get("currencyCollection");
        if (currencyColl == null) {
            try {
                CashHelper.initCombCurrency(this.comboCurrency, false);
            }
            catch (Exception e) {
                if (e.getCause() == null || !(e.getCause() instanceof PermissionServiceException)) ** GOTO lbl16
                iPermItem = PermItemFactory.getRemoteInstance();
                permissionItemInfo = iPermItem.getPermissionItemInfo("bd_assistant_currency_view");
                object = new Object[]{permissionItemInfo.getAlias()};
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, object);
            }
        } else {
            CashHelper.initCombCurrency(this.comboCurrency, currencyColl, false);
        }
lbl16:
        // 3 sources

        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initBillStatus(this.comboBillStatus);
        asstActTypeColl = null;
        asstActTypeColl = this.hm.get("asstActTypeCollection") != null ? (AsstActTypeCollection)this.hm.get("asstActTypeCollection") : CasRecPayHandler.getAsstActTypeColl(null, false, false);
        if (asstActTypeColl != null) {
            actionListener = this.comboPayeeType.getActionListeners();
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayeeType.removeActionListener(actionListener[i]);
            }
            this.comboPayeeType.removeAllItems();
            this.comboPayeeType.addItems(asstActTypeColl.toArray());
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            for (i = 0; i < actionListener.length; ++i) {
                this.comboPayeeType.addActionListener(actionListener[i]);
            }
        }
        this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.comboPayeeType_actionPerformed(null);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            orgRang = (CompanyOrgUnitCollection)this.hm.get("UserOrgRanges");
            if (orgRang == null) {
                this.prmtCompany.setValue((Object)this.currentCompany);
                return;
            }
            for (i = 0; i < orgRang.size(); ++i) {
                company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                if (!company.isIsBizUnit() || company.isIsOUSealUp()) continue;
                this.prmtCompany.setValue((Object)company);
                break;
            }
        } else {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
    }

    private void initSourceType(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)SourceTypeEnum.CASH);
        combo.addItem((Object)SourceTypeEnum.FS);
        combo.addItem((Object)SourceTypeEnum.NT);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)SourceTypeEnum.CASH);
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)BillStatusEnum.SAVE);
        combo.addItem((Object)BillStatusEnum.SUBMIT);
        combo.addItem((Object)BillStatusEnum.APPROVED);
        combo.addItem((Object)BillStatusEnum.AUDITED);
        combo.addItem((Object)BillStatusEnum.PAYED);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public Object getParam() {
        CasPaymentBillParam param = new CasPaymentBillParam();
        param.setBillDateFrom((Date)this.pkDateFrom.getValue());
        param.setBillDateTo((Date)this.pkDateTo.getValue());
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setMainOrgCollIDSet(idSet);
        }
        if (this.comboCurrency.getSelectedItem() == null || this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString());
        }
        if (this.comboBillStatus.getSelectedItem() == null || this.comboBillStatus.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setBillStatus(999);
        } else {
            param.setBillStatus(((BillStatusEnum)((Object)this.comboBillStatus.getSelectedItem())).getValue());
        }
        if (this.comboPayeeType.getSelectedItem() != null && !this.comboPayeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            if (this.comboPayeeType.getSelectedItem() == FMSysDefinedEnum.OTHER) {
                param.setPayeeTypeId("null");
            } else {
                param.setPayeeTypeId(((DataBaseInfo)this.comboPayeeType.getSelectedItem()).getId().toString());
            }
        }
        if (this.prmtPayee.getData() != null) {
            if (this.prmtPayee.getData() instanceof InnerAccountInfo) {
                param.setPayeeId(((InnerAccountInfo)this.prmtPayee.getData()).getId().toString());
                param.setPayeeName(((InnerAccountInfo)this.prmtPayee.getData()).getName());
            } else {
                param.setPayeeId(((DataBaseInfo)this.prmtPayee.getData()).getId().toString());
                param.setPayeeName(((DataBaseInfo)this.prmtPayee.getData()).getName());
            }
        }
        if (this.radioHead.isSelected()) {
            param.setDisplayEntries(false);
        } else if (this.radioEntries.isSelected()) {
            param.setDisplayEntries(true);
        }
        return param;
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.prmtCompany.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CasPaymentBillParam)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"326_CasPaymentFilterUI"));
            return;
        }
        CasPaymentBillParam filterParam = (CasPaymentBillParam)param;
        if (!EmptyUtil.isEmpty((Collection)filterParam.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterParam.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
        this.pkDateFrom.setValue((Object)filterParam.getBillDateFrom());
        this.pkDateTo.setValue((Object)filterParam.getBillDateTo());
        try {
            if (filterParam.getCurrencyId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(filterParam.getCurrencyId());
                this.comboCurrency.setSelectedItem((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)pk));
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filterParam.getBillStatus() == 999) {
            this.comboBillStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillStatus.setSelectedItem((Object)BillStatusEnum.getEnum(filterParam.getBillStatus()));
        }
        if (filterParam.getPayeeTypeId() == null) {
            this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            int selectIndex = BookNotifyClientHelper.getSelectIndex(this.comboPayeeType, filterParam.getPayeeTypeId());
            this.comboPayeeType.setSelectedIndex(selectIndex);
        }
        if (filterParam.isDisplayEntries()) {
            this.radioHead.setSelected(false);
            this.radioEntries.setSelected(true);
        } else {
            this.radioHead.setSelected(true);
            this.radioEntries.setSelected(false);
        }
        String payeeId = filterParam.getPayeeId();
        String payeeName = filterParam.getPayeeName();
        CasRecPayHandler handler = new CasRecPayHandler();
        handler.fillPayeeOrPayer(this.prmtPayee, payeeId, null, payeeName);
    }

    public void clear() {
        super.clear();
        try {
            this.customInit();
        }
        catch (Exception e) {
            logger.info((Object)e);
            logger.error((Object)e);
        }
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        if (this.pkDateFrom.getValue() == null || this.pkDateTo.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"327_CasPaymentFilterUI"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.pkDateFrom.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.pkDateTo.getValue()));
        ClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }

    @Override
    protected void comboPayeeType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayee.setValue(null);
        if (this.comboPayeeType.getSelectedItem() == null || !(this.comboPayeeType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayee.setEnabled(false);
            this.prmtPayee.setData(null);
            return;
        }
        if (this.prmtPayee.isEnabled() && this.prmtPayee.getData() != null) {
            return;
        }
        this.prmtPayee.setEnabled(true);
        this.prmtPayee.setData(null);
        this.prmtPayee.setSelector(null);
        this.prmtPayee.setFilterInfoProducer(null);
        AsstActTypeInfo info = (AsstActTypeInfo)this.comboPayeeType.getSelectedItem();
        this.prmtPayee.setSelector(null);
        this.prmtPayee.setFilterInfoProducer(null);
        CasRecPayHandler handler = new CasRecPayHandler();
        CompanyOrgUnitInfo company = this.getMainOrgColl().get(0);
        if (company == null) {
            company = this.currentCompany;
        }
        handler.setAsstActSelectorByCU((CoreUIObject)this, this.prmtPayee, info, company, false);
        if (info.getAsstHGAttribute().equalsIgnoreCase("innerAccount")) {
            info.setIsForCompany(false);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtPayee.setEntityViewInfo(evi);
        }
        this.prmtPayee.setDisplayFormat("$number$ $name$");
        this.prmtPayee.setCommitFormat("$number$;$name$");
        this.prmtPayee.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$", this.prmtPayee));
    }

    public String getPermissionItem() {
        return "cas_paymentbill_01view";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.getNewOrg() == null) {
            this.comboPayeeType.removeAllItems();
            return;
        }
        CompanyOrgUnitInfo company = null;
        if (chgVo.getNewOrg() instanceof Object[]) {
            Object[] companys = (Object[])chgVo.getNewOrg();
            if (companys.length == 0) return;
            company = (CompanyOrgUnitInfo)companys[0];
        } else {
            company = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        }
        AsstActTypeCollection asstActTypeColl = null;
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)company.getId().toString());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ui_name", "CasPaymentBillUI");
            hashMap.put("isList", Boolean.TRUE);
            hashMap.put("isFirtTime", Boolean.FALSE);
            hashMap.put("selectCompany", chgVo.getNewOrg());
            Map map = BatchFetchParamFacadeFactory.getRemoteInstanceWithObjectContext(this.mainOrgContext).fetchParam(hashMap);
            this.hm.putAll(map);
            asstActTypeColl = (AsstActTypeCollection)this.hm.get("asstActTypeCollection");
        }
        catch (Exception exception) {
            ExceptionHandler.handle((Throwable)exception);
            logger.error((Object)exception);
        }
        if (asstActTypeColl != null) {
            this.comboPayeeType.removeAllItems();
            this.comboPayeeType.addItems(asstActTypeColl.toArray());
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.OTHER);
            this.comboPayeeType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        this.comboPayeeType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        return this.isSharedOrg();
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

