/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.AbstractCasSubsidiaryLedgerFilterUI;
import com.kingdee.eas.fi.cas.client.CasSubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeModel;

public class CasSubsidiaryLedgerFilterUI
extends AbstractCasSubsidiaryLedgerFilterUI {
    public static final String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
    CompanyOrgUnitInfo currentCompany2 = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        super.onLoad();
        this.rdbByCompany.setVisible(false);
        this.rdbByType.setSelected(true);
        this.btnCompanySelect.setVisible(false);
    }

    @Override
    protected void chkDispUnUsed_actionPerformed(ActionEvent e) throws Exception {
        super.chkDispUnUsed_actionPerformed(e);
    }

    public TreeModel getTreeModel() throws EASBizException, BOSException {
        if (FSClientHelper.isCHUser()) {
            try {
                return FSClientHelper.getOrgTreeModelForCHUser();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getTreeModel();
    }

    public Object getParam() {
        CasSubsidiaryLedgerFilterParam para = new CasSubsidiaryLedgerFilterParam();
        String[] companyIds = this.getCompanyIds();
        para.setCompanyIds(companyIds);
        para.setByDay(this.rdbByDate.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiYearTo));
        para.setToDate(this.dtpDateTo.getSqlDate());
        para.setFromDate(this.dtpDateFrom.getSqlDate());
        para.setDispBalance(this.chkDispBalance.isSelected());
        para.setDispUnUsed(this.chkDispUnUsed.isSelected());
        para.setDispYearTotal(this.chkDispYearTotal.isSelected());
        para.setDispMouthTotal(this.chkDispMouthTotal.isSelected());
        para.setDisDayTotal(this.chkDispDayTotal.isSelected());
        para.setOrderByCompany(this.rdbByCompany.isSelected());
        if (this.prmtSubLedger.getData() != null && !FMHelper.isEmpty((Object[])((Object[])this.prmtSubLedger.getData()))) {
            para.setInnerAcctIDSet(FMHelper.asSet((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtSubLedger)));
        }
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        CasSubsidiaryLedgerFilterParam filterParam = (CasSubsidiaryLedgerFilterParam)((Object)param);
        String[] companyIds = filterParam.getCompanyIds();
        this.setCompanyIds(companyIds);
        this.rdbByDate.setSelected(filterParam.isByDay());
        this.rdbByMonth.setSelected(!filterParam.isByDay());
        this.spiYearFrom.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiYearTo.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiMonthFrom.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiMonthTo.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.dtpDateTo.setValue((Object)filterParam.getToDate());
        this.dtpDateFrom.setValue((Object)filterParam.getFromDate());
        this.chkDispBalance.setSelected(filterParam.isDispBalance());
        this.chkDispUnUsed.setSelected(filterParam.isDispUnUsed());
        this.chkDispYearTotal.setSelected(filterParam.isDispYearTotal());
        this.chkDispMouthTotal.setSelected(filterParam.isDispMouthTotal());
        this.chkDispDayTotal.setSelected(filterParam.isDisDayTotal());
        this.rdbByCompany.setSelected(filterParam.isOrderByCompany());
        if (!FMHelper.isEmpty((Collection)filterParam.getInnerAcctIDSet())) {
            try {
                this.prmtSubLedger.setData((Object)this.getBaseInfoFromIdSet(filterParam.getInnerAcctIDSet()));
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void rdbByMonth_stateChanged(ChangeEvent e) throws Exception {
        this.palDate.setVisible(false);
        this.palMonth.setVisible(false);
        if (this.rdbByMonth.isSelected()) {
            this.palMonth.setVisible(true);
        } else {
            this.palDate.setVisible(true);
            if (this.dtpDateFrom.getValue() == null && this.dtpDateTo.getValue() == null) {
                Calendar date = Calendar.getInstance();
                this.dtpDateFrom.setValue((Object)date.getTime());
                this.dtpDateTo.setValue((Object)date.getTime());
            }
        }
    }

    protected void init() throws Exception {
        super.init();
    }

    private void initInnerAccountF7() {
        String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        FilterInfo filter = null;
        filter = this.prmtSubLedger.getEntityViewInfo() != null ? this.prmtSubLedger.getEntityViewInfo().getFilter() : new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)companyId));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.prmtSubLedger.setEntityViewInfo(viewInfo);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.getCompanyIds() == null || this.getCompanyIds().length == 0) {
            this.btnCompanySelect.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoOrgUnit"));
            SysUtil.abort();
        }
        if (this.rdbByMonth.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiYearFrom) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthFrom) > AccessHelper.getSpiValue((KDSpinner)this.spiYearTo) * 12 + AccessHelper.getSpiValue((KDSpinner)this.spiMonthTo)) {
                this.spiYearFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpDateTo, (String)"NoDate");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDDatePicker)this.dtpDateFrom, (String)"NoDate");
            if (this.dtpDateTo.getSqlDate().before(this.dtpDateFrom.getSqlDate())) {
                this.dtpDateFrom.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckDateFromTo"));
                SysUtil.abort();
            }
        }
        return true;
    }

    protected void initCompanyState() {
        super.initCompanyState();
        if (FSClientHelper.isClearingHouseCompanyId((String)"")) {
            this.chkIA.setEnabled(true);
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        super.companyValueChange((Object)array);
    }

    protected void setDefaultValue() {
        this.chkDispUnUsed.setSelected(false);
        this.rdbByMonth.setSelected(true);
        this.rdbByType.setSelected(true);
        this.chkDispBalance.setSelected(true);
        this.chkDispYearTotal.setSelected(true);
        this.chkDispMouthTotal.setSelected(true);
        this.chkDispDayTotal.setSelected(true);
        FMClientHelper.initSpinFromTO((KDSpinner)this.spiYearFrom, (KDSpinner)this.spiMonthFrom, (KDSpinner)this.spiYearTo, (KDSpinner)this.spiMonthTo);
        this.lblMonthFrom.setEnabled(true);
        this.lblMonthTo.setEnabled(true);
        this.lblYearFrom.setEnabled(true);
        this.lblYearTo.setEnabled(true);
        this.setCompanyIdSet(AccessHelper.getIds((Object[])new Object[]{this.currentCompany2}));
        this.initInnerAccountF7();
        this.prmtSubLedger.setRequired(false);
    }

    protected Class getParamClass() {
        return CasSubsidiaryLedgerFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }
}

