/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitHandler;
import java.math.BigDecimal;

public class CashAccountInitHandler
extends AbstractCashMgtInitHandler {
    public final String CASACCT_COL = "cashAcct";
    private String[] columnKeys = new String[]{"cashAcct", "yearDebitAmt", "yearCreditAmt", "beginBalance"};

    @Override
    public void initTable(KDTable table, boolean isFirstPeriod) {
        String[] columnNames = new String[]{this.CASHACCOUNT, this.YEARDEBITAMOUNT, this.YEARCREDITAMOUNT, this.BEGINBALANCE};
        table.removeColumns();
        table.addColumns(this.columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < this.columnKeys.length; ++i) {
            table.getColumn(i).setKey(this.columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        IColumn column = table.getColumn("cashAcct");
        if (column != null) {
            column.setWidth(180);
        }
        if (isFirstPeriod) {
            table.getColumn("yearDebitAmt").getStyleAttributes().setHided(true);
            table.getColumn("yearCreditAmt").getStyleAttributes().setHided(true);
        }
        super.initTable(table, isFirstPeriod);
    }

    @Override
    public void initKDTableFormatter(KDTable table) {
        this.setColumnColor(table.getColumn("cashAcct"));
    }

    @Override
    public void loadField(KDTable table) throws Exception {
        super.loadField(table);
    }

    @Override
    public void loadLineFields(IRow row, JournalBalanceInfo obj) {
        CurrencyInfo currencyInfo = super.getCurrency();
        int scale = currencyInfo.getPrecision();
        JournalBalanceInfo initInfo = obj;
        row.getCell("cashAcct").setValue((Object)initInfo.getAccountView());
        BigDecimal debitStartAmt = initInfo.getDebitStartAmt();
        if (debitStartAmt != null) {
            debitStartAmt = this.getBigDecimalByScale(debitStartAmt, scale);
        }
        row.getCell("yearDebitAmt").setValue((Object)debitStartAmt);
        BigDecimal creditStartAmt = initInfo.getCreditStartAmt();
        if (creditStartAmt != null) {
            creditStartAmt = this.getBigDecimalByScale(creditStartAmt, scale);
        }
        row.getCell("yearCreditAmt").setValue((Object)creditStartAmt);
        BigDecimal monthStartAmt = initInfo.getMonthStartAmt();
        if (monthStartAmt != null) {
            monthStartAmt = this.getBigDecimalByScale(monthStartAmt, scale);
        }
        row.getCell("beginBalance").setValue((Object)monthStartAmt);
    }

    @Override
    public void storeField(KDTable table) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        JournalBalanceCollection journalBalCol = null;
        JournalBalanceInfo tmpJournalBalInfo = null;
        if (rowCount > 0) {
            journalBalCol = new JournalBalanceCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (i == 0) {
                    tmpJournalBalInfo = (JournalBalanceInfo)row.getUserObject();
                    tmpJournalBalInfo.setCompany(this.getCompanyInfo());
                    tmpJournalBalInfo.setCurrency(this.getCurrency());
                    tmpJournalBalInfo.setPeriod(this.getPeriodInfo());
                    tmpJournalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
                }
                if (this.isRowNotValid(row)) continue;
                JournalBalanceInfo journalBalInfo = (JournalBalanceInfo)row.getUserObject();
                journalBalInfo.setIsInit(true);
                journalBalInfo.setCompany(this.getCompanyInfo());
                journalBalInfo.setCurrency(this.getCurrency());
                journalBalInfo.setPeriod(this.getPeriodInfo());
                journalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
                journalBalInfo.setAccountView((AccountViewInfo)row.getCell("cashAcct").getValue());
                journalBalInfo.setDebitStartAmt(this.getBigDecimal(row.getCell("yearDebitAmt").getValue()));
                journalBalInfo.setCreditStartAmt(this.getBigDecimal(row.getCell("yearCreditAmt").getValue()));
                journalBalInfo.setMonthStartAmt(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalInfo.setYearStartAmt(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalCol.add(journalBalInfo);
            }
        }
        super.storeData(journalBalCol, tmpJournalBalInfo);
    }
}

