/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctType;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.JournalBaseInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class CashClientHelper {
    private static Logger logger = Logger.getLogger((String)CashClientHelper.class.getName());
    public static final HashMap mapPrecOfCurrency = new HashMap(32);

    public static void setNumberFormat(KDTable tblMain, String columnKey, String currencyID) {
        String numberFormat = CashClientHelper.getNumberFtm(BOSUuid.read((String)currencyID));
        StyleAttributes styleAttributes = tblMain.getColumn(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static String getNumberFtm(BOSUuid currencyId) {
        return FMClientHelper.getNumberFtm((BOSUuid)currencyId);
    }

    public static int getPrecOfCurrency(BOSUuid currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            CashClientHelper.setPrecOfCurrenty(mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    private static void setPrecOfCurrenty(HashMap map) {
        String str = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(BOSUuid.read((String)rs.getString(1)), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            return;
        }
        catch (SQLException sqle) {
            return;
        }
    }

    public static VoucherInfo getVoucherInfo(Context ctx, String billId) throws BOSException, EASBizException {
        Iterator iter;
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        VoucherInfo voucherInfo = null;
        BOSUuid uuid = BOSUuid.read((String)billId);
        String billBosType = uuid.getType().toString();
        String voucherBosType = new VoucherInfo().getBOSType().toString();
        IBOTRelation iBotRelation = null;
        IVoucher iVoucher = null;
        if (ctx == null) {
            iBotRelation = BOTRelationFactory.getRemoteInstance();
            iVoucher = VoucherFactory.getRemoteInstance();
        } else {
            iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("srcObjectID", (Object)billId));
        items.add(new FilterItemInfo("srcEntityID", (Object)billBosType));
        items.add(new FilterItemInfo("destEntityID", (Object)voucherBosType));
        BOTRelationCollection relationCollection = iBotRelation.getCollection(view);
        if (relationCollection != null && relationCollection.size() > 0 && (iter = relationCollection.iterator()).hasNext()) {
            BOTRelationInfo relationInfo = (BOTRelationInfo)iter.next();
            String voucherId = relationInfo.getDestObjectID();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("entries.*"));
            voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), selectors);
        }
        return voucherInfo;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getRemoteInstance();
        companyInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        return companyInfo;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static AccountBankCollection getAccountBankCollection(String companyID, boolean isIncludeClosed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("currency.*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("bank.name");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    public static AccountBankCollection getNoSharedAccountBankCollection(String companyID, boolean isIncludeClosed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("currency.*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("bank.name");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    public static AccountBankCollection getSharedAcctAccountBankCollection(String companyID, boolean isIncludeClosed) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("bank.name");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("shareAcct.shareBalanceOfAcctCompany.id");
        FilterInfo fi = new FilterInfo();
        if (companyID != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyID, CompareType.EQUALS));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            SharedAcctInfo sharedAcct = coll.get(i);
            sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!isIncludeClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    public static boolean isShareBalanceOfAcctCompany(AccountBankInfo accountbank, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return true;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        return sharedAcctInfo.getShareBalanceOfAcctCompany().getId().toString().equals(companyId);
    }

    public static PeriodInfo getStartPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriodInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"cm71"));
            SysUtil.abort();
        }
        return startPeriodInfo;
    }

    public static PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return currPeriodInfo;
    }

    public static ICellEditor getNumberEditor(String currencyId) {
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        formattedTextField.setHorizontalAlignment(4);
        formattedTextField.setDataVerifierType(-1);
        formattedTextField.setSupportedEmpty(true);
        formattedTextField.setMaximumValue((Comparable)FMConstants.MAX_VALUE);
        formattedTextField.setMinimumValue((Comparable)FMConstants.MIN_VALUE);
        formattedTextField.setPrecision(CashClientHelper.getPrecOfCurrency(BOSUuid.read((String)currencyId)));
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        numberEditor.setClickCountToStart(1);
        return numberEditor;
    }

    public static void checkCashBankAccount(CompanyOrgUnitInfo info, String currencyId) throws EASBizException, BOSException {
        if (info == null) {
            throw new NullPointerException("Company Is Null!");
        }
        String companyId = info.getId().toString();
        AccountViewCollection cashColl = FMHelper.getAcctViewCollection((String)companyId, null, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
        if (cashColl == null || cashColl.size() == 0) {
            throw new RecPayException(RecPayException.CASH_ACCOUNT_ISNULL);
        }
        AccountViewCollection bankColl = FMHelper.getAcctViewCollection((String)companyId, null, (AccountTypeEnum)AccountTypeEnum.BANKACCOUNT);
        if (bankColl == null || bankColl.size() == 0) {
            throw new RecPayException(RecPayException.BANK_ACCOUNT_ISNULL);
        }
    }

    public static Date getStartDate(SystemEnum systemEnum) {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo startPeriod = null;
        try {
            startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (startPeriod != null) {
            return startPeriod.getBeginDate();
        }
        return new Date();
    }

    public static PeriodInfo getARStartPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)companyInfo);
        if (period == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ARStartPeriodIsNull"));
            SysUtil.abort();
        }
        return period;
    }

    public static PeriodInfo getAPStartPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)companyInfo);
        if (period == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"APStartPeriodIsNull"));
            SysUtil.abort();
        }
        return period;
    }

    public static Date getPreDayOfStartDate(SystemEnum systemEnum) {
        Date date = DateTimeUtils.truncateDate((Date)CashClientHelper.getStartDate(systemEnum));
        return DateHelper.getBeforeDay((Date)date);
    }

    public static PeriodInfo getARCurrentPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)companyInfo);
        if (period == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ARCurrentPeriodIsNull"));
            SysUtil.abort();
        }
        return period;
    }

    public static PeriodInfo getAPCurrentPeriodInfo(Component comp, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)companyInfo);
        if (period == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"APCurrentPeriodIsNull"));
            SysUtil.abort();
        }
        return period;
    }

    public static String getBillIdByNumber(JournalBaseInfo journalInfo) throws BOSException, SQLException {
        String billId;
        block10: {
            String billNumber;
            BillTypeEnum billtype;
            block13: {
                block12: {
                    block11: {
                        billtype = journalInfo.getBillType();
                        billNumber = journalInfo.getBillNumber();
                        if (billtype == null) {
                            return null;
                        }
                        if (FMHelper.isEmpty((String)billNumber)) {
                            return null;
                        }
                        billId = null;
                        if (billtype != BillTypeEnum.voucher) break block11;
                        String sql = "select fid , fbizDate from t_gl_voucher where fcompanyid='" + journalInfo.getCompany().getId() + "' and fperiodid='" + journalInfo.getPeriod().getId() + "' and fnumber='" + billNumber + "'";
                        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                        if (rs == null || rs.size() == 0) {
                            return null;
                        }
                        while (rs.next()) {
                            billId = rs.getString(1);
                            if (rs.getDate(2).compareTo(journalInfo.getBizDate()) != 0) continue;
                            billId = rs.getString(1);
                            break block10;
                        }
                        break block10;
                    }
                    if (billtype != BillTypeEnum.paymentBill) break block12;
                    String sql = "select fid , fbizDate from t_cas_paymentbill where fcompanyid='" + journalInfo.getCompany().getId() + "' and fnumber='" + billNumber + "'";
                    IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                    if (rs == null || rs.size() == 0) {
                        return null;
                    }
                    while (rs.next()) {
                        billId = rs.getString(1);
                        if (rs.getDate(2).compareTo(journalInfo.getBizDate()) != 0) continue;
                        billId = rs.getString(1);
                        break block10;
                    }
                    break block10;
                }
                if (billtype != BillTypeEnum.receiveBill) break block13;
                String sql = "select fid , fbizDate from t_cas_receivingbill where fcompanyid='" + journalInfo.getCompany().getId() + "' and fnumber='" + billNumber + "'";
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                if (rs == null || rs.size() == 0) {
                    return null;
                }
                while (rs.next()) {
                    billId = rs.getString(1);
                    if (rs.getDate(2).compareTo(journalInfo.getBizDate()) != 0) continue;
                    billId = rs.getString(1);
                    break block10;
                }
                break block10;
            }
            if (billtype != BillTypeEnum.settlementBill) break block10;
            String sql = "select fid , fbizDate from t_fs_settlementbill where fcompanyid='" + journalInfo.getCompany().getId() + "' and fnumber='" + billNumber + "'";
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            if (rs == null || rs.size() == 0) {
                return null;
            }
            while (rs.next()) {
                billId = rs.getString(1);
                if (rs.getDate(2).compareTo(journalInfo.getBizDate()) != 0) continue;
                billId = rs.getString(1);
                break;
            }
        }
        return billId;
    }

    public static Set getBillIdSetByID(JournalBaseInfo journalInfo) throws BOSException, SQLException {
        Set<String> set = new HashSet();
        set = CashClientHelper.getUniteId(journalInfo.getBillId());
        if (set.size() > 1) {
            return set;
        }
        set.add(journalInfo.getBillId());
        return set;
    }

    private static Set getUniteId(String id) throws BOSException, SQLException {
        HashSet<String> idSet = new HashSet<String>();
        String sql = "select SrcBillId from T_CAS_MidJournalBacth where JBatchId = '" + id + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        while (rs.next()) {
            idSet.add(rs.getString(1));
        }
        return idSet;
    }

    public static Set getSelectedRows(KDTable table) {
        ArrayList arrayList = table.getSelectManager().getBlocks();
        TreeSet<Integer> set = new TreeSet<Integer>();
        int size = arrayList.size();
        for (int i = 0; i < size; ++i) {
            IBlock block = KDTSelectBlock.change((KDTable)table, (IBlock)((KDTSelectBlock)arrayList.get(i)));
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                Integer theInteger = new Integer(j);
                set.add(theInteger);
            }
        }
        return set;
    }

    public static boolean bookDatedVerify(Date date, PeriodInfo periodInfo) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(date);
        return periodInfo.getPeriodYear() == calender.get(1) && periodInfo.getPeriodNumber() == calender.get(2);
    }

    public static boolean hasSharedOrgUIParam(CoreUIObject ui) {
        String paramStr = (String)ui.getUIContext().get("UIClassParam");
        return paramStr != null && paramStr.indexOf("sharedorg=1") != -1;
    }

    public static void processSharedOrgFilterUI(FMFilterBaseUI filterUI) {
        if (filterUI != null && filterUI instanceof ISharedOrgSupport) {
            ((ISharedOrgSupport)filterUI).setIsSharedOrg(true);
        }
    }

    public static void processSharedOrgLicense(CoreUI ui) throws LicenseException {
        ui.getUIContext().put(LicenseService.MODULENAME, "FSSC_CAS");
    }

    public static void releaseSharedOrgLicense() {
    }

    public static String constructMessage(LicenseController lc, String className, IUIObject ui) throws LicenseException {
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append(ui.getUITitle() + "[" + CashClientHelper.getUIClassName(ui) + "]");
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"438_CashClientHelper"));
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"439_CashClientHelper"));
        return buffer.toString();
    }

    public static String getUIClassName(IUIObject uiObject) {
        String className = null;
        className = uiObject.getMetaDataPK() != null ? uiObject.getMetaDataPK().getFullName() : uiObject.getClass().getName();
        return className;
    }

    public static CompanyOrgUnitInfo getAcctMainSharedAcct(AccountBankInfo acctInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo acctCompany = null;
        if (SharedAcctType.shared != acctInfo.getShareType()) {
            acctCompany = acctInfo.getCompany();
            if (acctCompany == null) {
                AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctInfo.getId().toString()));
                acctCompany = info.getCompany();
            }
        } else {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("*");
            selectors.add("shareAcct.id");
            selectors.add("shareAcct.shareBalanceOfAcctCompany");
            AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctInfo.getId().toString()), selectors);
            acctCompany = info.getShareAcct().getShareBalanceOfAcctCompany();
        }
        return acctCompany;
    }
}

