/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLDetailResultUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class CashContrastGLDetailResultUI
extends AbstractCashContrastGLDetailResultUI {
    public static final int MANUAL_CONTRAST_FLAG = 2;
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private List resultList = new ArrayList();

    public List getResultList() {
        return this.resultList;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        List resultColl = (List)uiContext.get("resultColl");
        String capitalType = (String)uiContext.get("capitalType");
        String bankAccount = (String)uiContext.get("bankAccount");
        String accountView = (String)uiContext.get("accountView");
        String period = (String)uiContext.get("period");
        String currencyName = (String)uiContext.get("currencyName");
        BOSUuid currencyId = (BOSUuid)uiContext.get("currencyId");
        this.txtCapitalType.setText(capitalType);
        this.txtBankAccount.setText(bankAccount);
        this.txtAccountView.setText(accountView);
        this.txtCurrency.setText(currencyName);
        this.txtPeriod.setText(period);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.fillData(resultColl);
        this.setCurrencyFormat(this.tblMain, currencyId);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    private void fillData(List resultColl) {
        int i;
        int collSize = resultColl.size();
        if (collSize == 0) {
            return;
        }
        KDCheckBox chkSelect = new KDCheckBox();
        KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)chkSelect);
        this.tblMain.getColumn("select").setEditor((ICellEditor)selectEditor);
        for (i = 0; i < collSize; ++i) {
            IRow resultRow = (IRow)resultColl.get(i);
            IRow row = this.tblMain.addRow();
            row.setUserObject((Object)resultRow);
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue(resultRow.getCell("date").getValue());
            row.getCell("settNumber").setValue(resultRow.getCell("settNumber").getValue());
            row.getCell("settType").setValue(resultRow.getCell("settType").getValue());
            row.getCell("oppAccount").setValue(resultRow.getCell("oppAccount").getValue());
            row.getCell("description").setValue(resultRow.getCell("description").getValue());
            row.getCell("voucherNumber").setValue(resultRow.getCell("voucherNumber").getValue());
            row.getCell("voucherType").setValue(resultRow.getCell("voucherType").getValue());
            row.getCell("debit").setValue(resultRow.getCell("debit").getValue());
            row.getCell("credit").setValue(resultRow.getCell("credit").getValue());
            if (i % 2 == 0) {
                row.getCell("record").setValue((Object)EASResource.getString((String)resourcePath, (String)"Journal"));
                continue;
            }
            row.getCell("record").setValue((Object)EASResource.getString((String)resourcePath, (String)"Voucher"));
        }
        for (i = 0; i < collSize / 2; ++i) {
            this.tblMain.getMergeManager().mergeBlock(i * 2, 0, i * 2 + 1, 0);
        }
        int flag = 1;
        for (int i2 = 0; i2 < collSize; ++i2) {
            if (flag > 4) {
                flag = 1;
            }
            if (flag <= 2) {
                this.tblMain.getRow(i2).getStyleAttributes().setBackground(CasConstants.KDTABLE_YELLOW_COLOR);
            }
            ++flag;
        }
    }

    public void setCurrencyFormat(KDTable tblMain, BOSUuid currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblMain.getColumn("debit").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("credit").getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        boolean noSelect = false;
        boolean isBeforeRowSelect = false;
        this.resultList.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row;
            noSelect = ((Boolean)this.tblMain.getRow(i).getCell("select").getValue()).equals(Boolean.FALSE);
            if (i != 0) {
                isBeforeRowSelect = ((Boolean)this.tblMain.getRow(i - 1).getCell("select").getValue()).equals(Boolean.TRUE);
            }
            if (noSelect && !isBeforeRowSelect) continue;
            if (!noSelect) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(this.tblMain.getRow(i).getUserObject());
                list.add(this.tblMain.getRow(i + 1).getUserObject());
                row = (IRow)this.tblMain.getRow(i).getUserObject();
                row.setUserObject(list);
                row = (IRow)this.tblMain.getRow(i + 1).getUserObject();
                row.setUserObject(list);
            }
            row = (IRow)this.tblMain.getRow(i).getUserObject();
            this.resultList.add(row);
        }
        if (this.resultList.size() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); i += 2) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_savecollate"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
    }
}

