/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLDetailUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailFilterParam;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailFilterUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailHandler;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailOptionUI;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class CashContrastGLDetailUI
extends AbstractCashContrastGLDetailUI {
    private CashContrastGLDetailFilterUI filterUI;
    private CashContrastGLDetailHandler handler = new CashContrastGLDetailHandler();
    private int periodNumber;
    private int periodYear;

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fi.cas.app.CashContrastGlBatchFetcher";
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        FmRpcCacheInfo paramInfo = super.getRpcCacheParam();
        return paramInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.contCash.setTitleStyle(1);
        this.contGL.setTitleStyle(1);
        this.contCash.setEnableActive(false);
        this.contGL.setEnableActive(false);
        this.actionExport.setEnabled(true);
        this.btnAutoContrast.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnManualContrast.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnAutoSearch.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnContrastSetup.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnALL.setIcon(EASResource.getIcon((String)"imgTbtn_alreadycollate"));
        this.btnDiffRpt.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.btnNoContrast.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.btnHasContrast.setIcon(EASResource.getIcon((String)"imgTbtn_alreadycollate"));
        this.btnCancleContrast.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionAutoContrast.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.actionManualContrast.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionContrastSetup.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.actionAutoSearch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_check"));
        this.actionCancelContrast.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_collateresult"));
        this.actionQuery.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionRefresh.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionHasContrast.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_alreadycollate"));
        this.actionNoContrast.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionDiffRpt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contCash.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 376, 492));
        this.contCash.getContentPane().add((Component)this.tblCash, new KDLayout.Constraints(0, 0, 375, 492, 15));
        this.contGL.getContentPane().setLayout((LayoutManager)new KDLayout());
        this.contGL.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 376, 492));
        this.contGL.getContentPane().add((Component)this.tblGL, new KDLayout.Constraints(0, 0, 376, 492, 15));
        this.handler.refreshUIContentLayout(this);
    }

    public void onLoad() throws Exception {
        Map map;
        super.onLoad();
        PeriodInfo periodInfo = this.rpcCacheInfo.getCurPeriod();
        if (periodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
        if ((map = this.handler.getUIOptionMap()) == null || map.size() == 0) {
            this.contSpider.setOrientation(0);
            this.contSpider.setDividerLocation((this.getHeight() - 60) / 2);
        }
        this.actionQuery.setEnabled(false);
        this.actionQuery.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void comboCapitalType_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void comboAccountView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void comboBankAccount_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
    }

    private void fillData() throws Exception {
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.comboCapitalType.getSelectedItem());
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        Set acctViewIdSet = this.getSelectedAcctViewIDSet();
        Set bankAcctIdSet = this.getSelectedBankAcctIDSet();
        if (currency == null || capitalType.equals((Object)CapitalTypeEnum.BANK) && bankAcctIdSet.size() == 0 || acctViewIdSet.size() == 0) {
            return;
        }
        FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)((CashContrastGLDetailFilterParam)this.getFilterParam()).getCompany())) {
            paramInfo.put("company", (Object)((CashContrastGLDetailFilterParam)this.getFilterParam()).getCompany());
        }
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        this.rpcCacheInfo = FMBatchProcessFacadeFactory.getRemoteInstance().batchFetchData(paramInfo);
        CompanyOrgUnitInfo companyInfo = ((CashContrastGLDetailFilterParam)this.getFilterParam()).getCompany();
        if (EmptyUtil.isEmpty((CoreBaseInfo)companyInfo)) {
            companyInfo = this.rpcCacheInfo.getCurrentCompany();
        }
        PeriodInfo period = PeriodUtils.getPeriodInfo((int)this.periodYear, (int)this.periodNumber, (CompanyOrgUnitInfo)companyInfo);
        IRowSet cashRs = this.handler.getCashRowset(this.mainQueryPK, this.mainQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
        IRowSet glRs = this.handler.getGLRowset(this.gLSystemQueryPK, this.gLSystemQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
        if (cashRs == null || cashRs.size() == 0 || glRs == null || glRs.size() == 0) {
            this.actionAutoContrast.setEnabled(false);
            this.actionAutoSearch.setEnabled(false);
            this.actionManualContrast.setEnabled(false);
            this.actionCancelContrast.setEnabled(false);
            this.actionAll.setEnabled(false);
            this.actionNoContrast.setEnabled(false);
            this.actionHasContrast.setEnabled(false);
            this.actionDiffRpt.setEnabled(false);
        } else {
            this.actionAutoContrast.setEnabled(true);
            this.actionAutoSearch.setEnabled(true);
            this.actionManualContrast.setEnabled(true);
            this.actionCancelContrast.setEnabled(true);
            this.actionAll.setEnabled(true);
            this.actionNoContrast.setEnabled(true);
            this.actionHasContrast.setEnabled(true);
            this.actionDiffRpt.setEnabled(true);
        }
        this.tblCash.removeRows();
        this.tblGL.removeRows();
        this.handler.setSucessContrastTotal(0);
        this.handler.fillCashData(this.tblCash, cashRs);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblCash.getColumn("date").getStyleAttributes().setNumberFormat(dformat);
        this.tblGL.getColumn("date").getStyleAttributes().setNumberFormat(dformat);
        Iterator it = this.getSelectedAcctViewIDSet().iterator();
        CashContrastGLDetailFilterParam para = null;
        para = this.getUIContext().get("filterParam") != null ? (CashContrastGLDetailFilterParam)this.getUIContext().get("filterParam") : (CashContrastGLDetailFilterParam)this.getFilterParam();
        this.processCacheInfo(para, this.rpcCacheInfo);
        while (it.hasNext()) {
            String acctViewID = it.next().toString();
            Iterator it2 = bankAcctIdSet.iterator();
            if (bankAcctIdSet.size() == 0) {
                this.handler.fillGLData(this.tblGL, glRs, capitalType, acctViewID, null, this.rpcCacheInfo);
                continue;
            }
            while (it2.hasNext()) {
                String accountBankId = it2.next().toString();
                this.handler.fillGLData(this.tblGL, glRs, capitalType, acctViewID, accountBankId, this.rpcCacheInfo);
            }
        }
        this.handler.setCurrencyFormat(this.tblCash, this.tblGL, currency.getId());
    }

    private Set getSelectedAcctViewIDSet() {
        return this.getSelectedComboIDSet((JComboBox)this.comboAccountView, "id");
    }

    private Set getSelectedAcctViewNumSet() {
        return this.getSelectedComboIDSet((JComboBox)this.comboAccountView, "number");
    }

    private Set getSelectedComboIDSet(JComboBox comboBox, String prop) {
        HashSet<String> idSet = new HashSet<String>();
        if (comboBox.getSelectedItem() == null) {
            return idSet;
        }
        if (comboBox.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            ObjectBaseInfo acctInfo = (ObjectBaseInfo)comboBox.getSelectedItem();
            idSet.add(acctInfo.get(prop).toString());
        } else {
            ComboBoxModel model = comboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ObjectBaseInfo acctInfo;
                if (!(model.getElementAt(i) instanceof ObjectBaseInfo) || FMHelper.isEmpty((String)(acctInfo = (ObjectBaseInfo)model.getElementAt(i)).get(prop).toString())) continue;
                idSet.add(acctInfo.get(prop).toString());
            }
        }
        return idSet;
    }

    private Set getSelectedBankAcctIDSet() {
        return this.getSelectedComboIDSet((JComboBox)this.comboBankAccount, "id");
    }

    private Set getSelectedBankAcctNumNameSet() {
        HashSet<String> idSet = new HashSet<String>();
        if (this.comboBankAccount.getSelectedItem() == null) {
            return idSet;
        }
        if (this.comboBankAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            ObjectBaseInfo acctInfo = (ObjectBaseInfo)this.comboBankAccount.getSelectedItem();
            idSet.add(acctInfo.get("number").toString());
        } else {
            ComboBoxModel model = this.comboBankAccount.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                ObjectBaseInfo acctInfo;
                if (model.getElementAt(i) == FMSysDefinedEnum.SELECT_ALL || FMHelper.isEmpty((String)(acctInfo = (ObjectBaseInfo)model.getElementAt(i)).get("number").toString())) continue;
                idSet.add(acctInfo.get("number") + "--" + acctInfo.get("name"));
            }
        }
        return idSet;
    }

    @Override
    public void actionContrastSetup_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(CashContrastGLDetailOptionUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        wnd.show();
        this.handler.refreshUIContentLayout(this);
    }

    @Override
    public void actionAutoContrast_actionPerformed(ActionEvent e) throws Exception {
        this.handler.autoContrast_Multi_New2(this.tblCash, this.tblGL, this);
    }

    @Override
    public void actionManualContrast_actionPerformed(ActionEvent e) throws Exception {
        this.handler.manualContrast_New(this.tblCash, this.tblGL);
    }

    @Override
    public void actionAutoSearch_actionPerformed(ActionEvent e) throws Exception {
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.comboCapitalType.getSelectedItem());
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String acctBankNumSet = this.getSelectedBankAcctNumNameSet().toString();
        acctBankNumSet = acctBankNumSet.substring(1, acctBankNumSet.length() - 1);
        String acctViewSet = this.getSelectedAcctViewNumSet().toString();
        acctViewSet = acctViewSet.substring(1, acctViewSet.length() - 1);
        if (currency == null || capitalType.equals((Object)CapitalTypeEnum.BANK) && FMHelper.isEmpty((String)acctBankNumSet) || FMHelper.isEmpty((String)acctViewSet)) {
            return;
        }
        this.handler.autoSearch(this.tblCash, this.tblGL, this, capitalType.toString(), acctBankNumSet, acctViewSet, this.txtPeriod.getText(), currency.toString(), currency.getId());
    }

    @Override
    public void actionHasContrast_actionPerformed(ActionEvent e) throws Exception {
        this.handler.showHasContrast(this.tblCash, this.tblGL);
    }

    @Override
    public void actionAll_actionPerformed(ActionEvent e) throws Exception {
        this.handler.showAll(this.tblCash, this.tblGL);
    }

    @Override
    public void actionCancelContrast_actionPerformed(ActionEvent e) throws Exception {
        this.handler.cancleContrast(this.tblCash, this.tblGL);
    }

    @Override
    public void actionDiffRpt_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.handler.contrastDiffRpt(this, this.tblCash, this.tblGL, currency.getId());
    }

    @Override
    public void actionNoContrast_actionPerformed(ActionEvent e) throws Exception {
        this.handler.showUnContrast(this.tblCash, this.tblGL);
    }

    protected KDTable getMainTable() {
        return this.tblCash;
    }

    public static void showCashDetail(IUIObject ui, CashContrastGLDetailFilterParam para) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)para);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CashContrastGLDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void processCacheInfo(CashContrastGLDetailFilterParam para, FmRpcCacheInfo rpcCacheInfo) throws BOSException {
        CompanyOrgUnitInfo company = rpcCacheInfo.getCurrentCompany();
        if (rpcCacheInfo.get("accountBankColl") != null) {
            AccountBankCollection acctBankColl = (AccountBankCollection)rpcCacheInfo.get("accountBankColl");
            if (company != null && company.getAccountTable() != null) {
                acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)para.getAcctTableId());
                HashMap<String, Integer> acctViewCntMap = new HashMap<String, Integer>();
                int cnt = 0;
                AccountBankInfo acctBankInfo = null;
                String acctViewId = null;
                int size = acctBankColl.size();
                for (int i = 0; i < size; ++i) {
                    acctBankInfo = acctBankColl.get(i);
                    acctViewId = acctBankInfo.getAccount().getId().toString();
                    if (acctViewCntMap.containsKey(acctViewId)) {
                        cnt = (Integer)acctViewCntMap.get(acctViewId) + 1;
                        acctViewCntMap.put(acctViewId, new Integer(cnt));
                        continue;
                    }
                    acctViewCntMap.put(acctViewId, new Integer(1));
                }
                rpcCacheInfo.put("acctViewCntMap", acctViewCntMap);
            }
        }
    }

    protected void execQuery() throws BOSException {
        CashContrastGLDetailFilterParam para = null;
        para = this.getUIContext().get("filterParam") != null ? (CashContrastGLDetailFilterParam)this.getUIContext().get("filterParam") : (CashContrastGLDetailFilterParam)this.getFilterParam();
        this.processCacheInfo(para, this.rpcCacheInfo);
        this.periodNumber = para.getBeginPeriod();
        this.periodYear = para.getBeginYear();
        String result = "";
        Object[] args = new String[]{String.valueOf(para.getBeginYear()), String.valueOf(para.getBeginPeriod()), String.valueOf(para.getEndYear()), String.valueOf(para.getEndPeriod())};
        result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
        this.txtPeriod.setText(result);
        this.gLSystemQuery = new EntityViewInfo();
        this.gLSystemQuery.setFilter(para.getFilter());
        FilterInfo vouFilter = new FilterInfo();
        vouFilter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
        if (para.isUnTranVoucher()) {
            vouFilter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(1), CompareType.EQUALS));
            vouFilter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.EQUALS));
            vouFilter.setMaskString("#0 or #1 or #2");
        }
        this.gLSystemQuery.getFilter().mergeFilter(vouFilter, "and");
        this.tblCash.checkParsed();
        this.tblGL.checkParsed();
        KDCheckBox chkSelect = new KDCheckBox();
        KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)chkSelect);
        this.tblCash.getColumn("select").setEditor((ICellEditor)selectEditor);
        this.tblGL.getColumn("select").setEditor((ICellEditor)selectEditor);
        this.tblCash.getSelectManager().setSelectMode(10);
        this.tblGL.getSelectManager().setSelectMode(10);
        if (para.getCapitalType() != 0) {
            if (para.getCapitalType() == 1) {
                this.comboCapitalType.setSelectedIndex(0);
                Object accountBank = null;
                AccountViewCollection coll = null;
                Object account = null;
                this.fillComboBankAcct(para);
                if (para.getAcctTableId() != null) {
                    coll = this.getAdjustedAcctViewColl(para);
                }
                this.fillComboAccountView(coll);
            } else if (para.getCapitalType() == 2) {
                this.comboCapitalType.setSelectedIndex(1);
                this.fillComboAccountView(para);
            }
            CashHelper.initCombCurrency(this.comboCurrency, false);
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)para.getCurrencyId()));
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
            this.comboAccountView.setEnabled(false);
            this.comboBankAccount.setEnabled(false);
            this.comboCapitalType.setEnabled(false);
            this.comboCurrency.setEnabled(false);
            this.getUIContext().put("filterParam", null);
        }
        try {
            this.fillData();
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort((Throwable)e);
        }
    }

    private AccountViewCollection getAdjustedAcctViewColl(CashContrastGLDetailFilterParam para) throws BOSException {
        Set acctBankIdSet = this.getSelectedBankAcctIDSet();
        AccountViewCollection coll = new AccountViewCollection();
        Map map = FMHelper.getJBAcctBankAcctViewMap(null, (Set)acctBankIdSet, null, (String)para.getAcctTableId());
        Iterator it = acctBankIdSet.iterator();
        while (it.hasNext()) {
            String acctBankId = it.next().toString();
            if (map.containsKey(acctBankId)) {
                coll.add((AccountViewInfo)map.get(acctBankId));
                continue;
            }
            coll.add(this.getBankAcctFromComboBankAcct(acctBankId).getAccount());
        }
        return coll;
    }

    private void fillComboAccountView(AccountViewCollection coll) throws BOSException {
        this.comboAccountView.addItems(coll.toArray());
        if (coll.size() == 1) {
            this.comboAccountView.setSelectedIndex(0);
        } else {
            this.comboAccountView.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.comboAccountView.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    private void fillComboAccountView(CashContrastGLDetailFilterParam para) throws BOSException {
        String accountNum = para.getAcctId();
        String[] nums = accountNum.split(",");
        Set idSet = FMHelper.asSet((String[])nums);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountViewCollection coll = null;
        coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(view);
        this.comboAccountView.addItems(coll.toArray());
        if (nums.length == 1) {
            this.comboAccountView.setSelectedIndex(0);
        } else {
            this.comboAccountView.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.comboAccountView.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    private void fillComboBankAcct(CashContrastGLDetailFilterParam para) throws BOSException {
        String accountNum = para.getAccountBankId();
        String[] nums = accountNum.split(",");
        Set idSet = FMHelper.asSet((String[])nums);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.*"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        AccountBankCollection coll = null;
        coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        this.comboBankAccount.addItems(coll.toArray());
        if (nums.length == 1) {
            this.comboBankAccount.setSelectedIndex(0);
        } else {
            this.comboBankAccount.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.comboBankAccount.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    private AccountBankInfo getBankAcctFromComboBankAcct(String id) {
        ComboBoxModel model = this.comboBankAccount.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            AccountBankInfo bankAcct;
            if (model.getElementAt(i).equals(FMSysDefinedEnum.SELECT_ALL) || !(bankAcct = (AccountBankInfo)model.getElementAt(i)).getId().toString().equals(id)) continue;
            return bankAcct;
        }
        return null;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CashContrastGLDetailFilterUI();
        }
        return this.filterUI;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"Refresh_Msg"));
        if (result == 0) {
            super.actionRefresh_actionPerformed(e);
        }
    }
}

